/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.frontend.split.diff;

import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.LoadingDiffRequest;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.project.Project;
import com.intellij.platform.vcs.frontend.split.diff.FrontendDiffRequest;
import com.jetbrains.rd.ide.model.diffViewer.DiffRequestChainEditorModel;
import com.jetbrains.rd.ide.model.diffViewer.DiffViewerModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0017H\u0014J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0017H\u0014J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0017H\u0014J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u0017H\u0014J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u0017H\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Lcom/intellij/platform/vcs/frontend/split/diff/FrontendDiffRequestProcessor;", "Lcom/intellij/diff/impl/DiffRequestProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "model", "Lcom/jetbrains/rd/ide/model/diffViewer/DiffRequestChainEditorModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/ide/model/diffViewer/DiffRequestChainEditorModel;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getModel", "()Lcom/jetbrains/rd/ide/model/diffViewer/DiffRequestChainEditorModel;", "viewerLifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "getViewerLifetime", "()Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "setViewerLifetime", "(Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;)V", "updateRequest", "", "force", "", "scrollToChangePolicy", "Lcom/intellij/diff/util/DiffUserDataKeysEx$ScrollToPolicy;", "isNavigationEnabled", "hasPrevChange", "fromUpdate", "hasNextChange", "goToPrevChange", "fromDifferences", "goToNextChange", "intellij.platform.vcs.frontend.split"})
final class FrontendDiffRequestProcessor
extends DiffRequestProcessor {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final DiffRequestChainEditorModel model;
    @Nullable
    private LifetimeDefinition viewerLifetime;

    public FrontendDiffRequestProcessor(@NotNull Project project, @NotNull Lifetime lifetime, @NotNull DiffRequestChainEditorModel model) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super(project);
        this.lifetime = lifetime;
        this.model = model;
        this.model.getViewer().advise(this.lifetime, arg_0 -> FrontendDiffRequestProcessor._init_$lambda$0(this, arg_0));
        this.updateRequest();
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final DiffRequestChainEditorModel getModel() {
        return this.model;
    }

    @Nullable
    public final LifetimeDefinition getViewerLifetime() {
        return this.viewerLifetime;
    }

    public final void setViewerLifetime(@Nullable LifetimeDefinition lifetimeDefinition) {
        this.viewerLifetime = lifetimeDefinition;
    }

    public void updateRequest(boolean force, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
        DiffRequest diffRequest;
        DiffViewerModel viewerModel = (DiffViewerModel)this.model.getViewer().getValueOrNull();
        DiffRequest oldRequest = this.getActiveRequest();
        if (oldRequest instanceof FrontendDiffRequest && Intrinsics.areEqual((Object)((FrontendDiffRequest)oldRequest).getViewerModel(), (Object)viewerModel)) {
            return;
        }
        LifetimeDefinition lifetimeDefinition = this.viewerLifetime;
        if (lifetimeDefinition != null) {
            LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null);
        }
        this.viewerLifetime = this.lifetime.createNested();
        if (viewerModel == null) {
            diffRequest = (DiffRequest)new LoadingDiffRequest(null);
        } else {
            LifetimeDefinition lifetimeDefinition2 = this.viewerLifetime;
            Intrinsics.checkNotNull((Object)lifetimeDefinition2);
            diffRequest = new FrontendDiffRequest(lifetimeDefinition2.getLifetime(), viewerModel);
        }
        DiffRequest request = diffRequest;
        this.applyRequest(request, force, scrollToChangePolicy);
    }

    protected boolean isNavigationEnabled() {
        return this.hasPrevChange(true) || this.hasNextChange(true);
    }

    protected boolean hasPrevChange(boolean fromUpdate) {
        return (Boolean)InterfacesKt.valueOrDefault((IOptProperty)this.model.getHasPrev(), (Object)false);
    }

    protected boolean hasNextChange(boolean fromUpdate) {
        return (Boolean)InterfacesKt.valueOrDefault((IOptProperty)this.model.getHasNext(), (Object)false);
    }

    protected void goToPrevChange(boolean fromDifferences) {
        this.model.getGoPrev().start((Object)Unit.INSTANCE);
    }

    protected void goToNextChange(boolean fromDifferences) {
        this.model.getGoNext().start((Object)Unit.INSTANCE);
    }

    private static final Unit _init_$lambda$0(FrontendDiffRequestProcessor this$0, DiffViewerModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateRequest(true);
        return Unit.INSTANCE;
    }
}

