/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.DisposableEditorPanel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorPopupHandler;
import com.intellij.openapi.editor.impl.ContextMenuPopupHandler;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ssh.common.ServerDescription;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.util.text.DateFormatUtil;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.WebDeploymentIcons;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.ui.RerunTransferTask;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileTransferToolWindow {
    public static final Logger LOG = Logger.getInstance(FileTransferToolWindow.class);
    public static final String FILE_TRANSFER_TOOLWINDOW_ID = "File Transfer";
    private static final Key<Editor> EDITOR_KEY = Key.create((String)"FILE_TRANSFER_EDITOR");
    private static final int BUFFER_SIZE = 0x100000;

    public static void printWithTimestamp(@Nullable Project project, Mappable config, String text, ConsoleViewContentType contentType, PublishConfig.TraceLevel traceLevel) {
        if (traceLevel.enabled(contentType)) {
            FileTransferToolWindow.printWithTimestamp(project, config, text, contentType);
        }
    }

    public static void printWithTimestamp(@Nullable Project project, Mappable config, String text, ConsoleViewContentType contentType) {
        for (String line : StringUtil.splitByLines((String)text)) {
            String message = "[" + DateFormatUtil.formatDateTime((long)Clock.getTime()) + "] " + line;
            FileTransferToolWindow.print(project, config, message, contentType);
        }
    }

    public static void addRetryLink(@Nullable Project project, @Nullable ServerDescription config, final RerunTransferTask transferTask) {
        if (project == null || project.isDisposed() || project.isDefault()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            Content content = FileTransferToolWindow.getToolWindowContent(project, config, true, true);
            final Editor editor = (Editor)content.getUserData(EDITOR_KEY);
            assert (editor != null);
            Document document = editor.getDocument();
            WriteCommandAction.runWriteCommandAction((Project)project, null, null, () -> {
                String actionWord = WDBundle.message("rerun.action", new Object[0]);
                int textLength = document.getTextLength();
                document.insertString(textLength, (CharSequence)("\n" + WDBundle.message("rerun.question", new Object[0]) + "\n\n"));
                textLength = document.getTextLength();
                int offset = 3;
                final Ref link = Ref.create();
                link.set((Object)EditorHyperlinkSupport.get((Editor)editor).createHyperlink(textLength - actionWord.length() - offset, textLength - offset, null, new HyperlinkInfo(){

                    public void navigate(@NotNull Project project) {
                        if (project == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        transferTask.queue();
                        EditorHyperlinkSupport.get((Editor)editor).removeHyperlink((RangeHighlighter)link.get());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/ui/FileTransferToolWindow$1", "navigate"));
                    }
                }));
                FileTransferToolWindow.scrollToEnd(editor);
            }, (PsiFile[])new PsiFile[]{PsiDocumentManager.getInstance((Project)project).getPsiFile(document)});
        }, project.getDisposed());
    }

    public static void print(@Nullable Project project, @Nullable ServerDescription config, String text, ConsoleViewContentType contentType) {
        if (project == null || project.isDisposed() || project.isDefault()) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.info(text);
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (project.isDisposed() || project.isDefault()) {
                return;
            }
            Content content = FileTransferToolWindow.getToolWindowContent(project, config, false, contentType == ConsoleViewContentType.ERROR_OUTPUT);
            Editor editor = (Editor)content.getUserData(EDITOR_KEY);
            if (editor == null) {
                LOG.error("Editor was lost.");
                return;
            }
            Document document = editor.getDocument();
            WriteCommandAction.runWriteCommandAction((Project)project, null, null, () -> {
                int endBeforeLine = document.getTextLength();
                document.insertString(endBeforeLine, (CharSequence)(text + "\n"));
                editor.getMarkupModel().addRangeHighlighter(endBeforeLine, Math.min(document.getTextLength(), endBeforeLine + text.length()), 3000, contentType.getAttributes(), HighlighterTargetArea.EXACT_RANGE);
                FileTransferToolWindow.scrollToEnd(editor);
            }, (PsiFile[])new PsiFile[]{PsiDocumentManager.getInstance((Project)project).getPsiFile(document)});
        });
    }

    private static void scrollToEnd(Editor editor) {
        int textLength = editor.getDocument().getTextLength();
        editor.getCaretModel().moveToOffset(textLength);
        editor.getSelectionModel().removeSelection();
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    private static Content getToolWindowContent(@NotNull Project project, @Nullable ServerDescription server, boolean show, boolean select) {
        if (project == null) {
            FileTransferToolWindow.$$$reportNull$$$0(0);
        }
        ToolWindow toolWindow = Objects.requireNonNull(ToolWindowManager.getInstance((Project)project).getToolWindow(FILE_TRANSFER_TOOLWINDOW_ID));
        if (show) {
            toolWindow.show(null);
        }
        return FileTransferToolWindow.findOrCreateContent(project, toolWindow, server, select);
    }

    private static Content findOrCreateContent(@NotNull Project project, ToolWindow toolWindow, @Nullable ServerDescription server, boolean select) {
        if (project == null) {
            FileTransferToolWindow.$$$reportNull$$$0(1);
        }
        String serverName = server != null ? server.getName() : WDBundle.message("tab.title.file.transfer", new Object[0]);
        Content content = toolWindow.getContentManager().findContent(serverName);
        if (content == null) {
            EditorFactory editorFactory = EditorFactory.getInstance();
            Document document = editorFactory.createDocument((CharSequence)"");
            document.setCyclicBufferSize(0x100000);
            final Editor editor = editorFactory.createViewer(document, project);
            EditorSettings editorSettings = editor.getSettings();
            editorSettings.setLineMarkerAreaShown(false);
            editorSettings.setIndentGuidesShown(false);
            editorSettings.setLineNumbersShown(false);
            editorSettings.setFoldingOutlineShown(false);
            editorSettings.setRightMarginShown(false);
            ((EditorEx)editor).installPopupHandler((EditorPopupHandler)new ContextMenuPopupHandler(){

                public ActionGroup getActionGroup(@NotNull EditorMouseEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    DefaultActionGroup group = new DefaultActionGroup();
                    group.add((AnAction)new ClearAllAction(editor));
                    group.add((AnAction)new CopyAction(editor));
                    group.addSeparator();
                    ActionManager actionManager = ActionManager.getInstance();
                    group.add(actionManager.getAction("CompareClipboardWithSelection"));
                    return group;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/plugins/webDeployment/ui/FileTransferToolWindow$2", "getActionGroup"));
                }
            });
            editor.setBorder(null);
            content = ContentFactory.getInstance().createContent((JComponent)new DisposableEditorPanel(editor), serverName, true);
            content.setIcon(server != null ? server.getIcon() : WebDeploymentIcons.Ftp);
            content.putUserData(EDITOR_KEY, (Object)editor);
            toolWindow.getContentManager().addContent(content);
        }
        if (select) {
            toolWindow.getContentManager().setSelectedContent(content);
        }
        return content;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/FileTransferToolWindow";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getToolWindowContent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findOrCreateContent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class CopyAction
    extends AnAction {
        private final Editor myEditor;

        private CopyAction(Editor editor) {
            super(editor != null && editor.getSelectionModel().hasSelection() ? ExecutionBundle.message((String)"copy.selected.content.action.name", (Object[])new Object[0]) : ExecutionBundle.message((String)"copy.content.action.name", (Object[])new Object[0]));
            this.myEditor = editor;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyAction.$$$reportNull$$$0(0);
            }
            if (this.myEditor.getSelectionModel().hasSelection()) {
                this.myEditor.getSelectionModel().copySelectionToClipboard();
            } else {
                this.myEditor.getSelectionModel().setSelection(0, this.myEditor.getDocument().getTextLength());
                this.myEditor.getSelectionModel().copySelectionToClipboard();
                this.myEditor.getSelectionModel().removeSelection();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/webDeployment/ui/FileTransferToolWindow$CopyAction", "actionPerformed"));
        }
    }

    private static final class ClearAllAction
    extends AnAction {
        private final Editor myEditor;

        private ClearAllAction(Editor editor) {
            super(ExecutionBundle.message((String)"clear.all.from.console.action.name", (Object[])new Object[0]));
            this.myEditor = editor;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ClearAllAction.$$$reportNull$$$0(0);
            }
            final Document document = this.myEditor.getDocument();
            ApplicationManager.getApplication().runWriteAction((Runnable)new DocumentRunnable(document, this.myEditor.getProject()){

                public void run() {
                    CommandProcessor.getInstance().executeCommand(myEditor.getProject(), () -> document.deleteString(0, document.getTextLength()), null, (Object)DocCommandGroupId.noneGroupId((Document)document));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/webDeployment/ui/FileTransferToolWindow$ClearAllAction", "actionPerformed"));
        }
    }
}

