/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.formatter;

import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.lang.puppet.PuppetTokenTypes;
import com.intellij.lang.puppet.psi.PsiPuppetBlock;
import com.intellij.lang.puppet.psi.PsiPuppetExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PuppetIndentProcessor
implements PuppetTokenTypes {
    static final Indent DELEGATE_TO_PREV = Indent.getSpaceIndent((int)-239);
    private static final TokenSet BLOCK_LIKE_TOKENS = TokenSet.create((IElementType[])new IElementType[]{ARRAY, HASH_VALUE, EXPRESSION_PAREN, COLLECT_R_HAND, EXPRESSION_INDEX, HASH_ARRAY_INDEX});
    private static final TokenSet CONTINUATION_WITHOUT_FIRST_INDENTED_CONTAINERS = TokenSet.create((IElementType[])new IElementType[]{ARGUMENT, SELECTOR, RESOURCE_INSTANCE_DECLARATION, RESOURCE_LIKE_CLASS_DESCRIPTION});
    private static final TokenSet INDENTABLE_EXPRESSIONS_CONTAINERS = TokenSet.create((IElementType[])new IElementType[]{QUOTED_TEXT, HASH_ARRAY_ACCESSES, HASH_ARRAY_ACCESS});
    private static final TokenSet UNINDENTABLE_ELEMENTS = TokenSet.create((IElementType[])new IElementType[]{BRACED_CASE_OPTS_BLOCK});
    private static final TokenSet UNINDENTABLE_CONTAINERS = TokenSet.create((IElementType[])new IElementType[]{IF_STATEMENT, UNLESS_STATEMENT, EXPRESSION_RELATION});
    private static final TokenSet ABSOLUTE_UNINDENTABLE_ELEMENTS = TokenSet.create((IElementType[])new IElementType[]{HEREDOC_BODY, HEREDOC_BODY_QQ, HEREDOC_ENDING});

    PuppetIndentProcessor() {
    }

    @Nullable
    public Indent getNodeIndent(@NotNull ASTNode node) {
        IElementType nodeElementType;
        if (node == null) {
            PuppetIndentProcessor.$$$reportNull$$$0(0);
        }
        if (UNINDENTABLE_ELEMENTS.contains(nodeElementType = PsiUtilCore.getElementType((ASTNode)node))) {
            return Indent.getNoneIndent();
        }
        if (ABSOLUTE_UNINDENTABLE_ELEMENTS.contains(nodeElementType)) {
            return Indent.getAbsoluteNoneIndent();
        }
        ASTNode parentNode = node.getTreeParent();
        if (parentNode == null) {
            return null;
        }
        PsiElement parentElement = parentNode.getPsi();
        IElementType parentElementType = PsiUtilCore.getElementType((ASTNode)parentNode);
        if (parentElement instanceof PsiPuppetBlock || BLOCK_LIKE_TOKENS.contains(parentElementType)) {
            if (node.getTreeNext() != null && node.getTreePrev() != null) {
                return Indent.getNormalIndent();
            }
        } else {
            if (UNINDENTABLE_CONTAINERS.contains(parentElementType)) {
                return Indent.getNoneIndent();
            }
            if (CONTINUATION_WITHOUT_FIRST_INDENTED_CONTAINERS.contains(parentElementType) || parentElement instanceof PsiPuppetExpression) {
                return Indent.getContinuationWithoutFirstIndent();
            }
            if (INDENTABLE_EXPRESSIONS_CONTAINERS.contains(parentElementType) && node.getPsi() instanceof PsiPuppetExpression) {
                return Indent.getNormalIndent();
            }
        }
        return Indent.getNoneIndent();
    }

    @NotNull
    public Indent getChildNodeIndent(@NotNull ASTNode parentNode, @Nullable ASTNode prevChildNode) {
        if (parentNode == null) {
            PuppetIndentProcessor.$$$reportNull$$$0(1);
        }
        IElementType parentElementType = PsiUtilCore.getElementType((ASTNode)parentNode);
        PsiElement parentElement = parentNode.getPsi();
        IElementType prevChildElementType = PsiUtilCore.getElementType((ASTNode)prevChildNode);
        if (parentElementType == BRACED_RESOURCE_BY_CLASSNAME_CONTENTS_BLOCK && prevChildElementType == RESOURCE_INSTANCE_DECLARATION || parentElementType == RESOURCE_LIKE_CLASS_DECLARATION_BLOCK && prevChildElementType == RESOURCE_LIKE_CLASS_DESCRIPTION) {
            Indent indent = DELEGATE_TO_PREV;
            if (indent == null) {
                PuppetIndentProcessor.$$$reportNull$$$0(2);
            }
            return indent;
        }
        if (BLOCK_LIKE_TOKENS.contains(parentElementType) || parentElement instanceof PsiPuppetBlock) {
            Indent indent = Indent.getNormalIndent();
            if (indent == null) {
                PuppetIndentProcessor.$$$reportNull$$$0(3);
            }
            return indent;
        }
        if (parentElementType == RESOURCE_INSTANCE_DECLARATION || parentElementType == RESOURCE_LIKE_CLASS_DESCRIPTION) {
            Indent indent = Indent.getContinuationIndent();
            if (indent == null) {
                PuppetIndentProcessor.$$$reportNull$$$0(4);
            }
            return indent;
        }
        Indent indent = Indent.getNoneIndent();
        if (indent == null) {
            PuppetIndentProcessor.$$$reportNull$$$0(5);
        }
        return indent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/formatter/PuppetIndentProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/formatter/PuppetIndentProcessor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildNodeIndent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNodeIndent";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getChildNodeIndent";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

