/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.ssh;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remoteDev.tracing.RdctScopesKt;
import com.intellij.remoteDev.tracing.TelemetryDataUtilKt;
import com.intellij.remoteDev.util.LifetimeExKt;
import com.jetbrains.gateway.internal.GatewayCoreRegistry;
import com.jetbrains.gateway.ssh.RemoteCredentialsExKt;
import com.jetbrains.gateway.ssh.SshPortForwarder;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.Signal;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import java.io.Closeable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.selects.SelectBuilder;
import kotlinx.coroutines.selects.SelectImplementation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 12\u00020\u0001:\u000212B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 H\u0086@\u00a2\u0006\u0002\u0010!J\u0016\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0003H\u0082@\u00a2\u0006\u0002\u0010%J\u001e\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010(\u001a\u00020)H\u0082@\u00a2\u0006\u0002\u0010*J \u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020#2\u0006\u0010.\u001a\u00020#2\u0006\u0010/\u001a\u000200H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0018\u0010\u0012\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0018\u0010\u0013\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0018\u0010\u0014\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0015\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0019\u001a\f\u0012\u0004\u0012\u00020\u00180\u001aj\u0002`\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u00063"}, d2={"Lcom/jetbrains/gateway/ssh/SshPortForwarder;", "", "parentLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "remoteCredentials", "Lcom/intellij/remote/RemoteCredentials;", "remotePort", "", "remoteLocalAddress", "", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/remote/RemoteCredentials;ILjava/lang/String;)V", "meter", "Lio/opentelemetry/api/metrics/Meter;", "readCounterClient", "Lio/opentelemetry/api/metrics/LongCounter;", "kotlin.jvm.PlatformType", "Lio/opentelemetry/api/metrics/LongCounter;", "readCounterServer", "writeCounterClient", "writeCounterServer", "remoteReadable", "newClientSuccessfullyConnected", "Lcom/jetbrains/rd/util/reactive/Signal;", "", "newClientConnected", "Lcom/jetbrains/rd/util/reactive/ISource;", "Lcom/jetbrains/rd/util/reactive/IVoidSource;", "getNewClientConnected", "()Lcom/jetbrains/rd/util/reactive/ISource;", "beginForwarding", "localAddress", "Ljava/net/InetAddress;", "(Ljava/net/InetAddress;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setupIntermediateToForwardedChannel", "Lcom/jetbrains/gateway/ssh/SshPortForwarder$LifetimedChannel;", "lifetime", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "waitForClientConnection", "Ljava/nio/channels/SocketChannel;", "serverChannel", "Ljava/nio/channels/ServerSocketChannel;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/nio/channels/ServerSocketChannel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "launchTransfer", "Lkotlinx/coroutines/Job;", "src", "dest", "isClientTransfer", "", "Companion", "LifetimedChannel", "intellij.gateway.core"})
@SourceDebugExtension(value={"SMAP\nSshPortForwarder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshPortForwarder.kt\ncom/jetbrains/gateway/ssh/SshPortForwarder\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,293:1\n15#2:294\n*S KotlinDebug\n*F\n+ 1 SshPortForwarder.kt\ncom/jetbrains/gateway/ssh/SshPortForwarder\n*L\n63#1:294\n*E\n"})
public final class SshPortForwarder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime parentLifetime;
    @NotNull
    private final RemoteCredentials remoteCredentials;
    private final int remotePort;
    @NotNull
    private final String remoteLocalAddress;
    @NotNull
    private final Meter meter;
    private final LongCounter readCounterClient;
    private final LongCounter readCounterServer;
    private final LongCounter writeCounterClient;
    private final LongCounter writeCounterServer;
    @NotNull
    private final String remoteReadable;
    @NotNull
    private final Signal<Unit> newClientSuccessfullyConnected;
    @NotNull
    private final ISource<Unit> newClientConnected;
    @NotNull
    private static final Logger LOG;
    public static final long ESTABLISH_CONNECTION_RETRY_INTERVAL_MS = 100L;
    public static final int BUFFER_SIZE = 0x100000;
    public static final boolean useBlockingChannels = true;

    public SshPortForwarder(@NotNull Lifetime parentLifetime, @NotNull RemoteCredentials remoteCredentials, int remotePort, @NotNull String remoteLocalAddress) {
        Intrinsics.checkNotNullParameter((Object)parentLifetime, (String)"parentLifetime");
        Intrinsics.checkNotNullParameter((Object)remoteCredentials, (String)"remoteCredentials");
        Intrinsics.checkNotNullParameter((Object)remoteLocalAddress, (String)"remoteLocalAddress");
        this.parentLifetime = parentLifetime;
        this.remoteCredentials = remoteCredentials;
        this.remotePort = remotePort;
        this.remoteLocalAddress = remoteLocalAddress;
        this.meter = TelemetryManager.Companion.getMeter(RdctScopesKt.RDCT);
        this.readCounterClient = this.meter.counterBuilder("rdct.SshPortForwarder.readBytesRate.client").setUnit("bytes").build();
        this.readCounterServer = this.meter.counterBuilder("rdct.SshPortForwarder.readBytesRate.server").setUnit("bytes").build();
        this.writeCounterClient = this.meter.counterBuilder("rdct.SshPortForwarder.writeBytesRate.client").setUnit("bytes").build();
        this.writeCounterServer = this.meter.counterBuilder("rdct.SshPortForwarder.writeBytesRate.server").setUnit("bytes").build();
        this.remoteReadable = this.remoteCredentials.getHost() + ":" + this.remotePort;
        this.newClientSuccessfullyConnected = new Signal();
        this.newClientConnected = (ISource)this.newClientSuccessfullyConnected;
    }

    public /* synthetic */ SshPortForwarder(Lifetime lifetime, RemoteCredentials remoteCredentials, int n, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            string = "127.0.0.1";
        }
        this(lifetime, remoteCredentials, n, string);
    }

    @NotNull
    public final ISource<Unit> getNewClientConnected() {
        return this.newClientConnected;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object beginForwarding(@NotNull InetAddress var1_1, @NotNull Continuation<? super Integer> $completion) {
        if (!($completion instanceof beginForwarding.1)) ** GOTO lbl-1000
        var6_3 = $completion;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ SshPortForwarder this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.beginForwarding(null, (Continuation<? super Integer>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                SshPortForwarder.LOG.info("Forwarding " + this.remoteReadable + " (local address " + this.remoteLocalAddress + ") to " + localAddress.getHostAddress());
                lifetime = this.parentLifetime.createNested();
                $continuation.L$0 = this;
                $continuation.L$1 = lifetime;
                $continuation.label = 1;
                v0 = RdCoroutinesUtilKt.withBackgroundContext$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ServerSocketChannel>, Object>((InetAddress)localAddress, this, null){
                    int label;
                    final /* synthetic */ InetAddress $localAddress;
                    final /* synthetic */ SshPortForwarder this$0;
                    {
                        this.$localAddress = $localAddress;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ServerSocketChannel serverSocketChannel;
                                ResultKt.throwOnFailure((Object)object);
                                try {
                                    serverSocketChannel = ServerSocketChannel.open().bind(new InetSocketAddress(this.$localAddress, SshPortForwarder.access$getRemotePort$p(this.this$0)));
                                }
                                catch (Throwable throwable) {
                                    serverSocketChannel = ServerSocketChannel.open().bind(new InetSocketAddress(this.$localAddress, 0));
                                }
                                ServerSocketChannel channel2 = serverSocketChannel;
                                channel2.configureBlocking(GatewayCoreRegistry.INSTANCE.useNonBlockingForwardingChannel());
                                return channel2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super ServerSocketChannel> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation, (int)1, null);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl26
            }
            case 1: {
                lifetime = (LifetimeDefinition)$continuation.L$1;
                this = (SshPortForwarder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                persistentServerChannel = (ServerSocketChannel)v0;
                Intrinsics.checkNotNull((Object)persistentServerChannel);
                if (!lifetime.onTerminationIfAlive((Closeable)persistentServerChannel)) {
                    SshPortForwarder.LOG.info("Persistent channel. Close channel after lifetime termination.");
                    persistentServerChannel.close();
                    throw new IllegalStateException("Lifetime is not alive".toString());
                }
                SshPortForwarder.LOG.info("Persistent forwarding channel listening on " + persistentServerChannel.getLocalAddress());
                RdCoroutinesUtilKt.launchBackground$default((Lifetime)((Lifetime)lifetime), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(lifetime, this, persistentServerChannel, null){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    int label;
                    final /* synthetic */ LifetimeDefinition $lifetime;
                    final /* synthetic */ SshPortForwarder this$0;
                    final /* synthetic */ ServerSocketChannel $persistentServerChannel;
                    {
                        this.$lifetime = $lifetime;
                        this.this$0 = $receiver;
                        this.$persistentServerChannel = $persistentServerChannel;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object var1_1) {
                        var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                seqLt = new SequentialLifetimes((Lifetime)this.$lifetime);
lbl6:
                                // 3 sources

                                while (RLifetimeKt.isAlive((Lifetime)((Lifetime)this.$lifetime))) {
                                    $this$debug_u24default$iv = SshPortForwarder.access$getLOG$cp();
                                    e$iv = null;
                                    $i$f$debug = false;
                                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                                        var12_19 = $this$debug_u24default$iv;
                                        $i$a$-debug$default-SshPortForwarder$beginForwarding$2$1 = false;
                                        var12_19.debug("Start waiting for client connection", e$iv);
                                    }
                                    v0 = (Lifetime)this.$lifetime;
                                    e$iv = this.$persistentServerChannel;
                                    Intrinsics.checkNotNull((Object)e$iv);
                                    this.L$0 = seqLt;
                                    this.L$1 = null;
                                    this.L$2 = null;
                                    this.label = 1;
                                    v1 = SshPortForwarder.access$waitForClientConnection(this.this$0, v0, e$iv, (Continuation)this);
                                    if (v1 == var13_2) {
                                        return var13_2;
                                    }
                                    ** GOTO lbl31
                                }
                                break;
                            }
                            case 1: {
                                seqLt = (SequentialLifetimes)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl31:
                                // 2 sources

                                rawClientChannel = (SocketChannel)v1;
                                $this$debug_u24default$iv = SshPortForwarder.access$getLOG$cp();
                                e$iv = null;
                                $i$f$debug = false;
                                if ($this$debug_u24default$iv.isDebugEnabled()) {
                                    var12_19 = $this$debug_u24default$iv;
                                    $i$a$-debug$default-SshPortForwarder$beginForwarding$2$2 = false;
                                    var12_19.debug("Client is connected: " + rawClientChannel.getRemoteAddress(), e$iv);
                                }
                                clientLifetime = seqLt.next();
                                $this$debug_u24default$iv = SshPortForwarder.access$getLOG$cp();
                                e$iv = null;
                                $i$f$debug = false;
                                if ($this$debug_u24default$iv.isDebugEnabled()) {
                                    var12_19 = $this$debug_u24default$iv;
                                    $i$a$-debug$default-SshPortForwarder$beginForwarding$2$3 = false;
                                    var12_19.debug("Create client channel: GTW <-> Client", e$iv);
                                }
                                clientChannel = new LifetimedChannel((Lifetime)clientLifetime, rawClientChannel);
                                $this$debug_u24default$iv = SshPortForwarder.access$getLOG$cp();
                                e$iv = null;
                                $i$f$debug = false;
                                if ($this$debug_u24default$iv.isDebugEnabled()) {
                                    var12_19 = $this$debug_u24default$iv;
                                    $i$a$-debug$default-SshPortForwarder$beginForwarding$2$4 = false;
                                    var12_19.debug("Create intermediate channel", (Throwable)e$iv);
                                }
                                this.L$0 = seqLt;
                                this.L$1 = clientLifetime;
                                this.L$2 = clientChannel;
                                this.label = 2;
                                v2 = SshPortForwarder.access$setupIntermediateToForwardedChannel(this.this$0, (Lifetime)clientLifetime, (Continuation)this);
                                ** if (v2 != var13_2) goto lbl67
lbl66:
                                // 1 sources

                                return var13_2;
lbl67:
                                // 1 sources

                                ** GOTO lbl76
                            }
                            case 2: {
                                clientChannel = (LifetimedChannel)this.L$2;
                                clientLifetime = (LifetimeDefinition)this.L$1;
                                seqLt = (SequentialLifetimes)this.L$0;
                                try {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v2 = $result;
lbl76:
                                    // 2 sources

                                    e$iv = (LifetimedChannel)v2;
                                }
                                catch (Throwable e) {
                                    SshPortForwarder.access$getLOG$cp().warn("Failed to set up forwarding from " + SshPortForwarder.access$getRemoteReadable$p(this.this$0) + ", waiting for client to retry connection", e);
                                    ** GOTO lbl6
                                }
                                intermediateChannel = e$iv;
                                $this$debug_u24default$iv = SshPortForwarder.access$getLOG$cp();
                                e$iv = null;
                                $i$f$debug = false;
                                if ($this$debug_u24default$iv.isDebugEnabled()) {
                                    var12_19 = $this$debug_u24default$iv;
                                    $i$a$-debug$default-SshPortForwarder$beginForwarding$2$5 = false;
                                    var12_19.debug("Create transfer: [Client] -> [Server]", e$iv);
                                }
                                clientToServer = SshPortForwarder.access$launchTransfer(this.this$0, clientChannel, intermediateChannel, true);
                                $this$debug_u24default$iv = SshPortForwarder.access$getLOG$cp();
                                e$iv = null;
                                $i$f$debug = false;
                                if ($this$debug_u24default$iv.isDebugEnabled()) {
                                    var12_19 = $this$debug_u24default$iv;
                                    $i$a$-debug$default-SshPortForwarder$beginForwarding$2$6 = false;
                                    var12_19.debug("Create transfer: [Client] <- [Server]", e$iv);
                                }
                                serverToClient = SshPortForwarder.access$launchTransfer(this.this$0, intermediateChannel, clientChannel, false);
                                RdCoroutinesUtilKt.launchBackground$default((Lifetime)((Lifetime)this.$lifetime), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(clientChannel, clientLifetime, clientToServer, serverToClient, null){
                                    long J$0;
                                    Object L$0;
                                    Object L$1;
                                    Object L$2;
                                    int label;
                                    final /* synthetic */ LifetimedChannel $clientChannel;
                                    final /* synthetic */ LifetimeDefinition $clientLifetime;
                                    final /* synthetic */ Job $clientToServer;
                                    final /* synthetic */ Job $serverToClient;
                                    {
                                        this.$clientChannel = $clientChannel;
                                        this.$clientLifetime = $clientLifetime;
                                        this.$clientToServer = $clientToServer;
                                        this.$serverToClient = $serverToClient;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     * Unable to fully structure code
                                     */
                                    public final Object invokeSuspend(Object var1_1) {
                                        var31_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)var1_1);
                                                var2_3 = "gtw: transfer";
                                                var3_4 = SpanKind.SERVER;
                                                var4_5 = Context.current();
                                                Intrinsics.checkNotNullExpressionValue((Object)var4_5, (String)"current(...)");
                                                var7_6 = this.$clientChannel;
                                                var8_7 = this.$clientLifetime;
                                                var9_8 = this.$clientToServer;
                                                var10_9 = this.$serverToClient;
                                                delta$iv = 0L;
                                                $i$f$withSpan = false;
                                                startTime$iv = TelemetryDataUtilKt.currentTimeWithAdjustment((long)delta$iv);
                                                v0 = TelemetryDataUtilKt.rdctTracer().spanBuilder((String)message$iv).setSpanKind((SpanKind)kind$iv).setParent((Context)parent$iv).setAttribute("start time", startTime$iv).setStartTimestamp(startTime$iv, TimeUnit.NANOSECONDS).startSpan();
                                                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"startSpan(...)");
                                                $this$use$iv$iv = v0;
                                                $i$f$use = false;
                                                $this$withSpan_u24lambda_u240$iv = $this$use$iv$iv;
                                                $i$a$-use-TelemetryDataUtilKt$withSpan$1$iv = false;
                                                $i$a$-withSpan$default-SshPortForwarder$beginForwarding$2$7$1 = false;
                                                $i$f$select = false;
                                                $this$select_u24lambda_u241$iv = new SelectImplementation(this.getContext());
                                                $i$a$-run-SelectKt$select$3$iv = false;
                                                $this$invokeSuspend_u24lambda_u241_u24lambda_u240 = (SelectBuilder)$this$select_u24lambda_u241$iv;
                                                $i$a$-select-SshPortForwarder$beginForwarding$2$7$1$1 = false;
                                                $this$invokeSuspend_u24lambda_u241_u24lambda_u240.invoke(var9_8.getOnJoin(), (Function1)new Function1<Continuation<? super Unit>, Object>(null){
                                                    int label;

                                                    public final Object invokeSuspend(Object object) {
                                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                        switch (this.label) {
                                                            case 0: {
                                                                ResultKt.throwOnFailure((Object)object);
                                                                SshPortForwarder.access$getLOG$cp().info("Client to server transfer ended");
                                                                return Unit.INSTANCE;
                                                            }
                                                        }
                                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                    }

                                                    public final Continuation<Unit> create(Continuation<?> $completion) {
                                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                    }

                                                    public final Object invoke(Continuation<? super Unit> p1) {
                                                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                                                    }
                                                });
                                                $this$invokeSuspend_u24lambda_u241_u24lambda_u240.invoke(var10_9.getOnJoin(), (Function1)new Function1<Continuation<? super Unit>, Object>(null){
                                                    int label;

                                                    public final Object invokeSuspend(Object object) {
                                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                        switch (this.label) {
                                                            case 0: {
                                                                ResultKt.throwOnFailure((Object)object);
                                                                SshPortForwarder.access$getLOG$cp().info("Server to client transfer ended");
                                                                return Unit.INSTANCE;
                                                            }
                                                        }
                                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                    }

                                                    public final Continuation<Unit> create(Continuation<?> $completion) {
                                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                    }

                                                    public final Object invoke(Continuation<? super Unit> p1) {
                                                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                                                    }
                                                });
                                                this.L$0 = var7_6;
                                                this.L$1 = var8_7;
                                                this.L$2 = $this$use$iv$iv;
                                                this.J$0 = delta$iv;
                                                this.label = 1;
                                                v1 = $this$select_u24lambda_u241$iv.doSelect((Continuation)this);
                                                ** if (v1 != var31_2) goto lbl43
lbl42:
                                                // 1 sources

                                                return var31_2;
lbl43:
                                                // 1 sources

                                                ** GOTO lbl62
                                            }
                                            case 1: {
                                                $i$f$withSpan = false;
                                                $i$f$use = false;
                                                $i$a$-use-TelemetryDataUtilKt$withSpan$1$iv = false;
                                                $i$a$-withSpan$default-SshPortForwarder$beginForwarding$2$7$1 = false;
                                                $i$f$select = false;
                                                $i$a$-run-SelectKt$select$3$iv = false;
                                                delta$iv = this.J$0;
                                                $this$use$iv$iv = (Span)this.L$2;
                                                var8_7 = (LifetimeDefinition)this.L$1;
                                                var7_6 = (LifetimedChannel)this.L$0;
                                                try {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v1 = $result;
lbl62:
                                                    // 2 sources

                                                    try {
                                                        var20_24 = var7_6.getChannel().getRemoteAddress().toString();
                                                    }
                                                    catch (Throwable var21_30) {
                                                        var20_24 = "Closed/Unassigned";
                                                    }
                                                    address = var20_24;
                                                    SshPortForwarder.access$getLOG$cp().info("Terminating lifetime of a client " + address);
                                                    LifetimeDefinition.terminate$default((LifetimeDefinition)var8_7, (boolean)false, (int)1, null);
                                                    var26_32 = Unit.INSTANCE;
                                                }
                                                catch (Throwable var16_18) {
                                                    throw var16_18;
                                                }
                                                finally {
                                                    finishTime$iv$iv = TelemetryDataUtilKt.currentTimeWithAdjustment((long)delta$iv);
                                                    $this$use$iv$iv.setAttribute("finish time", finishTime$iv$iv);
                                                    $this$use$iv$iv.setAttribute("delta", delta$iv);
                                                    $this$use$iv$iv.end(finishTime$iv$iv, TimeUnit.NANOSECONDS);
                                                }
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)3, null);
                                InterfacesKt.fire((ISignal)((ISignal)SshPortForwarder.access$getNewClientSuccessfullyConnected$p(this.this$0)));
                                ** GOTO lbl6
                            }
                        }
                        return Unit.INSTANCE;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
                return Boxing.boxInt((int)persistentServerChannel.socket().getLocalPort());
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object setupIntermediateToForwardedChannel(Lifetime var1_1, Continuation<? super LifetimedChannel> $completion) {
        if (!($completion instanceof setupIntermediateToForwardedChannel.1)) ** GOTO lbl-1000
        var9_3 = $completion;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ SshPortForwarder this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SshPortForwarder.access$setupIntermediateToForwardedChannel(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                localHost = InetAddress.getLoopbackAddress();
                Intrinsics.checkNotNull((Object)localHost);
                forwardedPort = RemoteCredentialsExKt.forwardPort(this.remoteCredentials, (Lifetime)lifetime, localHost, this.remotePort, 0, this.remoteLocalAddress);
                forwardedAddress = new InetSocketAddress(localHost, forwardedPort);
                SshPortForwarder.LOG.info("Forwarded from " + this.remoteReadable + " to local address " + forwardedAddress);
                channelLifetime = lifetime.createNested();
                $continuation.L$0 = channelLifetime;
                $continuation.label = 1;
                v0 = RdCoroutinesUtilKt.withBackgroundContext$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SocketChannel>, Object>((Lifetime)lifetime, forwardedAddress, channelLifetime, null){
                    Object L$0;
                    int label;
                    final /* synthetic */ Lifetime $lifetime;
                    final /* synthetic */ InetSocketAddress $forwardedAddress;
                    final /* synthetic */ LifetimeDefinition $channelLifetime;
                    {
                        this.$lifetime = $lifetime;
                        this.$forwardedAddress = $forwardedAddress;
                        this.$channelLifetime = $channelLifetime;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object var1_1) {
                        var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                RLifetimeKt.throwIfNotAlive((Lifetime)this.$lifetime);
                                SshPortForwarder.access$getLOG$cp().info("Preparing channel to " + this.$forwardedAddress);
                                channel = SocketChannel.open();
                                channel.configureBlocking(true);
                                channel.connect(this.$forwardedAddress);
lbl12:
                                // 3 sources

                                while (!channel.finishConnect()) {
                                    RLifetimeKt.throwIfNotAlive((Lifetime)((Lifetime)this.$channelLifetime));
                                    this.L$0 = channel;
                                    this.label = 1;
                                    v0 = DelayKt.delay((long)100L, (Continuation)((Continuation)this));
                                    if (v0 != var4_2) continue;
                                    return var4_2;
                                }
                                break;
                            }
                            case 1: {
                                channel = (SocketChannel)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
                                ** GOTO lbl12
                            }
                        }
                        if (!channel.isConnected()) {
                            $i$a$-check-SshPortForwarder$setupIntermediateToForwardedChannel$channel$1$1 = false;
                            var3_5 = "Channel is not connected";
                            throw new IllegalStateException(var3_5.toString());
                        }
                        SshPortForwarder.access$getLOG$cp().info("Intermediate channel to forwarded " + this.$forwardedAddress + " connected, local address is " + channel.getLocalAddress());
                        return channel;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super SocketChannel> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation, (int)1, null);
                if (v0 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl28
            }
            case 1: {
                channelLifetime = (LifetimeDefinition)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                channel = (SocketChannel)v0;
                v1 = (Lifetime)channelLifetime;
                Intrinsics.checkNotNull((Object)channel);
                return new LifetimedChannel(v1, channel);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object waitForClientConnection(Lifetime var1_1, ServerSocketChannel var2_2, Continuation<? super SocketChannel> $completion) {
        if (!($completion instanceof waitForClientConnection.1)) ** GOTO lbl-1000
        var6_4 = $completion;
        if ((var6_4.label & -2147483648) != 0) {
            var6_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ SshPortForwarder this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SshPortForwarder.access$waitForClientConnection(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = RdCoroutinesUtilKt.withBackgroundContext$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SocketChannel>, Object>((Lifetime)lifetime, (ServerSocketChannel)serverChannel, this, null){
                    int label;
                    final /* synthetic */ Lifetime $lifetime;
                    final /* synthetic */ ServerSocketChannel $serverChannel;
                    final /* synthetic */ SshPortForwarder this$0;
                    {
                        this.$lifetime = $lifetime;
                        this.$serverChannel = $serverChannel;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object var1_1) {
                        var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                RLifetimeKt.throwIfNotAlive((Lifetime)this.$lifetime);
                                SshPortForwarder.access$getLOG$cp().info("Waiting for new connection from client to persistent channel (" + this.$serverChannel.getLocalAddress() + ")");
lbl7:
                                // 3 sources

                                while (RLifetimeKt.isAlive((Lifetime)this.$lifetime)) {
                                    try {
                                        newConnectionChannel = this.$serverChannel.accept();
                                        if (newConnectionChannel != null) {
                                            newConnectionChannel.configureBlocking(true);
                                            SshPortForwarder.access$getLOG$cp().info("Client " + newConnectionChannel.getRemoteAddress() + " connected to persistent channel " + this.$serverChannel.getLocalAddress());
                                            return newConnectionChannel;
                                        }
                                    }
                                    catch (ClosedChannelException var2_4) {
                                        SshPortForwarder.access$getLOG$cp().info("Accept thread for persistent channel " + SshPortForwarder.access$getRemoteReadable$p(this.this$0) + " closing due to closed acceptor socket");
                                    }
                                    this.label = 1;
                                    v0 = DelayKt.delay((long)100L, (Continuation)((Continuation)this));
                                    if (v0 != var3_2) continue;
                                    return var3_2;
                                }
                                break;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
                                ** GOTO lbl7
                            }
                        }
                        RLifetimeKt.throwIfNotAlive((Lifetime)this.$lifetime);
                        throw new IllegalStateException("Failed to wait for connection from client".toString());
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super SocketChannel> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation, (int)1, null);
                if (v0 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                channel = (SocketChannel)v0;
                return channel;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Job launchTransfer(LifetimedChannel src, LifetimedChannel dest, boolean isClientTransfer) {
        Lifetime lifetime = RLifetimeKt.intersect((Lifetime)src.getLifetime(), (Lifetime)dest.getLifetime());
        SocketAddress sourceRemoteAddress = src.getChannel().getRemoteAddress();
        SocketAddress destRemoteAddress = dest.getChannel().getRemoteAddress();
        return RdCoroutinesUtilKt.launchBackground$default((Lifetime)lifetime, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(sourceRemoteAddress, destRemoteAddress, lifetime, src, dest, isClientTransfer, this, null){
            int label;
            final /* synthetic */ SocketAddress $sourceRemoteAddress;
            final /* synthetic */ SocketAddress $destRemoteAddress;
            final /* synthetic */ Lifetime $lifetime;
            final /* synthetic */ LifetimedChannel $src;
            final /* synthetic */ LifetimedChannel $dest;
            final /* synthetic */ boolean $isClientTransfer;
            final /* synthetic */ SshPortForwarder this$0;
            {
                this.$sourceRemoteAddress = $sourceRemoteAddress;
                this.$destRemoteAddress = $destRemoteAddress;
                this.$lifetime = $lifetime;
                this.$src = $src;
                this.$dest = $dest;
                this.$isClientTransfer = $isClientTransfer;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        SshPortForwarder.access$getLOG$cp().info("Starting reading loop: " + this.$sourceRemoteAddress + " -> " + this.$destRemoteAddress);
                        ByteBuffer buf = ByteBuffer.allocate(0x100000);
                        while (RLifetimeKt.isAlive((Lifetime)this.$lifetime)) {
                            try {
                                Logger $this$debug_u24default$iv;
                                Logger logger;
                                void $this$debug_u24default$iv2;
                                buf.clear();
                                Logger logger2 = SshPortForwarder.access$getLOG$cp();
                                SocketAddress socketAddress = this.$sourceRemoteAddress;
                                Throwable e$iv = null;
                                boolean $i$f$debug = false;
                                if ($this$debug_u24default$iv2.isDebugEnabled()) {
                                    logger = $this$debug_u24default$iv2;
                                    boolean bl = false;
                                    logger.debug("Reading from " + socketAddress, e$iv);
                                }
                                int e$iv32 = this.$src.getChannel().read(buf);
                                boolean bl = this.$isClientTransfer;
                                Object object2 = this.this$0;
                                int it = e$iv32;
                                boolean bl2 = false;
                                if (bl) {
                                    SshPortForwarder.access$getReadCounterClient$p((SshPortForwarder)object2).add((long)it);
                                } else {
                                    SshPortForwarder.access$getReadCounterServer$p((SshPortForwarder)object2).add((long)it);
                                }
                                int bytesRead = e$iv32;
                                Logger e$iv32 = SshPortForwarder.access$getLOG$cp();
                                object2 = this.$sourceRemoteAddress;
                                Throwable e$iv2 = null;
                                boolean $i$f$debug2 = false;
                                if ($this$debug_u24default$iv.isDebugEnabled()) {
                                    logger = $this$debug_u24default$iv;
                                    boolean bl3 = false;
                                    logger.debug("Received " + bytesRead + " bytes from " + (SocketAddress)object2, e$iv2);
                                }
                                if (bytesRead == -1) {
                                    SshPortForwarder.access$getLOG$cp().info("Reached end of stream from " + this.$sourceRemoteAddress + ", nothing to read anymore");
                                    break;
                                }
                                if (bytesRead <= 0) continue;
                                buf.flip();
                                $this$debug_u24default$iv = SshPortForwarder.access$getLOG$cp();
                                object2 = this.$destRemoteAddress;
                                e$iv2 = null;
                                $i$f$debug2 = false;
                                if ($this$debug_u24default$iv.isDebugEnabled()) {
                                    logger = $this$debug_u24default$iv;
                                    boolean bl4 = false;
                                    logger.debug("Writing " + bytesRead + " bytes to " + (SocketAddress)object2, e$iv2);
                                }
                                int n = this.$dest.getChannel().write(buf);
                                boolean bl5 = this.$isClientTransfer;
                                object2 = this.this$0;
                                it = n;
                                boolean bl6 = false;
                                if (bl5) {
                                    SshPortForwarder.access$getWriteCounterClient$p((SshPortForwarder)object2).add((long)it);
                                }
                                SshPortForwarder.access$getWriteCounterServer$p((SshPortForwarder)object2).add((long)it);
                            }
                            catch (Throwable e) {
                                if (RLifetimeKt.isAlive((Lifetime)this.$lifetime)) {
                                    SshPortForwarder.access$getLOG$cp().warn("Channel data transfer (" + this.$sourceRemoteAddress + " -> " + this.$destRemoteAddress + ") failed unexpectedly, most likely connection was closed", e);
                                    break;
                                }
                                SshPortForwarder.access$getLOG$cp().info("Lifetime is dead, stopped reading " + this.$sourceRemoteAddress + " -> " + this.$destRemoteAddress);
                                break;
                            }
                        }
                        SshPortForwarder.access$getLOG$cp().info("Stopping reading loop " + this.$sourceRemoteAddress + " -> " + this.$destRemoteAddress);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static final /* synthetic */ int access$getRemotePort$p(SshPortForwarder $this) {
        return $this.remotePort;
    }

    public static final /* synthetic */ Object access$waitForClientConnection(SshPortForwarder $this, Lifetime lifetime, ServerSocketChannel serverChannel, Continuation $completion) {
        return $this.waitForClientConnection(lifetime, serverChannel, (Continuation<? super SocketChannel>)$completion);
    }

    public static final /* synthetic */ Object access$setupIntermediateToForwardedChannel(SshPortForwarder $this, Lifetime lifetime, Continuation $completion) {
        return $this.setupIntermediateToForwardedChannel(lifetime, (Continuation<? super LifetimedChannel>)$completion);
    }

    public static final /* synthetic */ String access$getRemoteReadable$p(SshPortForwarder $this) {
        return $this.remoteReadable;
    }

    public static final /* synthetic */ Job access$launchTransfer(SshPortForwarder $this, LifetimedChannel src, LifetimedChannel dest, boolean isClientTransfer) {
        return $this.launchTransfer(src, dest, isClientTransfer);
    }

    public static final /* synthetic */ Signal access$getNewClientSuccessfullyConnected$p(SshPortForwarder $this) {
        return $this.newClientSuccessfullyConnected;
    }

    public static final /* synthetic */ LongCounter access$getReadCounterClient$p(SshPortForwarder $this) {
        return $this.readCounterClient;
    }

    public static final /* synthetic */ LongCounter access$getReadCounterServer$p(SshPortForwarder $this) {
        return $this.readCounterServer;
    }

    public static final /* synthetic */ LongCounter access$getWriteCounterClient$p(SshPortForwarder $this) {
        return $this.writeCounterClient;
    }

    public static final /* synthetic */ LongCounter access$getWriteCounterServer$p(SshPortForwarder $this) {
        return $this.writeCounterServer;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SshPortForwarder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/gateway/ssh/SshPortForwarder$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "ESTABLISH_CONNECTION_RETRY_INTERVAL_MS", "", "BUFFER_SIZE", "", "useBlockingChannels", "", "intellij.gateway.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0018\u0010\u0010\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/gateway/ssh/SshPortForwarder$LifetimedChannel;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "channel", "Ljava/nio/channels/SocketChannel;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/nio/channels/SocketChannel;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getChannel", "()Ljava/nio/channels/SocketChannel;", "localAddress", "Ljava/net/SocketAddress;", "kotlin.jvm.PlatformType", "Ljava/net/SocketAddress;", "remoteAddress", "intellij.gateway.core"})
    @SourceDebugExtension(value={"SMAP\nSshPortForwarder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshPortForwarder.kt\ncom/jetbrains/gateway/ssh/SshPortForwarder$LifetimedChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,293:1\n62#2,5:294\n*S KotlinDebug\n*F\n+ 1 SshPortForwarder.kt\ncom/jetbrains/gateway/ssh/SshPortForwarder$LifetimedChannel\n*L\n171#1:294,5\n*E\n"})
    private static final class LifetimedChannel {
        @NotNull
        private final Lifetime lifetime;
        @NotNull
        private final SocketChannel channel;
        private final SocketAddress localAddress;
        private final SocketAddress remoteAddress;

        public LifetimedChannel(@NotNull Lifetime lifetime, @NotNull SocketChannel channel2) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)channel2, (String)"channel");
            this.lifetime = lifetime;
            this.channel = channel2;
            this.localAddress = this.channel.getLocalAddress();
            this.remoteAddress = this.channel.getRemoteAddress();
            Logger $this$debug_u24default$iv = LOG;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Create lifetimed channel: " + this.channel.getLocalAddress() + " (local) -> " + this.channel.getRemoteAddress() + " (remote)", e$iv);
            }
            LifetimeExKt.onTerminationOrNow((Lifetime)this.lifetime, () -> LifetimedChannel._init_$lambda$1(this));
        }

        @NotNull
        public final Lifetime getLifetime() {
            return this.lifetime;
        }

        @NotNull
        public final SocketChannel getChannel() {
            return this.channel;
        }

        private static final Unit _init_$lambda$1(LifetimedChannel this$0) {
            LOG.info("Terminating channel, local address=" + this$0.localAddress + ", remote address=" + this$0.remoteAddress);
            this$0.channel.close();
            return Unit.INSTANCE;
        }
    }
}

