/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.Dbms;
import com.intellij.database.DbmsExtension;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlResolveResult;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlLanguageDialect
extends Language {
    public static final DbmsExtension<SqlLanguageDialect> EP = new DbmsExtension("com.intellij.sql.dialect");
    public static final String ISO_SQL_ID = "SQL92";
    public static final String GENERIC_SQL_ID = "GenericSQL";
    public static final String SQL_ID = "SQL";

    protected SqlLanguageDialect(@NonNls @NotNull String id) {
        if (id == null) {
            SqlLanguageDialect.$$$reportNull$$$0(0);
        }
        super((Language)SqlLanguage.INSTANCE, id, new String[0]);
    }

    protected SqlLanguageDialect(@NotNull SqlLanguageDialect base, @NonNls @NotNull String id) {
        if (base == null) {
            SqlLanguageDialect.$$$reportNull$$$0(1);
        }
        if (id == null) {
            SqlLanguageDialect.$$$reportNull$$$0(2);
        }
        super((Language)base, id, new String[0]);
    }

    @NotNull
    public abstract DatabaseDialect getDatabaseDialect();

    @NotNull
    public abstract Icon getIcon();

    @NotNull
    public abstract Dbms getDbms();

    public abstract boolean isSyntheticKeyword(IElementType var1);

    public abstract boolean isReservedKeyword(IElementType var1);

    public boolean isReservedKeywordPL(IElementType tokenType) {
        return this.isReservedKeyword(tokenType);
    }

    public abstract boolean isOperatorSupported(IElementType var1);

    @NotNull
    public abstract Set<String> getKeywords();

    @NotNull
    public abstract Set<String> getReservedKeywords();

    @NotNull
    public abstract Set<String> getSystemVariables();

    @NotNull
    public Set<String> getExceptionNames() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            SqlLanguageDialect.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public ObjectKind getSuperKind(@NotNull ObjectKind kind) {
        if (kind == null) {
            SqlLanguageDialect.$$$reportNull$$$0(4);
        }
        ObjectKind objectKind = kind;
        if (objectKind == null) {
            SqlLanguageDialect.$$$reportNull$$$0(5);
        }
        return objectKind;
    }

    public boolean isResolveTargetAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            SqlLanguageDialect.$$$reportNull$$$0(6);
        }
        return false;
    }

    public boolean isResolveTargetNotAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            SqlLanguageDialect.$$$reportNull$$$0(7);
        }
        return false;
    }

    @NotNull
    public ObjectKind unaliased(@NotNull ObjectKind kind) {
        if (kind == null) {
            SqlLanguageDialect.$$$reportNull$$$0(8);
        }
        ObjectKind objectKind = kind;
        if (objectKind == null) {
            SqlLanguageDialect.$$$reportNull$$$0(9);
        }
        return objectKind;
    }

    public boolean allowGlobalTableResolve(@NotNull PsiElement place) {
        if (place == null) {
            SqlLanguageDialect.$$$reportNull$$$0(10);
        }
        return false;
    }

    public void filterResolveResults(@NotNull Set<SqlResolveResult> results) {
        if (results == null) {
            SqlLanguageDialect.$$$reportNull$$$0(11);
        }
    }

    public boolean shouldHide(@Nullable DasSymbol symbol, @Nullable PsiElement place) {
        return false;
    }

    public abstract TokenSet getStatementSeparators();

    public String getDelimiterAt(@NotNull SqlFile file, int offset) {
        if (file == null) {
            SqlLanguageDialect.$$$reportNull$$$0(12);
        }
        return ";";
    }

    public abstract Collection<ObjectKind> getMajorChildKinds();

    public final boolean isMajorChild(@NotNull ObjectKind kind) {
        if (kind == null) {
            SqlLanguageDialect.$$$reportNull$$$0(13);
        }
        return this.getMajorChildKinds().contains(kind);
    }

    public abstract boolean shouldSkipFromQualification(@NotNull ObjectKind var1);

    public abstract <T extends Collection<ObjectKind>> T getParentDbTypes(T var1, ObjectKind var2);

    public boolean processReservedEntitiesWithType(@Nullable String name, @NotNull PsiElement place, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (place == null) {
            SqlLanguageDialect.$$$reportNull$$$0(14);
        }
        if (processor == null) {
            SqlLanguageDialect.$$$reportNull$$$0(15);
        }
        return true;
    }

    public boolean processUnqualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiReference ref) {
        if (processor == null) {
            SqlLanguageDialect.$$$reportNull$$$0(16);
        }
        if (state == null) {
            SqlLanguageDialect.$$$reportNull$$$0(17);
        }
        if (ref == null) {
            SqlLanguageDialect.$$$reportNull$$$0(18);
        }
        return true;
    }

    public boolean processQualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @NotNull SqlReference ref, @NotNull SqlExpression qualifier) {
        if (processor == null) {
            SqlLanguageDialect.$$$reportNull$$$0(19);
        }
        if (state == null) {
            SqlLanguageDialect.$$$reportNull$$$0(20);
        }
        if (ref == null) {
            SqlLanguageDialect.$$$reportNull$$$0(21);
        }
        if (qualifier == null) {
            SqlLanguageDialect.$$$reportNull$$$0(22);
        }
        return true;
    }

    public boolean canBeQualifier(@NotNull DasObject o) {
        if (o == null) {
            SqlLanguageDialect.$$$reportNull$$$0(23);
        }
        return true;
    }

    @Nullable
    public Condition<DasObject> getAdditionalExpandCondition(@NotNull SqlScopeProcessor processor, @NotNull PsiElement place) {
        if (processor == null) {
            SqlLanguageDialect.$$$reportNull$$$0(24);
        }
        if (place == null) {
            SqlLanguageDialect.$$$reportNull$$$0(25);
        }
        return null;
    }

    @Nullable
    public Condition<DasObject> getAdditionalExpandFilter(@NotNull SqlScopeProcessor processor, @NotNull PsiElement place) {
        if (processor == null) {
            SqlLanguageDialect.$$$reportNull$$$0(26);
        }
        if (place == null) {
            SqlLanguageDialect.$$$reportNull$$$0(27);
        }
        return null;
    }

    public boolean isValidRawToken(@NotNull IElementType type, @NotNull CharSequence text) {
        if (type == null) {
            SqlLanguageDialect.$$$reportNull$$$0(28);
        }
        if (text == null) {
            SqlLanguageDialect.$$$reportNull$$$0(29);
        }
        return false;
    }

    public boolean isAutoIncrementColumn(@NotNull DasColumn column) {
        if (column == null) {
            SqlLanguageDialect.$$$reportNull$$$0(30);
        }
        return false;
    }

    public boolean shouldStubCall(@NotNull String name) {
        if (name == null) {
            SqlLanguageDialect.$$$reportNull$$$0(31);
        }
        return false;
    }

    public boolean supportsErrorHighlighting() {
        return true;
    }

    @NotNull
    public static SqlLanguageDialect getGenericDialect() {
        List dialects = EP.allForDbms(Dbms.UNKNOWN);
        assert (!dialects.isEmpty()) : "Generic dialect must exist (but found no dialects related to 'UNKNOWN' dbms)";
        SqlLanguageDialect dialect = (SqlLanguageDialect)((Object)ContainerUtil.find((Iterable)dialects, d -> d.getID().equals(GENERIC_SQL_ID)));
        assert (dialect != null) : "No Generic dialect found but found " + dialects.size() + " other ones";
        SqlLanguageDialect sqlLanguageDialect = dialect;
        if (sqlLanguageDialect == null) {
            SqlLanguageDialect.$$$reportNull$$$0(32);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public static SqlLanguageDialect getIsoDialect() {
        List dialects = EP.allForDbms(Dbms.UNKNOWN);
        assert (!dialects.isEmpty()) : "Iso dialect must exist (but found no dialects related to 'UNKNOWN' dbms)";
        SqlLanguageDialect dialect = (SqlLanguageDialect)((Object)ContainerUtil.find((Iterable)dialects, d -> d.getID().equals(ISO_SQL_ID)));
        assert (dialect != null) : "No Iso dialect found but found " + dialects.size() + " other ones";
        SqlLanguageDialect sqlLanguageDialect = dialect;
        if (sqlLanguageDialect == null) {
            SqlLanguageDialect.$$$reportNull$$$0(33);
        }
        return sqlLanguageDialect;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 9, 32, 33 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/SqlLanguageDialect";
                break;
            }
            case 4: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 10: 
            case 14: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: 
            case 16: 
            case 19: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/SqlLanguageDialect";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionNames";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperKind";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "unaliased";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericDialect";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getIsoDialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 32: 
            case 33: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSuperKind";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetNotAccepted";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "unaliased";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "allowGlobalTableResolve";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "filterResolveResults";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDelimiterAt";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isMajorChild";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processUnqualifiedResolve";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processQualifiedResolve";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "canBeQualifier";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalExpandCondition";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalExpandFilter";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isValidRawToken";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isAutoIncrementColumn";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "shouldStubCall";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 9, 32, 33 -> new IllegalStateException(string);
        };
    }
}

