/*
 * Decompiled with CFR 0.152.
 */
package externalApp;

import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExternalAppUtil {
    private ExternalAppUtil() {
    }

    @NotNull
    public static Result sendIdeRequest(@NotNull String entryPoint, int idePort, @NotNull String handlerId, @Nullable String bodyContent) {
        Result result;
        int statusCode;
        HttpResponse<String> response;
        block12: {
            block11: {
                if (entryPoint == null) {
                    ExternalAppUtil.$$$reportNull$$$0(0);
                }
                if (handlerId == null) {
                    ExternalAppUtil.$$$reportNull$$$0(1);
                }
                TrustManager[] tm = new TrustManager[]{new AllowingTrustManager()};
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, tm, null);
                HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).sslContext(sslContext).connectTimeout(Duration.ofSeconds(5L)).build();
                HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(String.format("https://127.0.0.1:%s/api/%s?%s=%s", idePort, entryPoint, "handlerId", handlerId)));
                if (bodyContent != null) {
                    requestBuilder.POST(HttpRequest.BodyPublishers.ofString(bodyContent));
                } else {
                    requestBuilder.POST(HttpRequest.BodyPublishers.noBody());
                }
                response = client.send(requestBuilder.build(), HttpResponse.BodyHandlers.ofString());
                statusCode = response.statusCode();
                if (statusCode != 200) break block11;
                Result result2 = Result.success(statusCode, response.body());
                if (result2 == null) {
                    ExternalAppUtil.$$$reportNull$$$0(2);
                }
                return result2;
            }
            if (statusCode != 204) break block12;
            Result result3 = Result.success(statusCode, null);
            if (result3 == null) {
                ExternalAppUtil.$$$reportNull$$$0(3);
            }
            return result3;
        }
        try {
            result = Result.error(statusCode, response.body());
        }
        catch (IOException | InterruptedException | KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        if (result == null) {
            ExternalAppUtil.$$$reportNull$$$0(4);
        }
        return result;
    }

    @NotNull
    public static String getEnv(@NotNull String env) {
        String value;
        if (env == null) {
            ExternalAppUtil.$$$reportNull$$$0(5);
        }
        if ((value = System.getenv(env)) == null) {
            throw new IllegalStateException(env + " environment variable is not defined!");
        }
        String string = value;
        if (string == null) {
            ExternalAppUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static int getEnvInt(@NotNull String env) {
        if (env == null) {
            ExternalAppUtil.$$$reportNull$$$0(7);
        }
        return Integer.parseInt(ExternalAppUtil.getEnv(env));
    }

    public static void handleAskPassInvocation(@NotNull String handlerIdEnvName, @NotNull String idePortEnvName, @NotNull String entryPoint, String[] args) {
        if (handlerIdEnvName == null) {
            ExternalAppUtil.$$$reportNull$$$0(8);
        }
        if (idePortEnvName == null) {
            ExternalAppUtil.$$$reportNull$$$0(9);
        }
        if (entryPoint == null) {
            ExternalAppUtil.$$$reportNull$$$0(10);
        }
        try {
            String passphrase;
            String handlerId = ExternalAppUtil.getEnv(handlerIdEnvName);
            int idePort = ExternalAppUtil.getEnvInt(idePortEnvName);
            String description = args.length > 0 ? args[0] : null;
            Result result = ExternalAppUtil.sendIdeRequest(entryPoint, idePort, handlerId, description);
            if (result.isError) {
                System.err.println(result.getPresentableError());
                System.exit(1);
            }
            if ((passphrase = result.response) == null) {
                System.err.println("Authentication request was cancelled");
                System.exit(1);
            }
            System.out.println(passphrase);
            System.exit(0);
        }
        catch (Throwable t) {
            System.err.println(t.getMessage());
            t.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryPoint";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handlerId";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalApp/ExternalAppUtil";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handlerIdEnvName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idePortEnvName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "externalApp/ExternalAppUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "sendIdeRequest";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnv";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "sendIdeRequest";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getEnv";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getEnvInt";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "handleAskPassInvocation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6 -> new IllegalStateException(string);
        };
    }

    private static class AllowingTrustManager
    extends X509ExtendedTrustManager {
        private AllowingTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }
    }

    public static class Result {
        public final boolean isError;
        public final int statusCode;
        public final String response;
        public final String error;

        private Result(int statusCode, String response, String error, boolean isError) {
            this.statusCode = statusCode;
            this.response = response;
            this.error = error;
            this.isError = isError;
        }

        public static Result success(int statusCode, @Nullable String response) {
            return new Result(statusCode, response, null, false);
        }

        public static Result error(int statusCode, @Nullable String error) {
            return new Result(statusCode, null, error, true);
        }

        @NotNull
        public String getPresentableError() {
            String msg = "Could not communicate with IDE: " + this.statusCode;
            if (this.error != null && !this.error.isEmpty()) {
                msg = msg + " - " + this.error;
            }
            String string = msg;
            if (string == null) {
                Result.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "externalApp/ExternalAppUtil$Result", "getPresentableError"));
        }
    }
}

