/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMembersFix;
import com.intellij.lang.javascript.validation.fixes.TypeScriptImplementMemberUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class TypeScriptImplementMembersFix
extends BaseCreateMembersFix<TypeScriptFunction>
implements IntentionAction {
    private final boolean myImplementAsAbstract;

    public TypeScriptImplementMembersFix(@NotNull PsiElement jsClass, boolean implementAsAbstract) {
        if (jsClass == null) {
            TypeScriptImplementMembersFix.$$$reportNull$$$0(0);
        }
        super(jsClass);
        this.myImplementAsAbstract = implementAsAbstract;
    }

    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message("javascript.fix.implement.members", new Object[0]);
        if (string == null) {
            TypeScriptImplementMembersFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("javascript.fix.implement.methods", new Object[0]);
        if (string == null) {
            TypeScriptImplementMembersFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            TypeScriptImplementMembersFix.$$$reportNull$$$0(3);
        }
        return this.myJsClass != null && this.myJsClass.isValid();
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            TypeScriptImplementMembersFix.$$$reportNull$$$0(4);
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        this.evalAnchor(editor, file);
        JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)file, () -> TypeScriptImplementMemberUtil.implementMembersForMemberOwner(this.myJsClass, this.getElementsToProcess(), this.anchor == null ? null : this.anchor.getNode(), this.myImplementAsAbstract));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/TypeScriptImplementMembersFix";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/TypeScriptImplementMembersFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

