/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.NewLineEraser;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.psi.util.SideEffectChecker;
import com.intellij.lang.javascript.validation.fixes.RemoveASTNodeFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveUnusedAssignmentFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final boolean myAllInDestructuring;

    public RemoveUnusedAssignmentFix(@Nullable PsiElement element, boolean allInDestructuring) {
        super(element);
        this.myAllInDestructuring = allInDestructuring;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        JSExpression operand;
        if (project == null) {
            RemoveUnusedAssignmentFix.$$$reportNull$$$0(0);
        }
        if (file == null) {
            RemoveUnusedAssignmentFix.$$$reportNull$$$0(1);
        }
        if (startElement == null) {
            RemoveUnusedAssignmentFix.$$$reportNull$$$0(2);
        }
        if (endElement == null) {
            RemoveUnusedAssignmentFix.$$$reportNull$$$0(3);
        }
        if (startElement instanceof JSAssignmentExpression && (operand = ((JSAssignmentExpression)startElement).getROperand()) != null && (SideEffectChecker.mayHaveSideEffects(operand) || RemoveUnusedAssignmentFix.isExpressionValueUsed((JSAssignmentExpression)startElement))) {
            ASTNode operationNode = ((JSAssignmentExpression)startElement).getOperationNode();
            if (operationNode == null) {
                return;
            }
            String newText = JSTokenTypes.ASSIGNMENT_MODIFYING_OPERATIONS.contains(operationNode.getElementType()) ? new StringBuilder(startElement.getText()).deleteCharAt(operationNode.getStartOffsetInParent() + operationNode.getTextLength() - 1).toString() : operand.getText();
            startElement.replace((PsiElement)JSPsiElementFactory.createJSExpression(newText, startElement));
            return;
        }
        PsiElement assignmentParent = this.getAssignmentParent(startElement);
        if (assignmentParent == null) {
            return;
        }
        NewLineEraser eraser = new NewLineEraser(assignmentParent);
        new RemoveASTNodeFix("js.remove.unused.assignment", assignmentParent).invoke(project, file, editor, assignmentParent, assignmentParent);
        eraser.process();
    }

    private static boolean isExpressionValueUsed(@NotNull JSExpression expression) {
        if (expression == null) {
            RemoveUnusedAssignmentFix.$$$reportNull$$$0(4);
        }
        return !(JSUtils.getParentSkipParentheses((PsiElement)expression) instanceof JSExpressionStatement);
    }

    @Nullable
    private PsiElement getAssignmentParent(@NotNull PsiElement startElement) {
        if (startElement == null) {
            RemoveUnusedAssignmentFix.$$$reportNull$$$0(5);
        }
        return this.myAllInDestructuring ? JSUtils.getParentSkipParentheses(PsiTreeUtil.getParentOfType((PsiElement)startElement, JSAssignmentExpression.class)) : JSUtils.getParentSkipParentheses(startElement);
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            RemoveUnusedAssignmentFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("js.remove.unused.assignment", new Object[0]);
        if (string == null) {
            RemoveUnusedAssignmentFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/RemoveUnusedAssignmentFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/RemoveUnusedAssignmentFix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isExpressionValueUsed";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAssignmentParent";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }
}

