/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmptyExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.evaluable.JSNumericIndexerAccessType;
import com.intellij.lang.javascript.psi.types.evaluable.JSQualifiedReferenceType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class JSDestructuringUtil {
    private static final String arrName = "$_$Arr$_$";

    private JSDestructuringUtil() {
    }

    @Nullable
    public static PsiElement getParentSkippingDestructuring(@NotNull JSElement element) {
        if (element == null) {
            JSDestructuringUtil.$$$reportNull$$$0(0);
        }
        PsiElement parent = element.getContext();
        while (JSDestructuringUtil.isDestructuring(parent)) {
            parent = parent.getContext();
        }
        return parent;
    }

    public static boolean isDestructuring(@Nullable PsiElement parent) {
        return parent instanceof JSDestructuringContainer || parent instanceof JSDestructuringProperty || parent instanceof JSDestructuringElement || parent instanceof JSDestructuringArrayRestElement;
    }

    @Nullable
    public static ASTNode getParentSkippingDestructuring(@NotNull ASTNode varNode) {
        if (varNode == null) {
            JSDestructuringUtil.$$$reportNull$$$0(1);
        }
        ASTNode parent = varNode.getTreeParent();
        while (JSElementTypes.DESTRUCTURING_CONTAINERS.contains(parent.getElementType()) || JSExtendedLanguagesTokenSetProvider.DESTRUCTURING_ELEMENTS.contains(parent.getElementType()) || JSStubElementTypes.DESTRUCTURING_PROPERTIES.contains(parent.getElementType()) || JSStubElementTypes.DESTRUCTURING_ARRAY_REST == parent.getElementType()) {
            if ((parent = parent.getTreeParent()) != null) continue;
            return null;
        }
        return parent;
    }

    @Nullable
    public static JSExpression getNearestDestructuringInitializer(@NotNull JSVariable var) {
        if (var == null) {
            JSDestructuringUtil.$$$reportNull$$$0(2);
        }
        PsiElement parent = var.getParent();
        while (JSDestructuringUtil.isDestructuring(parent)) {
            JSExpression initializer;
            if (parent instanceof JSInitializerOwner && (initializer = ((JSInitializerOwner)parent).getInitializer()) != null) {
                return initializer;
            }
            parent = parent.getParent();
        }
        return null;
    }

    @Nullable
    public static JSExpression getNearestInitializerStubSafely(@NotNull JSVariable var) {
        if (var == null) {
            JSDestructuringUtil.$$$reportNull$$$0(3);
        }
        JSVariable context2 = var;
        do {
            JSExpression initializer;
            if (!(context2 instanceof JSInitializerOwner) || (initializer = ((JSInitializerOwner)context2).getInitializerOrStub()) == null) continue;
            return initializer;
        } while (JSDestructuringUtil.isDestructuring((PsiElement)(context2 = context2.getContext())));
        return null;
    }

    @Nullable
    public static JSExpression getDestructuringAssignmentSource(@NotNull JSExpression expression) {
        if (expression == null) {
            JSDestructuringUtil.$$$reportNull$$$0(4);
        }
        JSExpression child = expression;
        PsiElement parent = child.getParent();
        while (JSDestructuringUtil.isAssignmentPatternElement(parent)) {
            child = parent;
            parent = parent.getParent();
        }
        if (parent instanceof JSForInStatement && JSDestructuringUtil.isDestructuringAssignmentFor((JSForInStatement)parent, (PsiElement)child)) {
            return ((JSForInStatement)parent).getCollectionExpression();
        }
        if (!(parent instanceof JSDefinitionExpression) || ((JSDefinitionExpression)parent).getExpression() != child) {
            return null;
        }
        JSExpression initializer = ((JSDefinitionExpression)parent).getInitializer();
        if (initializer != null) {
            return initializer;
        }
        child = parent;
        if ((parent = parent.getParent()) instanceof JSForInStatement && JSDestructuringUtil.isDestructuringAssignmentFor((JSForInStatement)parent, (PsiElement)child)) {
            return ((JSForInStatement)parent).getCollectionExpression();
        }
        return null;
    }

    public static boolean isInAssignmentPattern(@NotNull PsiElement element) {
        if (element == null) {
            JSDestructuringUtil.$$$reportNull$$$0(5);
        }
        if (!JSDestructuringUtil.isAssignmentPatternElement(element)) {
            return false;
        }
        while (JSDestructuringUtil.isAssignmentPatternElement(element)) {
            element = element.getParent();
        }
        return element instanceof JSDefinitionExpression;
    }

    public static boolean isAssignmentPatternElement(@Nullable PsiElement parent) {
        return parent instanceof JSProperty || parent instanceof JSObjectLiteralExpression || parent instanceof JSArrayLiteralExpression || parent instanceof JSSpreadExpression;
    }

    private static boolean isDestructuringAssignmentFor(JSForInStatement parent, PsiElement variableExpression) {
        return (variableExpression instanceof JSObjectLiteralExpression || variableExpression instanceof JSArrayLiteralExpression) && variableExpression == parent.getVariableExpression();
    }

    public static boolean parentIsDestructuringAssignmentLHS(@Nullable JSExpression referenceExpression) {
        return referenceExpression != null && JSDestructuringUtil.getDestructuringAssignmentSource(referenceExpression) != null;
    }

    @Contract(value="null -> false")
    public static boolean arrayLiteralCorrespondsToDestructuringArray(@Nullable JSExpression arrayLiteral) {
        JSDestructuringElement destructuringElement = (JSDestructuringElement)PsiTreeUtil.getParentOfType((PsiElement)arrayLiteral, JSDestructuringElement.class, (boolean)true, (Class[])new Class[]{JSStatement.class});
        if (destructuringElement == null) {
            return false;
        }
        JSExpression init = destructuringElement.getInitializer();
        if (init == null) {
            return false;
        }
        JSDestructuringContainer target2 = destructuringElement.getTarget();
        Stack items = new Stack();
        JSExpression expr = arrayLiteral;
        while (expr != null) {
            if (expr instanceof JSArrayLiteralExpression) {
                items.add((Object)arrName);
                if (expr == init) break;
                expr = expr.getParent();
                continue;
            }
            if (expr instanceof JSProperty) {
                items.add((Object)((JSProperty)((Object)expr)).getName());
                expr = PsiTreeUtil.getParentOfType((PsiElement)expr, JSObjectLiteralExpression.class, (boolean)true, (Class[])new Class[]{JSStatement.class});
                if (expr == init) break;
                if (expr == null) continue;
                expr = expr.getParent();
                continue;
            }
            PsiElement parent = expr.getParent();
            if (parent instanceof JSArrayLiteralExpression && expr instanceof JSExpression) {
                items.add((Object)String.valueOf(((JSArrayLiteralExpression)parent).indexOf(expr)));
                if (parent == init) break;
                expr = parent.getParent();
                continue;
            }
            if (parent instanceof JSProperty) {
                items.add((Object)((JSProperty)parent).getName());
                expr = PsiTreeUtil.getParentOfType((PsiElement)expr, JSObjectLiteralExpression.class, (boolean)true, (Class[])new Class[]{JSStatement.class});
                if (expr == init) break;
                if (expr == null) continue;
                expr = parent.getParent();
                continue;
            }
            return false;
        }
        while (!items.empty()) {
            JSDestructuringContainer initializer;
            JSInitializerOwner element;
            int i;
            String item = (String)items.pop();
            if (Objects.equals(item, arrName)) {
                return target2 instanceof JSDestructuringArray;
            }
            if (target2 instanceof JSDestructuringObject) {
                JSDestructuringContainer initializer2;
                JSInitializerOwner element2;
                Optional<JSDestructuringProperty> prop = Arrays.stream(((JSDestructuringObject)target2).getProperties()).filter(p -> Objects.equals(item, p.getName())).findAny();
                if (prop.isPresent() && (element2 = prop.get().getDestructuringElement()) instanceof JSDestructuringElement && (initializer2 = ((JSDestructuringElement)element2).getTarget()) != null) {
                    target2 = initializer2;
                    continue;
                }
                return false;
            }
            if (!(target2 instanceof JSDestructuringArray)) continue;
            JSInitializerOwner[] elements = ((JSDestructuringArray)target2).getElements();
            try {
                i = Integer.parseInt(item);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (i >= 0 && i < elements.length && (element = elements[i]) instanceof JSDestructuringElement && (initializer = ((JSDestructuringElement)element).getTarget()) != null) {
                target2 = initializer;
                continue;
            }
            return false;
        }
        return false;
    }

    @Nullable
    public static JSType getTypeFromInitializer(@NotNull PsiElement referenceOrVariable, @NotNull Function<@Nullable JSExpression, @Nullable JSType> initializerTypeSupplier) {
        if (referenceOrVariable == null) {
            JSDestructuringUtil.$$$reportNull$$$0(6);
        }
        if (initializerTypeSupplier == null) {
            JSDestructuringUtil.$$$reportNull$$$0(7);
        }
        PsiElement element = referenceOrVariable;
        PsiElement prevElement = referenceOrVariable;
        while (element instanceof JSDestructuringContainer || element instanceof JSDestructuringProperty || element instanceof JSDestructuringArrayRestElement || element instanceof JSObjectLiteralExpression || element instanceof JSArrayLiteralExpression || element instanceof JSInitializerOwner || element instanceof JSReferenceExpression) {
            if (element instanceof JSDefinitionExpression || element.getParent() instanceof JSVarStatement || element.getParent() instanceof JSParameterList) {
                if (element instanceof JSInitializerOwner) {
                    JSExpression initializer = ((JSInitializerOwner)element).getInitializer();
                    return initializerTypeSupplier.apply(initializer);
                }
                return null;
            }
            if (element instanceof JSDestructuringArray || element instanceof JSArrayLiteralExpression) {
                JSType parentType = JSDestructuringUtil.getTypeFromInitializer(element.getParent(), initializerTypeSupplier);
                if (parentType == null) {
                    return null;
                }
                Object[] elements = element instanceof JSDestructuringArray ? ((JSDestructuringArray)element).getElementsWithRest() : ((JSArrayLiteralExpression)element).getExpressions();
                int index = ArrayUtil.indexOf((Object[])elements, (Object)prevElement);
                return index != -1 ? new JSNumericIndexerAccessType(index, parentType, JSTypeSourceFactory.createTypeSource(element, true)) : null;
            }
            if (element instanceof JSDestructuringProperty || element instanceof JSProperty) {
                String name = ((JSPsiNamedElementBase)element).getName();
                if (name == null) {
                    return null;
                }
                JSType parentType = JSDestructuringUtil.getTypeFromInitializer(element.getParent(), initializerTypeSupplier);
                if (parentType == null) {
                    return null;
                }
                return new JSQualifiedReferenceType(name, parentType, JSTypeSourceFactory.createTypeSource(element, true));
            }
            prevElement = element;
            element = element.getParent();
        }
        return null;
    }

    private static @Unmodifiable List<JSInitializerOwner> filterNonEmptyElements(JSInitializerOwner[] elements) {
        return ContainerUtil.filter((Object[])elements, e -> !(e instanceof JSEmptyExpression));
    }

    public static boolean hasSingleElement(@NotNull JSDestructuringArray arrayPattern) {
        if (arrayPattern == null) {
            JSDestructuringUtil.$$$reportNull$$$0(8);
        }
        return arrayPattern.getRestElement() != null && JSDestructuringUtil.filterNonEmptyElements(arrayPattern.getElements()).isEmpty() || JSDestructuringUtil.filterNonEmptyElements(arrayPattern.getElements()).size() == 1 && arrayPattern.getRestElement() == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varNode";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceOrVariable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializerTypeSupplier";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayPattern";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/util/JSDestructuringUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getParentSkippingDestructuring";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getNearestDestructuringInitializer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getNearestInitializerStubSafely";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getDestructuringAssignmentSource";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isInAssignmentPattern";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getTypeFromInitializer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "hasSingleElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

