/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.IndexedData;
import com.intellij.lang.javascript.psi.JSApplyGenericsTransformer;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeIndexerKt;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptConditionalType;
import com.intellij.lang.javascript.psi.resolve.JSGenericMappings;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluatorBase;
import com.intellij.lang.javascript.psi.resolve.generic.JSTypeSubstitutorImpl;
import com.intellij.lang.javascript.psi.types.JSAliasTypeImpl;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCacheableTypeTransformerBase;
import com.intellij.lang.javascript.psi.types.JSCacheableTypeTransformerResolvedIdBase;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContextualUnionType;
import com.intellij.lang.javascript.psi.types.JSDistributedType;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSInferTypeId;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTemplateLiteralType;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeGenericId;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutionContextImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeWithGenericParameters;
import com.intellij.lang.javascript.psi.types.JSTypeWithWidening;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JSUnknownType;
import com.intellij.lang.javascript.psi.types.TypeScriptConditionalTypeGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericParameterImpl;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.MultiMap;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptConditionalTypeJSTypeImpl
extends JSTypeBaseImpl
implements JSEvaluableType,
JSTypeWithIncompleteSubstitution,
JSDistributedType,
JSTypeWithGenericParameters {
    private static final Class[] TO_PARENTHESIZE = new Class[]{JSUnionOrIntersectionType.class, JSFunctionTypeImpl.class, TypeScriptConditionalTypeJSTypeImpl.class};
    @NotNull
    private final JSType myCheckedType;
    @NotNull
    private final JSType myTestType;
    @NotNull
    private final JSType myTypeIfTrue;
    @NotNull
    private final JSType myTypeIfFalse;
    @NotNull
    private final Set<JSTypeGenericId> myOwnGenericIds;
    private final NotNullLazyValue<Boolean> myDeferBecauseOfForeignGenericsInChecked;

    private static boolean allowedForSubstitutionWithForeignGenerics(JSType checkedType) {
        return checkedType instanceof JSFunctionType || checkedType instanceof JSRecordType || checkedType instanceof JSAliasTypeImpl || checkedType instanceof JSGenericTypeImpl && TypeScriptConditionalTypeJSTypeImpl.isTSInterfaceOrClass((JSGenericTypeImpl)checkedType);
    }

    private static boolean isTSInterfaceOrClass(JSGenericTypeImpl genericType) {
        JSType jsType = genericType.getType();
        if (jsType instanceof JSResolvableType) {
            JSResolvedTypeInfo resolvedTypeInfo = ((JSResolvableType)jsType).resolveType();
            if (resolvedTypeInfo.isInterface()) {
                return true;
            }
            Collection<? extends PsiElement> declarations = resolvedTypeInfo.getDeclarations();
            if (declarations.size() == 1 && declarations.iterator().next() instanceof TypeScriptClass) {
                return true;
            }
        }
        return false;
    }

    @ApiStatus.Internal
    public TypeScriptConditionalTypeJSTypeImpl(@NotNull JSTypeSource source, @NotNull JSType checkedType, @NotNull JSType testType, @NotNull JSType typeIfTrue, @NotNull JSType typeIfFalse) {
        if (source == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(0);
        }
        if (checkedType == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(1);
        }
        if (testType == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(2);
        }
        if (typeIfTrue == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(3);
        }
        if (typeIfFalse == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(4);
        }
        super(source);
        this.myDeferBecauseOfForeignGenericsInChecked = NotNullLazyValue.atomicLazy(() -> JSTypeUtils.hasForeignGenericParameter(this.getCheckedType()) && !TypeScriptConditionalTypeJSTypeImpl.allowedForSubstitutionWithForeignGenerics(this.getCheckedType()));
        this.myCheckedType = checkedType;
        this.myTestType = testType;
        this.myTypeIfTrue = typeIfTrue;
        this.myTypeIfFalse = typeIfFalse;
        this.myOwnGenericIds = Collections.unmodifiableSet(TypeScriptConditionalTypeJSTypeImpl.calcOwnGenericParameters(this.myTestType));
    }

    TypeScriptConditionalTypeJSTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(5);
        }
        if (inputStream == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(6);
        }
        super(source);
        this.myDeferBecauseOfForeignGenericsInChecked = NotNullLazyValue.atomicLazy(() -> JSTypeUtils.hasForeignGenericParameter(this.getCheckedType()) && !TypeScriptConditionalTypeJSTypeImpl.allowedForSubstitutionWithForeignGenerics(this.getCheckedType()));
        this.myCheckedType = JSTypeSerializer.TYPE_SERIALIZER.read(source, inputStream);
        this.myTestType = JSTypeSerializer.TYPE_SERIALIZER.read(source, inputStream);
        this.myTypeIfTrue = JSTypeSerializer.TYPE_SERIALIZER.read(source, inputStream);
        this.myTypeIfFalse = JSTypeSerializer.TYPE_SERIALIZER.read(source, inputStream);
        this.myOwnGenericIds = Collections.unmodifiableSet(TypeScriptConditionalTypeJSTypeImpl.calcOwnGenericParameters(this.myTestType));
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(7);
        }
        super.serialize(outputStream);
        JSTypeSerializer.TYPE_SERIALIZER.write(this.myCheckedType, outputStream);
        JSTypeSerializer.TYPE_SERIALIZER.write(this.myTestType, outputStream);
        JSTypeSerializer.TYPE_SERIALIZER.write(this.myTypeIfTrue, outputStream);
        JSTypeSerializer.TYPE_SERIALIZER.write(this.myTypeIfFalse, outputStream);
    }

    @NotNull
    public JSType getCheckedType() {
        JSType jSType = this.myCheckedType;
        if (jSType == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(8);
        }
        return jSType;
    }

    @NotNull
    public JSType getTestType() {
        JSType jSType = this.myTestType;
        if (jSType == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(9);
        }
        return jSType;
    }

    @NotNull
    public JSType getTypeIfTrue() {
        JSType jSType = this.myTypeIfTrue;
        if (jSType == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(10);
        }
        return jSType;
    }

    @NotNull
    public JSType getTypeIfFalse() {
        JSType jSType = this.myTypeIfFalse;
        if (jSType == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(11);
        }
        return jSType;
    }

    @Override
    @Nullable
    public JSType substituteImpl(@NotNull JSTypeSubstitutionContext context2) {
        if (context2 == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(12);
        }
        if (this.myDeferBecauseOfForeignGenericsInChecked.getValue() == Boolean.TRUE) {
            return this;
        }
        return this.substituteInternal(context2);
    }

    @Override
    @NotNull
    public JSType substituteCompletely() {
        if (this.myDeferBecauseOfForeignGenericsInChecked.getValue() == Boolean.TRUE) {
            JSType jSType = this.getResolveCachedType(() -> {
                JSType result2 = this.substituteInternal(new JSTypeSubstitutionContextImpl());
                return result2 == this || result2 == null ? this : result2.substitute();
            }, SUBSTITUTE_COMPLETE);
            if (jSType == null) {
                TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(13);
            }
            return jSType;
        }
        JSType jSType = this.substitute();
        if (jSType == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(14);
        }
        return jSType;
    }

    @Nullable
    private JSType substituteInternal(@NotNull JSTypeSubstitutionContext context2) {
        ProcessingContext processingContext;
        JSType distributedType;
        if (context2 == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(15);
        }
        if ((distributedType = this.distributeType(context2)) != this) {
            return distributedType;
        }
        JSType testType = this.myTestType instanceof JSTypeWithWidening && ((JSTypeWithWidening)this.myTestType).allowWidening() ? ((JSTypeWithWidening)this.myTestType).copyWithAllowWidening(false) : this.myTestType;
        if ((testType = context2.substituteNested(testType)) == null) {
            return null;
        }
        if (testType instanceof JSAnyType) {
            return this.myTypeIfTrue;
        }
        JSType checkedType = context2.substituteNested(this.myCheckedType);
        if (checkedType == null) {
            return null;
        }
        if (checkedType instanceof JSAnyType && testType instanceof JSTemplateLiteralType) {
            return JSNamedTypeFactory.createNeverType(this.getSource());
        }
        if (checkedType instanceof JSAnyType && !(checkedType instanceof JSUnknownType)) {
            return JSCompositeTypeFactory.createUnionType(this.getSource(), this.myTypeIfTrue, this.myTypeIfFalse);
        }
        if (((Boolean)this.myDeferBecauseOfForeignGenericsInChecked.getValue()).booleanValue()) {
            return JSCompositeTypeFactory.createUnionType(this.getSource(), JSCompositeTypeFactory.createIntersectionType(Arrays.asList(this.myTypeIfTrue, this.myTestType), this.getSource()), this.myTypeIfFalse);
        }
        JSCacheableTypeTransformerResolvedIdBase transformer = TypeScriptTypeRelations.instantiationTransformer(false);
        JSType checkedSubstituted = JSTypeUtils.hasForeignGenericParameter(checkedType) ? checkedType.transformTypeHierarchy(transformer) : checkedType;
        JSType testSubstituted = JSTypeUtils.hasForeignGenericParameter(testType) ? testType.transformTypeHierarchy(transformer) : testType;
        if (!testSubstituted.isDirectlyAssignableType(checkedSubstituted, processingContext = JSTypeComparingContextService.createProcessingContextWithCache(this.getSourceElement())) && !checkedSubstituted.isDirectlyAssignableType(testSubstituted, processingContext)) {
            return this.myTypeIfFalse;
        }
        if (JSTypeUtils.hasForeignGenericParameter(testType, this.myOwnGenericIds)) {
            return this;
        }
        return this.checkTestType(testType, checkedType, processingContext);
    }

    @NotNull
    private JSType checkTestType(@NotNull JSType testType, @NotNull JSType checkedType, @NotNull ProcessingContext processingContext) {
        if (testType == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(16);
        }
        if (checkedType == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(17);
        }
        if (processingContext == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(18);
        }
        Supplier<JSType> typeIfTrue = () -> this.myTypeIfTrue;
        if (!this.myOwnGenericIds.isEmpty()) {
            JSGenericMappings genericArguments = new JSGenericMappings();
            ProcessingContext matchingContext = JSTypeComparingContextService.createProcessingContextWithCache(this.getSourceElement());
            matchingContext.put(JSGenericTypesEvaluator.ourHadContravariantGenerics, (Object)Boolean.FALSE);
            Predicate<JSType> predicate = el -> el instanceof JSGenericParameterType && this.myOwnGenericIds.contains(((JSGenericParameterType)el).getGenericId());
            JSGenericTypesEvaluatorBase.matchGenericTypes(genericArguments, matchingContext, checkedType, testType, new JSGenericTypesEvaluator.GenericEvaluationContext(JSGenericTypesEvaluator.DEFAULT_CONTEXT, predicate));
            MultiMap<JSTypeGenericId, JSType> mapping = genericArguments.getMapping();
            for (JSTypeGenericId genericId : genericArguments.getMappingsPossiblyNever()) {
                if (mapping.containsKey((Object)genericId)) continue;
                mapping.putValue((Object)genericId, (Object)JSNamedTypeFactory.createNeverType(this.getSource()));
            }
            JSTypeSubstitutor finalGenerics = this.intersectGenerics(mapping, matchingContext.get(JSGenericTypesEvaluator.ourHadContravariantGenerics) == Boolean.TRUE);
            if (JSTypeUtils.hasForeignGenericParameter(testType = JSTypeUtils.applyGenericArguments(testType, finalGenerics))) {
                TypeScriptConditionalTypeJSTypeImpl typeScriptConditionalTypeJSTypeImpl = this;
                if (typeScriptConditionalTypeJSTypeImpl == null) {
                    TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(19);
                }
                return typeScriptConditionalTypeJSTypeImpl;
            }
            typeIfTrue = () -> JSTypeUtils.applyGenericArguments(this.myTypeIfTrue, finalGenerics);
        }
        JSType jSType = testType.isDirectlyAssignableType(checkedType, processingContext) ? typeIfTrue.get() : this.myTypeIfFalse;
        if (jSType == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(20);
        }
        return jSType;
    }

    @NotNull
    private JSTypeSubstitutor intersectGenerics(@NotNull MultiMap<JSTypeGenericId, JSType> arguments, boolean hadContravariantGenerics) {
        if (arguments == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(21);
        }
        JSTypeSubstitutorImpl result2 = new JSTypeSubstitutorImpl();
        for (Map.Entry entry : arguments.entrySet()) {
            List types = StreamEx.of((Collection)((Collection)entry.getValue())).nonNull().toList();
            if (types.size() == 1) {
                result2.put((JSTypeGenericId)entry.getKey(), (JSType)types.get(0));
                continue;
            }
            JSType type2 = hadContravariantGenerics ? JSCompositeTypeFactory.createIntersectionType(types, this.getSource()) : JSCompositeTypeFactory.createUnionType(this.getSource(), types);
            result2.put((JSTypeGenericId)entry.getKey(), JSCompositeTypeFactory.optimizeTypeIfComposite(type2));
        }
        JSTypeSubstitutorImpl jSTypeSubstitutorImpl = result2;
        if (jSTypeSubstitutorImpl == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(22);
        }
        return jSTypeSubstitutorImpl;
    }

    @NotNull
    private static Set<? extends JSTypeGenericId> calcOwnGenericParameters(@NotNull JSType testType) {
        if (testType == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(23);
        }
        IndexedData data = JSTypeIndexerKt.getTypeIndexedData(testType);
        Set set = StreamEx.of(data.getGenerics()).select(JSInferTypeId.class).toSet();
        if (set == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(24);
        }
        return set;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSType substitute;
        if (elementType == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(25);
        }
        if (processingContext == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(26);
        }
        if ((substitute = this.substitute(processingContext)) != this) {
            return substitute.isDirectlyAssignableType(elementType, processingContext);
        }
        if (elementType instanceof TypeScriptConditionalTypeJSTypeImpl) {
            JSType targetExtends;
            TypeScriptConditionalTypeJSTypeImpl targetType = (TypeScriptConditionalTypeJSTypeImpl)elementType;
            JSType sourceExtends = this.getTestType();
            if (sourceExtends.isEquivalentTo(targetExtends = targetType.getTestType(), processingContext) && this.getCheckedType().isDirectlyAssignableType(targetType.getCheckedType(), processingContext) || targetType.getCheckedType().isDirectlyAssignableType(this.getCheckedType(), processingContext)) {
                return TypeScriptConditionalTypeJSTypeImpl.instantiate(this.getTypeIfTrue()).isDirectlyAssignableType(TypeScriptConditionalTypeJSTypeImpl.instantiate(targetType.getTypeIfTrue()), processingContext) && TypeScriptConditionalTypeJSTypeImpl.instantiate(this.getTypeIfFalse()).isDirectlyAssignableType(TypeScriptConditionalTypeJSTypeImpl.instantiate(targetType.getTypeIfFalse()), processingContext);
            }
        }
        if (this.myTestType.isDirectlyAssignableType(elementType, processingContext)) {
            return this.myTypeIfTrue.isDirectlyAssignableType(elementType, processingContext);
        }
        return this.myTypeIfFalse.isDirectlyAssignableType(elementType, processingContext);
    }

    @NotNull
    private static JSType instantiate(@NotNull JSType initialType) {
        if (initialType == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(27);
        }
        JSType jSType = initialType.transformTypeHierarchy(TypeScriptTypeRelations.instantiationTransformer(true));
        if (jSType == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(28);
        }
        return jSType;
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform, @NotNull JSTypeSource newSource) {
        JSType type2;
        JSType newChecked;
        if (childTransform == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(29);
        }
        if (newSource == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(30);
        }
        if ((newChecked = JSTypeUtils.transformTypeHierarchySafe(this.myCheckedType, childTransform)) != this.myCheckedType && newChecked instanceof JSUnionType && JSCompositeTypeFactory.isSimpleDistributedConditional(this.getSource()) && childTransform instanceof JSApplyGenericsTransformer && (type2 = this.tryDistributeTypeWithGenericsTransformer((JSUnionType)newChecked, (JSApplyGenericsTransformer)childTransform, newSource)) != null) {
            JSType jSType = type2;
            if (jSType == null) {
                TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(31);
            }
            return jSType;
        }
        JSType newTest = JSTypeUtils.transformTypeHierarchySafe(this.myTestType, childTransform);
        JSType newTrue = JSTypeUtils.transformTypeHierarchySafe(this.myTypeIfTrue, childTransform);
        JSType newFalse = JSTypeUtils.transformTypeHierarchySafe(this.myTypeIfFalse, childTransform);
        if (newChecked == this.myCheckedType && newTest == this.myTestType && newTrue == this.myTypeIfTrue && newFalse == this.myTypeIfFalse) {
            TypeScriptConditionalTypeJSTypeImpl typeScriptConditionalTypeJSTypeImpl = this;
            if (typeScriptConditionalTypeJSTypeImpl == null) {
                TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(32);
            }
            return typeScriptConditionalTypeJSTypeImpl;
        }
        JSType jSType = JSCompositeTypeFactory.createConditionalType(newSource, newChecked, newTest, newTrue, newFalse);
        if (jSType == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(33);
        }
        return jSType;
    }

    @Nullable
    private JSType tryDistributeTypeWithGenericsTransformer(@NotNull JSUnionType newChecked, @NotNull JSApplyGenericsTransformer childTransform, @NotNull JSTypeSource newSource) {
        JSTypeSubstitutor arguments;
        List<JSTypeGenericId> list;
        if (newChecked == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(34);
        }
        if (childTransform == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(35);
        }
        if (newSource == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(36);
        }
        if ((list = TypeScriptConditionalTypeJSTypeImpl.getDirectArguments(newChecked, arguments = childTransform.getTypeArguments())).isEmpty()) {
            return null;
        }
        List<JSType> types = newChecked.getTypes();
        ArrayList<JSType> result2 = new ArrayList<JSType>(types.size());
        LinkedHashMap<JSTypeGenericId, JSType> map2 = new LinkedHashMap<JSTypeGenericId, JSType>(arguments.map());
        for (JSType type2 : types) {
            for (JSTypeGenericId id : list) {
                map2.put(id, type2);
            }
            JSTypeSubstitutorImpl newSubstitutor = new JSTypeSubstitutorImpl(map2);
            JSApplyGenericsTransformer applier = childTransform.copyWithSubstitution(newSubstitutor);
            JSType newTest = JSTypeUtils.transformTypeHierarchySafe(this.myTestType, applier);
            JSType newTrue = JSTypeUtils.transformTypeHierarchySafe(this.myTypeIfTrue, applier);
            JSType newFalse = JSTypeUtils.transformTypeHierarchySafe(this.myTypeIfFalse, applier);
            result2.add(JSCompositeTypeFactory.createConditionalType(newSource, type2, newTest, newTrue, newFalse));
        }
        return JSCompositeTypeFactory.createUnionType(newSource, result2);
    }

    private static List<JSTypeGenericId> getDirectArguments(@NotNull JSUnionType newChecked, @NotNull JSTypeSubstitutor arguments) {
        if (newChecked == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(37);
        }
        if (arguments == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(38);
        }
        return arguments.map().entrySet().stream().filter(el -> el.getValue() == newChecked).map(el -> (JSTypeGenericId)el.getKey()).toList();
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(39);
        }
        JSType jSType = JSCompositeTypeFactory.createConditionalType(source, this.myCheckedType, this.myTestType, this.myTypeIfTrue, this.myTypeIfFalse);
        if (jSType == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(40);
        }
        return jSType;
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type2, ProcessingContext context2, boolean allowResolve) {
        if (type2 == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(41);
        }
        TypeScriptConditionalTypeJSTypeImpl otherConditional = (TypeScriptConditionalTypeJSTypeImpl)type2;
        return this.myCheckedType.isEquivalentTo(otherConditional.myCheckedType, context2, allowResolve) && this.myTestType.isEquivalentTo(otherConditional.myTestType, context2, allowResolve) && this.myTypeIfTrue.isEquivalentTo(otherConditional.myTypeIfTrue, context2, allowResolve) && this.myTypeIfFalse.isEquivalentTo(otherConditional.myTypeIfFalse, context2, allowResolve);
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder2) {
        if (format == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(42);
        }
        if (builder2 == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(43);
        }
        builder2.append(this.myCheckedType, format).append(" extends ").appendWithParentheses(this.getPresentableTestType(), format, TO_PARENTHESIZE).append(" ? ").appendWithParentheses(this.myTypeIfTrue, format, TO_PARENTHESIZE).append(" : ").appendWithParentheses(this.myTypeIfFalse, format, TO_PARENTHESIZE);
    }

    @NotNull
    private JSType getPresentableTestType() {
        JSType jSType = this.myOwnGenericIds.isEmpty() ? this.myTestType : this.myTestType.transformTypeHierarchy((Function<? super JSType, ? extends JSType>)((Function)t -> {
            JSTypeGenericId id;
            if (t instanceof TypeScriptConditionalTypeGenericParameterImpl && this.myOwnGenericIds.contains(id = ((TypeScriptConditionalTypeGenericParameterImpl)t).getGenericId())) {
                return new JSTypeImpl("infer " + id.getName(), t.getSource(), JSTypeContext.INSTANCE, true);
            }
            return t;
        }));
        if (jSType == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(44);
        }
        return jSType;
    }

    @Override
    protected int hashCodeImpl() {
        return Objects.hash(this.myCheckedType, this.myTestType, this.myTypeIfTrue, this.myTypeIfFalse);
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(45);
        }
        this.myCheckedType.accept(visitor);
        this.myTestType.accept(visitor);
        this.myTypeIfTrue.accept(visitor);
        this.myTypeIfFalse.accept(visitor);
    }

    @Override
    @NotNull
    public JSType distributeType() {
        JSType type2 = this.distributeType(new JSTypeSubstitutionContextImpl());
        JSType jSType = type2 == null ? this : type2;
        if (jSType == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(46);
        }
        return jSType;
    }

    @Nullable
    public JSType distributeType(@NotNull JSTypeSubstitutionContext context2) {
        if (context2 == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(47);
        }
        if (!this.isDistributedConditional(context2)) {
            return this;
        }
        JSType originalChecked = this.getCheckedType();
        JSType checkedType = context2.substituteNested(originalChecked);
        if (checkedType == null) {
            return null;
        }
        if (checkedType instanceof JSUnionType || checkedType instanceof JSContextualUnionType) {
            List<JSType> types = ((JSUnionOrIntersectionType)checkedType).getTypes();
            ArrayList<JSType> newTypes = new ArrayList<JSType>(types.size());
            for (JSType type2 : types) {
                newTypes.add(JSCompositeTypeFactory.createConditionalType(this.getSource(), type2, this.getTestType(), TypeScriptConditionalTypeJSTypeImpl.replaceCheckedType(originalChecked, type2, this.getTypeIfTrue()), TypeScriptConditionalTypeJSTypeImpl.replaceCheckedType(originalChecked, type2, this.getTypeIfFalse())));
            }
            return JSCompositeTypeFactory.createUnionType(checkedType.getSource(), newTypes);
        }
        return this;
    }

    private boolean isDistributedConditional(@NotNull JSTypeSubstitutionContext context2) {
        TypeScriptConditionalType typeNode;
        if (context2 == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(48);
        }
        if ((typeNode = (TypeScriptConditionalType)ObjectUtils.tryCast((Object)this.getSourceElement(), TypeScriptConditionalType.class)) == null) {
            return false;
        }
        JSType declaredType = typeNode.getJSType();
        if (!(declaredType instanceof TypeScriptConditionalTypeJSTypeImpl)) {
            return false;
        }
        JSType checkedType = ((TypeScriptConditionalTypeJSTypeImpl)declaredType).getCheckedType().substitute(context2.withGenerics(Collections.emptyList()));
        return checkedType instanceof TypeScriptGenericParameterImpl || checkedType instanceof TypeScriptConditionalTypeGenericParameterImpl;
    }

    @NotNull
    public static JSType replaceCheckedType(@NotNull JSType toReplace, @NotNull JSType newType, @NotNull JSType toProcess) {
        if (toReplace == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(49);
        }
        if (newType == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(50);
        }
        if (toProcess == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(51);
        }
        JSType jSType = toProcess.transformTypeHierarchy(new TypeReplacer(toReplace, newType));
        if (jSType == null) {
            TypeScriptConditionalTypeJSTypeImpl.$$$reportNull$$$0(52);
        }
        return jSType;
    }

    @Override
    public Set<JSTypeGenericId> getGenericIds() {
        return this.myOwnGenericIds;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 13, 14, 19, 20, 22, 24, 28, 31, 32, 33, 40, 44, 46, 52 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkedType";
                break;
            }
            case 2: 
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeIfTrue";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeIfFalse";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 40: 
            case 44: 
            case 46: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/TypeScriptConditionalTypeJSTypeImpl";
                break;
            }
            case 12: 
            case 15: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 18: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 21: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialType";
                break;
            }
            case 29: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 30: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChecked";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toReplace";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/TypeScriptConditionalTypeJSTypeImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCheckedType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeIfTrue";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeIfFalse";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteCompletely";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "checkTestType";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectGenerics";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "calcOwnGenericParameters";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiate";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableTestType";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "distributeType";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceCheckedType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 40: 
            case 44: 
            case 46: 
            case 52: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "substituteImpl";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "substituteInternal";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "checkTestType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "intersectGenerics";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "calcOwnGenericParameters";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "instantiate";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "tryDistributeTypeWithGenericsTransformer";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getDirectArguments";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "distributeType";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isDistributedConditional";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "replaceCheckedType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 13, 14, 19, 20, 22, 24, 28, 31, 32, 33, 40, 44, 46, 52 -> new IllegalStateException(string);
        };
    }

    private static final class TypeReplacer
    extends JSCacheableTypeTransformerBase {
        @NotNull
        private final JSType myChecked;
        @NotNull
        private final JSType myReplacer;
        private final boolean myCheckedTypeHasSimpleNested;

        @Override
        protected boolean isCompletelyIgnored(@NotNull JSType type2) {
            if (type2 == null) {
                TypeReplacer.$$$reportNull$$$0(0);
            }
            if (type2 == this.myChecked) {
                return false;
            }
            boolean simpleType = JSTypeIndexerKt.isSimpleType(type2);
            if (simpleType) {
                return true;
            }
            IndexedData data = JSTypeIndexerKt.getTypeIndexedData(type2);
            if (type2 instanceof JSUnionType && this.myChecked instanceof JSUnionType && data.getSimpleNested()) {
                return true;
            }
            return !this.myCheckedTypeHasSimpleNested && data.getSimpleNested();
        }

        private TypeReplacer(@NotNull JSType checked, @NotNull JSType replacer) {
            if (checked == null) {
                TypeReplacer.$$$reportNull$$$0(1);
            }
            if (replacer == null) {
                TypeReplacer.$$$reportNull$$$0(2);
            }
            this.myChecked = checked;
            this.myReplacer = replacer;
            this.myCheckedTypeHasSimpleNested = JSTypeIndexerKt.getTypeIndexedData(checked).getSimpleNested();
        }

        @Override
        @NotNull
        public JSType fun(@NotNull JSType type2) {
            if (type2 == null) {
                TypeReplacer.$$$reportNull$$$0(3);
            }
            JSType jSType = type2 == this.myChecked ? this.myReplacer : type2;
            if (jSType == null) {
                TypeReplacer.$$$reportNull$$$0(4);
            }
            return jSType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "checked";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replacer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/TypeScriptConditionalTypeJSTypeImpl$TypeReplacer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/TypeScriptConditionalTypeJSTypeImpl$TypeReplacer";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fun";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isCompletelyIgnored";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "fun";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

