/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.IndexedData;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeIndexerKt;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.generic.JSTypeSubstitutorImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSKeyofType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecursiveExpandTransformer;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeGenericId;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeWithOuterGenerics;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.evaluable.JSClassExpressionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSApplyGenericsTransformer
extends JSRecursiveExpandTransformer {
    @NotNull
    private final JSTypeSubstitutor myTypeArguments;
    @NotNull
    private final ProcessingContext myContext;
    @Nullable
    private final JSGenericTypesEvaluator.GenericErrorReporter myReport;
    private final boolean myIncludesStringArguments;
    private final boolean myLocalClassesPossible;
    @NotNull
    private final Collection<JSTypeGenericId> myKeys;

    public JSApplyGenericsTransformer(@NotNull JSTypeSubstitutor typeArguments2, @Nullable PsiElement element, boolean isCall, @Nullable JSGenericTypesEvaluator.GenericErrorReporter report) {
        if (typeArguments2 == null) {
            JSApplyGenericsTransformer.$$$reportNull$$$0(0);
        }
        super(true);
        this.myTypeArguments = typeArguments2;
        this.myContext = JSTypeComparingContextService.setCallEnvironment(JSTypeComparingContextService.createProcessingContextWithCache(element), isCall);
        this.myReport = report;
        this.myIncludesStringArguments = ContainerUtil.exists(typeArguments2.keys(), el -> el instanceof JSTypeSubstitutor.StringGenericId);
        this.myLocalClassesPossible = TypeScriptUtil.isLocalClassPossible(element);
        this.myKeys = typeArguments2.keys();
    }

    public JSApplyGenericsTransformer(@NotNull JSTypeSubstitutor typeArguments2, @NotNull ProcessingContext processingContext, @Nullable JSGenericTypesEvaluator.GenericErrorReporter report, boolean includesStringArguments, boolean localClassesPossible) {
        if (typeArguments2 == null) {
            JSApplyGenericsTransformer.$$$reportNull$$$0(1);
        }
        if (processingContext == null) {
            JSApplyGenericsTransformer.$$$reportNull$$$0(2);
        }
        super(true);
        this.myTypeArguments = typeArguments2;
        this.myReport = report;
        this.myContext = processingContext;
        this.myIncludesStringArguments = includesStringArguments;
        this.myLocalClassesPossible = localClassesPossible;
        this.myKeys = typeArguments2.keys();
    }

    @NotNull
    public JSApplyGenericsTransformer copyWithSubstitution(@NotNull JSTypeSubstitutor typeArguments2) {
        if (typeArguments2 == null) {
            JSApplyGenericsTransformer.$$$reportNull$$$0(3);
        }
        return new JSApplyGenericsTransformer(typeArguments2, this.myContext, this.myReport, this.myIncludesStringArguments, this.myLocalClassesPossible);
    }

    @Override
    protected boolean isCompletelyIgnored(@NotNull JSType appliedType) {
        if (appliedType == null) {
            JSApplyGenericsTransformer.$$$reportNull$$$0(4);
        }
        if (appliedType instanceof JSNamedType) {
            return this.isIgnoredNamed((JSNamedType)appliedType);
        }
        if (JSTypeIndexerKt.isSimpleType(appliedType)) {
            return true;
        }
        if (!this.myLocalClassesPossible && !this.myIncludesStringArguments) {
            IndexedData data = JSTypeIndexerKt.getTypeIndexedData(appliedType);
            if (data.getUnexpandedTypes()) {
                return false;
            }
            Set<JSTypeGenericId> generics = data.getGenerics();
            Set<JSTypeGenericId> ownGenerics = data.getDeclaredGenerics();
            if (generics.isEmpty() && ownGenerics.isEmpty()) {
                return true;
            }
            for (JSTypeGenericId key : this.myKeys) {
                if (!generics.contains(key) && !ownGenerics.contains(key)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isIgnoredNamed(@NotNull JSNamedType type2) {
        if (type2 == null) {
            JSApplyGenericsTransformer.$$$reportNull$$$0(5);
        }
        if (!(type2 instanceof JSTypeImpl)) {
            return true;
        }
        if (type2.isTypeScript()) {
            return !this.myLocalClassesPossible;
        }
        return !this.myIncludesStringArguments;
    }

    @Override
    @NotNull
    protected JSType expand(@NotNull JSType type2) {
        if (type2 == null) {
            JSApplyGenericsTransformer.$$$reportNull$$$0(6);
        }
        JSType jSType = JSTypeUtils.expandForTypeSubstitutor((PsiElement)this.myContext.get(JSTypeComparingContextService.LOCATION), type2, this.myTypeArguments);
        if (jSType == null) {
            JSApplyGenericsTransformer.$$$reportNull$$$0(7);
        }
        return jSType;
    }

    @Override
    @NotNull
    protected JSType processExpanded(@NotNull JSType type2) {
        if (type2 == null) {
            JSApplyGenericsTransformer.$$$reportNull$$$0(8);
        }
        if (type2 instanceof JSGenericTypeImpl) {
            boolean applyForArguments = this.shouldApplyForArguments(type2);
            JSType jSType = applyForArguments ? type2 : JSTypeBaseImpl.getSelfNoTransformationType();
            if (jSType == null) {
                JSApplyGenericsTransformer.$$$reportNull$$$0(9);
            }
            return jSType;
        }
        if (type2 instanceof JSTypeWithOuterGenerics) {
            JSTypeWithOuterGenerics remappedType = JSApplyGenericsTransformer.concatGenericsToJSGenericTypeIfNestedLocal((JSTypeWithOuterGenerics)type2, this.myTypeArguments);
            JSType jSType = remappedType.isEquivalentTo(type2, this.myContext, false) ? JSTypeBaseImpl.getSelfNoTransformationType() : remappedType;
            if (jSType == null) {
                JSApplyGenericsTransformer.$$$reportNull$$$0(10);
            }
            return jSType;
        }
        if (type2 instanceof TypeScriptGenericThisTypeImpl && this.myTypeArguments.containsId(((TypeScriptGenericThisTypeImpl)type2).getGenericId())) {
            JSType substitutionType = this.myTypeArguments.get(((TypeScriptGenericThisTypeImpl)type2).getGenericId());
            boolean useSelf = substitutionType == null || substitutionType instanceof TypeScriptGenericThisTypeImpl && type2.getResolvedTypeId().equals(substitutionType.getResolvedTypeId());
            JSType jSType = useSelf ? JSTypeBaseImpl.getSelfNoTransformationType() : substitutionType;
            if (jSType == null) {
                JSApplyGenericsTransformer.$$$reportNull$$$0(11);
            }
            return jSType;
        }
        if (type2 instanceof JSGenericParameterImpl) {
            JSType jsType = this.myTypeArguments.get(((JSGenericParameterImpl)type2).getGenericId());
            if (jsType != null) {
                JSType afterProcess = this.processGenericParameter((JSGenericParameterImpl)type2, jsType);
                JSType jSType = afterProcess == type2 ? JSTypeBaseImpl.getSelfNoTransformationType() : afterProcess;
                if (jSType == null) {
                    JSApplyGenericsTransformer.$$$reportNull$$$0(12);
                }
                return jSType;
            }
        } else if (type2 instanceof JSTypeImpl && type2.isTypeScript() && TypeScriptUtil.hasOuterGenerics(type2.getSourceElement())) {
            JSResolvedTypeInfo resolvedType = ((JSResolvableType)type2).resolveType();
            if (resolvedType.isLocal()) {
                return new JSTypeWithOuterGenerics(type2, this.myTypeArguments);
            }
        } else if (type2 instanceof JSTypeImpl) {
            JSType jsType = this.myTypeArguments.get(new JSTypeSubstitutor.StringGenericId(type2.getTypeText()));
            if (jsType != null) {
                if (jsType.isTypeScript()) {
                    JSType jSType = type2;
                    if (jSType == null) {
                        JSApplyGenericsTransformer.$$$reportNull$$$0(13);
                    }
                    return jSType;
                }
                JSType jSType = jsType == type2 ? JSTypeBaseImpl.getSelfNoTransformationType() : jsType;
                if (jSType == null) {
                    JSApplyGenericsTransformer.$$$reportNull$$$0(14);
                }
                return jSType;
            }
        } else if (type2 instanceof JSClassExpressionType) {
            return new JSTypeWithOuterGenerics(type2, this.myTypeArguments);
        }
        JSType jSType = type2;
        if (jSType == null) {
            JSApplyGenericsTransformer.$$$reportNull$$$0(15);
        }
        return jSType;
    }

    @NotNull
    private JSType processGenericParameter(@NotNull JSGenericParameterImpl currentType, @NotNull JSType replacement) {
        JSType newConstraint;
        if (currentType == null) {
            JSApplyGenericsTransformer.$$$reportNull$$$0(16);
        }
        if (replacement == null) {
            JSApplyGenericsTransformer.$$$reportNull$$$0(17);
        }
        JSType oldConstraint = currentType.getConstraintType();
        if (this.myReport != null && oldConstraint != null && !(newConstraint = JSTypeUtils.applyCompositeMapping(oldConstraint, this)).isDirectlyAssignableType(replacement, this.myContext)) {
            PsiElement sourceElement = currentType.getSource().getSourceElement();
            TypeScriptPropertySignature propertySignature = (TypeScriptPropertySignature)PsiTreeUtil.getContextOfType((PsiElement)sourceElement, (Class[])new Class[]{TypeScriptPropertySignature.class});
            if (!(propertySignature != null && propertySignature.isOptional() || newConstraint instanceof JSKeyofType)) {
                this.myReport.error(JavaScriptBundle.message("typescript.validation.cannot.find.best.common.type", new Object[0]));
            }
            JSType jSType = newConstraint;
            if (jSType == null) {
                JSApplyGenericsTransformer.$$$reportNull$$$0(18);
            }
            return jSType;
        }
        JSType jSType = replacement instanceof JSGenericParameterImpl && replacement != currentType && replacement.isEquivalentTo(currentType, this.myContext, true) ? currentType : replacement;
        if (jSType == null) {
            JSApplyGenericsTransformer.$$$reportNull$$$0(19);
        }
        return jSType;
    }

    private boolean shouldApplyForArguments(@NotNull JSType type2) {
        if (type2 == null) {
            JSApplyGenericsTransformer.$$$reportNull$$$0(20);
        }
        JSResolvedTypeId ownId = type2.getResolvedTypeId();
        return !ContainerUtil.exists(this.myTypeArguments.types(), subst -> subst != null && Objects.equals(ownId, subst.getResolvedTypeId()));
    }

    @NotNull
    public JSTypeSubstitutor getTypeArguments() {
        JSTypeSubstitutor jSTypeSubstitutor = this.myTypeArguments;
        if (jSTypeSubstitutor == null) {
            JSApplyGenericsTransformer.$$$reportNull$$$0(21);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public ProcessingContext getContext() {
        ProcessingContext processingContext = this.myContext;
        if (processingContext == null) {
            JSApplyGenericsTransformer.$$$reportNull$$$0(22);
        }
        return processingContext;
    }

    @NotNull
    private static JSTypeWithOuterGenerics concatGenericsToJSGenericTypeIfNestedLocal(@NotNull JSTypeWithOuterGenerics genericType, @NotNull JSTypeSubstitutor typeArguments2) {
        JSType innerType;
        if (genericType == null) {
            JSApplyGenericsTransformer.$$$reportNull$$$0(23);
        }
        if (typeArguments2 == null) {
            JSApplyGenericsTransformer.$$$reportNull$$$0(24);
        }
        if (!((innerType = genericType.getType()) instanceof JSResolvableType)) {
            JSTypeWithOuterGenerics jSTypeWithOuterGenerics = genericType;
            if (jSTypeWithOuterGenerics == null) {
                JSApplyGenericsTransformer.$$$reportNull$$$0(25);
            }
            return jSTypeWithOuterGenerics;
        }
        JSResolvedTypeInfo resolvedType = ((JSResolvableType)innerType).resolveType();
        if (!resolvedType.isLocal()) {
            JSTypeWithOuterGenerics jSTypeWithOuterGenerics = genericType;
            if (jSTypeWithOuterGenerics == null) {
                JSApplyGenericsTransformer.$$$reportNull$$$0(26);
            }
            return jSTypeWithOuterGenerics;
        }
        JSType jsType = typeArguments2.get(new JSTypeSubstitutor.StringGenericId(innerType.getTypeText()));
        if (jsType == null) {
            JSTypeSubstitutor newOuterArguments = typeArguments2;
            JSTypeSubstitutor outerArguments = genericType.getOuterArguments();
            if (!outerArguments.isEmpty() && (newOuterArguments = JSTypeSubstitutorImpl.combine(newOuterArguments, outerArguments)) == outerArguments) {
                JSTypeWithOuterGenerics jSTypeWithOuterGenerics = genericType;
                if (jSTypeWithOuterGenerics == null) {
                    JSApplyGenericsTransformer.$$$reportNull$$$0(27);
                }
                return jSTypeWithOuterGenerics;
            }
            return new JSTypeWithOuterGenerics(innerType, newOuterArguments);
        }
        JSTypeWithOuterGenerics jSTypeWithOuterGenerics = genericType;
        if (jSTypeWithOuterGenerics == null) {
            JSApplyGenericsTransformer.$$$reportNull$$$0(28);
        }
        return jSTypeWithOuterGenerics;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 9, 10, 11, 12, 13, 14, 15, 18, 19, 21, 22, 25, 26, 27, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appliedType";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/JSApplyGenericsTransformer";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentType";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/JSApplyGenericsTransformer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "expand";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "processExpanded";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "processGenericParameter";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArguments";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "concatGenericsToJSGenericTypeIfNestedLocal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "copyWithSubstitution";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isCompletelyIgnored";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredNamed";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processExpanded";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processGenericParameter";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "shouldApplyForArguments";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "concatGenericsToJSGenericTypeIfNestedLocal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 9, 10, 11, 12, 13, 14, 15, 18, 19, 21, 22, 25, 26, 27, 28 -> new IllegalStateException(string);
        };
    }
}

