/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutor;
import com.intellij.util.ObjectUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSLinterConfigLangSubstitutor
extends LanguageSubstitutor {
    private static final Logger LOG = Logger.getInstance(JSLinterConfigLangSubstitutor.class);
    private static final Key<TimestampedData> CHANGEABLE_CONFIG_TYPE_KEY = Key.create((String)"CHANGEABLE_CONFIG_TYPE_KEY");
    @NotNull
    private final String myFileName;

    protected JSLinterConfigLangSubstitutor(@NotNull String fileName) {
        if (fileName == null) {
            JSLinterConfigLangSubstitutor.$$$reportNull$$$0(0);
        }
        this.myFileName = fileName;
    }

    @Nullable
    public Language getLanguage(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            JSLinterConfigLangSubstitutor.$$$reportNull$$$0(1);
        }
        if (project == null) {
            JSLinterConfigLangSubstitutor.$$$reportNull$$$0(2);
        }
        if (!StringUtil.equals((CharSequence)this.myFileName, (CharSequence)file.getNameSequence()) || !file.isValid()) {
            return null;
        }
        TimestampedData data = (TimestampedData)CHANGEABLE_CONFIG_TYPE_KEY.get((UserDataHolder)file);
        long fileTimeStamp = file.getTimeStamp();
        if (data == null || data.getTimestamp() != fileTimeStamp) {
            data = new TimestampedData(fileTimeStamp, JSLinterConfigLangSubstitutor.isJsonDetected(file));
            CHANGEABLE_CONFIG_TYPE_KEY.set((UserDataHolder)file, (Object)data);
        }
        return data.isJsonDetected() ? JsonLanguage.INSTANCE : YamlLanguageHolder.INSTANCE;
    }

    private static boolean isJsonDetected(@NotNull VirtualFile file) {
        byte[] buffer;
        if (file == null) {
            JSLinterConfigLangSubstitutor.$$$reportNull$$$0(3);
        }
        try {
            buffer = VfsUtilCore.loadNBytes((VirtualFile)file, (int)64);
        }
        catch (FileNotFoundException e) {
            return true;
        }
        catch (IOException e) {
            LOG.warn("Failed to read first 64 bytes of " + file.getPath(), (Throwable)e);
            return true;
        }
        String str = new String(buffer, file.getCharset());
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch <= ' ') continue;
            return ch == '[' || ch == '{' || ch == '/';
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterConfigLangSubstitutor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isJsonDetected";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TimestampedData {
        private final long myTimestamp;
        private final boolean myJsonDetected;

        TimestampedData(long timestamp, boolean jsonDetected) {
            this.myTimestamp = timestamp;
            this.myJsonDetected = jsonDetected;
        }

        public long getTimestamp() {
            return this.myTimestamp;
        }

        public boolean isJsonDetected() {
            return this.myJsonDetected;
        }
    }

    public static final class YamlLanguageHolder {
        public static final Language INSTANCE = (Language)ObjectUtils.notNull((Object)Language.findLanguageByID((String)"yaml"), (Object)PlainTextLanguage.INSTANCE);
    }
}

