/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspection.JSSuspiciousTypeUtil;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSSuspiciousInstanceofCheck {
    static void checkInstanceOfGuard(@NotNull ProblemsHolder holder, @NotNull JSBinaryExpression expression, @NotNull ProblemHighlightType highlightType) {
        ProcessingContext context2;
        if (holder == null) {
            JSSuspiciousInstanceofCheck.$$$reportNull$$$0(0);
        }
        if (expression == null) {
            JSSuspiciousInstanceofCheck.$$$reportNull$$$0(1);
        }
        if (highlightType == null) {
            JSSuspiciousInstanceofCheck.$$$reportNull$$$0(2);
        }
        if (!DialectDetector.isTypeScript((PsiElement)expression) || !TypeScriptConfigUtil.strictNullChecks((PsiElement)expression)) {
            return;
        }
        JSExpression lOperand = expression.getLOperand();
        JSExpression rOperand = expression.getROperand();
        if (!(lOperand instanceof JSReferenceExpression) || rOperand == null) {
            return;
        }
        PsiElement element = lOperand.getNextSibling();
        PsiElement instanceOf = PsiTreeUtil.skipWhitespacesForward((PsiElement)element);
        if (instanceOf == null) {
            return;
        }
        JSType lType = TypeScriptTypeRelations.expandAndOptimizeExpressionTypeRecursive(lOperand);
        if (lType == null || JSTypeUtils.isAnyType(lType)) {
            return;
        }
        if (JSTypeUtils.hasForeignGenericParameter(lType = lType.transformTypeHierarchy((Function<? super JSType, ? extends JSType>)((Function)JSSuspiciousTypeUtil::getGenericConstraintSelfOrAny)))) {
            return;
        }
        JSType rType = TypeScriptTypeRelations.expandAndOptimizeExpressionTypeRecursive(rOperand);
        if (!(rType instanceof JSTypeImpl)) {
            return;
        }
        rType = JSSuspiciousTypeUtil.getConstructedType(rType, rOperand);
        if (TypeScriptTypeRelations.isTypeSubtypeOf(lType, rType = rType.transformTypeHierarchy(TypeScriptTypeRelations.instantiationTransformer(false)), context2 = JSTypeComparingContextService.createSubtypingProcessingContext((PsiElement)expression))) {
            boolean inherits;
            CheckInheritsResult res2 = JSSuspiciousInstanceofCheck.checkInherits(lType, rType, (PsiElement)lOperand);
            if (res2 == CheckInheritsResult.L_DOES_NOT_INHERIT_R) {
                return;
            }
            boolean bl = inherits = res2 == CheckInheritsResult.L_INHERITS_R;
            if (res2 == CheckInheritsResult.NOT_A_CLASS && lType instanceof JSUnionType) {
                JSUnionType lUnion = (JSUnionType)lType;
                for (JSType part : lUnion.getTypes()) {
                    CheckInheritsResult partRes = JSSuspiciousInstanceofCheck.checkInherits(part, rType, (PsiElement)lOperand);
                    if (partRes == CheckInheritsResult.L_DOES_NOT_INHERIT_R) {
                        return;
                    }
                    inherits |= partRes == CheckInheritsResult.L_INHERITS_R;
                }
            }
            holder.registerProblem((PsiElement)expression, JavaScriptBundle.message(inherits ? "typescript.redundant.instanceof.inheritor.guard" : "typescript.redundant.instanceof.guard", ((JSReferenceExpression)lOperand).getReferenceName(), rType.getTypeText(JSType.TypeTextFormat.PRESENTABLE)), highlightType, new LocalQuickFix[]{JSSuspiciousTypeUtil.getSimplifyFix(expression, false)});
            return;
        }
        if (TypeScriptTypeRelations.isTypeSubtypeOf(rType, lType, context2)) {
            return;
        }
        if (lType instanceof JSUnionType) {
            for (JSType part : ((JSUnionType)lType).getTypes()) {
                if (!TypeScriptTypeRelations.isTypeSubtypeOf(part, rType, context2) && !TypeScriptTypeRelations.isTypeSubtypeOf(rType, part, context2)) continue;
                return;
            }
        }
        holder.registerProblem((PsiElement)expression, JavaScriptBundle.message("typescript.suspicious.instanceof.guard", ((JSReferenceExpression)lOperand).getReferenceName(), rType.getTypeText(JSType.TypeTextFormat.PRESENTABLE)), highlightType, new LocalQuickFix[0]);
    }

    private static CheckInheritsResult checkInherits(@NotNull JSType lType, @NotNull JSType rType, @Nullable PsiElement location) {
        JSClass lClass;
        if (lType == null) {
            JSSuspiciousInstanceofCheck.$$$reportNull$$$0(3);
        }
        if (rType == null) {
            JSSuspiciousInstanceofCheck.$$$reportNull$$$0(4);
        }
        if ((lClass = JSSuspiciousInstanceofCheck.getDeclarationClass(lType, location)) == null) {
            return CheckInheritsResult.NOT_A_CLASS;
        }
        JSClass rClass = JSSuspiciousInstanceofCheck.getDeclarationClass(rType, location);
        if (rClass == null) {
            return CheckInheritsResult.NOT_A_CLASS;
        }
        return lClass == rClass || JSInheritanceUtil.isParentClass(lClass, rClass) ? CheckInheritsResult.L_INHERITS_R : CheckInheritsResult.L_DOES_NOT_INHERIT_R;
    }

    @Nullable
    private static JSClass getDeclarationClass(@NotNull JSType type2, @Nullable PsiElement location) {
        JSResolvableType resolvableType;
        JSClass declarationClass;
        JSType expanded;
        if (type2 == null) {
            JSSuspiciousInstanceofCheck.$$$reportNull$$$0(5);
        }
        if ((expanded = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type2, location)) instanceof JSResolvableType && (declarationClass = (resolvableType = (JSResolvableType)expanded).resolveType().getDeclarationOfType(JSClass.class)) != null) {
            return declarationClass;
        }
        if (expanded instanceof JSGenericTypeImpl) {
            JSGenericTypeImpl genericType = (JSGenericTypeImpl)expanded;
            Object object = genericType.getType().getSourceElement();
            if (object instanceof JSClass) {
                JSClass sourceClass = (JSClass)object;
                return sourceClass;
            }
            object = genericType.getType();
            if (object instanceof JSResolvableType) {
                JSResolvableType resolvableType2 = (JSResolvableType)object;
                return resolvableType2.resolveType().getDeclarationOfType(JSClass.class);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/inspection/JSSuspiciousInstanceofCheck";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkInstanceOfGuard";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkInherits";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getDeclarationClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum CheckInheritsResult {
        NOT_A_CLASS,
        L_INHERITS_R,
        L_DOES_NOT_INHERIT_R;

    }
}

