/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathBuilder;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathConfigurationImpl;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSFileModuleReference;
import com.intellij.lang.javascript.frameworks.modules.JSMappingReferenceSet;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSFileReferenceContext;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.CachingReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSReferencePathUpdater {
    @NotNull
    private final JSFileModuleReference myReference;
    private final JSFileReferenceContext myContext;
    @NotNull
    private final PsiElement myBind;
    private final boolean myAbsolute;

    public JSReferencePathUpdater(@NotNull JSFileModuleReference reference, JSFileReferenceContext context2, @NotNull PsiElement toBind, boolean isAbsolute) {
        if (reference == null) {
            JSReferencePathUpdater.$$$reportNull$$$0(0);
        }
        if (toBind == null) {
            JSReferencePathUpdater.$$$reportNull$$$0(1);
        }
        this.myReference = reference;
        this.myContext = context2;
        this.myBind = toBind;
        this.myAbsolute = isAbsolute;
    }

    @Nullable
    public PsiElement bind() {
        boolean isBindTypeScript;
        String[] extensions;
        boolean hasMappings;
        PsiElement element = this.myReference.getElement();
        if (!element.isValid() || this.myAbsolute) {
            return null;
        }
        boolean bl = hasMappings = !this.myContext.pathsMappings().isEmpty();
        if (!this.myReference.isLast()) {
            return hasMappings ? JSReferencePathUpdater.bindForModule(this.myBind, (PsiReference)this.myReference) : null;
        }
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)this.myBind);
        if (file == null || file.isDirectory()) {
            return null;
        }
        FileReferenceSet set = this.myReference.getFileReferenceSet();
        boolean isRelative = this.isRelative(element, set);
        if (!isRelative && JSFileReferencesUtil.checkReferencedFileFromNodeModules(this.myBind)) {
            return element;
        }
        String path2 = set.getPathString();
        String extension = JSFileReferencesUtil.findExtension(path2, extensions = this.myReference.getSortedByLengthImplicitExtensions());
        final boolean hasExtension = extension != null;
        JSImportPathConfigurationImpl configuration = new JSImportPathConfigurationImpl(element, file, isBindTypeScript = DialectDetector.isTypeScript(this.myBind), extension, isRelative, set, hasMappings){
            final /* synthetic */ boolean val$isBindTypeScript;
            final /* synthetic */ String val$extension;
            final /* synthetic */ boolean val$isRelative;
            final /* synthetic */ FileReferenceSet val$set;
            final /* synthetic */ boolean val$hasMappings;
            {
                this.val$isBindTypeScript = bl2;
                this.val$extension = string;
                this.val$isRelative = bl3;
                this.val$set = fileReferenceSet;
                this.val$hasMappings = bl4;
                super(arg0, arg1);
            }

            @Override
            public boolean forceExtension() {
                return hasExtension;
            }

            @Override
            @NotNull
            public JSModuleNameInfo.ExtensionSettings getPathSettings() {
                if (hasExtension && this.val$isBindTypeScript && TypeScriptUtil.isTypeScriptFile(this.val$extension)) {
                    JSModuleNameInfo.ExtensionSettings extensionSettings = JSModuleNameInfo.ExtensionSettings.FORCE_EXTENSION;
                    if (extensionSettings == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return extensionSettings;
                }
                if (hasExtension && DialectDetector.isTypeScript(this.getPlace()) && !this.val$isBindTypeScript) {
                    JSModuleNameInfo.ExtensionSettings extensionSettings = JSModuleNameInfo.ExtensionSettings.FORCE_EXTENSION;
                    if (extensionSettings == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return extensionSettings;
                }
                JSModuleNameInfo.ExtensionSettings extensionSettings = super.getPathSettings();
                if (extensionSettings == null) {
                    1.$$$reportNull$$$0(2);
                }
                return extensionSettings;
            }

            @Override
            public boolean isProcessRootPaths() {
                return !this.val$isRelative && !JSReferencePathUpdater.this.isMappingSet(this.val$set) && !this.val$hasMappings || super.isProcessRootPaths();
            }

            @Override
            public boolean relativeForSamePathMappings() {
                if (!this.usePathMappings()) {
                    return false;
                }
                if (this.val$isRelative) {
                    return true;
                }
                return super.relativeForSamePathMappings();
            }

            @Override
            public String @NotNull [] extensions() {
                String[] stringArray = JSReferencePathUpdater.this.myReference.getImplicitExtensions();
                if (stringArray == null) {
                    1.$$$reportNull$$$0(3);
                }
                return stringArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/lang/javascript/frameworks/modules/JSReferencePathUpdater$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPathSettings";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "extensions";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        JSImportPathBuilder builder2 = JSImportPathBuilder.createBuilder(configuration);
        JSModuleNameInfo name = ES6CreateImportUtil.getExternalFileModuleName(builder2);
        if (name == null) {
            return null;
        }
        return this.remapForInfo(name, element, set);
    }

    private boolean isRelative(@NotNull PsiElement element, @NotNull FileReferenceSet set) {
        if (element == null) {
            JSReferencePathUpdater.$$$reportNull$$$0(2);
        }
        if (set == null) {
            JSReferencePathUpdater.$$$reportNull$$$0(3);
        }
        return this.myReference.isRelativeCommonPath();
    }

    @Nullable
    public PsiElement remapForInfo(@NotNull JSModuleNameInfo name, @NotNull PsiElement element, @NotNull FileReferenceSet set) {
        if (name == null) {
            JSReferencePathUpdater.$$$reportNull$$$0(4);
        }
        if (element == null) {
            JSReferencePathUpdater.$$$reportNull$$$0(5);
        }
        if (set == null) {
            JSReferencePathUpdater.$$$reportNull$$$0(6);
        }
        int startOffsetInHost = set.getStartInElement();
        if (this.isMappingSet(set)) {
            JSMappingReferenceSet.MappingFileReferenceSet mappingSet = (JSMappingReferenceSet.MappingFileReferenceSet)set;
            startOffsetInHost = mappingSet.getStartOffsetInHost();
        }
        TextRange range = new TextRange(startOffsetInHost, this.myReference.getRangeInElement().getEndOffset());
        return JSReferencePathUpdater.renameWithManipulator(element, range, name.getModuleName());
    }

    public boolean isMappingSet(@NotNull FileReferenceSet set) {
        if (set == null) {
            JSReferencePathUpdater.$$$reportNull$$$0(7);
        }
        return set instanceof JSMappingReferenceSet.MappingFileReferenceSet;
    }

    @Nullable
    public static PsiElement renameWithManipulator(@NotNull PsiElement element, @NotNull TextRange range, @NotNull String newName) {
        if (element == null) {
            JSReferencePathUpdater.$$$reportNull$$$0(8);
        }
        if (range == null) {
            JSReferencePathUpdater.$$$reportNull$$$0(9);
        }
        if (newName == null) {
            JSReferencePathUpdater.$$$reportNull$$$0(10);
        }
        return CachingReference.getManipulator((PsiElement)element).handleContentChange(element, range, newName);
    }

    @Nullable
    public static PsiElement bindForModule(@NotNull PsiElement newElement, @NotNull PsiReference ref2) {
        String name;
        if (newElement == null) {
            JSReferencePathUpdater.$$$reportNull$$$0(11);
        }
        if (ref2 == null) {
            JSReferencePathUpdater.$$$reportNull$$$0(12);
        }
        if ((name = JSReferencePathUpdater.getNameForModuleBind(newElement, ref2)) == null) {
            return newElement;
        }
        PsiElement context2 = ref2.getElement();
        if (!context2.isValid()) {
            return newElement;
        }
        return JSReferencePathUpdater.renameWithManipulator(context2, JSReferencePathUpdater.calculateRange(ref2), name);
    }

    @Nullable
    public static String getNameForModuleBind(@NotNull PsiElement newElement, @NotNull PsiReference ref2) {
        VirtualFile toBind;
        if (newElement == null) {
            JSReferencePathUpdater.$$$reportNull$$$0(13);
        }
        if (ref2 == null) {
            JSReferencePathUpdater.$$$reportNull$$$0(14);
        }
        if ((toBind = PsiUtilCore.getVirtualFile((PsiElement)newElement)) == null) {
            return null;
        }
        if (JSFileReferencesUtil.checkReferencedFileFromNodeModules(newElement)) {
            return null;
        }
        PsiElement context2 = ref2.getElement();
        if (!context2.isValid()) {
            return null;
        }
        JSImportPathBuilder builder2 = JSImportPathBuilder.createBuilder(new JSImportPathConfigurationImpl(context2, toBind));
        JSModuleNameInfo name = ES6CreateImportUtil.getExternalFileModuleName(builder2);
        if (name == null) {
            return null;
        }
        String newName = name.getModuleName();
        if (ref2 instanceof FileReference) {
            newName = StringUtil.trimEnd((String)newName, (String)"/");
        }
        return newName;
    }

    @NotNull
    private static TextRange calculateRange(@NotNull PsiReference ref2) {
        if (ref2 == null) {
            JSReferencePathUpdater.$$$reportNull$$$0(15);
        }
        TextRange currentRange = ref2.getRangeInElement();
        if (ref2 instanceof FileReference) {
            FileReferenceSet set = ((FileReference)ref2).getFileReferenceSet();
            return new TextRange(set.getStartInElement(), currentRange.getEndOffset());
        }
        TextRange textRange = currentRange;
        if (textRange == null) {
            JSReferencePathUpdater.$$$reportNull$$$0(16);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toBind";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/modules/JSReferencePathUpdater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/modules/JSReferencePathUpdater";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isRelative";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "remapForInfo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isMappingSet";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "renameWithManipulator";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "bindForModule";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getNameForModuleBind";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "calculateRange";
                break;
            }
            case 16: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 16 -> new IllegalStateException(string);
        };
    }
}

