/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.JavascriptParserDefinition;
import com.intellij.lang.javascript.JsDialectWithJavaScriptFormatterSettings;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSLanguageUtil {
    @NotNull
    public static Language getLanguageDialect(PsiElement element) {
        return JSLanguageUtil.getLanguageDialect(element, element.getTextOffset());
    }

    @NotNull
    public static Language getLanguageDialect(PsiElement element, int startOffset) {
        PsiFile psiFile = element instanceof PsiFile ? (PsiFile)element : element.getContainingFile();
        Language dialect = psiFile.getLanguage();
        if (dialect == FlexSupportLoader.ECMA_SCRIPT_L4) {
            Language language = dialect;
            if (language == null) {
                JSLanguageUtil.$$$reportNull$$$0(0);
            }
            return language;
        }
        if (!(dialect instanceof JSLanguageDialect) && dialect.isKindOf((Language)JavascriptLanguage.INSTANCE)) {
            Language language = dialect;
            if (language == null) {
                JSLanguageUtil.$$$reportNull$$$0(1);
            }
            return language;
        }
        dialect = DialectDetector.languageOfElement((PsiElement)psiFile);
        if (!(dialect instanceof JSLanguageDialect)) {
            dialect = JSLanguageUtil.getLanguage(psiFile, startOffset);
        }
        if (!(dialect instanceof JSLanguageDialect) || dialect instanceof JsDialectWithJavaScriptFormatterSettings) {
            dialect = JavascriptLanguage.INSTANCE;
        }
        Language language = dialect;
        if (language == null) {
            JSLanguageUtil.$$$reportNull$$$0(2);
        }
        return language;
    }

    @Nullable
    public static Language getLanguage(PsiFile file, int offset) {
        PsiElement at = file.findElementAt(offset);
        if (at == null && offset == file.getTextLength()) {
            at = file.findElementAt(offset - 1);
        }
        return JSLanguageUtil.getLanguage(at);
    }

    @Nullable
    public static Language getLanguage(@Nullable PsiElement element) {
        PsiLanguageInjectionHost host;
        Language language;
        Language language2 = language = element != null ? element.getParent().getLanguage() : null;
        if (language != null && (host = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLanguageInjectionHost.class, (boolean)false)) != null) {
            final Ref injectedLanguageRef = new Ref();
            InjectedLanguageManager.getInstance((Project)host.getProject()).enumerateEx((PsiElement)host, element.getContainingFile(), false, (PsiLanguageInjectionHost.InjectedPsiVisitor)new JSResolveUtil.JSInjectedFilesVisitor(){

                @Override
                protected void process(JSFile file) {
                    injectedLanguageRef.set((Object)file.getLanguage());
                }
            });
            if (!injectedLanguageRef.isNull()) {
                language = (Language)injectedLanguageRef.get();
            }
        }
        return language;
    }

    @NotNull
    public static JSLanguageDialect getLanguageForParser(@NotNull PsiElement psi) {
        JSLanguageDialect dialect;
        if (psi == null) {
            JSLanguageUtil.$$$reportNull$$$0(3);
        }
        if ((dialect = DialectDetector.languageDialectOfElement(psi)) == null || dialect == JavascriptLanguage.INSTANCE) {
            JSLanguageDialect dialectFromVirtualFile;
            PsiFile file = psi.getContainingFile();
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile == null) {
                virtualFile = file.getViewProvider().getVirtualFile();
            }
            if ((dialectFromVirtualFile = DialectDetector.getLanguageDialect(virtualFile, psi.getProject())) != null) {
                dialect = dialectFromVirtualFile;
            }
        }
        Object object = dialect != null ? dialect : JavascriptLanguage.INSTANCE;
        if (object == null) {
            JSLanguageUtil.$$$reportNull$$$0(4);
        }
        return object;
    }

    @NotNull
    public static Collection<FileType> getFileTypesCompilableToJavaScript() {
        Object[] registeredFileTypes;
        HashSet<FileType> fileTypes = new HashSet<FileType>();
        for (FileType fileType : registeredFileTypes = FileTypeRegistry.getInstance().getRegisteredFileTypes()) {
            Language language;
            if (!(fileType instanceof LanguageFileType) || (language = ((LanguageFileType)fileType).getLanguage()) instanceof JSLanguageDialect && ((JSLanguageDialect)language).getOptionHolder().isECMA4 || !language.isKindOf((Language)JavascriptLanguage.INSTANCE)) continue;
            fileTypes.add(fileType);
        }
        if (fileTypes.isEmpty()) {
            Logger.getInstance(JSLanguageUtil.class).warn("No file types compilable to JavaScript: " + Arrays.toString(registeredFileTypes));
        }
        fileTypes.addAll(TypeScriptUtil.TYPESCRIPT_FILE_TYPES);
        fileTypes.addAll(DialectDetector.JAVASCRIPT_FILE_TYPES);
        Collection<FileType> collection = Collections.unmodifiableCollection(fileTypes);
        if (collection == null) {
            JSLanguageUtil.$$$reportNull$$$0(5);
        }
        return collection;
    }

    public static JavaScriptParser createJSParser(@NotNull JSLanguageDialect language, @NotNull PsiBuilder builder2) {
        ParserDefinition parserDefinition;
        if (language == null) {
            JSLanguageUtil.$$$reportNull$$$0(6);
        }
        if (builder2 == null) {
            JSLanguageUtil.$$$reportNull$$$0(7);
        }
        return (parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)language)) instanceof JavascriptParserDefinition ? ((JavascriptParserDefinition)parserDefinition).createJSParser(builder2) : new JavaScriptParser(language, builder2);
    }

    @NotNull
    public static String getDefaultExtension(@Nullable Language language) {
        LanguageFileType fileType = null;
        if (language != null) {
            fileType = language.getAssociatedFileType();
        }
        if (fileType == null) {
            fileType = JavaScriptFileType.INSTANCE;
        }
        String string = fileType.getDefaultExtension();
        if (string == null) {
            JSLanguageUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/JSLanguageUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageDialect";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/JSLanguageUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageForParser";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypesCompilableToJavaScript";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultExtension";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageForParser";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createJSParser";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

