/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.refactoring;

import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.refactoring.ES6MoveModuleDestination;
import com.intellij.lang.ecmascript6.refactoring.ES6MoveModuleMembersDialog;
import com.intellij.lang.ecmascript6.refactoring.ES6MoveModuleMembersProcessor;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6MoveModuleMembersHandler
extends MoveHandlerDelegate {
    public static final Key<String> EXPLICIT_TARGET_MODULE_KEY = new Key("ES6MoveModuleMembersHandler.EXPLICIT_TARGET_FILE_KEY");
    public static final Key<Boolean> EXPLICIT_ESCALATE_VISIBILITY_KEY = new Key("ES6MoveModuleMembersHandler.EXPLICIT_ESCALATE_VISIBILITY_KEY");

    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable PsiReference reference) {
        PsiElement firstModule = null;
        for (PsiElement element : elements) {
            PsiElement movableElement = ES6MoveModuleMembersHandler.getMovableElement(element);
            PsiElement module = ES6MoveModuleMembersHandler.getModuleOrContainingFile(movableElement);
            if (module == null) {
                return false;
            }
            if (firstModule == null) {
                firstModule = module;
                continue;
            }
            if (firstModule.isEquivalentTo(module)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static PsiElement getMovableElement(@Nullable PsiElement element) {
        JSVariable[] variables;
        if (!DialectDetector.hasFeature(element, JSLanguageFeature.IMPORT_DECLARATIONS)) {
            return null;
        }
        if (JSCorePredefinedLibrariesProvider.isLibraryElement(element)) {
            return null;
        }
        if (element instanceof PsiWhiteSpace) {
            element = element.getPrevSibling();
        }
        if (element instanceof JSQualifiedNamedElement || element instanceof ES6ExportDefaultAssignment) {
            return element;
        }
        if (element instanceof JSVarStatement && (variables = ((JSVarStatement)element).getVariables()).length == 1) {
            return variables[0];
        }
        return null;
    }

    @Nullable
    private static PsiElement getModuleOrContainingFile(@Nullable PsiElement element) {
        PsiElement module = PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{JSFile.class, JSEmbeddedContent.class});
        if (module != null && ES6MoveModuleMembersHandler.isAcceptableFileOrModule(module)) {
            return module;
        }
        return null;
    }

    private static boolean isAcceptableFileOrModule(@Nullable PsiElement element) {
        if (element instanceof JSModuleStatusOwner) {
            JSModuleStatusOwner.ModuleStatus moduleStatus = ((JSModuleStatusOwner)element).getModuleStatus();
            return moduleStatus == JSModuleStatusOwner.ModuleStatus.ES6 || moduleStatus == JSModuleStatusOwner.ModuleStatus.NONE;
        }
        return ES6PsiUtil.isEmbeddedModule(element);
    }

    public void doMove(Project project, PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable MoveCallback callback) {
        if (elements.length == 0) {
            return;
        }
        PsiElement sourceModuleOrFile = ES6MoveModuleMembersHandler.getModuleOrContainingFile(elements[0]);
        if (sourceModuleOrFile == null) {
            return;
        }
        if (!JSRefactoringUtil.checkReadOnlyStatus(sourceModuleOrFile, PsiEditorUtil.findEditor((PsiElement)sourceModuleOrFile), (String)ObjectUtils.coalesce((Object)this.getActionName(elements), (Object)JavaScriptBundle.message("dialog.title.move.members", new Object[0])))) {
            return;
        }
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)sourceModuleOrFile);
        if (file == null) {
            return;
        }
        String fromPath = StringUtil.notNullize((String)file.getPresentableUrl());
        List<JSQualifiedNamedElement> selectedElements = Arrays.stream(elements).filter(el -> el instanceof JSQualifiedNamedElement).map(el -> (JSQualifiedNamedElement)el).collect(Collectors.toList());
        String toPath = (String)ObjectUtils.coalesce((Object)ES6MoveModuleMembersHandler.getToPath(selectedElements, file), (Object)fromPath);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String targetModule = (String)project.getUserData(EXPLICIT_TARGET_MODULE_KEY);
            ES6MoveModuleDestination destination = ES6MoveModuleDestination.getModuleDestination(sourceModuleOrFile, targetModule);
            boolean escalateVisibility = (Boolean)ObjectUtils.notNull((Object)((Boolean)project.getUserData(EXPLICIT_ESCALATE_VISIBILITY_KEY)), (Object)Boolean.FALSE);
            assert (targetModule != null);
            assert (destination != null);
            new ES6MoveModuleMembersProcessor(selectedElements, destination, sourceModuleOrFile, escalateVisibility, null).run();
        } else {
            ES6MoveModuleMembersDialog dialog = new ES6MoveModuleMembersDialog(project, fromPath, toPath, selectedElements, sourceModuleOrFile, callback);
            dialog.show();
        }
    }

    @Nullable
    private static String getToPath(@NotNull List<JSQualifiedNamedElement> selectedElements, @NotNull VirtualFile file) {
        if (selectedElements == null) {
            ES6MoveModuleMembersHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ES6MoveModuleMembersHandler.$$$reportNull$$$0(1);
        }
        if (selectedElements.size() != 1) {
            return null;
        }
        JSQualifiedNamedElement element = selectedElements.get(0);
        String name = element.getName();
        if (name == null) {
            return null;
        }
        VirtualFile parent = file.getParent();
        return FileUtil.toSystemDependentName((String)(parent.getPath() + "/" + JSNameSuggestionsUtil.fileNameFromElementName(element, name) + "." + file.getExtension()));
    }

    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, @Nullable PsiReference reference, Editor editor) {
        PsiElement movableElement = ES6MoveModuleMembersHandler.getMovableElement(element);
        PsiElement module = ES6MoveModuleMembersHandler.getModuleOrContainingFile(movableElement);
        if (module != null) {
            this.doMove(project, new PsiElement[]{movableElement}, null, null);
            return true;
        }
        return false;
    }

    public boolean supportsLanguage(@NotNull Language language) {
        if (language == null) {
            ES6MoveModuleMembersHandler.$$$reportNull$$$0(2);
        }
        return language.isKindOf((Language)JavascriptLanguage.INSTANCE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedElements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getToPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "supportsLanguage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

