/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing;

import com.intellij.javascript.testFramework.JsTestSelector;
import com.intellij.javascript.testing.detection.JsTestFrameworkDetector;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u0018\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0002H\u0002\u001a*\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u0002\u001a\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001e0\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"\u001a$\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00122\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0012H\u0002\"\u001d\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0002X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"TEST_NAMES_INDEX_NAME", "Lcom/intellij/util/indexing/ID;", "", "Ljava/lang/Void;", "getTEST_NAMES_INDEX_NAME", "()Lcom/intellij/util/indexing/ID;", "BASE_VERSION", "", "KEY_DELIMITER", "", "TEST_NAMES_PREFIX", "TESTS_DETECTOR_KEY_PREFIX", "JS_TEST_NAMES_INDEX_DELIMITER", "toTestNameIndexKey", "testName", "testSelector", "Lcom/intellij/javascript/testFramework/JsTestSelector;", "extractTestNamesFromIndexKey", "", "indexKey", "toTestsDetectorIndexKey", "detector", "Lcom/intellij/javascript/testing/detection/JsTestFrameworkDetector;", "toCustomMarkerIndexKey", "customMarker", "hasFrameworkNamesDetectionMarker", "", "project", "Lcom/intellij/openapi/project/Project;", "directory", "Lcom/intellij/openapi/vfs/VirtualFile;", "frameworkCustomMarker", "findTestFilesByIndexKey", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "findTestFilesByTestSelector", "lowerJsFileTypesRelevance", "files", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJsTestFileByTestNamesIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsTestFileByTestNamesIndex.kt\ncom/intellij/javascript/testing/JsTestFileByTestNamesIndexKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n1#2:211\n*E\n"})
public final class JsTestFileByTestNamesIndexKt {
    @NotNull
    private static final ID<String, Void> TEST_NAMES_INDEX_NAME;
    private static final int BASE_VERSION = 1;
    private static final char KEY_DELIMITER = '\u0000';
    @NotNull
    private static final String TEST_NAMES_PREFIX = "T\u0000";
    @NotNull
    private static final String TESTS_DETECTOR_KEY_PREFIX = "D\u0000";
    @NotNull
    public static final String JS_TEST_NAMES_INDEX_DELIMITER = "\u0000";

    @NotNull
    public static final ID<String, Void> getTEST_NAMES_INDEX_NAME() {
        return TEST_NAMES_INDEX_NAME;
    }

    private static final String toTestNameIndexKey(String testName) {
        return TEST_NAMES_PREFIX + testName;
    }

    private static final String toTestNameIndexKey(JsTestSelector testSelector) {
        return TEST_NAMES_PREFIX + CollectionsKt.joinToString$default((Iterable)testSelector.getNames(), (CharSequence)JS_TEST_NAMES_INDEX_DELIMITER, null, null, (int)0, null, null, (int)62, null);
    }

    @Nullable
    public static final List<String> extractTestNamesFromIndexKey(@NotNull String indexKey) {
        Intrinsics.checkNotNullParameter((Object)indexKey, (String)"indexKey");
        if (StringsKt.startsWith$default((String)indexKey, (String)TEST_NAMES_PREFIX, (boolean)false, (int)2, null)) {
            String string = indexKey.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String[] stringArray = new String[]{JS_TEST_NAMES_INDEX_DELIMITER};
            return StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        }
        return null;
    }

    private static final String toTestsDetectorIndexKey(JsTestFrameworkDetector detector) {
        return TESTS_DETECTOR_KEY_PREFIX + detector.getFrameworkName();
    }

    private static final String toCustomMarkerIndexKey(JsTestFrameworkDetector detector, String customMarker) {
        return JsTestFileByTestNamesIndexKt.toTestsDetectorIndexKey(detector) + JS_TEST_NAMES_INDEX_DELIMITER + customMarker;
    }

    public static final boolean hasFrameworkNamesDetectionMarker(@NotNull Project project, @NotNull VirtualFile directory, @NotNull JsTestFrameworkDetector detector, @Nullable String frameworkCustomMarker) {
        String string;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
                Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
                if (project.isDisposed() || DumbService.Companion.isDumb(project)) {
                    return false;
                }
                string = frameworkCustomMarker;
                if (string == null) break block4;
                String it = string;
                boolean bl = false;
                String string2 = JsTestFileByTestNamesIndexKt.toCustomMarkerIndexKey(detector, it);
                string = string2;
                if (string2 != null) break block5;
            }
            string = JsTestFileByTestNamesIndexKt.toTestsDetectorIndexKey(detector);
        }
        String dataKey = string;
        AtomicBoolean result2 = new AtomicBoolean(false);
        GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)directory, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"directoryScope(...)");
        GlobalSearchScope scope2 = globalSearchScope;
        FileBasedIndex.getInstance().processFilesContainingAnyKey(TEST_NAMES_INDEX_NAME, (Collection)CollectionsKt.listOf((Object)dataKey), scope2, null, null, arg_0 -> JsTestFileByTestNamesIndexKt.hasFrameworkNamesDetectionMarker$lambda$2(arg_0 -> JsTestFileByTestNamesIndexKt.hasFrameworkNamesDetectionMarker$lambda$1(result2, arg_0), arg_0));
        return result2.get();
    }

    public static /* synthetic */ boolean hasFrameworkNamesDetectionMarker$default(Project project, VirtualFile virtualFile, JsTestFrameworkDetector jsTestFrameworkDetector, String string, int n, Object object) {
        if ((n & 8) != 0) {
            string = null;
        }
        return JsTestFileByTestNamesIndexKt.hasFrameworkNamesDetectionMarker(project, virtualFile, jsTestFrameworkDetector, string);
    }

    @NotNull
    public static final List<VirtualFile> findTestFilesByIndexKey(@NotNull String indexKey, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter((Object)indexKey, (String)"indexKey");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Project project = scope2.getProject();
        if (project != null && (project.isDisposed() || DumbService.Companion.isDumb(project))) {
            return CollectionsKt.emptyList();
        }
        Collection collection = FileBasedIndex.getInstance().getContainingFiles(TEST_NAMES_INDEX_NAME, (Object)indexKey, scope2);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getContainingFiles(...)");
        Collection files = collection;
        return JsTestFileByTestNamesIndexKt.lowerJsFileTypesRelevance(CollectionsKt.toMutableList((Collection)files));
    }

    @NotNull
    public static final List<VirtualFile> findTestFilesByTestSelector(@NotNull Project project, @NotNull JsTestSelector testSelector, @NotNull JsTestFrameworkDetector detector) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)testSelector, (String)"testSelector");
        Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
        if (project.isDisposed() || DumbService.Companion.isDumb(project)) {
            return CollectionsKt.emptyList();
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
        GlobalSearchScope scope2 = globalSearchScope;
        List results = new ArrayList();
        Object[] objectArray = new String[]{JsTestFileByTestNamesIndexKt.toTestNameIndexKey(testSelector), JsTestFileByTestNamesIndexKt.toTestsDetectorIndexKey(detector)};
        FileBasedIndex.getInstance().processFilesContainingAllKeys(TEST_NAMES_INDEX_NAME, (Collection)CollectionsKt.listOf((Object[])objectArray), scope2, null, arg_0 -> JsTestFileByTestNamesIndexKt.findTestFilesByTestSelector$lambda$4(arg_0 -> JsTestFileByTestNamesIndexKt.findTestFilesByTestSelector$lambda$3(results, arg_0), arg_0));
        return JsTestFileByTestNamesIndexKt.lowerJsFileTypesRelevance(results);
    }

    private static final List<VirtualFile> lowerJsFileTypesRelevance(List<? extends VirtualFile> files) {
        if (files.size() <= 1) {
            return files;
        }
        return CollectionsKt.sortedWith((Iterable)files, (arg_0, arg_1) -> JsTestFileByTestNamesIndexKt.lowerJsFileTypesRelevance$lambda$6(JsTestFileByTestNamesIndexKt::lowerJsFileTypesRelevance$lambda$5, arg_0, arg_1));
    }

    private static final boolean hasFrameworkNamesDetectionMarker$lambda$1(AtomicBoolean $result, VirtualFile it) {
        $result.set(true);
        return false;
    }

    private static final boolean hasFrameworkNamesDetectionMarker$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean findTestFilesByTestSelector$lambda$3(List $results, VirtualFile it) {
        Intrinsics.checkNotNull((Object)it);
        return $results.add(it);
    }

    private static final boolean findTestFilesByTestSelector$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final int lowerJsFileTypesRelevance$lambda$5(VirtualFile file1, VirtualFile file2) {
        int n;
        String string = file1.getExtension();
        if (string == null) {
            string = "";
        }
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String ext1 = string2;
        String string3 = file2.getExtension();
        if (string3 == null) {
            string3 = "";
        }
        String string4 = string3.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        String ext2 = string4;
        boolean isJs1 = Intrinsics.areEqual((Object)ext1, (Object)"js");
        boolean isJs2 = Intrinsics.areEqual((Object)ext2, (Object)"js");
        if (isJs1 != isJs2) {
            n = isJs1 ? 1 : -1;
        } else {
            String string5 = file1.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getPath(...)");
            String string6 = file2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getPath(...)");
            n = StringsKt.compareTo((String)string5, (String)string6, (boolean)true);
        }
        return n;
    }

    private static final int lowerJsFileTypesRelevance$lambda$6(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    public static final /* synthetic */ String access$toTestNameIndexKey(String testName) {
        return JsTestFileByTestNamesIndexKt.toTestNameIndexKey(testName);
    }

    public static final /* synthetic */ String access$toCustomMarkerIndexKey(JsTestFrameworkDetector detector, String customMarker) {
        return JsTestFileByTestNamesIndexKt.toCustomMarkerIndexKey(detector, customMarker);
    }

    public static final /* synthetic */ String access$toTestsDetectorIndexKey(JsTestFrameworkDetector detector) {
        return JsTestFileByTestNamesIndexKt.toTestsDetectorIndexKey(detector);
    }

    static {
        ID iD = ID.create((String)"js.test.names.extensible");
        Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"create(...)");
        TEST_NAMES_INDEX_NAME = iD;
    }
}

