/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.github.ultimate.features.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.util.PathUtil;
import com.intellij.vcs.github.ultimate.features.context.handler.GitHubActionContext;
import com.intellij.vcs.github.ultimate.features.i18n.GithubUltimateBundle;
import com.intellij.vcs.github.ultimate.features.ide.actions.BaseCreateFileAction;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J$\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\rH\u0014J$\u0010\u0014\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0015\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u0014J\u001c\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u0016R\u0018\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/vcs/github/ultimate/features/ide/actions/CreateActionFileAction;", "Lcom/intellij/vcs/github/ultimate/features/ide/actions/BaseCreateFileAction;", "<init>", "()V", "actionName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "buildDialog", "", "project", "Lcom/intellij/openapi/project/Project;", "directory", "Lcom/intellij/psi/PsiDirectory;", "builder", "Lcom/intellij/ide/actions/CreateFileFromTemplateDialog$Builder;", "prepareProperties", "", "name", "dir", "getActionName", "newName", "templateName", "isProperDirectory", "", "dirName", "parentDirName", "intellij.vcs.github.ultimate.features"})
public final class CreateActionFileAction
extends BaseCreateFileAction {
    @NotNull
    private final String actionName;

    public CreateActionFileAction() {
        String string = GithubUltimateBundle.message("github.action.file.create", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.actionName = string;
    }

    protected void buildDialog(@NotNull Project project, @NotNull PsiDirectory directory, @NotNull CreateFileFromTemplateDialog.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.setTitle(this.actionName).setDefaultText("action.yml").setValidator((InputValidator)new InputValidatorEx(){

            public String getErrorText(String inputString) {
                Object[] objectArray = new Object[]{GitHubActionContext.ContextUtils.getFileNames()};
                String string = GithubUltimateBundle.message("invalid.github.action.file.name", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            public boolean checkInput(String inputString) {
                String string = inputString;
                if (string == null) {
                    string = "";
                }
                String string2 = PathUtil.getFileName((String)string);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFileName(...)");
                String fileName = string2;
                return GitHubActionContext.ContextUtils.getFileNames().contains(fileName);
            }

            public boolean canClose(String inputString) {
                return this.checkInput(inputString);
            }
        }).addKind(GithubUltimateBundle.message("github.action.file.description", new Object[0]), AllIcons.Vcs.Vendors.Github, "action");
    }

    @Override
    @NotNull
    protected Map<String, String> prepareProperties(@NotNull String name, @NotNull PsiDirectory dir) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        HashMap props = new HashMap();
        Map map2 = props;
        String string = "FOLDER_NAME";
        Object object = NioPathUtil.toNioPathOrNull((String)name);
        if (object == null || (object = object.getParent()) == null || (object = PathsKt.getName((Path)object)) == null) {
            String string2 = dir.getName();
            object = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        }
        Object object2 = object;
        map2.put(string, object2);
        return props;
    }

    @NotNull
    protected String getActionName(@Nullable PsiDirectory directory, @NotNull String newName, @Nullable String templateName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        return this.actionName;
    }

    @Override
    public boolean isProperDirectory(@Nullable String dirName, @Nullable String parentDirName) {
        return Intrinsics.areEqual((Object)dirName, (Object)"actions") && Intrinsics.areEqual((Object)parentDirName, (Object)".github");
    }
}

