/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.searchEverywhereMl.ranking.core;

import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereEssentialContributorMarker;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.searchEverywhereMl.SearchEverywhereMlExperiment;
import com.intellij.searchEverywhereMl.SearchEverywhereTabWithMlRanking;
import com.intellij.searchEverywhereMl.ranking.core.SearchEverywhereMLSearchSession;
import com.intellij.searchEverywhereMl.ranking.core.SearchEverywhereMlRankingService;
import com.intellij.searchEverywhereMl.ranking.core.SearchEverywhereMlRankingServiceKt;
import com.intellij.searchEverywhereMl.ranking.core.SearchEverywhereMlSearchState;
import com.intellij.searchEverywhereMl.ranking.core.model.CatBoostModelFactory;
import com.intellij.searchEverywhereMl.ranking.core.model.SearchEverywhereCatBoostBinaryClassifierModel;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\u0007H\u0016J\b\u0010\n\u001a\u00020\u0007H\u0002J\b\u0010\u000b\u001a\u00020\u0007H\u0002J\u001b\u0010\f\u001a\u0004\u0018\u00010\u00072\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u001e\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u00112\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/searchEverywhereMl/ranking/core/SearchEverywhereEssentialContributorMlMarker;", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereEssentialContributorMarker;", "<init>", "()V", "model", "Lcom/intellij/searchEverywhereMl/ranking/core/model/SearchEverywhereCatBoostBinaryClassifierModel;", "isExperimentDisabledByRegistry", "", "()Z", "isAvailable", "isActiveExperiment", "isSearchStateActive", "isContributorEssential", "contributor", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereContributor;", "(Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereContributor;)Ljava/lang/Boolean;", "getFeatures", "", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "Companion", "intellij.searchEverywhereMl.ranking.core"})
@SourceDebugExtension(value={"SMAP\nSearchEverywhereEssentialContributorMarker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchEverywhereEssentialContributorMarker.kt\ncom/intellij/searchEverywhereMl/ranking/core/SearchEverywhereEssentialContributorMlMarker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1#2:77\n25#3:78\n1187#4,2:79\n1261#4,4:81\n*S KotlinDebug\n*F\n+ 1 SearchEverywhereEssentialContributorMarker.kt\ncom/intellij/searchEverywhereMl/ranking/core/SearchEverywhereEssentialContributorMlMarker\n*L\n55#1:78\n61#1:79,2\n61#1:81,4\n*E\n"})
public final class SearchEverywhereEssentialContributorMlMarker
implements SearchEverywhereEssentialContributorMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SearchEverywhereCatBoostBinaryClassifierModel model = new CatBoostModelFactory().withModelDirectory("ec_model_exp").withResourceDirectory("ec_features_exp").buildBinaryClassifier(0.4);
    @NotNull
    private static final String MODEL_DIR = "ec_model_exp";
    @NotNull
    private static final String RESOURCE_DIR = "ec_features_exp";
    private static final double TRUE_THRESHOLD = 0.4;

    private final boolean isExperimentDisabledByRegistry() {
        return Registry.Companion.is("search.everywhere.force.disable.experiment.essential.contributors.ml");
    }

    public boolean isAvailable() {
        return this.isActiveExperiment() && this.isSearchStateActive();
    }

    private final boolean isActiveExperiment() {
        if (this.isExperimentDisabledByRegistry()) {
            return false;
        }
        SearchEverywhereMlExperiment experiment = new SearchEverywhereMlExperiment();
        SearchEverywhereMlExperiment.ExperimentType experimentForAllTab = experiment.getExperimentForTab(SearchEverywhereTabWithMlRanking.ALL);
        return experimentForAllTab == SearchEverywhereMlExperiment.ExperimentType.ESSENTIAL_CONTRIBUTOR_PREDICTION;
    }

    private final boolean isSearchStateActive() {
        try {
            SearchEverywhereMlRankingService searchEverywhereMlRankingService = SearchEverywhereMlRankingServiceKt.getSearchEverywhereMlRankingService();
            if (searchEverywhereMlRankingService == null) {
                boolean $i$a$-checkNotNull-SearchEverywhereEssentialContributorMlMarker$isSearchStateActive$rankingService$22 = false;
                String $i$a$-checkNotNull-SearchEverywhereEssentialContributorMlMarker$isSearchStateActive$rankingService$22 = "Search Everywhere Ranking Service is null";
                throw new IllegalStateException($i$a$-checkNotNull-SearchEverywhereEssentialContributorMlMarker$isSearchStateActive$rankingService$22.toString());
            }
            SearchEverywhereMlRankingService rankingService = searchEverywhereMlRankingService;
            SearchEverywhereMLSearchSession searchEverywhereMLSearchSession = rankingService.getCurrentSession$intellij_searchEverywhereMl_ranking_core();
            if (searchEverywhereMLSearchSession == null) {
                boolean $i$a$-checkNotNull-SearchEverywhereEssentialContributorMlMarker$isSearchStateActive$searchSession$22 = false;
                String $i$a$-checkNotNull-SearchEverywhereEssentialContributorMlMarker$isSearchStateActive$searchSession$22 = "Search Everywhere Search Session is null";
                throw new IllegalStateException($i$a$-checkNotNull-SearchEverywhereEssentialContributorMlMarker$isSearchStateActive$searchSession$22.toString());
            }
            SearchEverywhereMLSearchSession searchSession = searchEverywhereMLSearchSession;
            if (searchSession.getCurrentSearchState() == null) {
                boolean $i$a$-checkNotNull-SearchEverywhereEssentialContributorMlMarker$isSearchStateActive$22 = false;
                String $i$a$-checkNotNull-SearchEverywhereEssentialContributorMlMarker$isSearchStateActive$22 = "Search Everywhere Search State is null";
                throw new IllegalStateException($i$a$-checkNotNull-SearchEverywhereEssentialContributorMlMarker$isSearchStateActive$22.toString());
            }
            return true;
        }
        catch (IllegalStateException e) {
            SearchEverywhereEssentialContributorMlMarker $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SearchEverywhereEssentialContributorMlMarker.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug((Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Boolean isContributorEssential(@NotNull SearchEverywhereContributor<?> contributor) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter(contributor, (String)"contributor");
        Iterable $this$associate$iv = this.getFeatures(contributor);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            EventPair it = (EventPair)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getField().getName(), (Object)it.getData());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map features = destination$iv$iv;
        return this.model.predictTrue(features);
    }

    private final List<EventPair<?>> getFeatures(SearchEverywhereContributor<?> contributor) {
        SearchEverywhereMlRankingService searchEverywhereMlRankingService = SearchEverywhereMlRankingServiceKt.getSearchEverywhereMlRankingService();
        if (searchEverywhereMlRankingService == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        SearchEverywhereMlRankingService rankingService = searchEverywhereMlRankingService;
        SearchEverywhereMLSearchSession searchEverywhereMLSearchSession = rankingService.getCurrentSession$intellij_searchEverywhereMl_ranking_core();
        if (searchEverywhereMLSearchSession == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        SearchEverywhereMLSearchSession searchSession = searchEverywhereMLSearchSession;
        SearchEverywhereMlSearchState searchEverywhereMlSearchState = searchSession.getCurrentSearchState();
        if (searchEverywhereMlSearchState == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        SearchEverywhereMlSearchState searchState = searchEverywhereMlSearchState;
        List<EventPair<?>> sessionContextFeatures = searchSession.getCachedContextInfo().getFeatures();
        List<EventPair<?>> stateFeatures = searchState.getSearchStateFeatures();
        List<EventPair<?>> contributorFeatures = searchState.getContributorFeatures(contributor);
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)sessionContextFeatures, (Iterable)stateFeatures), (Iterable)contributorFeatures);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/searchEverywhereMl/ranking/core/SearchEverywhereEssentialContributorMlMarker$Companion;", "", "<init>", "()V", "MODEL_DIR", "", "RESOURCE_DIR", "TRUE_THRESHOLD", "", "intellij.searchEverywhereMl.ranking.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

