/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui;

import com.intellij.icons.AllIcons;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.ProgressStatus;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.editor.ex.EditorEx;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0003\u001e\u001f B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0006\u0010\u001b\u001a\u00020\u0018J\b\u0010\u001c\u001a\u00020\u0018H\u0002J\b\u0010\u001d\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006!"}, d2={"Lcom/intellij/notebooks/visualization/ui/EditorCellRunGutterButton;", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "cell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/notebooks/visualization/ui/EditorCell;)V", "lastRunButtonVisibility", "", "getLastRunButtonVisibility", "()Ljava/lang/Boolean;", "setLastRunButtonVisibility", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "currentAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "value", "visible", "getVisible", "()Z", "setVisible", "(Z)V", "updateGutterAction", "", "currentStatus", "Lcom/intellij/notebooks/visualization/ui/ProgressStatus;", "updateIfShown", "showRunButton", "hideRunButton", "RunCellGutterAction", "StopCellExecutionGutterAction", "DummyEmptyAction", "intellij.notebooks.visualization"})
public final class EditorCellRunGutterButton {
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final EditorCell cell;
    @Nullable
    private Boolean lastRunButtonVisibility;
    @NotNull
    private AnAction currentAction;
    private boolean visible;

    public EditorCellRunGutterButton(@NotNull EditorEx editor, @NotNull EditorCell cell) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        this.editor = editor;
        this.cell = cell;
        this.lastRunButtonVisibility = false;
        this.currentAction = new RunCellGutterAction(this.cell);
    }

    @Nullable
    public final Boolean getLastRunButtonVisibility() {
        return this.lastRunButtonVisibility;
    }

    public final void setLastRunButtonVisibility(@Nullable Boolean bl) {
        this.lastRunButtonVisibility = bl;
    }

    public final boolean getVisible() {
        return this.visible;
    }

    public final void setVisible(boolean value) {
        if (value) {
            this.showRunButton();
        } else {
            this.hideRunButton();
        }
        this.visible = value;
    }

    public final void updateGutterAction(@Nullable ProgressStatus currentStatus) {
        AnAction newAction;
        ProgressStatus progressStatus = currentStatus;
        AnAction anAction = newAction = (progressStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[progressStatus.ordinal()]) == 1 ? new StopCellExecutionGutterAction() : new RunCellGutterAction(this.cell);
        if (Intrinsics.areEqual((Object)newAction, (Object)this.currentAction)) {
            return;
        }
        this.currentAction = newAction;
        if (this.visible) {
            this.showRunButton();
        }
    }

    public final void updateIfShown() {
        boolean bl = this.visible;
        if (bl) {
            this.showRunButton();
        } else if (bl) {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void showRunButton() {
        try {
            this.cell.setGutterAction(this.currentAction);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void hideRunButton() {
        this.cell.setGutterAction(new DummyEmptyAction());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/notebooks/visualization/ui/EditorCellRunGutterButton$DummyEmptyAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "(Lcom/intellij/notebooks/visualization/ui/EditorCellRunGutterButton;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.notebooks.visualization"})
    public final class DummyEmptyAction
    extends AnAction {
        public DummyEmptyAction() {
            super(AllIcons.Empty);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/notebooks/visualization/ui/EditorCellRunGutterButton$RunCellGutterAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$BackendOnly;", "cell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "<init>", "(Lcom/intellij/notebooks/visualization/ui/EditorCellRunGutterButton;Lcom/intellij/notebooks/visualization/ui/EditorCell;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.notebooks.visualization"})
    public final class RunCellGutterAction
    extends AnAction
    implements ActionRemoteBehaviorSpecification.BackendOnly {
        @NotNull
        private final EditorCell cell;

        public RunCellGutterAction(EditorCell cell) {
            Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
            super(AllIcons.RunConfigurations.TestState.Run);
            this.cell = cell;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            int cellLineOffset = this.cell.getInterval().getLines().getFirst();
            EditorCellRunGutterButton.this.editor.getCaretModel().moveToOffset(EditorCellRunGutterButton.this.editor.getDocument().getLineStartOffset(cellLineOffset));
            AnAction runCellAction = ActionManager.getInstance().getAction("NotebookRunCellAction");
            runCellAction.actionPerformed(e);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/notebooks/visualization/ui/EditorCellRunGutterButton$StopCellExecutionGutterAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$BackendOnly;", "<init>", "(Lcom/intellij/notebooks/visualization/ui/EditorCellRunGutterButton;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.notebooks.visualization"})
    public final class StopCellExecutionGutterAction
    extends AnAction
    implements ActionRemoteBehaviorSpecification.BackendOnly {
        public StopCellExecutionGutterAction() {
            super(AllIcons.Run.Stop);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            AnAction interruptKernelAction = ActionManager.getInstance().getAction("JupyterInterruptKernelAction");
            interruptKernelAction.actionPerformed(e);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProgressStatus.values().length];
            try {
                nArray[ProgressStatus.RUNNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

