/*
 * Decompiled with CFR 0.152.
 */
package training.dsl;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.util.text.StringUtil;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import training.ui.LearningUiManager;
import training.util.UtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u0003H\u0016J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003H\u0016J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u0003H\u0016J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000e\u00c0\u0006\u0001"}, d2={"Ltraining/dsl/LearningDslBase;", "", "action", "", "actionId", "code", "sourceSample", "strong", "text", "icon", "Ljavax/swing/Icon;", "actionIcon", "shortcut", "key", "intellij.featuresTrainer"})
public interface LearningDslBase {
    @NotNull
    default public String action(@Language(value="devkit-action-id") @NotNull String actionId) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        return UtilsKt.surroundWithNonBreakSpaces("<action>" + actionId + "</action>");
    }

    @NotNull
    default public String code(@NotNull String sourceSample) {
        Intrinsics.checkNotNullParameter((Object)sourceSample, (String)"sourceSample");
        String string = StringUtil.escapeXmlEntities((String)sourceSample);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeXmlEntities(...)");
        return UtilsKt.surroundWithNonBreakSpaces("<code>" + UtilsKt.replaceSpacesWithNonBreakSpace(string) + "</code>");
    }

    @NotNull
    default public String strong(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return "<strong>" + StringUtil.escapeXmlEntities((String)text) + "</strong>";
    }

    @NotNull
    default public String icon(@NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        String index = LearningUiManager.INSTANCE.getIconIndex(icon);
        return "<icon_idx>" + index + "</icon_idx>";
    }

    @NotNull
    default public String actionIcon(@Language(value="devkit-action-id") @NotNull String actionId) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Object object = ActionManager.getInstance().getAction(actionId);
        if (object == null || (object = object.getTemplatePresentation()) == null || (object = object.getIcon()) == null) {
            Icon icon = AllIcons.Toolbar.Unknown;
            object = icon;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Unknown");
        }
        Object icon = object;
        String index = LearningUiManager.INSTANCE.getIconIndex((Icon)icon);
        return "<icon_idx>" + index + "</icon_idx>";
    }

    @NotNull
    default public String shortcut(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return UtilsKt.surroundWithNonBreakSpaces("<shortcut>" + key + "</shortcut>");
    }
}

