/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid.color;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.datagrid.color.ColorLayer;
import com.intellij.database.editor.DataGridColors;
import com.intellij.database.util.DataGridUIUtil;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.ui.hover.TableHoverListener;
import com.intellij.util.ObjectUtils;
import java.awt.Color;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectionColorLayer
implements ColorLayer {
    private final DataGrid myGrid;
    private final boolean myTransparentRowHeaderBg;
    private final boolean myTransparentColumnHeaderBg;

    public SelectionColorLayer(@NotNull DataGrid grid, boolean transparentRowHeaderBg, boolean transparentColumnHeaderBg) {
        if (grid == null) {
            SelectionColorLayer.$$$reportNull$$$0(0);
        }
        this.myGrid = grid;
        this.myTransparentRowHeaderBg = transparentRowHeaderBg;
        this.myTransparentColumnHeaderBg = transparentColumnHeaderBg;
    }

    @Override
    @Nullable
    public Color getCellBackground(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column, @NotNull DataGrid grid, @Nullable Color color) {
        boolean isRowSelected;
        if (row == null) {
            SelectionColorLayer.$$$reportNull$$$0(1);
        }
        if (column == null) {
            SelectionColorLayer.$$$reportNull$$$0(2);
        }
        if (grid == null) {
            SelectionColorLayer.$$$reportNull$$$0(3);
        }
        if (SelectionColorLayer.isRowBgPaintedByTable(row, column, grid, isRowSelected = grid.getSelectionModel().isSelectedRow(row))) {
            return color;
        }
        if (isRowSelected) {
            return SelectionColorLayer.getSelectedRowColor(grid, color);
        }
        return color;
    }

    static boolean isRowBgPaintedByTable(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column, @NotNull DataGrid grid, boolean selected) {
        if (row == null) {
            SelectionColorLayer.$$$reportNull$$$0(4);
        }
        if (column == null) {
            SelectionColorLayer.$$$reportNull$$$0(5);
        }
        if (grid == null) {
            SelectionColorLayer.$$$reportNull$$$0(6);
        }
        ViewIndex viewRow = grid.getResultView().isTransposed() ? column.toView((CoreGrid)grid) : row.toView((CoreGrid)grid);
        return SelectionColorLayer.isRowBgPaintedByTable(viewRow, grid, selected);
    }

    public static boolean isRowBgPaintedByTable(@NotNull ViewIndex<?> viewRow, @NotNull DataGrid grid, boolean selected) {
        if (viewRow == null) {
            SelectionColorLayer.$$$reportNull$$$0(7);
        }
        if (grid == null) {
            SelectionColorLayer.$$$reportNull$$$0(8);
        }
        return SelectionColorLayer.isHoveredRow(viewRow, grid) || SelectionColorLayer.isStripedRow(viewRow, grid) && !selected;
    }

    private static boolean isHoveredRow(@NotNull ViewIndex<?> viewRow, @NotNull DataGrid grid) {
        if (viewRow == null) {
            SelectionColorLayer.$$$reportNull$$$0(9);
        }
        if (grid == null) {
            SelectionColorLayer.$$$reportNull$$$0(10);
        }
        return grid.getResultView().isHoveredRowBgHighlightingEnabled() && grid.getResultView() instanceof JTable && TableHoverListener.getHoveredRow((JTable)((JTable)((Object)grid.getResultView()))) == viewRow.asInteger();
    }

    private static boolean isStripedRow(@NotNull ViewIndex<?> viewRow, @NotNull DataGrid grid) {
        if (viewRow == null) {
            SelectionColorLayer.$$$reportNull$$$0(11);
        }
        if (grid == null) {
            SelectionColorLayer.$$$reportNull$$$0(12);
        }
        return grid.getResultView().isStriped() && viewRow.asInteger() % 2 == 0;
    }

    @Override
    @Nullable
    public Color getRowHeaderBackground(@NotNull ModelIndex<GridRow> row, @NotNull DataGrid grid, @Nullable Color color) {
        boolean selected;
        if (row == null) {
            SelectionColorLayer.$$$reportNull$$$0(13);
        }
        if (grid == null) {
            SelectionColorLayer.$$$reportNull$$$0(14);
        }
        return (selected = grid.getSelectionModel().isSelectedRow(row)) && !SelectionColorLayer.isRowBgPaintedByTable(row, (ModelIndex<GridColumn>)ModelIndex.forColumn((CoreGrid)grid, (int)-1), grid, selected) ? SelectionColorLayer.getSelectedRowColor(grid, color) : this.getHeaderColor(color, grid.getResultView().isTransposed() ? this.myTransparentColumnHeaderBg : this.myTransparentRowHeaderBg);
    }

    @Override
    @Nullable
    public Color getColumnHeaderBackground(@NotNull ModelIndex<GridColumn> column, @NotNull DataGrid grid, @Nullable Color color) {
        boolean selected;
        if (column == null) {
            SelectionColorLayer.$$$reportNull$$$0(15);
        }
        if (grid == null) {
            SelectionColorLayer.$$$reportNull$$$0(16);
        }
        return (selected = grid.getSelectionModel().isSelectedColumn(column)) && !SelectionColorLayer.isRowBgPaintedByTable((ModelIndex<GridRow>)ModelIndex.forRow((CoreGrid)grid, (int)-1), column, grid, selected) ? SelectionColorLayer.getSelectedColumnColor(grid, color) : this.getHeaderColor(color, grid.getResultView().isTransposed() ? this.myTransparentRowHeaderBg : this.myTransparentColumnHeaderBg);
    }

    @Override
    @NotNull
    public Color getRowHeaderForeground(@NotNull ModelIndex<GridRow> row, @NotNull DataGrid grid, @Nullable Color color) {
        if (row == null) {
            SelectionColorLayer.$$$reportNull$$$0(17);
        }
        if (grid == null) {
            SelectionColorLayer.$$$reportNull$$$0(18);
        }
        if (grid.getResultView().isTransposed() || !this.myTransparentRowHeaderBg) {
            Color color2 = grid.getResultView().getComponent().getForeground();
            if (color2 == null) {
                SelectionColorLayer.$$$reportNull$$$0(19);
            }
            return color2;
        }
        Color lineNumbersColor = grid.getColorsScheme().getColor(EditorColors.LINE_NUMBERS_COLOR);
        Color c = grid.getSelectionModel().isSelectedRow(row) ? grid.getColorsScheme().getColor(EditorColors.LINE_NUMBER_ON_CARET_ROW_COLOR) : lineNumbersColor;
        Color color3 = (Color)ObjectUtils.notNull((Object)((Color)ObjectUtils.chooseNotNull((Object)c, (Object)lineNumbersColor)), (Object)grid.getResultView().getComponent().getForeground());
        if (color3 == null) {
            SelectionColorLayer.$$$reportNull$$$0(20);
        }
        return color3;
    }

    @Override
    @NotNull
    public Color getColumnHeaderForeground(@NotNull ModelIndex<GridColumn> column, @NotNull DataGrid grid, @Nullable Color color) {
        if (column == null) {
            SelectionColorLayer.$$$reportNull$$$0(21);
        }
        if (grid == null) {
            SelectionColorLayer.$$$reportNull$$$0(22);
        }
        Color color2 = grid.getResultView().getComponent().getForeground();
        if (color2 == null) {
            SelectionColorLayer.$$$reportNull$$$0(23);
        }
        return color2;
    }

    @Override
    public int getPriority() {
        return 3;
    }

    @Nullable
    private Color getHeaderColor(@Nullable Color color, boolean transparent) {
        return color == null ? (transparent ? null : DataGridUIUtil.softHighlightOf(this.myGrid.getResultView().getComponent().getBackground())) : color;
    }

    @Nullable
    public Color getHeaderColor(@Nullable Color color) {
        return this.getHeaderColor(color, this.myGrid.getResultView().isTransposed() ? this.myTransparentRowHeaderBg : this.myTransparentColumnHeaderBg);
    }

    @Nullable
    static Color getSelectedRowColor(@NotNull DataGrid grid, @Nullable Color color) {
        if (grid == null) {
            SelectionColorLayer.$$$reportNull$$$0(24);
        }
        return color == null ? SelectionColorLayer.getCurrentColor(grid) : DataGridUIUtil.softHighlightOf(color);
    }

    @Nullable
    static Color getSelectedColumnColor(@NotNull DataGrid grid, @Nullable Color color) {
        if (grid == null) {
            SelectionColorLayer.$$$reportNull$$$0(25);
        }
        return color == null ? SelectionColorLayer.getCurrentColor(grid) : color;
    }

    @Nullable
    private static Color getCurrentColor(@NotNull DataGrid grid) {
        if (grid == null) {
            SelectionColorLayer.$$$reportNull$$$0(26);
        }
        return grid.getResultView().isStriped() ? grid.getHoveredRowBackground() : grid.getColorsScheme().getColor(DataGridColors.GRID_CURRENT_ROW);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 19, 20, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 4: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 5: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewRow";
                break;
            }
            case 19: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/color/SelectionColorLayer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/color/SelectionColorLayer";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getRowHeaderForeground";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnHeaderForeground";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCellBackground";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isRowBgPaintedByTable";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isHoveredRow";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isStripedRow";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRowHeaderBackground";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getColumnHeaderBackground";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getRowHeaderForeground";
                break;
            }
            case 19: 
            case 20: 
            case 23: {
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getColumnHeaderForeground";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedRowColor";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedColumnColor";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentColor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 19, 20, 23 -> new IllegalStateException(string);
        };
    }
}

