/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv.ui;

import com.intellij.DynamicBundle;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.ui.CsvFormatForm;
import com.intellij.database.csv.ui.CsvFormatUISettings;
import com.intellij.database.csv.ui.CsvFormatsListComponent;
import com.intellij.database.csv.ui.preview.CsvFormatPreview;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.view.editors.DataGridEditorUtil;
import com.intellij.openapi.Disposable;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CsvFormatsUI
implements Disposable {
    private CsvFormatsListComponent myFormatsList;
    private JPanel myPanel;
    private JPanel myFormatListPanel;
    private JBLabel myFormatsLabel;
    private CsvFormatForm myFormatForm;
    private JBScrollPane myFormatFormScrollPane;
    private CsvFormatPreview myPreview;
    private final CsvFormatUISettings mySettings;

    public CsvFormatsUI(boolean allowNameEditing, @NotNull CsvFormatUISettings settings) {
        if (settings == null) {
            CsvFormatsUI.$$$reportNull$$$0(0);
        }
        this.mySettings = settings;
        this.$$$setupUI$$$();
        new FormatsListToFormatEditorBond().setListeners();
        ToolbarDecorator decorator = this.createFormatListDecorator();
        this.myFormatListPanel.add((Component)DataGridEditorUtil.labeledDecorator((JComponent)this.myFormatsLabel, decorator), "Center");
        this.myFormatListPanel.setBorder(new EmptyBorder(0, 0, JBUIScale.scale((int)8), UIUtil.getScrollBarWidth()));
        AnActionButton button = ToolbarDecorator.findEditButton((JComponent)decorator.getActionsPanel());
        if (button != null) {
            button.setVisible(false);
        }
        this.myFormatsList.setNameEditingAllowed(allowNameEditing);
        this.myFormatsList.addChangeListener(new CsvFormatsListComponent.ChangeListener(){

            @Override
            public void formatsChanged(@NotNull CsvFormatsListComponent formatsListComponent) {
                CsvFormat selectedFormat;
                if (formatsListComponent == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((selectedFormat = CsvFormatsUI.this.getSelectedFormat()) == null) {
                    return;
                }
                if (CsvFormatsUI.this.myPreview != null) {
                    CsvFormatsUI.this.myPreview.setFormat(selectedFormat, new GridRequestSource(null));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatsListComponent", "com/intellij/database/csv/ui/CsvFormatsUI$1", "formatsChanged"));
            }
        });
        this.myFormatFormScrollPane.setPreferredSize(this.myFormatFormScrollPane.getViewport().getView().getPreferredSize());
    }

    @NotNull
    public CsvFormatForm getFormatForm() {
        CsvFormatForm csvFormatForm = this.myFormatForm;
        if (csvFormatForm == null) {
            CsvFormatsUI.$$$reportNull$$$0(1);
        }
        return csvFormatForm;
    }

    private void createUIComponents() {
        this.myFormatForm = new CsvFormatForm(this, this.mySettings);
        this.myFormatsList = new CsvFormatsListComponent(this);
        this.myFormatFormScrollPane = (JBScrollPane)ScrollPaneFactory.createScrollPane();
        this.myFormatFormScrollPane.setBorder((Border)JBUI.Borders.empty());
    }

    public void reset(@NotNull List<CsvFormat> formats, @Nullable String nameToSelect) {
        if (formats == null) {
            CsvFormatsUI.$$$reportNull$$$0(2);
        }
        this.myFormatsList.reset(formats, nameToSelect);
    }

    @Nullable
    public CsvFormat select(@Nullable CsvFormat format) {
        ArrayList<CsvFormat> formats = new ArrayList<CsvFormat>(this.getFormats());
        CsvFormat existing = this.findFormat(format);
        if (format != null && existing == null) {
            return this.myFormatsList.newFormat(format);
        }
        this.myFormatsList.reset(formats, existing == null ? null : existing.name);
        return existing;
    }

    @NotNull
    public List<CsvFormat> getFormats() {
        List<CsvFormat> list = this.myFormatsList.getFormats();
        if (list == null) {
            CsvFormatsUI.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public CsvFormat getSelectedFormat() {
        return this.myFormatsList.getSelected();
    }

    public void attachPreview(@NotNull CsvFormatPreview preview) {
        if (preview == null) {
            CsvFormatsUI.$$$reportNull$$$0(4);
        }
        this.myPreview = preview;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            CsvFormatsUI.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    public void dispose() {
    }

    @NotNull
    public CsvFormatsListComponent getFormatsListComponent() {
        CsvFormatsListComponent csvFormatsListComponent = this.myFormatsList;
        if (csvFormatsListComponent == null) {
            CsvFormatsUI.$$$reportNull$$$0(6);
        }
        return csvFormatsListComponent;
    }

    public void addFormatChangeListener(@NotNull CsvFormatForm.ChangeListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            CsvFormatsUI.$$$reportNull$$$0(7);
        }
        if (parent == null) {
            CsvFormatsUI.$$$reportNull$$$0(8);
        }
        this.myFormatForm.addChangeListener(listener, parent);
    }

    @NotNull
    protected abstract ToolbarDecorator createFormatListDecorator();

    @Nullable
    private CsvFormat findFormat(@Nullable CsvFormat format) {
        if (format == null) {
            return null;
        }
        for (CsvFormat csvFormat : this.getFormats()) {
            CsvFormat toCompare;
            if (!csvFormat.equals((Object)(toCompare = new CsvFormat(csvFormat.name, format.dataRecord, format.headerRecord, csvFormat.id, format.rowNumbers)))) continue;
            return csvFormat;
        }
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = this.myFormatFormScrollPane;
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel3);
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20), null, 0, 0, null, null));
        CsvFormatForm csvFormatForm = this.myFormatForm;
        JComponent jComponent = csvFormatForm.$$$getRootComponent$$$();
        jPanel3.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 8, 2, 3, 3, null, null, null));
        this.myFormatListPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, new Dimension(1, -1), null));
        this.myFormatsLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DataGridBundle", CsvFormatsUI.class).getString("csv.format.settings.formats"));
        jPanel.add((Component)jBLabel, "North");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/csv/ui/CsvFormatsUI";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formats";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preview";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/csv/ui/CsvFormatsUI";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormatForm";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormats";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormatsListComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "attachPreview";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addFormatChangeListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5, 6 -> new IllegalStateException(string);
        };
    }

    private class FormatsListToFormatEditorBond
    implements CsvFormatsListComponent.ChangeListener,
    CsvFormatForm.ChangeListener {
        private boolean myUpdating;

        private FormatsListToFormatEditorBond() {
        }

        void setListeners() {
            CsvFormatsUI.this.myFormatsList.addChangeListener(this);
            CsvFormatsUI.this.myFormatForm.addChangeListener(this);
        }

        @Override
        public void formatsChanged(@NotNull CsvFormatsListComponent formatsListComponent) {
            if (formatsListComponent == null) {
                FormatsListToFormatEditorBond.$$$reportNull$$$0(0);
            }
            this.update(() -> {
                CsvFormat selectedFormat = CsvFormatsUI.this.myFormatsList.getSelected();
                if (selectedFormat == null) {
                    CsvFormatsUI.this.myFormatForm.getComponent().setVisible(false);
                } else {
                    CsvFormatsUI.this.myFormatForm.getComponent().setVisible(true);
                    CsvFormatsUI.this.myFormatForm.reset(selectedFormat);
                }
            });
        }

        @Override
        public void formatChanged(@NotNull CsvFormatForm source) {
            if (source == null) {
                FormatsListToFormatEditorBond.$$$reportNull$$$0(1);
            }
            this.update(() -> {
                CsvFormat format = CsvFormatsUI.this.myFormatForm.getFormat();
                CsvFormatsUI.this.myFormatsList.updateSelectedFormat(format);
            });
        }

        private void update(Runnable updater) {
            if (this.myUpdating) {
                return;
            }
            this.myUpdating = true;
            try {
                updater.run();
            }
            finally {
                this.myUpdating = false;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formatsListComponent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/csv/ui/CsvFormatsUI$FormatsListToFormatEditorBond";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "formatsChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "formatChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

