/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataWrangler.core.engine;

import com.intellij.dataWrangler.core.engine.DataWranglerCoreContext;
import com.intellij.dataWrangler.core.operations.FilterCommandFactory;
import com.intellij.dataWrangler.executor.DataWranglerEngine;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.util.registry.Registry;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/dataWrangler/core/engine/CoreDataWranglerEngine;", "Lcom/intellij/dataWrangler/executor/DataWranglerEngine;", "Lcom/intellij/dataWrangler/core/engine/DataWranglerCoreContext;", "<init>", "()V", "createInitialContext", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "collectCommandsFactories", "", "Lcom/intellij/dataWrangler/core/operations/FilterCommandFactory;", "canCreateDWContext", "", "intellij.dataWrangler.core"})
public final class CoreDataWranglerEngine
implements DataWranglerEngine<DataWranglerCoreContext> {
    private CoreDataWranglerEngine() {
    }

    @Nullable
    public DataWranglerCoreContext createInitialContext(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!this.canCreateDWContext(dataContext)) {
            return null;
        }
        DataGrid dataGrid = GridUtil.getDataGrid((DataContext)dataContext);
        if (dataGrid == null) {
            return null;
        }
        DataGrid dataGrid2 = dataGrid;
        return new DataWranglerCoreContext(dataGrid2);
    }

    @NotNull
    public List<FilterCommandFactory> collectCommandsFactories() {
        return CollectionsKt.listOf((Object)((Object)new FilterCommandFactory()));
    }

    public boolean canCreateDWContext(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!Registry.Companion.is("tables.datawrangler.plugin.show.core.internal.action")) {
            return false;
        }
        DataGrid dataGrid = GridUtil.getDataGrid((DataContext)dataContext);
        if (dataGrid == null) {
            return false;
        }
        DataGrid dataGrid2 = dataGrid;
        return dataGrid2.getDataHookup() instanceof CsvDocumentDataHookUp;
    }
}

