/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.remote.vfs.file;

import com.intellij.codeWithMe.ClientId;
import com.intellij.jupyter.core.jupyter.remote.JupyterRemoteLocalRootManager;
import com.intellij.notebooks.core.remote.JupyterRemotePath;
import com.intellij.notebooks.core.remote.RemotePath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.PathKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/jupyter/core/jupyter/remote/vfs/file/JupyterRfsLocalFileCache;", "Lcom/intellij/openapi/Disposable$Default;", "<init>", "()V", "syncObj", "", "getOrCreateLocalFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "Lcom/intellij/notebooks/core/remote/JupyterRemotePath;", "isDirectory", "", "deleteLocalFile", "", "toLocalPath", "Ljava/nio/file/Path;", "Companion", "intellij.jupyter.core"})
public final class JupyterRfsLocalFileCache
implements Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Object syncObj = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final VirtualFile getOrCreateLocalFile(@NotNull JupyterRemotePath path, boolean isDirectory) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object object = this.syncObj;
        synchronized (object) {
            VirtualFile localVirtualFile;
            boolean bl = false;
            Path localPath = this.toLocalPath(path);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(localPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (Files.isDirectory(localPath, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) != isDirectory) {
                    PathKt.delete((Path)localPath, (boolean)true);
                }
            }
            LinkOption[] linkOptionArray3 = new LinkOption[]{};
            if (!Files.exists(localPath, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) {
                Path path2 = localPath.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
                Path path3 = path2;
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path3, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
                if (isDirectory) {
                    FileAttribute[] fileAttributeArray2 = new FileAttribute[]{};
                    Path path4 = Files.createDirectory(localPath, Arrays.copyOf(fileAttributeArray2, fileAttributeArray2.length));
                    v6 = path4;
                    Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"createDirectory(...)");
                } else {
                    FileAttribute[] fileAttributeArray3 = new FileAttribute[]{};
                    Path path5 = Files.createFile(localPath, Arrays.copyOf(fileAttributeArray3, fileAttributeArray3.length));
                    v6 = path5;
                    Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"createFile(...)");
                }
            }
            VirtualFile virtualFile2 = VfsUtil.findFile((Path)localPath, (boolean)true);
            if (virtualFile2 == null) {
                throw new IllegalStateException(("Can't find created local file by path " + localPath).toString());
            }
            VirtualFile virtualFile3 = localVirtualFile = virtualFile2;
            return virtualFile3;
        }
    }

    public final void deleteLocalFile(@NotNull JupyterRemotePath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path localPath = this.toLocalPath(path);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(localPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            PathKt.delete((Path)localPath, (boolean)true);
        }
    }

    @NotNull
    public final Path toLocalPath(@NotNull JupyterRemotePath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path2 = JupyterRemoteLocalRootManager.INSTANCE.getLocalRoot().resolve("files").resolve(RemotePath.escapeLocalPathForRemoteUsage((String)path.getFullPath()));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return path2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/jupyter/core/jupyter/remote/vfs/file/JupyterRfsLocalFileCache$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/jupyter/core/jupyter/remote/vfs/file/JupyterRfsLocalFileCache;", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nJupyterRfsLocalFileCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterRfsLocalFileCache.kt\ncom/intellij/jupyter/core/jupyter/remote/vfs/file/JupyterRfsLocalFileCache$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,50:1\n40#2,3:51\n*S KotlinDebug\n*F\n+ 1 JupyterRfsLocalFileCache.kt\ncom/intellij/jupyter/core/jupyter/remote/vfs/file/JupyterRfsLocalFileCache$Companion\n*L\n48#1:51,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JupyterRfsLocalFileCache getInstance() {
            boolean $i$f$service = false;
            Class<JupyterRfsLocalFileCache> serviceClass$iv = JupyterRfsLocalFileCache.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (JupyterRfsLocalFileCache)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

