/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.remote.vfs;

import com.intellij.jupyter.core.jupyter.connections.client.JupyterClient;
import com.intellij.jupyter.core.jupyter.connections.client.status.JupyterConnectionStatus;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.CachingFileContentsApi;
import com.intellij.jupyter.core.jupyter.remote.vfs.JupyterFsFileOutputStream;
import com.intellij.jupyter.core.jupyter.remote.vfs.JupyterRemoteFileSystem;
import com.intellij.jupyter.core.jupyter.remote.vfs.file.JupyterRfsLocalFileCache;
import com.intellij.jupyter.core.jupyter.remote.vfs.utils.JupyterRemoteVfsUtilKt;
import com.intellij.notebooks.core.remote.JupyterRemotePath;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerBase;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 F2\u00020\u0001:\u0001FB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\"\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0016J\u0013\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00000%H\u0016\u00a2\u0006\u0002\u0010&J\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020(J\"\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u00052\b\u0010-\u001a\u0004\u0018\u00010.H\u0016J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u00020\"H\u0016J\b\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u00020\u0005H\u0016J\b\u00107\u001a\u00020\"H\u0016J\b\u00108\u001a\u00020\"H\u0016J\b\u00109\u001a\u00020\"H\u0016J\b\u0010:\u001a\u00020\u0005H\u0016J\n\u0010;\u001a\u0004\u0018\u00010\u0000H\u0016J\b\u0010<\u001a\u00020\u0005H\u0016J\b\u0010=\u001a\u00020\u0001H\u0002J\t\u0010>\u001a\u00020\u0003H\u00c6\u0003J\t\u0010?\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010@\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010A\u001a\u00020\u00052\b\u0010B\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010C\u001a\u00020DH\u00d6\u0001J\t\u0010E\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\nR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006G"}, d2={"Lcom/intellij/jupyter/core/jupyter/remote/vfs/JupyterRemoteVirtualFile;", "Lcom/intellij/openapi/vfs/VirtualFile;", "remotePath", "Lcom/intellij/notebooks/core/remote/JupyterRemotePath;", "isRemoteDirectory", "", "<init>", "(Lcom/intellij/notebooks/core/remote/JupyterRemotePath;Z)V", "getRemotePath", "()Lcom/intellij/notebooks/core/remote/JupyterRemotePath;", "()Z", "client", "Lcom/intellij/jupyter/core/jupyter/connections/client/JupyterClient;", "getClient", "()Lcom/intellij/jupyter/core/jupyter/connections/client/JupyterClient;", "api", "Lcom/intellij/jupyter/core/jupyter/connections/filecontentsapi/CachingFileContentsApi;", "getApi", "()Lcom/intellij/jupyter/core/jupyter/connections/filecontentsapi/CachingFileContentsApi;", "localFile", "getLocalFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "localFilePath", "Ljava/nio/file/Path;", "getLocalFilePath", "()Ljava/nio/file/Path;", "getName", "", "getPath", "getOutputStream", "Ljava/io/OutputStream;", "requestor", "", "newModificationStamp", "", "newTimeStamp", "getChildren", "", "()[Lcom/intellij/jupyter/core/jupyter/remote/vfs/JupyterRemoteVirtualFile;", "clearLocalFile", "", "recreateLocalFile", "refresh", "asynchronous", "recursive", "postRunnable", "Ljava/lang/Runnable;", "contentsToByteArray", "", "getInputStream", "Ljava/io/InputStream;", "getLength", "getFileSystem", "Lcom/intellij/jupyter/core/jupyter/remote/vfs/JupyterRemoteFileSystem;", "isDirectory", "getModificationStamp", "getModificationCount", "getTimeStamp", "isValid", "getParent", "isWritable", "initLocalFile", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterRemoteVirtualFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterRemoteVirtualFile.kt\ncom/intellij/jupyter/core/jupyter/remote/vfs/JupyterRemoteVirtualFile\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,94:1\n37#2:95\n36#2,3:96\n*S KotlinDebug\n*F\n+ 1 JupyterRemoteVirtualFile.kt\ncom/intellij/jupyter/core/jupyter/remote/vfs/JupyterRemoteVirtualFile\n*L\n43#1:95\n43#1:96,3\n*E\n"})
public final class JupyterRemoteVirtualFile
extends VirtualFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JupyterRemotePath remotePath;
    private final boolean isRemoteDirectory;
    @NotNull
    private final VirtualFile localFile;
    @NotNull
    private final Path localFilePath;
    @NotNull
    private static final Key<JupyterRemoteVirtualFile> JUPYTER_REMOTE_VIRTUAL_FILE_KEY;

    public JupyterRemoteVirtualFile(@NotNull JupyterRemotePath remotePath, boolean isRemoteDirectory) {
        Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
        this.remotePath = remotePath;
        this.isRemoteDirectory = isRemoteDirectory;
        this.putUserData(FileDocumentManagerBase.TRACK_NON_PHYSICAL, true);
        this.localFile = this.initLocalFile();
        this.localFilePath = JupyterRfsLocalFileCache.Companion.getInstance().toLocalPath(this.remotePath);
    }

    @NotNull
    public final JupyterRemotePath getRemotePath() {
        return this.remotePath;
    }

    public final boolean isRemoteDirectory() {
        return this.isRemoteDirectory;
    }

    private final JupyterClient getClient() {
        return JupyterRemoteVfsUtilKt.getJupyterClient(this.remotePath);
    }

    @Nullable
    public final CachingFileContentsApi getApi() {
        JupyterClient jupyterClient = this.getClient();
        return jupyterClient != null ? jupyterClient.getFileContentsApi() : null;
    }

    @NotNull
    public final VirtualFile getLocalFile() {
        return this.localFile;
    }

    @NotNull
    public final Path getLocalFilePath() {
        return this.localFilePath;
    }

    @NotNull
    public String getName() {
        return this.remotePath.getNameOrAuthority();
    }

    @NotNull
    public String getPath() {
        return this.remotePath.getFullPath();
    }

    @NotNull
    public OutputStream getOutputStream(@Nullable Object requestor, long newModificationStamp, long newTimeStamp) {
        return new JupyterFsFileOutputStream(this);
    }

    @NotNull
    public JupyterRemoteVirtualFile[] getChildren() {
        Collection $this$toTypedArray$iv = JupyterRemoteFileSystem.Companion.getInstance().findCachedChildren(this.remotePath);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new JupyterRemoteVirtualFile[0]);
    }

    public final void clearLocalFile() {
        JupyterRfsLocalFileCache.Companion.getInstance().deleteLocalFile(this.remotePath);
    }

    public final void recreateLocalFile() {
        JupyterRfsLocalFileCache.Companion.getInstance().deleteLocalFile(this.remotePath);
    }

    public void refresh(boolean asynchronous, boolean recursive, @Nullable Runnable postRunnable) {
        this.localFile.refresh(asynchronous, recursive, postRunnable);
    }

    @NotNull
    public byte[] contentsToByteArray() {
        byte[] byArray = this.localFile.contentsToByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"contentsToByteArray(...)");
        return byArray;
    }

    @NotNull
    public InputStream getInputStream() {
        InputStream inputStream = this.localFile.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        return inputStream;
    }

    public long getLength() {
        return this.localFile.getLength();
    }

    @NotNull
    public JupyterRemoteFileSystem getFileSystem() {
        return JupyterRemoteFileSystem.Companion.getInstance();
    }

    public boolean isDirectory() {
        return this.isRemoteDirectory;
    }

    public long getModificationStamp() {
        return this.localFile.getModificationStamp();
    }

    public long getModificationCount() {
        return this.localFile.getModificationCount();
    }

    public long getTimeStamp() {
        return this.localFile.getTimeStamp();
    }

    public boolean isValid() {
        return true;
    }

    @Nullable
    public JupyterRemoteVirtualFile getParent() {
        JupyterRemoteVirtualFile jupyterRemoteVirtualFile;
        JupyterRemotePath jupyterRemotePath = this.remotePath.getParent();
        if (jupyterRemotePath != null) {
            JupyterRemotePath it = jupyterRemotePath;
            boolean bl = false;
            jupyterRemoteVirtualFile = JupyterRemoteFileSystem.Companion.getInstance().findCachedFileByPath(it);
        } else {
            jupyterRemoteVirtualFile = null;
        }
        return jupyterRemoteVirtualFile;
    }

    public boolean isWritable() {
        JupyterClient jupyterClient = this.getClient();
        return (jupyterClient != null ? jupyterClient.getCachedConnectionStatus() : null) instanceof JupyterConnectionStatus.Success;
    }

    private final VirtualFile initLocalFile() {
        VirtualFile virtualFile2;
        VirtualFile it = virtualFile2 = JupyterRfsLocalFileCache.Companion.getInstance().getOrCreateLocalFile(this.remotePath, this.isRemoteDirectory);
        boolean bl = false;
        it.putUserData(JUPYTER_REMOTE_VIRTUAL_FILE_KEY, (Object)this);
        return virtualFile2;
    }

    @NotNull
    public final JupyterRemotePath component1() {
        return this.remotePath;
    }

    public final boolean component2() {
        return this.isRemoteDirectory;
    }

    @NotNull
    public final JupyterRemoteVirtualFile copy(@NotNull JupyterRemotePath remotePath, boolean isRemoteDirectory) {
        Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
        return new JupyterRemoteVirtualFile(remotePath, isRemoteDirectory);
    }

    public static /* synthetic */ JupyterRemoteVirtualFile copy$default(JupyterRemoteVirtualFile jupyterRemoteVirtualFile, JupyterRemotePath jupyterRemotePath, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            jupyterRemotePath = jupyterRemoteVirtualFile.remotePath;
        }
        if ((n & 2) != 0) {
            bl = jupyterRemoteVirtualFile.isRemoteDirectory;
        }
        return jupyterRemoteVirtualFile.copy(jupyterRemotePath, bl);
    }

    @NotNull
    public String toString() {
        return "JupyterRemoteVirtualFile(remotePath=" + this.remotePath + ", isRemoteDirectory=" + this.isRemoteDirectory + ")";
    }

    public int hashCode() {
        int result = this.remotePath.hashCode();
        result = result * 31 + Boolean.hashCode(this.isRemoteDirectory);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JupyterRemoteVirtualFile)) {
            return false;
        }
        JupyterRemoteVirtualFile jupyterRemoteVirtualFile = (JupyterRemoteVirtualFile)((Object)other);
        if (!Intrinsics.areEqual((Object)this.remotePath, (Object)jupyterRemoteVirtualFile.remotePath)) {
            return false;
        }
        return this.isRemoteDirectory == jupyterRemoteVirtualFile.isRemoteDirectory;
    }

    static {
        Key key = Key.create((String)"JUPYTER_REMOTE_VIRTUAL_FILE");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        JUPYTER_REMOTE_VIRTUAL_FILE_KEY = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/jupyter/core/jupyter/remote/vfs/JupyterRemoteVirtualFile$Companion;", "", "<init>", "()V", "JUPYTER_REMOTE_VIRTUAL_FILE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/jupyter/core/jupyter/remote/vfs/JupyterRemoteVirtualFile;", "getJUPYTER_REMOTE_VIRTUAL_FILE_KEY", "()Lcom/intellij/openapi/util/Key;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<JupyterRemoteVirtualFile> getJUPYTER_REMOTE_VIRTUAL_FILE_KEY() {
            return JUPYTER_REMOTE_VIRTUAL_FILE_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

