/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs.console;

import com.intellij.jupyter.core.jupyter.actions.JupyterEditorActionPromoterKt;
import com.intellij.jupyter.core.jupyter.editor.outputs.console.JupyterOutputConsoleView;
import com.intellij.notebooks.visualization.outputs.NotebookOutputDataKey;
import com.intellij.notebooks.visualization.outputs.NotebookOutputInlayShowable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.InjectedDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Disposer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u00062\u00020\u0007B\u0011\b\u0004\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH$J\u000e\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0002J\u0013\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00028\u0000\u00a2\u0006\u0002\u0010#J\b\u0010$\u001a\u00020\u0017H\u0016J\b\u0010%\u001a\u00020!H\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020'H\u0016J \u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020*H\u0016J \u0010/\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020*H\u0016J\b\u00100\u001a\u00020\u0017H\u0016J\b\u00101\u001a\u00020\u0017H\u0016J\u0010\u00102\u001a\u00020!2\u0006\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u00020*H\u0014J\b\u00106\u001a\u00020!H\u0002R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR0\u0010\u0010\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000f2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000f8\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R$\u0010\u0013\u001a\u0004\u0018\u00018\u00002\b\u0010\u000e\u001a\u0004\u0018\u00018\u0000@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R$\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u0017@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u00067"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/console/TextOutputComponentBase;", "KeyT", "Lcom/intellij/notebooks/visualization/outputs/NotebookOutputDataKey;", "Ljavax/swing/JPanel;", "Lcom/intellij/notebooks/visualization/outputs/NotebookOutputInlayShowable;", "Lcom/intellij/openapi/Disposable;", "Ljavax/swing/Scrollable;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "value", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/console/JupyterOutputConsoleView;", "console", "getConsole", "()Lcom/intellij/jupyter/core/jupyter/editor/outputs/console/JupyterOutputConsoleView;", "currentData", "getCurrentData", "()Lcom/intellij/notebooks/visualization/outputs/NotebookOutputDataKey;", "Lcom/intellij/notebooks/visualization/outputs/NotebookOutputDataKey;", "", "shown", "getShown", "()Z", "setShown", "(Z)V", "createConsoleView", "needsUpdating", "outputDataKey", "setContent", "", "output", "(Lcom/intellij/notebooks/visualization/outputs/NotebookOutputDataKey;)V", "isValidateRoot", "dispose", "getPreferredSize", "Ljava/awt/Dimension;", "getPreferredScrollableViewportSize", "getScrollableUnitIncrement", "", "visibleRect", "Ljava/awt/Rectangle;", "orientation", "direction", "getScrollableBlockIncrement", "getScrollableTracksViewportWidth", "getScrollableTracksViewportHeight", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "getPreferredLinesCount", "createComponent", "intellij.jupyter.core"})
public abstract class TextOutputComponentBase<KeyT extends NotebookOutputDataKey>
extends JPanel
implements NotebookOutputInlayShowable,
Disposable,
Scrollable,
UiDataProvider {
    @NotNull
    private final EditorImpl editor;
    @VisibleForTesting
    @Nullable
    private JupyterOutputConsoleView<KeyT> console;
    @Nullable
    private KeyT currentData;
    private boolean shown;

    protected TextOutputComponentBase(@NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        super(new BorderLayout());
        this.editor = editor;
        this.setFocusable(true);
        this.setOpaque(false);
    }

    @NotNull
    protected final EditorImpl getEditor() {
        return this.editor;
    }

    @Nullable
    public final JupyterOutputConsoleView<KeyT> getConsole() {
        return this.console;
    }

    @Nullable
    public final KeyT getCurrentData() {
        return this.currentData;
    }

    public boolean getShown() {
        return this.shown;
    }

    public void setShown(boolean value) {
        if (this.shown || this.shown == value || !value) {
            return;
        }
        this.shown = true;
        if (this.console != null) {
            return;
        }
        this.createComponent();
    }

    @NotNull
    protected abstract JupyterOutputConsoleView<KeyT> createConsoleView();

    public final boolean needsUpdating(@NotNull NotebookOutputDataKey outputDataKey) {
        Intrinsics.checkNotNullParameter((Object)outputDataKey, (String)"outputDataKey");
        return !Intrinsics.areEqual(this.currentData, (Object)outputDataKey);
    }

    public final void setContent(@NotNull KeyT output) {
        block1: {
            Intrinsics.checkNotNullParameter(output, (String)"output");
            if (!this.needsUpdating((NotebookOutputDataKey)output)) {
                return;
            }
            this.currentData = output;
            JupyterOutputConsoleView<KeyT> jupyterOutputConsoleView = this.console;
            if (jupyterOutputConsoleView == null) break block1;
            jupyterOutputConsoleView.setContent(output);
        }
    }

    @Override
    public boolean isValidateRoot() {
        return false;
    }

    public void dispose() {
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        int count = this.getPreferredLinesCount();
        JupyterOutputConsoleView<KeyT> jupyterOutputConsoleView = this.console;
        if (jupyterOutputConsoleView == null) {
            return new Dimension(this.editor.getScrollPane().getWidth(), count * this.editor.getLineHeight());
        }
        JupyterOutputConsoleView<KeyT> console = jupyterOutputConsoleView;
        Dimension dimension = console.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
        return dimension;
    }

    @Override
    @NotNull
    public Dimension getPreferredScrollableViewportSize() {
        JScrollPane scrollPane;
        Dimension dimension;
        Dimension it = dimension = this.getPreferredSize();
        boolean bl = false;
        Container container = this.getParent();
        Container container2 = container != null ? container.getParent() : null;
        JScrollPane jScrollPane = scrollPane = container2 instanceof JScrollPane ? (JScrollPane)container2 : null;
        if (scrollPane != null) {
            it.width = scrollPane.getWidth() - scrollPane.getVerticalScrollBar().getWidth();
        }
        return dimension;
    }

    @Override
    public int getScrollableUnitIncrement(@NotNull Rectangle visibleRect, int orientation, int direction) {
        Intrinsics.checkNotNullParameter((Object)visibleRect, (String)"visibleRect");
        return 10;
    }

    @Override
    public int getScrollableBlockIncrement(@NotNull Rectangle visibleRect, int orientation, int direction) {
        Intrinsics.checkNotNullParameter((Object)visibleRect, (String)"visibleRect");
        return 10;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        DataKey dataKey = CommonDataKeys.EDITOR;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"EDITOR");
        sink.setNull(dataKey);
        DataKey dataKey2 = CommonDataKeys.HOST_EDITOR;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"HOST_EDITOR");
        sink.setNull(dataKey2);
        DataKey dataKey3 = InjectedDataKeys.EDITOR;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey3, (String)"EDITOR");
        sink.setNull(dataKey3);
        sink.set(JupyterEditorActionPromoterKt.getDISABLE_JUPYTER_EDITOR_ACTION_PROMOTER_KEY(), (Object)true);
    }

    protected int getPreferredLinesCount() {
        return 3;
    }

    private final void createComponent() {
        JupyterOutputConsoleView<KeyT> consoleView = this.createConsoleView();
        Disposer.register((Disposable)this, (Disposable)((Disposable)consoleView));
        this.console = consoleView;
        this.add((Component)consoleView.getComponent(), "Center");
        consoleView.installFilters();
        KeyT KeyT = this.currentData;
        if (KeyT == null) {
            return;
        }
        KeyT data = KeyT;
        consoleView.setContent(data);
    }
}

