/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.shadowed.com.ibm.icu.impl.number.parse;

import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.graalvm.shadowed.com.ibm.icu.impl.StringSegment;
import org.graalvm.shadowed.com.ibm.icu.impl.number.AffixPatternProvider;
import org.graalvm.shadowed.com.ibm.icu.impl.number.CustomSymbolCurrency;
import org.graalvm.shadowed.com.ibm.icu.impl.number.DecimalFormatProperties;
import org.graalvm.shadowed.com.ibm.icu.impl.number.Grouper;
import org.graalvm.shadowed.com.ibm.icu.impl.number.PatternStringParser;
import org.graalvm.shadowed.com.ibm.icu.impl.number.PropertiesAffixPatternProvider;
import org.graalvm.shadowed.com.ibm.icu.impl.number.RoundingUtils;
import org.graalvm.shadowed.com.ibm.icu.impl.number.parse.AffixMatcher;
import org.graalvm.shadowed.com.ibm.icu.impl.number.parse.AffixTokenMatcherFactory;
import org.graalvm.shadowed.com.ibm.icu.impl.number.parse.CombinedCurrencyMatcher;
import org.graalvm.shadowed.com.ibm.icu.impl.number.parse.DecimalMatcher;
import org.graalvm.shadowed.com.ibm.icu.impl.number.parse.IgnorablesMatcher;
import org.graalvm.shadowed.com.ibm.icu.impl.number.parse.InfinityMatcher;
import org.graalvm.shadowed.com.ibm.icu.impl.number.parse.MinusSignMatcher;
import org.graalvm.shadowed.com.ibm.icu.impl.number.parse.MultiplierParseHandler;
import org.graalvm.shadowed.com.ibm.icu.impl.number.parse.NanMatcher;
import org.graalvm.shadowed.com.ibm.icu.impl.number.parse.NumberParseMatcher;
import org.graalvm.shadowed.com.ibm.icu.impl.number.parse.PaddingMatcher;
import org.graalvm.shadowed.com.ibm.icu.impl.number.parse.ParsedNumber;
import org.graalvm.shadowed.com.ibm.icu.impl.number.parse.PercentMatcher;
import org.graalvm.shadowed.com.ibm.icu.impl.number.parse.PermilleMatcher;
import org.graalvm.shadowed.com.ibm.icu.impl.number.parse.PlusSignMatcher;
import org.graalvm.shadowed.com.ibm.icu.impl.number.parse.RequireAffixValidator;
import org.graalvm.shadowed.com.ibm.icu.impl.number.parse.RequireCurrencyValidator;
import org.graalvm.shadowed.com.ibm.icu.impl.number.parse.RequireDecimalSeparatorValidator;
import org.graalvm.shadowed.com.ibm.icu.impl.number.parse.RequireNumberValidator;
import org.graalvm.shadowed.com.ibm.icu.impl.number.parse.ScientificMatcher;
import org.graalvm.shadowed.com.ibm.icu.number.NumberFormatter;
import org.graalvm.shadowed.com.ibm.icu.number.Scale;
import org.graalvm.shadowed.com.ibm.icu.text.DecimalFormatSymbols;
import org.graalvm.shadowed.com.ibm.icu.util.Currency;
import org.graalvm.shadowed.com.ibm.icu.util.CurrencyAmount;
import org.graalvm.shadowed.com.ibm.icu.util.ULocale;

public class NumberParserImpl {
    private final int parseFlags;
    private final List<NumberParseMatcher> matchers = new ArrayList<NumberParseMatcher>();
    private boolean frozen;

    public static NumberParserImpl createSimpleParser(ULocale locale, String pattern, int parseFlags) {
        NumberParserImpl parser = new NumberParserImpl(parseFlags);
        Currency currency = Currency.getInstance("USD");
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
        IgnorablesMatcher ignorables = IgnorablesMatcher.getInstance(parseFlags);
        AffixTokenMatcherFactory factory = new AffixTokenMatcherFactory();
        factory.currency = currency;
        factory.symbols = symbols;
        factory.ignorables = ignorables;
        factory.locale = locale;
        factory.parseFlags = parseFlags;
        PatternStringParser.ParsedPatternInfo patternInfo = PatternStringParser.parseToPatternInfo(pattern);
        AffixMatcher.createMatchers(patternInfo, parser, factory, ignorables, parseFlags);
        Grouper grouper = Grouper.forStrategy(NumberFormatter.GroupingStrategy.AUTO).withLocaleData(locale, patternInfo);
        parser.addMatcher(ignorables);
        parser.addMatcher(DecimalMatcher.getInstance(symbols, grouper, parseFlags));
        parser.addMatcher(MinusSignMatcher.getInstance(symbols, false));
        parser.addMatcher(PlusSignMatcher.getInstance(symbols, false));
        parser.addMatcher(PercentMatcher.getInstance(symbols));
        parser.addMatcher(PermilleMatcher.getInstance(symbols));
        parser.addMatcher(NanMatcher.getInstance(symbols, parseFlags));
        parser.addMatcher(InfinityMatcher.getInstance(symbols));
        parser.addMatcher(PaddingMatcher.getInstance("@"));
        parser.addMatcher(ScientificMatcher.getInstance(symbols, grouper));
        parser.addMatcher(CombinedCurrencyMatcher.getInstance(currency, symbols, parseFlags));
        parser.addMatcher(new RequireNumberValidator());
        parser.freeze();
        return parser;
    }

    public static Number parseStatic(String input, ParsePosition ppos, DecimalFormatProperties properties2, DecimalFormatSymbols symbols) {
        NumberParserImpl parser = NumberParserImpl.createParserFromProperties(properties2, symbols, false);
        ParsedNumber result2 = new ParsedNumber();
        parser.parse(input, true, result2);
        if (result2.success()) {
            ppos.setIndex(result2.charEnd);
            return result2.getNumber();
        }
        ppos.setErrorIndex(result2.charEnd);
        return null;
    }

    public static CurrencyAmount parseStaticCurrency(String input, ParsePosition ppos, DecimalFormatProperties properties2, DecimalFormatSymbols symbols) {
        NumberParserImpl parser = NumberParserImpl.createParserFromProperties(properties2, symbols, true);
        ParsedNumber result2 = new ParsedNumber();
        parser.parse(input, true, result2);
        if (result2.success()) {
            ppos.setIndex(result2.charEnd);
            assert (result2.currencyCode != null);
            return new CurrencyAmount(result2.getNumber(), Currency.getInstance(result2.currencyCode));
        }
        ppos.setErrorIndex(result2.charEnd);
        return null;
    }

    public static NumberParserImpl createDefaultParserForLocale(ULocale loc) {
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(loc);
        DecimalFormatProperties properties2 = PatternStringParser.parseToProperties("0");
        return NumberParserImpl.createParserFromProperties(properties2, symbols, false);
    }

    public static NumberParserImpl createParserFromProperties(DecimalFormatProperties properties2, DecimalFormatSymbols symbols, boolean parseCurrency) {
        Scale multiplier;
        ULocale locale = symbols.getULocale();
        AffixPatternProvider affixProvider = PropertiesAffixPatternProvider.forProperties(properties2);
        Currency currency = CustomSymbolCurrency.resolve(properties2.getCurrency(), locale, symbols);
        DecimalFormatProperties.ParseMode parseMode = properties2.getParseMode();
        if (parseMode == null) {
            parseMode = DecimalFormatProperties.ParseMode.LENIENT;
        }
        Grouper grouper = Grouper.forProperties(properties2);
        int parseFlags = 0;
        if (!properties2.getParseCaseSensitive()) {
            parseFlags |= 1;
        }
        if (properties2.getParseIntegerOnly()) {
            parseFlags |= 0x10;
        }
        if (properties2.getParseToBigDecimal()) {
            parseFlags |= 0x1000;
        }
        if (properties2.getSignAlwaysShown()) {
            parseFlags |= 0x400;
        }
        if (parseMode == DecimalFormatProperties.ParseMode.JAVA_COMPATIBILITY) {
            parseFlags |= 4;
            parseFlags |= 0x100;
            parseFlags |= 0x200;
            parseFlags |= 0x10000;
        } else if (parseMode == DecimalFormatProperties.ParseMode.STRICT) {
            parseFlags |= 8;
            parseFlags |= 4;
            parseFlags |= 0x100;
            parseFlags |= 0x200;
            parseFlags |= 0x8000;
        } else {
            parseFlags |= 0x80;
        }
        if (grouper.getPrimary() <= 0) {
            parseFlags |= 0x20;
        }
        if (parseCurrency || affixProvider.hasCurrencySign()) {
            parseFlags |= 2;
        }
        if (!parseCurrency) {
            parseFlags |= 0x2000;
        }
        NumberParserImpl parser = new NumberParserImpl(parseFlags);
        IgnorablesMatcher ignorables = IgnorablesMatcher.getInstance(parseFlags);
        AffixTokenMatcherFactory factory = new AffixTokenMatcherFactory();
        factory.currency = currency;
        factory.symbols = symbols;
        factory.ignorables = ignorables;
        factory.locale = locale;
        factory.parseFlags = parseFlags;
        AffixMatcher.createMatchers(affixProvider, parser, factory, ignorables, parseFlags);
        if (parseCurrency || affixProvider.hasCurrencySign()) {
            parser.addMatcher(CombinedCurrencyMatcher.getInstance(currency, symbols, parseFlags));
        }
        if (parseMode == DecimalFormatProperties.ParseMode.LENIENT && affixProvider.containsSymbolType(-4)) {
            parser.addMatcher(PercentMatcher.getInstance(symbols));
        }
        if (parseMode == DecimalFormatProperties.ParseMode.LENIENT && affixProvider.containsSymbolType(-5)) {
            parser.addMatcher(PermilleMatcher.getInstance(symbols));
        }
        if (parseMode == DecimalFormatProperties.ParseMode.LENIENT) {
            parser.addMatcher(PlusSignMatcher.getInstance(symbols, false));
            parser.addMatcher(MinusSignMatcher.getInstance(symbols, false));
        }
        parser.addMatcher(NanMatcher.getInstance(symbols, parseFlags));
        parser.addMatcher(InfinityMatcher.getInstance(symbols));
        String padString = properties2.getPadString();
        if (padString != null && !ignorables.getSet().contains(padString)) {
            parser.addMatcher(PaddingMatcher.getInstance(padString));
        }
        parser.addMatcher(ignorables);
        parser.addMatcher(DecimalMatcher.getInstance(symbols, grouper, parseFlags));
        if (!properties2.getParseNoExponent() || properties2.getMinimumExponentDigits() > 0) {
            parser.addMatcher(ScientificMatcher.getInstance(symbols, grouper));
        }
        parser.addMatcher(new RequireNumberValidator());
        if (parseMode != DecimalFormatProperties.ParseMode.LENIENT) {
            parser.addMatcher(new RequireAffixValidator());
        }
        if (parseCurrency) {
            parser.addMatcher(new RequireCurrencyValidator());
        }
        if (properties2.getDecimalPatternMatchRequired()) {
            boolean patternHasDecimalSeparator = properties2.getDecimalSeparatorAlwaysShown() || properties2.getMaximumFractionDigits() != 0;
            parser.addMatcher(RequireDecimalSeparatorValidator.getInstance(patternHasDecimalSeparator));
        }
        if ((multiplier = RoundingUtils.scaleFromProperties(properties2)) != null) {
            parser.addMatcher(new MultiplierParseHandler(multiplier));
        }
        parser.freeze();
        return parser;
    }

    public NumberParserImpl(int parseFlags) {
        this.parseFlags = parseFlags;
        this.frozen = false;
    }

    public void addMatcher(NumberParseMatcher matcher) {
        assert (!this.frozen);
        this.matchers.add(matcher);
    }

    public void addMatchers(Collection<? extends NumberParseMatcher> matchers) {
        assert (!this.frozen);
        this.matchers.addAll(matchers);
    }

    public void freeze() {
        this.frozen = true;
    }

    public int getParseFlags() {
        return this.parseFlags;
    }

    public void parse(String input, boolean greedy, ParsedNumber result2) {
        this.parse(input, 0, greedy, result2);
    }

    public void parse(String input, int start2, boolean greedy, ParsedNumber result2) {
        assert (this.frozen);
        assert (start2 >= 0 && start2 < input.length());
        StringSegment segment = new StringSegment(input, 0 != (this.parseFlags & 1));
        segment.adjustOffset(start2);
        if (greedy) {
            this.parseGreedy(segment, result2);
        } else if (0 != (this.parseFlags & 0x4000)) {
            this.parseLongestRecursive(segment, result2, 1);
        } else {
            this.parseLongestRecursive(segment, result2, -100);
        }
        for (NumberParseMatcher matcher : this.matchers) {
            matcher.postProcess(result2);
        }
        result2.postProcess();
    }

    private void parseGreedy(StringSegment segment, ParsedNumber result2) {
        int i = 0;
        while (i < this.matchers.size()) {
            if (segment.length() == 0) {
                return;
            }
            NumberParseMatcher matcher = this.matchers.get(i);
            if (!matcher.smokeTest(segment)) {
                ++i;
                continue;
            }
            int initialOffset = segment.getOffset();
            matcher.match(segment, result2);
            if (segment.getOffset() != initialOffset) {
                i = 0;
                continue;
            }
            ++i;
        }
    }

    private void parseLongestRecursive(StringSegment segment, ParsedNumber result2, int recursionLevels) {
        if (segment.length() == 0) {
            return;
        }
        if (recursionLevels == 0) {
            return;
        }
        ParsedNumber initial = new ParsedNumber();
        initial.copyFrom(result2);
        ParsedNumber candidate = new ParsedNumber();
        int initialOffset = segment.getOffset();
        block0: for (int i = 0; i < this.matchers.size(); ++i) {
            NumberParseMatcher matcher = this.matchers.get(i);
            if (!matcher.smokeTest(segment)) continue;
            int charsToConsume = 0;
            while (charsToConsume < segment.length()) {
                charsToConsume += Character.charCount(segment.codePointAt(charsToConsume));
                candidate.copyFrom(initial);
                segment.setLength(charsToConsume);
                boolean maybeMore = matcher.match(segment, candidate);
                segment.resetLength();
                if (segment.getOffset() - initialOffset == charsToConsume) {
                    this.parseLongestRecursive(segment, candidate, recursionLevels + 1);
                    if (candidate.isBetterThan(result2)) {
                        result2.copyFrom(candidate);
                    }
                }
                segment.setOffset(initialOffset);
                if (maybeMore) continue;
                continue block0;
            }
        }
    }

    public String toString() {
        return "<NumberParserImpl matchers=" + this.matchers.toString() + ">";
    }
}

