/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.InternalResource;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.InstrumentCache;
import com.oracle.truffle.polyglot.InternalResourceCache;
import com.oracle.truffle.polyglot.InternalResourceCacheSymbol;
import com.oracle.truffle.polyglot.LanguageCache;
import java.io.PrintStream;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.collections.Pair;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.ProcessProperties;

final class InternalResourceRoots {
    private static final String OVERRIDDEN_CACHE_ROOT = "polyglot.engine.resourcePath";
    private static final Map<Collection<EngineAccessor.AbstractClassLoaderSupplier>, InternalResourceRoots> runtimeCaches = new ConcurrentHashMap<Collection<EngineAccessor.AbstractClassLoaderSupplier>, InternalResourceRoots>();
    private volatile Set<Root> roots;

    static String overriddenComponentRootProperty(String componentId) {
        StringBuilder builder2 = new StringBuilder(OVERRIDDEN_CACHE_ROOT);
        builder2.append('.');
        builder2.append(componentId);
        return builder2.toString();
    }

    static String overriddenResourceRootProperty(String componentId, String resourceId) {
        StringBuilder builder2 = new StringBuilder(OVERRIDDEN_CACHE_ROOT);
        builder2.append('.');
        builder2.append(componentId);
        builder2.append('.');
        builder2.append(resourceId);
        return builder2.toString();
    }

    private InternalResourceRoots() {
    }

    static InternalResourceRoots getInstance() {
        List<Object> loaders = TruffleOptions.AOT ? List.of() : EngineAccessor.locatorOrDefaultLoaders();
        InternalResourceRoots instance = runtimeCaches.computeIfAbsent(loaders, k -> new InternalResourceRoots());
        instance.ensureInitialized();
        return instance;
    }

    void patch() {
        this.ensureInitialized();
    }

    private synchronized void ensureInitialized() {
        if (this.roots == null) {
            this.roots = InternalResourceCache.usesInternalResources() ? InternalResourceRoots.computeRoots(InternalResourceRoots.findDefaultRoot()) : Set.of();
        }
    }

    Root findRoot(Path hostPath) {
        for (Root root : this.roots) {
            if (!hostPath.startsWith(root.path)) continue;
            return root;
        }
        return null;
    }

    InternalResourceCache findInternalResource(Path hostPath) {
        Root root = this.findRoot(hostPath);
        if (root != null) {
            for (InternalResourceCache cache : root.caches) {
                Path resourceRoot = cache.getPathOrNull();
                if (resourceRoot == null || !hostPath.startsWith(resourceRoot)) continue;
                return cache;
            }
        }
        return null;
    }

    static void initializeRuntimeResource(InternalResourceCache truffleRuntimeResource) {
        Pair<Path, Root.Kind> defaultRoot = InternalResourceRoots.findDefaultRoot();
        HashMap<Pair<Path, Root.Kind>, List<InternalResourceCache>> collector = new HashMap<Pair<Path, Root.Kind>, List<InternalResourceCache>>();
        InternalResourceRoots.collectRoots("engine", defaultRoot.getLeft(), defaultRoot.getRight(), List.of(truffleRuntimeResource), collector);
        Map.Entry entry = collector.entrySet().iterator().next();
        Pair key = (Pair)entry.getKey();
        truffleRuntimeResource.initializeOwningRoot(new Root((Path)key.getLeft(), (Root.Kind)((Object)key.getRight()), (List)entry.getValue()));
    }

    private static void setTestCacheRoot(Path newRoot, boolean nativeImageRuntime) {
        List<Object> loaders = TruffleOptions.AOT ? List.of() : EngineAccessor.locatorOrDefaultLoaders();
        InternalResourceRoots resourceRoots = runtimeCaches.computeIfAbsent(loaders, k -> new InternalResourceRoots());
        if (resourceRoots.roots != null) {
            for (Root root : resourceRoots.roots) {
                for (InternalResourceCache cache : root.caches()) {
                    cache.clearCache();
                }
            }
        }
        if (newRoot != null) {
            resourceRoots.roots = InternalResourceRoots.computeRoots(Pair.create(newRoot, nativeImageRuntime ? Root.Kind.UNVERSIONED : Root.Kind.VERSIONED));
        } else if (nativeImageRuntime) {
            Pair<Path, Root.Kind> defaultRoots = InternalResourceRoots.findDefaultRoot();
            resourceRoots.roots = InternalResourceRoots.computeRoots(Pair.create(defaultRoots.getLeft(), Root.Kind.UNVERSIONED));
        } else {
            resourceRoots.roots = null;
        }
    }

    private static Set<Root> computeRoots(Pair<Path, Root.Kind> defaultRoot) {
        Collection<InternalResourceCache> resources;
        HashMap<Pair<Path, Root.Kind>, List<InternalResourceCache>> collector = new HashMap<Pair<Path, Root.Kind>, List<InternalResourceCache>>();
        for (LanguageCache language : LanguageCache.languages().values()) {
            resources = language.getResources();
            if (resources.isEmpty()) continue;
            InternalResourceRoots.collectRoots(language.getId(), defaultRoot.getLeft(), defaultRoot.getRight(), resources, collector);
        }
        for (InstrumentCache instrument : InstrumentCache.load()) {
            resources = instrument.getResources();
            if (resources.isEmpty()) continue;
            InternalResourceRoots.collectRoots(instrument.getId(), defaultRoot.getLeft(), defaultRoot.getRight(), resources, collector);
        }
        Collection<InternalResourceCache> engineResources = InternalResourceCache.getEngineResources();
        if (!engineResources.isEmpty()) {
            InternalResourceRoots.collectRoots("engine", defaultRoot.getLeft(), defaultRoot.getRight(), engineResources, collector);
        }
        HashSet<Root> result2 = new HashSet<Root>();
        for (Map.Entry entry : collector.entrySet()) {
            Pair key = (Pair)entry.getKey();
            List resources2 = (List)entry.getValue();
            Root internalResourceRoot = new Root((Path)key.getLeft(), (Root.Kind)((Object)key.getRight()), resources2);
            for (InternalResourceCache resource : resources2) {
                resource.initializeOwningRoot(internalResourceRoot);
            }
            result2.add(internalResourceRoot);
        }
        return Collections.unmodifiableSet(result2);
    }

    private static Pair<Path, Root.Kind> findDefaultRoot() {
        Root.Kind kind;
        ResolvedCacheFolder root;
        String overriddenRoot = System.getProperty(OVERRIDDEN_CACHE_ROOT);
        if (overriddenRoot != null) {
            Path overriddenRootPath = Path.of(overriddenRoot, new String[0]).toAbsolutePath();
            root = new ResolvedCacheFolder(overriddenRootPath, "polyglot.engine.resourcePath system property", overriddenRootPath);
            kind = Root.Kind.UNVERSIONED;
        } else if (ImageInfo.inImageRuntimeCode()) {
            root = InternalResourceRoots.findCacheRootOnNativeImage();
            kind = Root.Kind.UNVERSIONED;
        } else {
            root = InternalResourceRoots.findCacheRootOnHotSpot();
            kind = Root.Kind.VERSIONED;
        }
        InternalResourceRoots.logInternalResourceEvent("Resolved the root directory for the internal resource cache to: %s, determined by the %s with the value %s.", root.path(), root.hint(), root.hintValue());
        return Pair.create(root.path(), kind);
    }

    private static void collectRoots(String componentId, Path componentRoot, Root.Kind componentKind, Collection<InternalResourceCache> resources, Map<Pair<Path, Root.Kind>, List<InternalResourceCache>> collector) {
        Path useRoot = componentRoot;
        Root.Kind useKind = componentKind;
        String overriddenRoot = System.getProperty(InternalResourceRoots.overriddenComponentRootProperty(componentId));
        if (overriddenRoot != null) {
            useRoot = Path.of(overriddenRoot, new String[0]).toAbsolutePath();
            useKind = Root.Kind.COMPONENT;
        }
        for (InternalResourceCache resource : resources) {
            Path resourceRoot = useRoot;
            Root.Kind resourceKind = useKind;
            overriddenRoot = System.getProperty(InternalResourceRoots.overriddenResourceRootProperty(componentId, resource.getResourceId()));
            if (overriddenRoot != null) {
                resourceRoot = Path.of(overriddenRoot, new String[0]).toAbsolutePath();
                resourceKind = Root.Kind.RESOURCE;
            }
            collector.computeIfAbsent(Pair.create(resourceRoot, resourceKind), k -> new ArrayList()).add(resource);
        }
    }

    private static ResolvedCacheFolder findCacheRootOnNativeImage() {
        assert (ImageInfo.inImageRuntimeCode()) : "Can be called only in the native-image execution time.";
        Path executable = InternalResourceRoots.getExecutablePath();
        return new ResolvedCacheFolder(executable.resolveSibling("resources"), "executable location", executable);
    }

    private static Path getExecutablePath() {
        assert (ImageInfo.inImageRuntimeCode());
        if (ImageInfo.isExecutable()) {
            return Path.of(ProcessProperties.getExecutableName(), new String[0]);
        }
        if (ImageInfo.isSharedLibrary()) {
            return Path.of(ProcessProperties.getObjectFile(InternalResourceCacheSymbol.SYMBOL), new String[0]);
        }
        throw CompilerDirectives.shouldNotReachHere("Should only be invoked within native image runtime code.");
    }

    private static ResolvedCacheFolder findCacheRootOnHotSpot() {
        String userHomeValue = System.getProperty("user.home");
        if (userHomeValue == null) {
            throw CompilerDirectives.shouldNotReachHere("The 'user.home' system property is not set.");
        }
        Path userHome = Paths.get(userHomeValue, new String[0]);
        ResolvedCacheFolder container = switch (InternalResource.OS.getCurrent()) {
            default -> throw new IncompatibleClassChangeError();
            case InternalResource.OS.DARWIN -> {
                ResolvedCacheFolder var3_2;
                yield var3_2 = new ResolvedCacheFolder(userHome.resolve(Path.of("Library", "Caches")), "user home", userHome);
            }
            case InternalResource.OS.LINUX -> {
                ResolvedCacheFolder var3_2;
                ResolvedCacheFolder userCacheDir = null;
                String xdgCacheValue = System.getenv("XDG_CACHE_HOME");
                if (xdgCacheValue != null) {
                    try {
                        Path xdgCacheDir = Path.of(xdgCacheValue, new String[0]);
                        if (xdgCacheDir.isAbsolute()) {
                            userCacheDir = new ResolvedCacheFolder(xdgCacheDir, "XDG_CACHE_HOME env variable", xdgCacheDir);
                        } else {
                            InternalResourceRoots.emitWarning("The value of the environment variable 'XDG_CACHE_HOME' is not an absolute path. Using the default cache folder '%s'.", userHome.resolve(".cache"));
                        }
                    }
                    catch (InvalidPathException notPath) {
                        InternalResourceRoots.emitWarning("The value of the environment variable 'XDG_CACHE_HOME' is not a valid path. Using the default cache folder '%s'.", userHome.resolve(".cache"));
                    }
                }
                if (userCacheDir == null) {
                    userCacheDir = new ResolvedCacheFolder(userHome.resolve(".cache"), "user home", userHome);
                }
                yield var3_2 = userCacheDir;
            }
            case InternalResource.OS.WINDOWS -> {
                ResolvedCacheFolder var3_2;
                yield var3_2 = new ResolvedCacheFolder(userHome.resolve(Path.of("AppData", "Local")), "user home", userHome);
            }
        };
        return container.resolve("org.graalvm.polyglot");
    }

    static boolean isTraceInternalResourceEvents() {
        return Boolean.getBoolean("polyglotimpl.TraceInternalResources");
    }

    static void logInternalResourceEvent(String message, Object ... args) {
        if (InternalResourceRoots.isTraceInternalResourceEvents()) {
            PrintStream out = System.err;
            out.printf("[engine][resource] " + message + "%n", args);
        }
    }

    private static void emitWarning(String message, Object ... args) {
        PrintStream out = System.err;
        out.printf(message + "%n", args);
    }

    record Root(Path path, Kind kind, List<InternalResourceCache> caches) {

        static enum Kind {
            COMPONENT,
            RESOURCE,
            UNVERSIONED,
            VERSIONED;

        }
    }

    private record ResolvedCacheFolder(Path path, String hint, Path hintValue) {
        ResolvedCacheFolder resolve(String file) {
            return new ResolvedCacheFolder(this.path.resolve(file), this.hint, this.hintValue);
        }
    }
}

