/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.util;

import com.oracle.truffle.api.CompilerDirectives;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class DirectByteBufferHelper {
    private static final Class<? extends ByteBuffer> DIRECT_BYTE_BUFFER_CLASS = ByteBuffer.allocateDirect(0).getClass();

    private DirectByteBufferHelper() {
    }

    @CompilerDirectives.TruffleBoundary
    private static ByteBuffer allocateDirectImpl(int length2) {
        return ByteBuffer.allocateDirect(length2).order(ByteOrder.nativeOrder());
    }

    public static ByteBuffer allocateDirect(int length2) {
        return DirectByteBufferHelper.cast(DirectByteBufferHelper.allocateDirectImpl(length2));
    }

    public static ByteBuffer cast(ByteBuffer buffer) {
        return CompilerDirectives.castExact(buffer, DIRECT_BYTE_BUFFER_CLASS);
    }
}

