/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.DebugBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.TestV8BuiltinsFactory;
import com.oracle.truffle.js.builtins.helper.GCNodeGen;
import com.oracle.truffle.js.builtins.helper.SharedMemorySync;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.cast.JSToIndexNode;
import com.oracle.truffle.js.nodes.cast.JSToLengthNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSAgent;
import com.oracle.truffle.js.runtime.JSAgentWaiterList;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JobCallback;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSAsyncFromSyncIteratorObject;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSSharedArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSTestV8;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.ArrayList;
import java.util.Set;

public final class TestV8Builtins
extends JSBuiltinsContainer.SwitchEnum<TestV8> {
    public static final JSBuiltinsContainer BUILTINS = new TestV8Builtins();

    protected TestV8Builtins() {
        super(JSTestV8.CLASS_NAME, TestV8.class);
    }

    @Override
    protected Object createNode(JSContext context2, JSBuiltin builtin, boolean construct, boolean newTarget, TestV8 builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return DebugBuiltinsFactory.DebugClassNodeGen.create(context2, builtin, true, TestV8Builtins.args().fixedArgs(1).createArgumentNodes(context2));
            }
            case 1: {
                return DebugBuiltinsFactory.DebugClassNameNodeGen.create(context2, builtin, TestV8Builtins.args().fixedArgs(1).createArgumentNodes(context2));
            }
            case 2: {
                return TestV8BuiltinsFactory.TestV8CreateAsyncFromSyncIteratorNodeGen.create(context2, builtin, TestV8Builtins.args().fixedArgs(1).createArgumentNodes(context2));
            }
            case 3: {
                return TestV8BuiltinsFactory.TestV8RunMicrotasksNodeGen.create(context2, builtin, TestV8Builtins.args().createArgumentNodes(context2));
            }
            case 4: {
                return TestV8BuiltinsFactory.TestV8EnqueueJobNodeGen.create(context2, builtin, TestV8Builtins.args().fixedArgs(1).createArgumentNodes(context2));
            }
            case 5: {
                return TestV8BuiltinsFactory.TestV8SetTimeoutNodeGen.create(context2, builtin, TestV8Builtins.args().fixedArgs(1).createArgumentNodes(context2));
            }
            case 6: {
                return DebugBuiltinsFactory.DebugStringCompareNodeGen.create(context2, builtin, TestV8Builtins.args().fixedArgs(2).createArgumentNodes(context2));
            }
            case 7: {
                return DebugBuiltinsFactory.DebugTypedArrayDetachBufferNodeGen.create(context2, builtin, TestV8Builtins.args().fixedArgs(1).createArgumentNodes(context2));
            }
            case 8: {
                return TestV8BuiltinsFactory.TestV8ConstructDoubleNodeGen.create(context2, builtin, TestV8Builtins.args().fixedArgs(2).createArgumentNodes(context2));
            }
            case 9: {
                return TestV8BuiltinsFactory.TestV8DoublePartNodeGen.create(context2, builtin, true, TestV8Builtins.args().fixedArgs(1).createArgumentNodes(context2));
            }
            case 10: {
                return TestV8BuiltinsFactory.TestV8DoublePartNodeGen.create(context2, builtin, false, TestV8Builtins.args().fixedArgs(1).createArgumentNodes(context2));
            }
            case 11: {
                return DebugBuiltinsFactory.DebugContinueInInterpreterNodeGen.create(context2, builtin, true, TestV8Builtins.args().createArgumentNodes(context2));
            }
            case 12: {
                return GCNodeGen.create(context2, builtin, TestV8Builtins.args().createArgumentNodes(context2));
            }
            case 13: {
                return TestV8BuiltinsFactory.TestV8ReferenceEqualNodeGen.create(context2, builtin, TestV8Builtins.args().fixedArgs(2).createArgumentNodes(context2));
            }
            case 15: {
                return TestV8BuiltinsFactory.TestV8ToStringNodeGen.create(context2, builtin, TestV8Builtins.args().fixedArgs(1).createArgumentNodes(context2));
            }
            case 16: {
                return TestV8BuiltinsFactory.TestV8ToNameNodeGen.create(context2, builtin, TestV8Builtins.args().fixedArgs(1).createArgumentNodes(context2));
            }
            case 18: {
                return TestV8BuiltinsFactory.TestV8ToPrimitiveNodeGen.create(context2, builtin, JSToPrimitiveNode.Hint.Default, TestV8Builtins.args().fixedArgs(1).createArgumentNodes(context2));
            }
            case 19: {
                return TestV8BuiltinsFactory.TestV8ToPrimitiveNodeGen.create(context2, builtin, JSToPrimitiveNode.Hint.String, TestV8Builtins.args().fixedArgs(1).createArgumentNodes(context2));
            }
            case 20: {
                return TestV8BuiltinsFactory.TestV8ToPrimitiveNodeGen.create(context2, builtin, JSToPrimitiveNode.Hint.Number, TestV8Builtins.args().fixedArgs(1).createArgumentNodes(context2));
            }
            case 17: {
                return TestV8BuiltinsFactory.TestV8ToNumberNodeGen.create(context2, builtin, TestV8Builtins.args().fixedArgs(1).createArgumentNodes(context2));
            }
            case 14: {
                return TestV8BuiltinsFactory.TestV8ToLengthNodeGen.create(context2, builtin, TestV8Builtins.args().fixedArgs(1).createArgumentNodes(context2));
            }
            case 21: {
                return TestV8BuiltinsFactory.TestV8AtomicsNumWaitersForTestingNodeGen.create(context2, builtin, TestV8Builtins.args().fixedArgs(2).createArgumentNodes(context2));
            }
            case 22: {
                return TestV8BuiltinsFactory.TestV8AtomicsNumUnresolvedAsyncPromisesForTestingNodeGen.create(context2, builtin, TestV8Builtins.args().fixedArgs(2).createArgumentNodes(context2));
            }
            case 23: {
                return TestV8BuiltinsFactory.TestV8SetAllowAtomicsWaitNodeGen.create(context2, builtin, TestV8Builtins.args().fixedArgs(1).createArgumentNodes(context2));
            }
            case 24: {
                return TestV8BuiltinsFactory.TestV8CreatePrivateSymbolNodeGen.create(context2, builtin, TestV8Builtins.args().fixedArgs(1).createArgumentNodes(context2));
            }
            case 25: {
                return TestV8BuiltinsFactory.TestV8SymbolIsPrivateNodeGen.create(context2, builtin, TestV8Builtins.args().fixedArgs(1).createArgumentNodes(context2));
            }
        }
        return null;
    }

    public static enum TestV8 implements BuiltinEnum<TestV8>
    {
        class_(1),
        className(1),
        createAsyncFromSyncIterator(1),
        runMicrotasks(0),
        enqueueJob(1),
        setTimeout(1),
        stringCompare(2),
        typedArrayDetachBuffer(1),
        constructDouble(2),
        doubleHi(1),
        doubleLo(1),
        deoptimize(0),
        gc(0),
        referenceEqual(2),
        toLength(1),
        toStringConv(1),
        toName(1),
        toNumber(1),
        toPrimitive(1),
        toPrimitiveString(1),
        toPrimitiveNumber(1),
        atomicsNumWaitersForTesting(2),
        atomicsNumUnresolvedAsyncPromisesForTesting(2),
        setAllowAtomicsWait(1),
        createPrivateSymbol(1),
        symbolIsPrivate(1);

        private final int length;

        private TestV8(int length2) {
            this.length = length2;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class TestV8CreateAsyncFromSyncIterator
    extends JSBuiltinNode {
        @Node.Child
        private PropertyGetNode getNextMethodNode;

        public TestV8CreateAsyncFromSyncIterator(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
            this.getNextMethodNode = PropertyGetNode.create(Strings.NEXT, context2);
        }

        @Specialization
        protected Object createAsyncFromSyncIterator(JSObject syncIterator) {
            Object nextMethod = this.getNextMethodNode.getValue(syncIterator);
            IteratorRecord syncIteratorRecord = IteratorRecord.create(syncIterator, nextMethod, false);
            return JSAsyncFromSyncIteratorObject.create(this.getContext(), this.getRealm(), syncIteratorRecord);
        }

        @Specialization(guards={"!isJSObject(syncIterator)"})
        protected Object notObject(Object syncIterator) {
            throw Errors.createTypeErrorNotAnObject(syncIterator, this);
        }
    }

    public static abstract class TestV8RunMicrotasksNode
    extends JSBuiltinNode {
        public TestV8RunMicrotasksNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected Object runMicrotasks() {
            this.getContext().processAllPendingPromiseJobs(this.getRealm());
            return Undefined.instance;
        }
    }

    public static abstract class TestV8EnqueueJobNode
    extends JSBuiltinNode {
        public TestV8EnqueueJobNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected Object enqueueJob(Object function) {
            if (JSFunction.isJSFunction(function)) {
                this.getContext().enqueuePromiseJob(this.getRealm(), (JSFunctionObject)function);
            }
            return 0;
        }
    }

    public static abstract class TestV8SetTimeoutNode
    extends JSBuiltinNode {
        public TestV8SetTimeoutNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected Object setTimeout(Object callback) {
            assert (JSRuntime.isCallable(callback));
            JSRealm realm = this.getRealm();
            ArrayList<JobCallback> embedderData = (ArrayList<JobCallback>)realm.getEmbedderData();
            if (embedderData == null) {
                embedderData = new ArrayList<JobCallback>();
                realm.setEmbedderData(embedderData);
            }
            embedderData.add(realm.getAgent().hostMakeJobCallback(callback));
            return Undefined.instance;
        }
    }

    public static abstract class TestV8ConstructDoubleNode
    extends JSBuiltinNode {
        public TestV8ConstructDoubleNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected double constructDouble(Object hiObj, Object loObj) {
            long hi = JSRuntime.toUInt32(hiObj);
            long lo = JSRuntime.toUInt32(loObj);
            return Double.longBitsToDouble(hi << 32 | lo);
        }
    }

    public static abstract class TestV8DoublePartNode
    extends JSBuiltinNode {
        private final boolean upper;

        public TestV8DoublePartNode(JSContext context2, JSBuiltin builtin, boolean upper) {
            super(context2, builtin);
            this.upper = upper;
        }

        @Specialization
        protected int doublePart(Object value2) {
            long bits = Double.doubleToRawLongBits((Double)value2);
            return this.upper ? (int)(bits >>> 32) : (int)(bits & 0xFFFFFFFFL);
        }
    }

    public static abstract class TestV8ReferenceEqualNode
    extends JSBuiltinNode {
        public TestV8ReferenceEqualNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected boolean referenceEqual(Object arg1, Object arg2) {
            return arg1 == arg2;
        }
    }

    public static abstract class TestV8ToStringNode
    extends JSBuiltinNode {
        @Node.Child
        private JSToStringNode toStringNode = JSToStringNode.create();

        public TestV8ToStringNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected TruffleString toStringConv(Object obj) {
            return this.toStringNode.executeString(obj);
        }
    }

    public static abstract class TestV8ToNameNode
    extends JSBuiltinNode {
        @Node.Child
        private JSToStringNode toStringNode = JSToStringNode.create();

        public TestV8ToNameNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected Object toName(Object obj) {
            if (obj instanceof Symbol) {
                return obj;
            }
            return this.toStringNode.executeString(obj);
        }
    }

    public static abstract class TestV8ToPrimitiveNode
    extends JSBuiltinNode {
        @Node.Child
        private JSToPrimitiveNode toPrimitiveNode;

        public TestV8ToPrimitiveNode(JSContext context2, JSBuiltin builtin, JSToPrimitiveNode.Hint hint) {
            super(context2, builtin);
            this.toPrimitiveNode = JSToPrimitiveNode.create(hint);
        }

        @Specialization
        protected Object toPrimitive(Object obj) {
            return this.toPrimitiveNode.execute(obj);
        }
    }

    public static abstract class TestV8ToNumberNode
    extends JSBuiltinNode {
        @Node.Child
        private JSToNumberNode toNumberNode = JSToNumberNode.create();

        public TestV8ToNumberNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected Number toNumberOp(Object obj) {
            return this.toNumberNode.executeNumber(obj);
        }
    }

    public static abstract class TestV8ToLengthNode
    extends JSBuiltinNode {
        @Node.Child
        private JSToLengthNode toLengthNode = JSToLengthNode.create();

        public TestV8ToLengthNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected Object toLengthOp(Object obj) {
            long value2 = this.toLengthNode.executeLong(obj);
            double d = value2;
            if (JSRuntime.doubleIsRepresentableAsInt(d)) {
                return (int)d;
            }
            return d;
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return TestV8BuiltinsFactory.TestV8ToLengthNodeGen.create(this.getContext(), this.getBuiltin(), TestV8ToLengthNode.cloneUninitialized(this.getArguments(), materializedTags));
        }
    }

    public static abstract class TestV8AtomicsNumWaitersForTestingNode
    extends TestV8AtomicsBaseNode {
        public TestV8AtomicsNumWaitersForTestingNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected Object numWaiters(Object maybeTarget, Object index, @Cached JSToIndexNode toIndexNode) {
            JSDynamicObject target = this.ensureSharedArray(maybeTarget);
            int i = TestV8AtomicsNumWaitersForTestingNode.validateAtomicAccess(target, toIndexNode.executeLong(index), index);
            JSAgentWaiterList.JSAgentWaiterListEntry wl = SharedMemorySync.getWaiterList(this.getContext(), target, i);
            return wl.size();
        }
    }

    public static abstract class TestV8AtomicsNumUnresolvedAsyncPromisesForTestingNode
    extends TestV8AtomicsBaseNode {
        public TestV8AtomicsNumUnresolvedAsyncPromisesForTestingNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected Object numUnresolvedAsyncPromises(Object maybeTarget, Object index, @Cached JSToIndexNode toIndexNode) {
            JSDynamicObject target = this.ensureSharedArray(maybeTarget);
            int i = TestV8AtomicsNumUnresolvedAsyncPromisesForTestingNode.validateAtomicAccess(target, toIndexNode.executeLong(index), index);
            JSAgent agent = this.getRealm().getAgent();
            JSAgentWaiterList.JSAgentWaiterListEntry wl = SharedMemorySync.getWaiterList(this.getContext(), target, i);
            return agent.getAsyncWaitersToBeResolved(wl);
        }
    }

    public static abstract class TestV8SetAllowAtomicsWait
    extends JSBuiltinNode {
        @Node.Child
        JSToBooleanNode toBooleanNode = JSToBooleanNode.create();

        public TestV8SetAllowAtomicsWait(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected Object setAllowAtomicsWait(Object allow) {
            this.getRealm().getAgent().setCanBlock(this.toBooleanNode.executeBoolean(allow));
            return Undefined.instance;
        }
    }

    public static abstract class TestV8CreatePrivateSymbol
    extends JSBuiltinNode {
        public TestV8CreatePrivateSymbol(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected Object doCreate(Object description, @Cached JSToStringNode toStringNode) {
            return Symbol.createPrivate(toStringNode.executeString(description));
        }
    }

    public static abstract class TestV8SymbolIsPrivate
    extends JSBuiltinNode {
        public TestV8SymbolIsPrivate(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected boolean isPrivate(Object symbol) {
            return JSRuntime.isPrivateSymbol(symbol);
        }
    }

    public static abstract class TestV8AtomicsBaseNode
    extends JSBuiltinNode {
        public TestV8AtomicsBaseNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        protected JSDynamicObject ensureSharedArray(Object maybeTarget) {
            JSArrayBufferObject buffer;
            if (JSArrayBufferView.isJSArrayBufferView(maybeTarget) && JSSharedArrayBuffer.isJSSharedArrayBuffer(buffer = JSArrayBufferView.getArrayBuffer((JSDynamicObject)maybeTarget))) {
                return (JSDynamicObject)maybeTarget;
            }
            throw this.createTypeErrorNotSharedArray();
        }

        @CompilerDirectives.TruffleBoundary
        protected final JSException createTypeErrorNotSharedArray() {
            return Errors.createTypeError("Cannot execute on non-shared array.", (Node)this);
        }

        @CompilerDirectives.TruffleBoundary
        protected static final JSException createRangeErrorSharedArray(Object idx) {
            return Errors.createRangeError("Range error with index : " + String.valueOf(idx));
        }

        protected static int validateAtomicAccess(JSDynamicObject target, long convertedIndex, Object originalIndex) {
            int length2 = JSArrayBufferView.typedArrayGetLength(target);
            assert (convertedIndex >= 0L);
            if (convertedIndex >= (long)length2) {
                throw TestV8AtomicsBaseNode.createRangeErrorSharedArray(originalIndex);
            }
            return (int)convertedIndex;
        }
    }
}

