/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.CountingConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.StringIteratorPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.access.CreateIterResultObjectNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSStringIterator;
import com.oracle.truffle.js.runtime.builtins.JSStringIteratorObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class StringIteratorPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<StringIteratorPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new StringIteratorPrototypeBuiltins();

    protected StringIteratorPrototypeBuiltins() {
        super(JSStringIterator.PROTOTYPE_NAME, StringIteratorPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context2, JSBuiltin builtin, boolean construct, boolean newTarget, StringIteratorPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return StringIteratorPrototypeBuiltinsFactory.StringIteratorNextNodeGen.create(context2, builtin, StringIteratorPrototypeBuiltins.args().withThis().createArgumentNodes(context2));
            }
        }
        return null;
    }

    public static enum StringIteratorPrototype implements BuiltinEnum<StringIteratorPrototype>
    {
        next(0);

        private final int length;

        private StringIteratorPrototype(int length2) {
            this.length = length2;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class StringIteratorNextNode
    extends JSBuiltinNode {
        @Node.Child
        private CreateIterResultObjectNode createIterResultObjectNode;
        @Node.Child
        private TruffleString.ReadCharUTF16Node stringReadNode;
        private final CountingConditionProfile isSurrogatePair = CountingConditionProfile.create();

        public StringIteratorNextNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
            this.createIterResultObjectNode = CreateIterResultObjectNode.create(context2);
            this.stringReadNode = TruffleString.ReadCharUTF16Node.create();
        }

        @Specialization
        protected final JSObject doStringIterator(VirtualFrame frame, JSStringIteratorObject iterator, @Cached TruffleString.FromCodePointNode fromCodePointNode, @Cached TruffleString.SubstringByteIndexNode substringNode) {
            int length2;
            TruffleString iteratedString = iterator.getIteratedString();
            if (iteratedString == null) {
                return this.createIterResultObjectNode.execute(frame, Undefined.instance, true);
            }
            TruffleString string = iteratedString;
            int index = iterator.getNextIndex();
            if (index >= (length2 = Strings.length(string))) {
                iterator.setIteratedString(null);
                return this.createIterResultObjectNode.execute(frame, Undefined.instance, true);
            }
            char first = Strings.charAt(this.stringReadNode, string, index);
            TruffleString result2 = this.isSurrogatePair.profile(Character.isHighSurrogate(first) && index + 1 < length2) && Character.isLowSurrogate(Strings.charAt(this.stringReadNode, string, index + 1)) ? Strings.substring(this.getContext(), substringNode, string, index, 2) : Strings.fromCodePoint(fromCodePointNode, first);
            iterator.setNextIndex(index + Strings.length(result2));
            return this.createIterResultObjectNode.execute(frame, result2, false);
        }

        @Fallback
        protected static JSObject doIncompatibleReceiver(Object iterator) {
            throw Errors.createTypeError("not a String Iterator");
        }
    }
}

