/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.StopIterationException;
import com.oracle.truffle.api.interop.UnknownKeyException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.MapPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.helper.JSCollectionsNormalizeNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.cast.LongToIntOrDoubleNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSMap;
import com.oracle.truffle.js.runtime.builtins.JSMapIterator;
import com.oracle.truffle.js.runtime.builtins.JSMapObject;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.JSHashMap;
import com.oracle.truffle.js.runtime.util.SimpleArrayList;

public final class MapPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<MapPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new MapPrototypeBuiltins();

    protected MapPrototypeBuiltins() {
        super(JSMap.PROTOTYPE_NAME, MapPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context2, JSBuiltin builtin, boolean construct, boolean newTarget, MapPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return MapPrototypeBuiltinsFactory.JSMapClearNodeGen.create(context2, builtin, MapPrototypeBuiltins.args().withThis().createArgumentNodes(context2));
            }
            case 1: {
                return MapPrototypeBuiltinsFactory.JSMapDeleteNodeGen.create(context2, builtin, MapPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 2: {
                return MapPrototypeBuiltinsFactory.JSMapSetNodeGen.create(context2, builtin, MapPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context2));
            }
            case 3: {
                return MapPrototypeBuiltinsFactory.JSMapGetNodeGen.create(context2, builtin, MapPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 4: {
                return MapPrototypeBuiltinsFactory.JSMapHasNodeGen.create(context2, builtin, MapPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 5: {
                return MapPrototypeBuiltinsFactory.JSMapForEachNodeGen.create(context2, builtin, MapPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context2));
            }
            case 6: {
                return MapPrototypeBuiltinsFactory.CreateMapIteratorNodeGen.create(context2, builtin, 1, MapPrototypeBuiltins.args().withThis().createArgumentNodes(context2));
            }
            case 7: {
                return MapPrototypeBuiltinsFactory.CreateMapIteratorNodeGen.create(context2, builtin, 2, MapPrototypeBuiltins.args().withThis().createArgumentNodes(context2));
            }
            case 8: {
                return MapPrototypeBuiltinsFactory.CreateMapIteratorNodeGen.create(context2, builtin, 3, MapPrototypeBuiltins.args().withThis().createArgumentNodes(context2));
            }
            case 9: {
                return MapPrototypeBuiltinsFactory.MapGetSizeNodeGen.create(context2, builtin, MapPrototypeBuiltins.args().withThis().createArgumentNodes(context2));
            }
        }
        return null;
    }

    public static enum MapPrototype implements BuiltinEnum<MapPrototype>
    {
        clear(0),
        delete(1),
        set(2),
        get(1),
        has(1),
        forEach(1),
        keys(0),
        values(0),
        entries(0),
        size(0);

        private final int length;

        private MapPrototype(int length2) {
            this.length = length2;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return this == size;
        }
    }

    @ImportStatic(value={JSConfig.class, JSMapOperation.class})
    public static abstract class JSMapClearNode
    extends JSBuiltinNode {
        public JSMapClearNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected static JSDynamicObject doMap(JSMapObject thisObj) {
            JSMap.getInternalMap(thisObj).clear();
            return Undefined.instance;
        }

        @Specialization(guards={"!isJSMap(thisObj)", "isForeignHash(thisObj, mapLib)"})
        protected JSDynamicObject doForeignMap(Object thisObj, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared(value="mapLib") InteropLibrary mapLib, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Exclusive InteropLibrary iteratorLib, @Cached InlinedBranchProfile growProfile) {
            try {
                Object hashEntriesIterator = mapLib.getHashKeysIterator(thisObj);
                SimpleArrayList<Object> keys = SimpleArrayList.create(mapLib.getHashSize(thisObj));
                while (true) {
                    try {
                        Object nextKey = iteratorLib.getIteratorNextElement(hashEntriesIterator);
                        keys.add(nextKey, this, growProfile);
                    }
                    catch (StopIterationException e) {
                        break;
                    }
                    TruffleSafepoint.poll(this);
                }
                for (Object key : keys.toArray()) {
                    try {
                        mapLib.removeHashEntry(thisObj, key);
                    }
                    catch (UnknownKeyException e) {
                        continue;
                    }
                    TruffleSafepoint.poll(this);
                }
            }
            catch (UnsupportedMessageException e) {
                throw Errors.createTypeErrorInteropException(thisObj, e, "clear", this);
            }
            return Undefined.instance;
        }

        @Specialization(guards={"!isJSMap(thisObj)", "!isForeignHash(thisObj, mapLib)"})
        protected static JSDynamicObject notMap(Object thisObj, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared(value="mapLib") InteropLibrary mapLib) {
            throw Errors.createTypeErrorMapExpected();
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class JSMapDeleteNode
    extends JSMapOperation {
        public JSMapDeleteNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected boolean doMap(JSMapObject thisObj, Object key) {
            Object normalizedKey = this.normalize(key);
            return JSMap.getInternalMap(thisObj).remove(normalizedKey);
        }

        @Specialization(guards={"!isJSMap(thisObj)", "isForeignHash(thisObj, mapLib)"})
        protected boolean doForeignMap(Object thisObj, Object key, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared(value="mapLib") InteropLibrary mapLib) {
            Object normalizedKey = this.normalize(key);
            try {
                mapLib.removeHashEntry(thisObj, normalizedKey);
                return true;
            }
            catch (UnknownKeyException e) {
                return false;
            }
            catch (UnsupportedMessageException e) {
                throw Errors.createTypeErrorInteropException(thisObj, e, "removeHashEntry", this);
            }
        }

        @Specialization(guards={"!isJSMap(thisObj)", "!isForeignHash(thisObj, mapLib)"})
        protected static boolean notMap(Object thisObj, Object key, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared(value="mapLib") InteropLibrary mapLib) {
            throw Errors.createTypeErrorMapExpected();
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class JSMapSetNode
    extends JSMapOperation {
        public JSMapSetNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected JSDynamicObject doMap(JSMapObject thisObj, Object key, Object value2) {
            Object normalizedKey = this.normalize(key);
            JSMap.getInternalMap(thisObj).put(normalizedKey, value2);
            return thisObj;
        }

        @Specialization(guards={"!isJSMap(thisObj)", "isForeignHash(thisObj, mapLib)"})
        protected Object doForeignMap(Object thisObj, Object key, Object value2, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared(value="mapLib") InteropLibrary mapLib, @Cached ExportValueNode exportValueNode) {
            Object normalizedKey = this.normalize(key);
            Object exportedValue = exportValueNode.execute(value2);
            try {
                mapLib.writeHashEntry(thisObj, normalizedKey, exportedValue);
            }
            catch (UnknownKeyException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw Errors.createTypeErrorInteropException(thisObj, e, "writeHashEntry", this);
            }
            return thisObj;
        }

        @Specialization(guards={"!isJSMap(thisObj)", "!isForeignHash(thisObj, mapLib)"})
        protected static JSDynamicObject notMap(Object thisObj, Object key, Object value2, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared(value="mapLib") InteropLibrary mapLib) {
            throw Errors.createTypeErrorMapExpected();
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class JSMapGetNode
    extends JSMapOperation {
        public JSMapGetNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected Object doMap(JSMapObject thisObj, Object key) {
            Object normalizedKey = this.normalize(key);
            Object value2 = JSMap.getInternalMap(thisObj).get(normalizedKey);
            return JSRuntime.nullToUndefined(value2);
        }

        @Specialization(guards={"!isJSMap(thisObj)", "isForeignHash(thisObj, mapLib)"})
        protected Object doForeignMap(Object thisObj, Object key, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared(value="mapLib") InteropLibrary mapLib, @Cached ImportValueNode importValue) {
            Object normalizedKey = this.normalize(key);
            try {
                return importValue.executeWithTarget(mapLib.readHashValueOrDefault(thisObj, normalizedKey, Undefined.instance));
            }
            catch (UnsupportedMessageException e) {
                throw Errors.createTypeErrorInteropException(thisObj, e, "readHashValue", this);
            }
        }

        @Specialization(guards={"!isJSMap(thisObj)", "!isForeignHash(thisObj, mapLib)"})
        protected static Object notMap(Object thisObj, Object key, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared(value="mapLib") InteropLibrary mapLib) {
            throw Errors.createTypeErrorMapExpected();
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class JSMapHasNode
    extends JSMapOperation {
        public JSMapHasNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected boolean doMap(JSMapObject thisObj, Object key) {
            Object normalizedKey = this.normalize(key);
            return JSMap.getInternalMap(thisObj).has(normalizedKey);
        }

        @Specialization(guards={"!isJSMap(thisObj)", "isForeignHash(thisObj, mapLib)"})
        protected Object doForeignMap(Object thisObj, Object key, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared(value="mapLib") InteropLibrary mapLib) {
            Object normalizedKey = this.normalize(key);
            return mapLib.isHashEntryReadable(thisObj, normalizedKey);
        }

        @Specialization(guards={"!isJSMap(thisObj)", "!isForeignHash(thisObj, mapLib)"})
        protected static boolean notMap(Object thisObj, Object key, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared(value="mapLib") InteropLibrary mapLib) {
            throw Errors.createTypeErrorMapExpected();
        }
    }

    @ImportStatic(value={JSConfig.class, JSMapOperation.class})
    public static abstract class JSMapForEachNode
    extends JSBuiltinNode {
        public JSMapForEachNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization(guards={"isCallable.executeBoolean(callback)"}, limit="1")
        protected Object doMap(JSMapObject thisObj, Object callback, Object thisArg, @Cached @Cached.Shared(value="isCallable") IsCallableNode isCallable, @Cached(value="createCall()") @Cached.Shared(value="callNode") JSFunctionCallNode callNode) {
            JSHashMap map2 = JSMap.getInternalMap(thisObj);
            JSHashMap.Cursor cursor = map2.getEntries();
            while (cursor.advance()) {
                Object value2 = cursor.getValue();
                Object key = cursor.getKey();
                callNode.executeCall(JSArguments.create(thisArg, callback, value2, key, thisObj));
            }
            return Undefined.instance;
        }

        @Specialization(guards={"!isJSMap(thisObj)", "isForeignHash(thisObj, mapLib)", "isCallable.executeBoolean(callback)"}, limit="1")
        protected Object doForeignMap(Object thisObj, Object callback, Object thisArg, @Cached @Cached.Shared(value="isCallable") IsCallableNode isCallable, @Cached(value="createCall()") @Cached.Shared(value="callNode") JSFunctionCallNode callNode, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared(value="mapLib") InteropLibrary mapLib, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Exclusive InteropLibrary iteratorLib, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Exclusive InteropLibrary entryLib) {
            try {
                Object hashEntriesIterator = mapLib.getHashEntriesIterator(thisObj);
                try {
                    while (true) {
                        Object nextEntry = iteratorLib.getIteratorNextElement(hashEntriesIterator);
                        Object key = entryLib.readArrayElement(nextEntry, 0L);
                        Object value2 = entryLib.readArrayElement(nextEntry, 1L);
                        callNode.executeCall(JSArguments.create(thisArg, callback, value2, key, thisObj));
                    }
                }
                catch (StopIterationException e) {
                }
            }
            catch (InvalidArrayIndexException | UnsupportedMessageException e) {
                throw Errors.createTypeErrorInteropException(thisObj, e, "forEach", this);
            }
            return Undefined.instance;
        }

        @Specialization(guards={"isJSMap(thisObj) || isForeignHash(thisObj, mapLib)", "!isCallable.executeBoolean(callback)"}, limit="1")
        protected static Object invalidCallback(Object thisObj, Object callback, Object thisArg, @Cached @Cached.Shared(value="isCallable") IsCallableNode isCallable, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared(value="mapLib") InteropLibrary mapLib) {
            throw Errors.createTypeErrorCallableExpected();
        }

        @Specialization(guards={"!isJSMap(thisObj)", "!isForeignHash(thisObj, mapLib)"})
        protected static Object notMap(Object thisObj, Object callback, Object thisArg, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared(value="mapLib") InteropLibrary mapLib) {
            throw Errors.createTypeErrorMapExpected();
        }
    }

    @ImportStatic(value={JSConfig.class, JSRuntime.class, JSMapOperation.class})
    public static abstract class CreateMapIteratorNode
    extends JSBuiltinNode {
        private final int iterationKind;

        public CreateMapIteratorNode(JSContext context2, JSBuiltin builtin, int iterationKind) {
            super(context2, builtin);
            this.iterationKind = iterationKind;
        }

        @Specialization
        protected final JSObject doMap(JSMapObject map2) {
            return JSMapIterator.create(this.getContext(), this.getRealm(), map2, JSMap.getInternalMap(map2).getEntries(), this.iterationKind);
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"!isJSMap(map)", "isForeignHash(map, mapLib)"})
        protected final JSObject doForeignMap(Object map2, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared(value="mapLib") InteropLibrary mapLib, @Cached(value="createSetHidden(ENUMERATE_ITERATOR_ID, getContext())") PropertySetNode setEnumerateIteratorNode) {
            Object iterator;
            try {
                if (this.iterationKind == 1) {
                    iterator = mapLib.getHashKeysIterator(map2);
                } else if (this.iterationKind == 2) {
                    iterator = mapLib.getHashValuesIterator(map2);
                } else {
                    assert (this.iterationKind == 3);
                    iterator = mapLib.getHashEntriesIterator(map2);
                }
            }
            catch (UnsupportedMessageException e) {
                throw Errors.createTypeErrorInteropException(map2, e, "get hash iterator", this);
            }
            JSObject iteratorObj = JSOrdinary.create(this.getContext(), this.getContext().getEnumerateIteratorFactory(), this.getRealm());
            setEnumerateIteratorNode.setValue(iteratorObj, iterator);
            return iteratorObj;
        }

        @Specialization(guards={"!isJSMap(thisObj)", "!isForeignHash(thisObj, mapLib)"})
        protected static JSObject doIncompatibleReceiver(Object thisObj, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared(value="mapLib") InteropLibrary mapLib) {
            throw Errors.createTypeErrorMapExpected();
        }
    }

    @ImportStatic(value={JSConfig.class, JSMapOperation.class})
    public static abstract class MapGetSizeNode
    extends JSBuiltinNode {
        public MapGetSizeNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected static int doMap(JSMapObject thisObj) {
            return JSMap.getMapSize(thisObj);
        }

        @Specialization(guards={"!isJSMap(thisObj)", "isForeignHash(thisObj, mapLib)"})
        protected final Object doForeignMap(Object thisObj, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared(value="mapLib") InteropLibrary mapLib, @Cached(inline=true) LongToIntOrDoubleNode sizeToJSNumber) {
            try {
                long hashSize = mapLib.getHashSize(thisObj);
                return sizeToJSNumber.execute(this, hashSize);
            }
            catch (UnsupportedMessageException e) {
                throw Errors.createTypeErrorInteropException(thisObj, e, "getHashSize", this);
            }
        }

        @Specialization(guards={"!isJSMap(thisObj)", "!isForeignHash(thisObj, mapLib)"})
        protected static int notMap(Object thisObj, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared(value="mapLib") InteropLibrary mapLib) {
            throw Errors.createTypeErrorMapExpected();
        }
    }

    public static abstract class JSMapOperation
    extends JSBuiltinNode {
        @Node.Child
        private JSCollectionsNormalizeNode normalizeNode = JSCollectionsNormalizeNode.create();

        protected JSMapOperation(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        protected final Object normalize(Object value2) {
            return this.normalizeNode.execute(value2);
        }

        protected static boolean isForeignHash(Object value2, InteropLibrary interopLibrary) {
            return interopLibrary.hasHashEntries(value2) && !(value2 instanceof JSDynamicObject);
        }
    }
}

