/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.console;

import com.intellij.execution.filters.AbstractFileHyperlinkFilter;
import com.intellij.execution.filters.FileHyperlinkRawData;
import com.intellij.httpClient.execution.HttpClientExecutorBundle;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0005\u000f\u0010\u0011\u0012\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\fR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/httpClient/http/request/run/console/HttpRequestErrorFileFilter;", "Lcom/intellij/execution/filters/AbstractFileHyperlinkFilter;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "errorExtractors", "", "Lcom/intellij/httpClient/http/request/run/console/HttpRequestErrorFileFilter$ErrorInformationExtractor;", "parse", "Lcom/intellij/execution/filters/FileHyperlinkRawData;", "line", "", "getErrorInformation", "Lcom/intellij/httpClient/http/request/run/console/HttpRequestErrorFileFilter$ErrorInformation;", "ErrorInformation", "ErrorInformationExtractor", "Companion", "SubstitutionErrorExtractor", "SslErrorExtractor", "intellij.restClient"})
public final class HttpRequestErrorFileFilter
extends AbstractFileHyperlinkFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<ErrorInformationExtractor> errorExtractors;
    private static final long REG_EXP_TIMEOUT = 100L;
    @NotNull
    private static final String PATH_PATTERN = "(((\\w:)?[^:]+):(\\d+):(\\d+))";
    @Nullable
    private static final String BASE_DIR;

    public HttpRequestErrorFileFilter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, BASE_DIR);
        Object[] objectArray = new ErrorInformationExtractor[]{new SubstitutionErrorExtractor(), new SslErrorExtractor()};
        this.errorExtractors = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<FileHyperlinkRawData> parse(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        ErrorInformation errorInformation = this.getErrorInformation(line);
        return CollectionsKt.listOfNotNull((Object)(errorInformation != null ? errorInformation.getPosition() : null));
    }

    @Nullable
    public final ErrorInformation getErrorInformation(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return (ErrorInformation)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.errorExtractors), arg_0 -> HttpRequestErrorFileFilter.getErrorInformation$lambda$0(line, arg_0)));
    }

    private static final ErrorInformation getErrorInformation$lambda$0(String $line, ErrorInformationExtractor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.extractError($line);
    }

    @JvmStatic
    @NotNull
    public static final HttpRequestErrorFileFilter getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/httpClient/http/request/run/console/HttpRequestErrorFileFilter$Companion;", "", "<init>", "()V", "REG_EXP_TIMEOUT", "", "PATH_PATTERN", "", "BASE_DIR", "getInstance", "Lcom/intellij/httpClient/http/request/run/console/HttpRequestErrorFileFilter;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.restClient"})
    @SourceDebugExtension(value={"SMAP\nHttpRequestErrorFileFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestErrorFileFilter.kt\ncom/intellij/httpClient/http/request/run/console/HttpRequestErrorFileFilter$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,139:1\n31#2,2:140\n*S KotlinDebug\n*F\n+ 1 HttpRequestErrorFileFilter.kt\ncom/intellij/httpClient/http/request/run/console/HttpRequestErrorFileFilter$Companion\n*L\n38#1:140,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final HttpRequestErrorFileFilter getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<HttpRequestErrorFileFilter> serviceClass$iv = HttpRequestErrorFileFilter.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (HttpRequestErrorFileFilter)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/httpClient/http/request/run/console/HttpRequestErrorFileFilter$ErrorInformation;", "", "position", "Lcom/intellij/execution/filters/FileHyperlinkRawData;", "message", "", "<init>", "(Lcom/intellij/execution/filters/FileHyperlinkRawData;Ljava/lang/String;)V", "getPosition", "()Lcom/intellij/execution/filters/FileHyperlinkRawData;", "getMessage", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.restClient"})
    public static final class ErrorInformation {
        @NotNull
        private final FileHyperlinkRawData position;
        @NotNull
        private final String message;

        public ErrorInformation(@NotNull FileHyperlinkRawData position, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.position = position;
            this.message = message;
        }

        @NotNull
        public final FileHyperlinkRawData getPosition() {
            return this.position;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final FileHyperlinkRawData component1() {
            return this.position;
        }

        @NotNull
        public final String component2() {
            return this.message;
        }

        @NotNull
        public final ErrorInformation copy(@NotNull FileHyperlinkRawData position, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new ErrorInformation(position, message);
        }

        public static /* synthetic */ ErrorInformation copy$default(ErrorInformation errorInformation, FileHyperlinkRawData fileHyperlinkRawData, String string, int n, Object object) {
            if ((n & 1) != 0) {
                fileHyperlinkRawData = errorInformation.position;
            }
            if ((n & 2) != 0) {
                string = errorInformation.message;
            }
            return errorInformation.copy(fileHyperlinkRawData, string);
        }

        @NotNull
        public String toString() {
            return "ErrorInformation(position=" + this.position + ", message=" + this.message + ")";
        }

        public int hashCode() {
            int result2 = this.position.hashCode();
            result2 = result2 * 31 + this.message.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ErrorInformation)) {
                return false;
            }
            ErrorInformation errorInformation = (ErrorInformation)other;
            if (!Intrinsics.areEqual((Object)this.position, (Object)errorInformation.position)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.message, (Object)errorInformation.message);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/httpClient/http/request/run/console/HttpRequestErrorFileFilter$ErrorInformationExtractor;", "", "extractError", "Lcom/intellij/httpClient/http/request/run/console/HttpRequestErrorFileFilter$ErrorInformation;", "line", "", "intellij.restClient"})
    public static interface ErrorInformationExtractor {
        @Nullable
        public ErrorInformation extractError(@NotNull String var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/httpClient/http/request/run/console/HttpRequestErrorFileFilter$SslErrorExtractor;", "Lcom/intellij/httpClient/http/request/run/console/HttpRequestErrorFileFilter$ErrorInformationExtractor;", "<init>", "()V", "emptyError", "", "Lorg/jetbrains/annotations/Nls;", "pathPattern", "Ljava/util/regex/Pattern;", "extractError", "Lcom/intellij/httpClient/http/request/run/console/HttpRequestErrorFileFilter$ErrorInformation;", "line", "Companion", "intellij.restClient"})
    private static final class SslErrorExtractor
    implements ErrorInformationExtractor {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String emptyError;
        @NotNull
        private final Pattern pathPattern;
        public static final int POSITION_GROUP = 1;
        public static final int PATH_GROUP = 2;
        public static final int LINE_GROUP = 4;
        public static final int COLUMN_GROUP = 5;

        public SslErrorExtractor() {
            Object object = new Object[]{""};
            this.emptyError = HttpClientExecutorBundle.message("http.request.ssl.error.response", object);
            object = HttpRequestErrorFileFilter.PATH_PATTERN;
            int n = 0;
            Pattern pattern = Pattern.compile((String)object, n);
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
            this.pathPattern = pattern;
        }

        @Override
        @Nullable
        public ErrorInformation extractError(@NotNull String line) {
            Integer columnPosition;
            MatchResult matcher;
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            if (!StringsKt.startsWith$default((String)line, (String)this.emptyError, (boolean)false, (int)2, null)) {
                return null;
            }
            String pathCandidate = StringsKt.drop((String)line, (int)this.emptyError.length());
            try {
                matcher = this.pathPattern.matcher(StringUtil.newBombedCharSequence((CharSequence)pathCandidate, (long)100L));
                if (!((Matcher)matcher).find()) {
                    return null;
                }
                matcher = ((Matcher)matcher).toMatchResult();
            }
            catch (ProcessCanceledException e) {
                return null;
            }
            MatchResult matchResult = matcher;
            String position = matchResult.group(1);
            if (position == null) {
                return null;
            }
            String path = matchResult.group(2);
            Object object = matchResult.group(4);
            Integer linePosition = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? Integer.valueOf((Integer)object - 1) : null;
            String string = matchResult.group(5);
            Integer n = columnPosition = string != null ? StringsKt.toIntOrNull((String)string) : null;
            if (path == null || linePosition == null || columnPosition == null) {
                return null;
            }
            int pathBegin = this.emptyError.length();
            int pathEnd = pathBegin + position.length();
            return new ErrorInformation(new FileHyperlinkRawData(path, linePosition.intValue(), columnPosition.intValue(), pathBegin, pathEnd), "");
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/httpClient/http/request/run/console/HttpRequestErrorFileFilter$SslErrorExtractor$Companion;", "", "<init>", "()V", "POSITION_GROUP", "", "PATH_GROUP", "LINE_GROUP", "COLUMN_GROUP", "intellij.restClient"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/httpClient/http/request/run/console/HttpRequestErrorFileFilter$SubstitutionErrorExtractor;", "Lcom/intellij/httpClient/http/request/run/console/HttpRequestErrorFileFilter$ErrorInformationExtractor;", "<init>", "()V", "pathPatternInfo", "Lcom/intellij/httpClient/http/request/run/console/HttpRequestErrorFileFilter$SubstitutionErrorExtractor$SubstitutionErrorPathPatternInfo;", "extractError", "Lcom/intellij/httpClient/http/request/run/console/HttpRequestErrorFileFilter$ErrorInformation;", "line", "", "SubstitutionErrorPathPatternInfo", "intellij.restClient"})
    private static final class SubstitutionErrorExtractor
    implements ErrorInformationExtractor {
        @NotNull
        private final SubstitutionErrorPathPatternInfo pathPatternInfo = SubstitutionErrorPathPatternInfo.Companion.createPattern();

        @Override
        @Nullable
        public ErrorInformation extractError(@NotNull String line) {
            MatchResult matcher;
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            try {
                matcher = this.pathPatternInfo.getPattern().matcher(StringUtil.newBombedCharSequence((CharSequence)line, (long)100L));
                if (!((Matcher)matcher).find()) {
                    return null;
                }
                matcher = ((Matcher)matcher).toMatchResult();
            }
            catch (ProcessCanceledException e) {
                return null;
            }
            MatchResult matchResult = matcher;
            if (matchResult.group(this.pathPatternInfo.getPositionGroup()) == null) {
                return null;
            }
            int pathBegin = matchResult.start(this.pathPatternInfo.getPositionGroup());
            int pathEnd = matchResult.end(this.pathPatternInfo.getPositionGroup());
            String path = matchResult.group(this.pathPatternInfo.getPathGroup());
            Object object = matchResult.group(this.pathPatternInfo.getLineGroup());
            Integer linePosition = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? Integer.valueOf((Integer)object - 1) : null;
            Object object2 = matchResult.group(this.pathPatternInfo.getColumnGroup());
            Integer columnPosition = object2 != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? Integer.valueOf((Integer)object2 - 1) : null;
            String message = matchResult.group(this.pathPatternInfo.getMessageGroup());
            if (path == null || linePosition == null || columnPosition == null || message == null) {
                return null;
            }
            return new ErrorInformation(new FileHyperlinkRawData(path, linePosition.intValue(), columnPosition.intValue(), pathBegin, pathEnd), message);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u0000 !2\u00020\u0001:\u0001!B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003JE\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006\""}, d2={"Lcom/intellij/httpClient/http/request/run/console/HttpRequestErrorFileFilter$SubstitutionErrorExtractor$SubstitutionErrorPathPatternInfo;", "", "pattern", "Ljava/util/regex/Pattern;", "messageGroup", "", "positionGroup", "pathGroup", "lineGroup", "columnGroup", "<init>", "(Ljava/util/regex/Pattern;IIIII)V", "getPattern", "()Ljava/util/regex/Pattern;", "getMessageGroup", "()I", "getPositionGroup", "getPathGroup", "getLineGroup", "getColumnGroup", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "intellij.restClient"})
        private static final class SubstitutionErrorPathPatternInfo {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final Pattern pattern;
            private final int messageGroup;
            private final int positionGroup;
            private final int pathGroup;
            private final int lineGroup;
            private final int columnGroup;

            public SubstitutionErrorPathPatternInfo(@NotNull Pattern pattern, int messageGroup, int positionGroup, int pathGroup, int lineGroup, int columnGroup) {
                Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
                this.pattern = pattern;
                this.messageGroup = messageGroup;
                this.positionGroup = positionGroup;
                this.pathGroup = pathGroup;
                this.lineGroup = lineGroup;
                this.columnGroup = columnGroup;
            }

            public /* synthetic */ SubstitutionErrorPathPatternInfo(Pattern pattern, int n, int n2, int n3, int n4, int n5, int n6, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n6 & 8) != 0) {
                    n3 = n2 + 1;
                }
                if ((n6 & 0x10) != 0) {
                    n4 = n2 + 3;
                }
                if ((n6 & 0x20) != 0) {
                    n5 = n2 + 4;
                }
                this(pattern, n, n2, n3, n4, n5);
            }

            @NotNull
            public final Pattern getPattern() {
                return this.pattern;
            }

            public final int getMessageGroup() {
                return this.messageGroup;
            }

            public final int getPositionGroup() {
                return this.positionGroup;
            }

            public final int getPathGroup() {
                return this.pathGroup;
            }

            public final int getLineGroup() {
                return this.lineGroup;
            }

            public final int getColumnGroup() {
                return this.columnGroup;
            }

            @NotNull
            public final Pattern component1() {
                return this.pattern;
            }

            public final int component2() {
                return this.messageGroup;
            }

            public final int component3() {
                return this.positionGroup;
            }

            public final int component4() {
                return this.pathGroup;
            }

            public final int component5() {
                return this.lineGroup;
            }

            public final int component6() {
                return this.columnGroup;
            }

            @NotNull
            public final SubstitutionErrorPathPatternInfo copy(@NotNull Pattern pattern, int messageGroup, int positionGroup, int pathGroup, int lineGroup, int columnGroup) {
                Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
                return new SubstitutionErrorPathPatternInfo(pattern, messageGroup, positionGroup, pathGroup, lineGroup, columnGroup);
            }

            public static /* synthetic */ SubstitutionErrorPathPatternInfo copy$default(SubstitutionErrorPathPatternInfo substitutionErrorPathPatternInfo, Pattern pattern, int n, int n2, int n3, int n4, int n5, int n6, Object object) {
                if ((n6 & 1) != 0) {
                    pattern = substitutionErrorPathPatternInfo.pattern;
                }
                if ((n6 & 2) != 0) {
                    n = substitutionErrorPathPatternInfo.messageGroup;
                }
                if ((n6 & 4) != 0) {
                    n2 = substitutionErrorPathPatternInfo.positionGroup;
                }
                if ((n6 & 8) != 0) {
                    n3 = substitutionErrorPathPatternInfo.pathGroup;
                }
                if ((n6 & 0x10) != 0) {
                    n4 = substitutionErrorPathPatternInfo.lineGroup;
                }
                if ((n6 & 0x20) != 0) {
                    n5 = substitutionErrorPathPatternInfo.columnGroup;
                }
                return substitutionErrorPathPatternInfo.copy(pattern, n, n2, n3, n4, n5);
            }

            @NotNull
            public String toString() {
                return "SubstitutionErrorPathPatternInfo(pattern=" + this.pattern + ", messageGroup=" + this.messageGroup + ", positionGroup=" + this.positionGroup + ", pathGroup=" + this.pathGroup + ", lineGroup=" + this.lineGroup + ", columnGroup=" + this.columnGroup + ")";
            }

            public int hashCode() {
                int result2 = this.pattern.hashCode();
                result2 = result2 * 31 + Integer.hashCode(this.messageGroup);
                result2 = result2 * 31 + Integer.hashCode(this.positionGroup);
                result2 = result2 * 31 + Integer.hashCode(this.pathGroup);
                result2 = result2 * 31 + Integer.hashCode(this.lineGroup);
                result2 = result2 * 31 + Integer.hashCode(this.columnGroup);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SubstitutionErrorPathPatternInfo)) {
                    return false;
                }
                SubstitutionErrorPathPatternInfo substitutionErrorPathPatternInfo = (SubstitutionErrorPathPatternInfo)other;
                if (!Intrinsics.areEqual((Object)this.pattern, (Object)substitutionErrorPathPatternInfo.pattern)) {
                    return false;
                }
                if (this.messageGroup != substitutionErrorPathPatternInfo.messageGroup) {
                    return false;
                }
                if (this.positionGroup != substitutionErrorPathPatternInfo.positionGroup) {
                    return false;
                }
                if (this.pathGroup != substitutionErrorPathPatternInfo.pathGroup) {
                    return false;
                }
                if (this.lineGroup != substitutionErrorPathPatternInfo.lineGroup) {
                    return false;
                }
                return this.columnGroup == substitutionErrorPathPatternInfo.columnGroup;
            }

            @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/httpClient/http/request/run/console/HttpRequestErrorFileFilter$SubstitutionErrorExtractor$SubstitutionErrorPathPatternInfo$Companion;", "", "<init>", "()V", "createPattern", "Lcom/intellij/httpClient/http/request/run/console/HttpRequestErrorFileFilter$SubstitutionErrorExtractor$SubstitutionErrorPathPatternInfo;", "intellij.restClient"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final SubstitutionErrorPathPatternInfo createPattern() {
                    SubstitutionErrorPathPatternInfo substitutionErrorPathPatternInfo;
                    String descriptionPattern = "(.+)";
                    Object object = new Object[]{descriptionPattern, HttpRequestErrorFileFilter.PATH_PATTERN};
                    String resultPattern = HttpClientExecutorBundle.message("http.client.request.error.message.begin", object);
                    if (StringsKt.indexOf$default((CharSequence)resultPattern, (String)descriptionPattern, (int)0, (boolean)false, (int)6, null) < StringsKt.indexOf$default((CharSequence)resultPattern, (String)HttpRequestErrorFileFilter.PATH_PATTERN, (int)0, (boolean)false, (int)6, null)) {
                        object = resultPattern;
                        int n = 0;
                        Pattern pattern = Pattern.compile((String)object, n);
                        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
                        substitutionErrorPathPatternInfo = new SubstitutionErrorPathPatternInfo(pattern, 1, 2, 0, 0, 0, 56, null);
                    } else {
                        object = resultPattern;
                        int n = 0;
                        Pattern pattern = Pattern.compile((String)object, n);
                        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
                        substitutionErrorPathPatternInfo = new SubstitutionErrorPathPatternInfo(pattern, 6, 1, 0, 0, 0, 56, null);
                    }
                    return substitutionErrorPathPatternInfo;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }
}

