/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request;

import com.intellij.httpClient.http.request.HttpRequestNameElement;
import com.intellij.httpClient.http.request.HttpRequestPsiFileIdentifiersScope;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocNameTag;
import com.intellij.httpClient.http.request.psi.HttpClientExecutionBlock;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestBlock;
import com.intellij.httpClient.http.request.psi.HttpRequestElementTypes;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0007\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0003H\u0007\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0003\u001a\f\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u0003\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"getDeclaredName", "", "Lcom/intellij/httpClient/http/request/psi/HttpClientExecutionBlock;", "Lcom/intellij/httpClient/http/request/psi/HttpRequest;", "getUniqueName", "getDeclaredNameElement", "Lcom/intellij/httpClient/http/request/HttpRequestNameElement;", "SEPARATOR_PREFIX", "IDENTIFIER_INDEX_PREFIX", "IDENTIFIER_INDEX_PREFIX_REPLACEMENT", "intellij.httpClient.lang"})
@JvmName(name="HttpRequestNameSupport")
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nHttpRequestNameSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestNameSupport.kt\ncom/intellij/httpClient/http/request/HttpRequestNameSupport\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,122:1\n19#2:123\n808#3,11:124\n1#4:135\n158#5,6:136\n*S KotlinDebug\n*F\n+ 1 HttpRequestNameSupport.kt\ncom/intellij/httpClient/http/request/HttpRequestNameSupport\n*L\n22#1:123\n44#1:124,11\n60#1:136,6\n*E\n"})
public final class HttpRequestNameSupport {
    @NotNull
    private static final String SEPARATOR_PREFIX = "###";
    @NotNull
    public static final String IDENTIFIER_INDEX_PREFIX = "#";
    @NotNull
    private static final String IDENTIFIER_INDEX_PREFIX_REPLACEMENT = "##";

    @NlsSafe
    @Nullable
    public static final String getDeclaredName(@NotNull HttpClientExecutionBlock $this$getDeclaredName) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$getDeclaredName, (String)"<this>");
        HttpClientExecutionBlock $this$asSafely$iv = $this$getDeclaredName;
        boolean $i$f$asSafely = false;
        HttpClientExecutionBlock httpClientExecutionBlock = $this$asSafely$iv;
        if (!(httpClientExecutionBlock instanceof HttpRequestBlock)) {
            httpClientExecutionBlock = null;
        }
        return (object = (HttpRequestBlock)httpClientExecutionBlock) != null && (object = object.getRequest()) != null && (object = HttpRequestNameSupport.getDeclaredNameElement((HttpRequest)object)) != null ? ((HttpRequestNameElement)object).getName() : null;
    }

    @NlsSafe
    @Nullable
    public static final String getDeclaredName(@NotNull HttpRequest $this$getDeclaredName) {
        Intrinsics.checkNotNullParameter((Object)$this$getDeclaredName, (String)"<this>");
        HttpRequestNameElement httpRequestNameElement = HttpRequestNameSupport.getDeclaredNameElement($this$getDeclaredName);
        return httpRequestNameElement != null ? httpRequestNameElement.getName() : null;
    }

    @NotNull
    public static final String getUniqueName(@NotNull HttpClientExecutionBlock $this$getUniqueName) {
        Intrinsics.checkNotNullParameter((Object)$this$getUniqueName, (String)"<this>");
        PsiFile psiFile = $this$getUniqueName.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        HttpRequestPsiFileIdentifiersScope scope = new HttpRequestPsiFileIdentifiersScope(psiFile);
        return scope.getIdentifier($this$getUniqueName);
    }

    @NotNull
    public static final String getUniqueName(@NotNull HttpRequest $this$getUniqueName) {
        Intrinsics.checkNotNullParameter((Object)$this$getUniqueName, (String)"<this>");
        PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)$this$getUniqueName), HttpClientExecutionBlock.class);
        Intrinsics.checkNotNull((Object)psiElement);
        HttpClientExecutionBlock parent = (HttpClientExecutionBlock)psiElement;
        return HttpRequestNameSupport.getUniqueName(parent);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final HttpRequestNameElement getDeclaredNameElement(@NotNull HttpRequest $this$getDeclaredNameElement) {
        Integer n;
        int n2;
        Object $this$indexOfFirst$iv;
        String withoutPrefix;
        String separatorText;
        PsiElement firstSeparator;
        Object object;
        block11: {
            HttpDocNameTag nameDocComment;
            Intrinsics.checkNotNullParameter((Object)$this$getDeclaredNameElement, (String)"<this>");
            Object object2 = HttpRequestPsiUtils.findDocComment($this$getDeclaredNameElement);
            if (object2 != null && (object2 = object2.getTags()) != null) {
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = (Iterable)object2;
                boolean $i$f$filterIsInstance = false;
                object = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof HttpDocNameTag)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                v1 = (HttpDocNameTag)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            } else {
                v1 = nameDocComment = null;
            }
            if (nameDocComment != null) {
                String string;
                String it = string = nameDocComment.getName();
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if ((!StringsKt.isBlank((CharSequence)it) ? string : null) != null) {
                    String string2 = nameDocComment.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                    CharSequence charSequence = string2;
                    String string3 = nameDocComment.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                    int indexOfNameInElement = StringsKt.indexOf$default((CharSequence)charSequence, (String)string3, (int)0, (boolean)false, (int)6, null);
                    String string4 = nameDocComment.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
                    TextRange textRange = nameDocComment.getTextRange().shiftRight(indexOfNameInElement).grown(-indexOfNameInElement);
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"grown(...)");
                    return new HttpRequestNameElement(string4, textRange);
                }
            }
            PsiElement psiElement = (PsiElement)SequencesKt.lastOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.takeWhile((Sequence)PsiTreeUtilKt.siblings((PsiElement)((PsiElement)$this$getDeclaredNameElement), (boolean)false, (boolean)false), HttpRequestNameSupport::getDeclaredNameElement$lambda$1), HttpRequestNameSupport::getDeclaredNameElement$lambda$2));
            if (psiElement == null) {
                return null;
            }
            firstSeparator = psiElement;
            separatorText = firstSeparator.getText();
            Intrinsics.checkNotNull((Object)separatorText);
            withoutPrefix = StringsKt.removePrefix((String)separatorText, (CharSequence)SEPARATOR_PREFIX);
            boolean bl = false;
            $this$indexOfFirst$iv = withoutPrefix;
            boolean $i$f$indexOfFirst = false;
            int n3 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n3; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl2 = false;
                if (!(it != '#')) continue;
                n2 = index$iv;
                break block11;
            }
            n2 = -1;
        }
        $this$indexOfFirst$iv = n2;
        int it = ((Number)$this$indexOfFirst$iv).intValue();
        boolean bl = false;
        Object object3 = it != -1 ? $this$indexOfFirst$iv : null;
        if (object3 != null) {
            int start2 = ((Number)object3).intValue();
            boolean bl3 = false;
            int trimmedStart = SequencesKt.count((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.drop((Sequence)StringsKt.asSequence((CharSequence)withoutPrefix), (int)start2), HttpRequestNameSupport::getDeclaredNameElement$lambda$8$lambda$7$lambda$5));
            boolean bl4 = false;
            n = 3 + start2 + trimmedStart;
        } else {
            n = null;
        }
        if (n == null) {
            return null;
        }
        int indexOfNameInElement = n;
        String string = separatorText.substring(indexOfNameInElement);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        Object it2 = object = ((Object)StringsKt.trimEnd((CharSequence)string)).toString();
        boolean bl5 = false;
        Object object4 = ((CharSequence)it2).length() > 0 ? object : null;
        if (object4 == null) {
            return null;
        }
        Object name = object4;
        TextRange textRange = firstSeparator.getTextRange().shiftRight(indexOfNameInElement).grown(-indexOfNameInElement);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"grown(...)");
        return new HttpRequestNameElement((String)name, textRange);
    }

    private static final boolean getDeclaredNameElement$lambda$1(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !(it instanceof HttpRequest);
    }

    private static final boolean getDeclaredNameElement$lambda$2(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return HttpRequestPsiUtils.isOfType(it, HttpRequestElementTypes.REQUEST_SEPARATOR);
    }

    private static final boolean getDeclaredNameElement$lambda$8$lambda$7$lambda$5(char it) {
        return CharsKt.isWhitespace((char)it);
    }
}

