/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.converters.curl;

import com.intellij.httpClient.converters.RequestBuilder;
import com.intellij.httpClient.converters.curl.CurlMultipartBodyBuilder;
import com.intellij.httpClient.converters.curl.CurlRequestBuilderKt;
import com.intellij.httpClient.converters.curl.CurlRequestFormBody;
import com.intellij.httpClient.converters.curl.CurlRequestMessageBody;
import com.intellij.httpClient.converters.curl.RequestFieldParam;
import com.intellij.httpClient.execution.HttpRequestConfig;
import com.intellij.httpClient.execution.auth.HttpClientAuthData;
import com.intellij.httpClient.execution.auth.HttpRequestAuthCredentials;
import com.intellij.httpClient.execution.auth.HttpRequestAuthScope;
import com.intellij.httpClient.execution.ssl.SslConfiguration;
import com.intellij.httpClient.executor.graphql.request.GraphQLPresentationKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ThrowableConsumer;
import java.io.File;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J&\u0010\u001a\u001a\u00020\u0017\"\b\b\u0000\u0010\u001b*\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u0002H\u001b0\u001eH\u0016J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u0015H\u0016J.\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u00022\u0014\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u0002H\u0016J8\u0010,\u001a\u00020\u0017\"\b\b\u0000\u0010\u001b*\u00020\u001c2\b\u0010-\u001a\u0004\u0018\u00010\u00022\u001a\u0010.\u001a\u0016\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u00030/\u0012\u0004\u0012\u0002H\u001b0\u001eH\u0016J\u0010\u00100\u001a\u00020\u00172\u0006\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u00020\u0017H\u0016J\b\u00104\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\u0017*\u000605j\u0002`6H\u0002J\u0010\u00107\u001a\u00020\u0017*\u000605j\u0002`6H\u0002J\u0010\u0010\u0010\u001a\u00020\u0017*\u000605j\u0002`6H\u0002J\u0010\u0010\u0012\u001a\u00020\u0017*\u000605j\u0002`6H\u0002J\u0010\u0010!\u001a\u00020\u0017*\u000605j\u0002`6H\u0002J\u0010\u00108\u001a\u00020\u0017*\u000605j\u0002`6H\u0002J\u0012\u00109\u001a\u00020\u00172\b\u0010:\u001a\u0004\u0018\u00010;H\u0016J\u0018\u0010<\u001a\u00020\u00172\u0006\u0010=\u001a\u00020\u00022\u0006\u0010>\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/intellij/httpClient/converters/curl/CurlRequestBuilder;", "Lcom/intellij/httpClient/converters/RequestBuilder;", "", "Lcom/intellij/httpClient/converters/curl/CurlRequestFormBody;", "graphQL", "", "<init>", "(Z)V", "url", "method", "queryParams", "", "Lcom/intellij/httpClient/converters/curl/RequestFieldParam;", "body", "Lcom/intellij/httpClient/converters/curl/CurlRequestMessageBody;", "allowRedirect", "protocol", "Lcom/intellij/httpClient/converters/RequestBuilder$HttpProtocol;", "headers", "contentType", "authData", "Lcom/intellij/httpClient/execution/auth/HttpClientAuthData;", "withUrl", "", "withMethod", "withProtocol", "withQueryParameters", "E", "", "queryInitializer", "Lcom/intellij/util/ThrowableConsumer;", "Lcom/intellij/httpClient/converters/RequestBuilder$QueryBuilder;", "withAuthData", "data", "withHeader", "name", "value", "optionProvider", "Ljava/util/function/Function;", "withFileToSend", "file", "Ljava/io/File;", "withTextToSend", "text", "withMultipartBody", "multipartBoundary", "multipartInitializer", "Lcom/intellij/httpClient/converters/RequestBuilder$MultipartBodyBuilder;", "withConfig", "config", "Lcom/intellij/httpClient/execution/HttpRequestConfig;", "withEmptyCredentials", "build", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "buildUrl", "authentication", "withSslConfiguration", "sslConfiguration", "Lcom/intellij/httpClient/execution/ssl/SslConfiguration;", "withUserDefinedOutputFilePath", "filePath", "isForce", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nCurlRequestBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CurlRequestBuilder.kt\ncom/intellij/httpClient/converters/curl/CurlRequestBuilder\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,316:1\n15#2:317\n1#3:318\n*S KotlinDebug\n*F\n+ 1 CurlRequestBuilder.kt\ncom/intellij/httpClient/converters/curl/CurlRequestBuilder\n*L\n72#1:317\n*E\n"})
public final class CurlRequestBuilder
implements RequestBuilder<String, CurlRequestFormBody> {
    private final boolean graphQL;
    @NotNull
    private String url;
    @NotNull
    private String method;
    @NotNull
    private final List<RequestFieldParam> queryParams;
    @Nullable
    private CurlRequestMessageBody body;
    private boolean allowRedirect;
    @Nullable
    private RequestBuilder.HttpProtocol protocol;
    @NotNull
    private final List<RequestFieldParam> headers;
    @Nullable
    private String contentType;
    @Nullable
    private HttpClientAuthData authData;

    @JvmOverloads
    public CurlRequestBuilder(boolean graphQL) {
        this.graphQL = graphQL;
        this.url = "";
        this.method = "GET";
        this.queryParams = new ArrayList();
        this.allowRedirect = true;
        this.headers = new ArrayList();
    }

    public /* synthetic */ CurlRequestBuilder(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @Override
    public void withUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.url = url;
    }

    @Override
    public void withMethod(@NotNull String method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        this.method = method;
        if (this.graphQL) {
            this.headers.add(new RequestFieldParam("Content-Type", "application/json"));
        }
    }

    @Override
    public void withProtocol(@NotNull RequestBuilder.HttpProtocol protocol) {
        Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"protocol");
        this.protocol = protocol;
    }

    @Override
    public <E extends Throwable> void withQueryParameters(@NotNull ThrowableConsumer<RequestBuilder.QueryBuilder, E> queryInitializer) {
        Intrinsics.checkNotNullParameter(queryInitializer, (String)"queryInitializer");
        queryInitializer.consume((arg_0, arg_1) -> CurlRequestBuilder.withQueryParameters$lambda$0(this, arg_0, arg_1));
    }

    @Override
    public void withAuthData(@NotNull HttpClientAuthData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.authData = data;
    }

    @Override
    public void withHeader(@NotNull String name, @NotNull String value2, @NotNull Function<String, String> optionProvider) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter(optionProvider, (String)"optionProvider");
        this.headers.add(new RequestFieldParam(name, value2));
        if (StringsKt.equals((String)"Content-Type", (String)name, (boolean)true)) {
            char[] cArray = new char[]{';'};
            String string = (String)CollectionsKt.firstOrNull((List)StringsKt.split$default((CharSequence)value2, (char[])cArray, (boolean)false, (int)0, (int)6, null));
            this.contentType = string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
        }
    }

    @Override
    public void withFileToSend(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.graphQL) {
            String string;
            try {
                string = FilesKt.readText((File)file, (Charset)Charsets.UTF_8);
            }
            catch (Exception e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(CurlRequestBuilder.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn((Throwable)e);
                string = "";
            }
            String text2 = string;
            this.body = new CurlRequestMessageBody.SingleDataBody.ExactBody(GraphQLPresentationKt.toGraphQLJson(text2));
        } else {
            String string = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            this.body = new CurlRequestMessageBody.SingleDataBody.FileBody(string);
        }
    }

    @Override
    public void withTextToSend(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        String bodyText = this.graphQL ? GraphQLPresentationKt.toGraphQLJson(text2) : text2;
        this.body = new CurlRequestMessageBody.SingleDataBody.ExactBody(bodyText);
    }

    @Override
    public <E extends Throwable> void withMultipartBody(@Nullable String multipartBoundary, @NotNull ThrowableConsumer<? super RequestBuilder.MultipartBodyBuilder<CurlRequestFormBody>, E> multipartInitializer) {
        Intrinsics.checkNotNullParameter(multipartInitializer, (String)"multipartInitializer");
        CurlMultipartBodyBuilder partsBuilder = new CurlMultipartBodyBuilder();
        multipartInitializer.consume((Object)partsBuilder);
        this.body = new CurlRequestMessageBody.MultipartBody(partsBuilder.getParts());
    }

    @Override
    public void withConfig(@NotNull HttpRequestConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.allowRedirect = config.isFollowRedirects() || this.graphQL;
    }

    @Override
    public void withEmptyCredentials() {
        this.authData = new HttpClientAuthData(new HttpRequestAuthScope("Negotiate"), HttpRequestAuthCredentials.Empty.INSTANCE);
    }

    @Override
    @NotNull
    public String build() {
        StringBuilder stringBuilder;
        StringBuilder $this$build_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$build_u24lambda_u241.append("curl");
        this.method($this$build_u24lambda_u241);
        this.buildUrl($this$build_u24lambda_u241);
        this.protocol($this$build_u24lambda_u241);
        this.headers($this$build_u24lambda_u241);
        this.data($this$build_u24lambda_u241);
        this.authentication($this$build_u24lambda_u241);
        return stringBuilder.toString();
    }

    private final void method(StringBuilder $this$method) {
        String it = this.method;
        boolean bl = false;
        $this$method.append(" -X ");
        $this$method.append(this.graphQL ? "POST" : this.method);
    }

    private final void buildUrl(StringBuilder $this$buildUrl) {
        List<RequestFieldParam> list2;
        if (this.allowRedirect) {
            $this$buildUrl.append(" --location");
        }
        $this$buildUrl.append(" \"");
        $this$buildUrl.append(this.url);
        List<RequestFieldParam> it = list2 = this.queryParams;
        boolean bl = false;
        List<RequestFieldParam> list3 = !((Collection)it).isEmpty() ? list2 : null;
        if (list3 != null) {
            it = list3;
            boolean bl2 = false;
            $this$buildUrl.append("?");
            for (RequestFieldParam requestFieldParam : this.queryParams) {
                String name = requestFieldParam.component1();
                String value2 = requestFieldParam.component2();
                $this$buildUrl.append(URLEncoder.encode(name, Charsets.UTF_8));
                $this$buildUrl.append("=");
                $this$buildUrl.append(URLEncoder.encode(value2, Charsets.UTF_8));
                $this$buildUrl.append("&");
            }
            $this$buildUrl.deleteCharAt($this$buildUrl.length() - 1);
        }
        $this$buildUrl.append("\"");
    }

    private final void protocol(StringBuilder $this$protocol) {
        RequestBuilder.HttpProtocol httpProtocol = this.protocol;
        switch (httpProtocol == null ? -1 : WhenMappings.$EnumSwitchMapping$0[httpProtocol.ordinal()]) {
            case -1: {
                return;
            }
            case 1: {
                StringBuilder stringBuilder = $this$protocol.append(" --http1.1");
                break;
            }
            case 2: {
                StringBuilder stringBuilder = $this$protocol.append(" --http2");
                break;
            }
            case 3: {
                StringBuilder stringBuilder = $this$protocol.append("--http2-prior-knowledge");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void headers(StringBuilder $this$headers) {
        for (RequestFieldParam requestFieldParam : this.headers) {
            String name = requestFieldParam.component1();
            String value2 = requestFieldParam.component2();
            CurlRequestBuilderKt.access$lineSeparator($this$headers);
            $this$headers.append("-H \"");
            $this$headers.append(name);
            $this$headers.append(": ");
            $this$headers.append(value2);
            $this$headers.append("\"");
        }
    }

    private final void data(StringBuilder $this$data) {
        block0: {
            CurlRequestMessageBody curlRequestMessageBody = this.body;
            if (curlRequestMessageBody == null) break block0;
            CurlRequestMessageBody $this$data_u24lambda_u245 = curlRequestMessageBody;
            boolean bl = false;
            $this$data_u24lambda_u245.appendData($this$data, this.contentType);
        }
    }

    private final void authentication(StringBuilder $this$authentication) {
        String string;
        String string2;
        HttpClientAuthData httpClientAuthData = this.authData;
        if (httpClientAuthData == null) {
            return;
        }
        HttpClientAuthData authData = httpClientAuthData;
        CurlRequestBuilderKt.access$lineSeparator($this$authentication);
        String string3 = authData.getScope().getSchemeName();
        if (string3 != null) {
            String string4 = string3;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string5 = string4.toLowerCase(locale);
            string2 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
        } else {
            string2 = null;
        }
        String string6 = string2;
        String string7 = "Basic";
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string8 = string7.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toLowerCase(...)");
        if (Intrinsics.areEqual((Object)string6, (Object)string8)) {
            string = "--basic ";
        } else {
            string7 = "Digest";
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
            String string9 = string7.toLowerCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"toLowerCase(...)");
            if (Intrinsics.areEqual((Object)string6, (Object)string9)) {
                string = "--digest ";
            } else {
                string7 = "Negotiate";
                Locale locale3 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"getDefault(...)");
                String string10 = string7.toLowerCase(locale3);
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"toLowerCase(...)");
                string = Intrinsics.areEqual((Object)string6, (Object)string10) ? "--negotiate " : "";
            }
        }
        String option = string;
        $this$authentication.append(option);
        $this$authentication.append("--user ");
        String string11 = authData.getAuthCredentials().getName();
        if (string11 == null) {
            string11 = "";
        }
        $this$authentication.append(string11);
        $this$authentication.append(":");
        String string12 = authData.getAuthCredentials().getPassword();
        if (string12 == null) {
            string12 = "";
        }
        $this$authentication.append(string12);
    }

    @Override
    public void withSslConfiguration(@Nullable SslConfiguration sslConfiguration) {
    }

    @Override
    public void withUserDefinedOutputFilePath(@NotNull String filePath, boolean isForce) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
    }

    @JvmOverloads
    public CurlRequestBuilder() {
        this(false, 1, null);
    }

    private static final void withQueryParameters$lambda$0(CurlRequestBuilder this$0, String key, String value2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this$0.queryParams.add(new RequestFieldParam(key, value2));
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RequestBuilder.HttpProtocol.values().length];
            try {
                nArray[RequestBuilder.HttpProtocol.HTTP_11.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestBuilder.HttpProtocol.HTTP_2.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestBuilder.HttpProtocol.HTTP_2_PRIOR_KNOWLEDGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

