/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.editor;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.javascript.JSInjectionBracesUtil;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.injections.JSFormattableInjectionUtil;
import com.intellij.lang.javascript.injections.JSInjectionUtil;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.impl.JSLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.xml.XmlAttributeValueImpl;
import com.intellij.psi.impl.source.xml.XmlTextImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.NullableFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.codeInsight.VueUtilKt;
import org.jetbrains.vuejs.codeInsight.attributes.VueAttributeNameParser;
import org.jetbrains.vuejs.context.VueContextKt;
import org.jetbrains.vuejs.index.VueFrameworkHandlerKt;
import org.jetbrains.vuejs.index.VueIndexKt;
import org.jetbrains.vuejs.index.VueOptionsIndexKt;
import org.jetbrains.vuejs.lang.VueScriptLangs;
import org.jetbrains.vuejs.lang.expr.VueJSLanguage;
import org.jetbrains.vuejs.lang.html.VueLanguage;
import org.jetbrains.vuejs.libraries.componentDecorator.VueComponentDecoratorUtilsKt;
import org.jetbrains.vuejs.model.VueModelManager;
import org.jetbrains.vuejs.model.VueRegularComponent;
import org.jetbrains.vuejs.model.source.VueComponents;
import org.jetbrains.vuejs.model.source.VueSourceContainer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\u00160\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\tH\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/vuejs/editor/VueInjector;", "Lcom/intellij/lang/injection/MultiHostInjector;", "<init>", "()V", "getLanguagesToInject", "", "registrar", "Lcom/intellij/lang/injection/MultiHostRegistrar;", "context", "Lcom/intellij/psi/PsiElement;", "shouldInjectVueTemplate", "", "template", "Lcom/intellij/lang/javascript/psi/impl/JSLiteralExpressionImpl;", "initializer", "Lcom/intellij/lang/javascript/psi/JSObjectLiteralExpression;", "injectExpressionIn", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "attributeName", "", "elementsToInjectIn", "", "Ljava/lang/Class;", "inVPreContext", "element", "Holder", "intellij.vuejs"})
@SourceDebugExtension(value={"SMAP\nVueInjector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueInjector.kt\norg/jetbrains/vuejs/editor/VueInjector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,185:1\n1#2:186\n1251#3,2:187\n*S KotlinDebug\n*F\n+ 1 VueInjector.kt\norg/jetbrains/vuejs/editor/VueInjector\n*L\n181#1:187,2\n*E\n"})
public final class VueInjector
implements MultiHostInjector {
    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PsiElement parent = context.getParent();
        if (parent == null || !VueContextKt.isVueContext(context)) {
            return;
        }
        if (this.inVPreContext(context)) {
            return;
        }
        if (context instanceof XmlAttributeValueImpl) {
            String string = ((XmlAttributeValueImpl)context).getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            if (!StringsKt.isBlank((CharSequence)string) && parent instanceof XmlAttribute && ((XmlAttribute)parent).getParent() != null) {
                String string2 = ((XmlAttribute)parent).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                CharSequence charSequence = string2;
                XmlTag xmlTag = ((XmlAttribute)parent).getParent();
                Intrinsics.checkNotNullExpressionValue((Object)xmlTag, (String)"getParent(...)");
                if (VueAttributeNameParser.Companion.parse(charSequence, xmlTag).getInjectJS()) {
                    if (((XmlAttribute)parent).getLanguage() != VueLanguage.Companion.getINSTANCE()) {
                        JSEmbeddedContent embedded = (JSEmbeddedContent)PsiTreeUtil.getChildOfType((PsiElement)context, JSEmbeddedContent.class);
                        if (embedded != null) {
                            JSLiteralExpressionImpl literal = (JSLiteralExpressionImpl)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)embedded), JSLiteralExpressionImpl.class);
                            if (literal != null && literal.isValidHost()) {
                                PsiLanguageInjectionHost psiLanguageInjectionHost = (PsiLanguageInjectionHost)literal;
                                String string3 = ((XmlAttribute)parent).getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                                this.injectExpressionIn(psiLanguageInjectionHost, registrar, string3);
                            }
                        } else {
                            PsiLanguageInjectionHost psiLanguageInjectionHost = (PsiLanguageInjectionHost)context;
                            String string4 = ((XmlAttribute)parent).getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
                            this.injectExpressionIn(psiLanguageInjectionHost, registrar, string4);
                        }
                    }
                    return;
                }
            }
        }
        if (context instanceof XmlTextImpl || context instanceof XmlAttributeValueImpl) {
            com.intellij.openapi.util.Pair pair = (com.intellij.openapi.util.Pair)Holder.INSTANCE.getBRACES_FACTORY().fun((Object)context);
            if (pair == null) {
                return;
            }
            com.intellij.openapi.util.Pair braces = pair;
            JSLanguageDialect exprLanguage2 = VueScriptLangs.INSTANCE.getLatestKnownLang(context).getExprLang();
            JSInjectionBracesUtil.injectInXmlTextByDelimiters((MultiHostRegistrar)registrar, (PsiElement)context, (Language)((Language)exprLanguage2), (String)((String)braces.getFirst()), (String)((String)braces.getSecond()), (String)"int");
        } else if (context instanceof JSLiteralExpressionImpl && ((JSLiteralExpressionImpl)context).isQuotedLiteral() && ((JSLiteralExpressionImpl)context).isValidHost() && parent instanceof JSProperty && Intrinsics.areEqual((Object)((JSProperty)parent).getName(), (Object)"template") && ((JSProperty)parent).getParent() instanceof JSObjectLiteralExpression) {
            JSLiteralExpressionImpl jSLiteralExpressionImpl = (JSLiteralExpressionImpl)context;
            PsiElement psiElement = ((JSProperty)parent).getParent();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.psi.JSObjectLiteralExpression");
            if (this.shouldInjectVueTemplate(jSLiteralExpressionImpl, (JSObjectLiteralExpression)psiElement)) {
                com.intellij.openapi.util.Pair pair;
                VueRegularComponent vueRegularComponent;
                PsiElement psiElement2 = ((JSProperty)parent).getParent();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getParent(...)");
                Pair<String, String> pair2 = VueModelManager.Companion.getComponent(psiElement2);
                VueRegularComponent vueRegularComponent2 = vueRegularComponent = pair2 instanceof VueRegularComponent ? (VueRegularComponent)pair2 : null;
                if (vueRegularComponent != null && (pair2 = vueRegularComponent.getDelimiters()) != null) {
                    Pair<String, String> it = pair2;
                    boolean bl = false;
                    pair = new com.intellij.openapi.util.Pair(it.getFirst(), it.getSecond());
                } else {
                    pair = (com.intellij.openapi.util.Pair)Holder.INSTANCE.getBRACES_FACTORY().fun((Object)context);
                    if (pair == null) {
                        pair = new com.intellij.openapi.util.Pair((Object)"{{", (Object)"}}");
                    }
                }
                com.intellij.openapi.util.Pair braces = pair;
                JSInjectionUtil.injectInQuotedLiteral((MultiHostRegistrar)registrar, (Language)((Language)VueLanguage.Companion.getINSTANCE()), (String)(braces.first + "." + braces.second + ".#@injected@#.html"), (JSLiteralExpression)((JSLiteralExpression)context), null, null);
                JSFormattableInjectionUtil.setReformattableInjection((PsiElement)context, (Language)((Language)VueLanguage.Companion.getINSTANCE()));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldInjectVueTemplate(JSLiteralExpressionImpl template, JSObjectLiteralExpression initializer) {
        CharSequence charSequence = template.getNode().getChars();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getChars(...)");
        CharSequence chars = charSequence;
        if (chars.length() > 2 && chars.charAt(1) == '#') {
            return false;
        }
        if (VueFrameworkHandlerKt.hasComponentIndicatorProperties(initializer, "template")) return true;
        Class[] classArray = new Class[]{ES6Decorator.class};
        ES6Decorator eS6Decorator = (ES6Decorator)PsiTreeUtil.getContextOfType((PsiElement)((PsiElement)initializer), (Class[])classArray);
        if (eS6Decorator == null) return false;
        ES6Decorator it = eS6Decorator;
        boolean bl = false;
        if (!VueComponentDecoratorUtilsKt.isComponentDecorator(it)) return false;
        return true;
    }

    private final void injectExpressionIn(PsiLanguageInjectionHost context, MultiHostRegistrar registrar, String attributeName) {
        JSLanguageDialect exprLanguage2 = VueScriptLangs.INSTANCE.getLatestKnownLang((PsiElement)context).getExprLang();
        String extension = StringsKt.replace$default((String)attributeName, (char)'.', (char)' ', (boolean)false, (int)4, null) + ".expr";
        registrar.startInjecting((Language)exprLanguage2, extension).addPlace(null, null, context, ElementManipulators.getValueTextRange((PsiElement)((PsiElement)context))).doneInjecting();
    }

    @NotNull
    public List<Class<? extends PsiElement>> elementsToInjectIn() {
        Object[] objectArray = new Class[]{XmlTextImpl.class, XmlAttributeValueImpl.class, JSLiteralExpressionImpl.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final boolean inVPreContext(PsiElement element) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = PsiTreeUtilKt.parents((PsiElement)element, (boolean)true);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl2 = false;
                XmlTag xmlTag = it instanceof XmlTag ? (XmlTag)it : null;
                if (!((xmlTag != null ? xmlTag.getAttribute("v-pre") : null) != null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J&\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/vuejs/editor/VueInjector$Holder;", "", "<init>", "()V", "delimitersOptionHolders", "", "", "BRACES_FACTORY", "Lcom/intellij/util/NullableFunction;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/openapi/util/Pair;", "getBRACES_FACTORY", "()Lcom/intellij/util/NullableFunction;", "calculateDelimitersFromIndex", "project", "Lcom/intellij/openapi/project/Project;", "key", "calculateDelimitersFromAssignment", "getDelimiterValue", "holder", "intellij.vuejs"})
    @SourceDebugExtension(value={"SMAP\nVueInjector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueInjector.kt\norg/jetbrains/vuejs/editor/VueInjector$Holder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,185:1\n1#2:186\n3829#3:187\n4344#3,2:188\n1557#4:190\n1628#4,3:191\n*S KotlinDebug\n*F\n+ 1 VueInjector.kt\norg/jetbrains/vuejs/editor/VueInjector$Holder\n*L\n78#1:187\n78#1:188,2\n82#1:190\n82#1:191,3\n*E\n"})
    public static final class Holder {
        @NotNull
        public static final Holder INSTANCE = new Holder();
        @NotNull
        private static final Set<String> delimitersOptionHolders;
        @NotNull
        private static final NullableFunction<PsiElement, com.intellij.openapi.util.Pair<String, String>> BRACES_FACTORY;

        private Holder() {
        }

        @NotNull
        public final NullableFunction<PsiElement, com.intellij.openapi.util.Pair<String, String>> getBRACES_FACTORY() {
            return BRACES_FACTORY;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final com.intellij.openapi.util.Pair<String, PsiElement> calculateDelimitersFromIndex(Project project, String key) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
            Collection<JSImplicitElement> collection = VueIndexKt.resolve("", globalSearchScope, VueOptionsIndexKt.getVUE_OPTIONS_INDEX_KEY());
            if (collection.isEmpty()) {
                return null;
            }
            Collection<JSImplicitElement> elements = collection;
            JSImplicitElement jSImplicitElement = (JSImplicitElement)CollectionsKt.firstOrNull(VueComponents.Companion.onlyLocal(elements));
            if (jSImplicitElement == null) {
                return null;
            }
            JSImplicitElement element = jSImplicitElement;
            JSObjectLiteralExpression jSObjectLiteralExpression = element instanceof JSObjectLiteralExpression ? (JSObjectLiteralExpression)element : null;
            if (jSObjectLiteralExpression == null && (jSObjectLiteralExpression = (JSObjectLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)element), JSObjectLiteralExpression.class)) == null) {
                return null;
            }
            JSObjectLiteralExpression obj = jSObjectLiteralExpression;
            JSProperty jSProperty = obj.findProperty("delimiters");
            if (jSProperty == null) return null;
            JSProperty jSProperty2 = jSProperty;
            boolean bl = false;
            String string = INSTANCE.getDelimiterValue((PsiElement)jSProperty2, key);
            if (string == null) return null;
            String string2 = string;
            boolean bl2 = false;
            com.intellij.openapi.util.Pair pair = com.intellij.openapi.util.Pair.create((Object)string2, (Object)element);
            return pair;
        }

        /*
         * WARNING - void declaration
         */
        private final com.intellij.openapi.util.Pair<String, PsiElement> calculateDelimitersFromAssignment(Project project, String key) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            NavigationItem[] delimitersDefinitions;
            NavigationItem[] navigationItemArray = JavaScriptIndex.getInstance((Project)project).getSymbolsByName("delimiters", false);
            Intrinsics.checkNotNullExpressionValue((Object)navigationItemArray, (String)"getSymbolsByName(...)");
            Object $this$filter$iv = delimitersDefinitions = navigationItemArray;
            boolean $i$f$filter = false;
            NavigationItem[] navigationItemArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (NavigationItem element$iv$iv : $this$filterTo$iv$iv) {
                void it = element$iv$iv;
                boolean bl = false;
                if (!(it instanceof JSDefinitionExpression && ((PsiElement)it).getContext() != null && CollectionsKt.contains((Iterable)delimitersOptionHolders, (Object)((JSDefinitionExpression)it).getQualifiedName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                NavigationItem element$iv$iv;
                element$iv$iv = (NavigationItem)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.psi.PsiElement");
                PsiElement psiElement = ((PsiElement)it).getContext();
                Intrinsics.checkNotNull((Object)psiElement);
                String delimiter = INSTANCE.getDelimiterValue(psiElement, key);
                collection.add(delimiter != null ? com.intellij.openapi.util.Pair.create((Object)delimiter, (Object)((PsiElement)it)) : null);
            }
            return (com.intellij.openapi.util.Pair)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        }

        private final String getDelimiterValue(PsiElement holder, String key) {
            List<JSLiteralExpression> list = VueUtilKt.getStringLiteralsFromInitializerArray(holder);
            if (list.size() != 2) {
                return null;
            }
            JSLiteralExpression jSLiteralExpression = list.get(Intrinsics.areEqual((Object)"startSymbol", (Object)key) ? 0 : 1);
            JSLiteralExpression jSLiteralExpression2 = jSLiteralExpression instanceof JSLiteralExpression ? jSLiteralExpression : null;
            if (jSLiteralExpression2 == null) {
                return null;
            }
            JSLiteralExpression literal = jSLiteralExpression2;
            String string = literal.getSignificantValue();
            Intrinsics.checkNotNull((Object)string);
            return JSStringUtil.unquoteWithoutUnescapingStringLiteralValue((String)string);
        }

        private static final com.intellij.openapi.util.Pair BRACES_FACTORY$lambda$1(PsiElement element) {
            com.intellij.openapi.util.Pair pair;
            VueSourceContainer vueSourceContainer;
            Intrinsics.checkNotNull((Object)element);
            Pair<String, String> pair2 = VueModelManager.Companion.findEnclosingContainer(element);
            VueSourceContainer vueSourceContainer2 = vueSourceContainer = pair2 instanceof VueSourceContainer ? (VueSourceContainer)pair2 : null;
            if (vueSourceContainer != null && (pair2 = vueSourceContainer.getDelimiters()) != null) {
                Pair<String, String> it = pair2;
                boolean bl = false;
                pair = new com.intellij.openapi.util.Pair(it.getFirst(), it.getSecond());
            } else {
                pair = null;
            }
            return pair;
        }

        private static final com.intellij.openapi.util.Pair BRACES_FACTORY$lambda$2(Function1 $tmp0, Object p0) {
            return (com.intellij.openapi.util.Pair)$tmp0.invoke(p0);
        }

        private static final com.intellij.openapi.util.Pair BRACES_FACTORY$lambda$3(Project project, String key) {
            if (project == null || key == null) {
                return null;
            }
            com.intellij.openapi.util.Pair<String, PsiElement> pair = INSTANCE.calculateDelimitersFromIndex(project, key);
            if (pair == null) {
                pair = INSTANCE.calculateDelimitersFromAssignment(project, key);
            }
            return pair;
        }

        private static final com.intellij.openapi.util.Pair BRACES_FACTORY$lambda$4(Function2 $tmp0, Object p0, Object p1) {
            return (com.intellij.openapi.util.Pair)$tmp0.invoke(p0, p1);
        }

        static {
            String[] stringArray = new String[]{"Vue.config.delimiters", "Vue.options.delimiters"};
            delimitersOptionHolders = SetsKt.setOf((Object[])stringArray);
            stringArray = JSInjectionBracesUtil.delimitersFactory((String)VueJSLanguage.Companion.getINSTANCE().getID(), arg_0 -> Holder.BRACES_FACTORY$lambda$2(Holder::BRACES_FACTORY$lambda$1, arg_0), (arg_0, arg_1) -> Holder.BRACES_FACTORY$lambda$4(Holder::BRACES_FACTORY$lambda$3, arg_0, arg_1));
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"delimitersFactory(...)");
            BRACES_FACTORY = stringArray;
        }
    }
}

