/*
 * Decompiled with CFR 0.152.
 */
package git4idea.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.update.FilePathChange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.changes.GitCommittedChangeList;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitHandler;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.util.StringScanner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitChangeUtils {
    @NonNls
    public static final String COMMITTED_CHANGELIST_FORMAT = "%ct%n%H%n%P%n%an%x20%x3C%ae%x3E%n%cn%x20%x3C%ce%x3E%n%s%n%x03%n%b%n%x03";
    private static final Logger LOG = Logger.getInstance(GitChangeUtils.class);

    private GitChangeUtils() {
    }

    private static void parseChanges(Project project, VirtualFile vcsRoot, @Nullable GitRevisionNumber thisRevision, GitRevisionNumber parentRevision, String s, Collection<? super Change> changes) throws VcsException {
        GitChangeUtils.parseChanges(project, vcsRoot, thisRevision, parentRevision, new StringScanner(s), changes);
    }

    private static void parseChanges(Project project, VirtualFile vcsRoot, @Nullable GitRevisionNumber thisRevision, @Nullable GitRevisionNumber parentRevision, StringScanner s, Collection<? super Change> changes) throws VcsException {
        FileStatusLineParser<Change> parser = GitChangeUtils.getChangesParser(project, thisRevision, parentRevision);
        GitChangeUtils.parseChanges(vcsRoot, s, (status, beforePath, afterPath) -> changes.add((Change)parser.parse(status, beforePath, afterPath)));
    }

    @NotNull
    private static FileStatusLineParser<Change> getChangesParser(@NotNull Project project, @Nullable GitRevisionNumber thisRevision, @Nullable GitRevisionNumber parentRevision) {
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(0);
        }
        FileStatusLineParser<Change> fileStatusLineParser = (status, beforePath, afterPath) -> {
            assert (beforePath != null || afterPath != null);
            ContentRevision before = beforePath != null ? GitContentRevision.createRevision(beforePath, (VcsRevisionNumber)parentRevision, project) : null;
            ContentRevision after = afterPath != null ? GitContentRevision.createRevision(afterPath, (VcsRevisionNumber)thisRevision, project) : null;
            return new Change(before, after, status);
        };
        if (fileStatusLineParser == null) {
            GitChangeUtils.$$$reportNull$$$0(1);
        }
        return fileStatusLineParser;
    }

    private static void parseChanges(@NotNull VirtualFile vcsRoot, @NotNull StringScanner s, @NotNull FileStatusLineConsumer consumer) throws VcsException {
        if (vcsRoot == null) {
            GitChangeUtils.$$$reportNull$$$0(2);
        }
        if (s == null) {
            GitChangeUtils.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            GitChangeUtils.$$$reportNull$$$0(4);
        }
        while (s.hasMoreData()) {
            FilePath after;
            FilePath before;
            FileStatus status = null;
            if (s.isEol()) {
                s.nextLine();
                continue;
            }
            if ("CADUMRT".indexOf(s.peek()) == -1) {
                return;
            }
            String[] tokens = s.line().split("\t");
            String path = tokens[tokens.length - 1];
            FilePath filePath = GitContentRevision.createPathFromEscaped(vcsRoot, path);
            switch (tokens[0].charAt(0)) {
                case 'A': 
                case 'C': {
                    status = FileStatus.ADDED;
                    before = null;
                    after = filePath;
                    break;
                }
                case 'U': {
                    status = FileStatus.MERGED_WITH_CONFLICTS;
                }
                case 'M': {
                    if (status == null) {
                        status = FileStatus.MODIFIED;
                    }
                    before = filePath;
                    after = filePath;
                    break;
                }
                case 'D': {
                    status = FileStatus.DELETED;
                    before = filePath;
                    after = null;
                    break;
                }
                case 'R': {
                    status = FileStatus.MODIFIED;
                    before = GitContentRevision.createPathFromEscaped(vcsRoot, tokens[1]);
                    after = filePath;
                    break;
                }
                case 'T': {
                    status = FileStatus.MODIFIED;
                    before = filePath;
                    after = filePath;
                    break;
                }
                default: {
                    throw new VcsException(GitBundle.message("error.git.parse.unknown.file.status", Arrays.asList(tokens)));
                }
            }
            consumer.consume(status, before, after);
        }
    }

    @NotNull
    public static GitRevisionNumber resolveReference(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull @NonNls String reference) throws VcsException {
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(5);
        }
        if (vcsRoot == null) {
            GitChangeUtils.$$$reportNull$$$0(6);
        }
        if (reference == null) {
            GitChangeUtils.$$$reportNull$$$0(7);
        }
        GitLineHandler handler = GitChangeUtils.createRefResolveHandler(project, vcsRoot, reference);
        String output2 = Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]);
        StringTokenizer stk = new StringTokenizer(output2, "\n\r \t", false);
        if (!stk.hasMoreTokens()) {
            try {
                GitLineHandler dh = new GitLineHandler(project, vcsRoot, GitCommand.LOG);
                dh.addParameters("-1", "HEAD");
                dh.setSilent(true);
                String out = Git.getInstance().runCommand(dh).getOutputOrThrow(new int[0]);
                LOG.info("Diagnostic output from 'git log -1 HEAD': [" + out + "]");
                dh = GitChangeUtils.createRefResolveHandler(project, vcsRoot, reference);
                out = Git.getInstance().runCommand(dh).getOutputOrThrow(new int[0]);
                LOG.info("Diagnostic output from 'git rev-list -1 --timestamp HEAD': [" + out + "]");
            }
            catch (VcsException e) {
                LOG.info("Exception while trying to get some diagnostics info", (Throwable)e);
            }
            throw new VcsException(GitBundle.message("error.git.parse.not.a.revision.number", reference));
        }
        Date timestamp = GitUtil.parseTimestampWithNFEReport(stk.nextToken(), handler, output2);
        return new GitRevisionNumber(stk.nextToken(), timestamp);
    }

    @NotNull
    private static GitLineHandler createRefResolveHandler(@NotNull Project project, @NotNull VirtualFile root, @NotNull @NonNls String reference) {
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(8);
        }
        if (root == null) {
            GitChangeUtils.$$$reportNull$$$0(9);
        }
        if (reference == null) {
            GitChangeUtils.$$$reportNull$$$0(10);
        }
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.REV_LIST);
        handler.addParameters("--timestamp", "--max-count=1", reference);
        handler.endOptions();
        handler.setSilent(true);
        GitLineHandler gitLineHandler = handler;
        if (gitLineHandler == null) {
            GitChangeUtils.$$$reportNull$$$0(11);
        }
        return gitLineHandler;
    }

    public static GitCommittedChangeList getRevisionChanges(Project project, @NotNull VirtualFile root, @NonNls String revisionName, boolean skipDiffsForMerge, boolean local, boolean revertable) throws VcsException {
        if (root == null) {
            GitChangeUtils.$$$reportNull$$$0(12);
        }
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.SHOW);
        h.setSilent(true);
        h.addParameters("--name-status", "--first-parent", "--no-abbrev", "-M", "--pretty=format:%ct%n%H%n%P%n%an%x20%x3C%ae%x3E%n%cn%x20%x3C%ce%x3E%n%s%n%x03%n%b%n%x03", "--encoding=UTF-8", revisionName, "--");
        String output2 = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        StringScanner s = new StringScanner(output2);
        return GitChangeUtils.parseChangeList(project, root, s, skipDiffsForMerge, h, local, revertable);
    }

    public static GitCommittedChangeList parseChangeList(Project project, VirtualFile root, StringScanner s, boolean skipDiffsForMerge, GitHandler handler, boolean local, boolean revertable) throws VcsException {
        ArrayList<Change> changes = new ArrayList<Change>();
        Date commitDate = GitUtil.parseTimestampWithNFEReport(s.line(), handler, s.getAllText());
        String revisionNumber = s.line();
        String parentsLine = s.line();
        String[] parents = parentsLine.isEmpty() ? ArrayUtilRt.EMPTY_STRING_ARRAY : parentsLine.split(" ");
        String authorName = s.line();
        String committerName = s.line();
        committerName = GitUtil.adjustAuthorName(authorName, committerName);
        String commentSubject = s.boundedToken('\u0003', true);
        s.nextLine();
        String commentBody = s.boundedToken('\u0003', true);
        Object fullComment = commentSubject.isEmpty() ? commentBody : (commentBody.isEmpty() ? commentSubject : commentSubject + "\n" + commentBody);
        GitRevisionNumber thisRevision = new GitRevisionNumber(revisionNumber, commitDate);
        if (skipDiffsForMerge || parents.length <= 1) {
            String[] parentRevision = parents.length > 0 ? GitChangeUtils.resolveReference(project, root, parents[0]) : null;
            GitChangeUtils.parseChanges(project, root, thisRevision, (GitRevisionNumber)(local ? null : parentRevision), s, changes);
        } else {
            for (String parent : parents) {
                GitRevisionNumber parentRevision = GitChangeUtils.resolveReference(project, root, parent);
                GitLineHandler diffHandler = new GitLineHandler(project, root, GitCommand.DIFF);
                diffHandler.setSilent(true);
                diffHandler.addParameters("--name-status", "-M", parentRevision.getRev(), thisRevision.getRev());
                String diff = Git.getInstance().runCommand(diffHandler).getOutputOrThrow(new int[0]);
                GitChangeUtils.parseChanges(project, root, thisRevision, parentRevision, diff, changes);
                if (!changes.isEmpty()) break;
            }
        }
        String changeListName = String.format("%s(%s)", commentSubject, revisionNumber);
        return new GitCommittedChangeList(changeListName, (String)fullComment, committerName, thisRevision, commitDate, changes, GitVcs.getInstance(project), revertable);
    }

    @NotNull
    public static Collection<Change> getDiff(@NotNull Project project, @NotNull VirtualFile root, @Nullable @NonNls String oldRevision, @Nullable @NonNls String newRevision, @Nullable Collection<? extends FilePath> dirtyPaths) throws VcsException {
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(13);
        }
        if (root == null) {
            GitChangeUtils.$$$reportNull$$$0(14);
        }
        return GitChangeUtils.getDiff(project, root, oldRevision, newRevision, dirtyPaths, true, false);
    }

    @NotNull
    public static Collection<Change> getLocalChangesDiff(@NotNull Project project, @NotNull VirtualFile root, @Nullable Collection<? extends FilePath> dirtyPaths) throws VcsException {
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(15);
        }
        if (root == null) {
            GitChangeUtils.$$$reportNull$$$0(16);
        }
        GitRevisionNumber head = GitChangeUtils.resolveReference(project, root, "HEAD");
        return GitChangeUtils.getLocalChanges(project, root, dirtyPaths, GitChangeUtils.getChangesParser(project, null, head), "-M", "HEAD");
    }

    @NotNull
    private static Collection<Change> getDiff(@NotNull Project project, @NotNull VirtualFile root, @Nullable @NonNls String oldRevision, @Nullable @NonNls String newRevision, @Nullable Collection<? extends FilePath> dirtyPaths, boolean detectRenames, boolean threeDots) throws VcsException {
        GitRevisionNumber newRev;
        GitRevisionNumber oldRev;
        String range;
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(17);
        }
        if (root == null) {
            GitChangeUtils.$$$reportNull$$$0(18);
        }
        LOG.assertTrue(oldRevision != null || newRevision != null, (Object)"Both old and new revisions can't be null");
        String dots = threeDots ? "..." : "..";
        if (newRevision == null) {
            range = oldRevision + dots;
            oldRev = GitChangeUtils.resolveReference(project, root, oldRevision);
            newRev = null;
        } else if (oldRevision == null) {
            range = dots + newRevision;
            oldRev = null;
            newRev = GitChangeUtils.resolveReference(project, root, newRevision);
        } else {
            range = oldRevision + dots + newRevision;
            oldRev = GitChangeUtils.resolveReference(project, root, oldRevision);
            newRev = GitChangeUtils.resolveReference(project, root, newRevision);
        }
        String output2 = GitChangeUtils.getDiffOutput(project, root, range, dirtyPaths, false, detectRenames);
        ArrayList<Change> changes = new ArrayList<Change>();
        GitChangeUtils.parseChanges(project, root, newRev, oldRev, output2, changes);
        ArrayList<Change> arrayList = changes;
        if (arrayList == null) {
            GitChangeUtils.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<GitDiffChange> getStagedChanges(@NotNull Project project, @NotNull VirtualFile root) throws VcsException {
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(20);
        }
        if (root == null) {
            GitChangeUtils.$$$reportNull$$$0(21);
        }
        return GitChangeUtils.getLocalChanges(project, root, null, "--cached", "-M");
    }

    @NotNull
    public static Collection<GitDiffChange> getUnstagedChanges(@NotNull Project project, @NotNull VirtualFile root, @Nullable Collection<FilePath> paths, boolean detectMoves) throws VcsException {
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(22);
        }
        if (root == null) {
            GitChangeUtils.$$$reportNull$$$0(23);
        }
        if (detectMoves) {
            return GitChangeUtils.getLocalChanges(project, root, paths, "-M");
        }
        return GitChangeUtils.getLocalChanges(project, root, paths, "--no-renames");
    }

    @NotNull
    public static Collection<GitDiffChange> getWorkingTreeChanges(@NotNull Project project, @NotNull VirtualFile root, @Nullable Collection<FilePath> paths, boolean detectMoves) throws VcsException {
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(24);
        }
        if (root == null) {
            GitChangeUtils.$$$reportNull$$$0(25);
        }
        if (detectMoves) {
            return GitChangeUtils.getLocalChanges(project, root, paths, "-M", "HEAD");
        }
        return GitChangeUtils.getLocalChanges(project, root, paths, "--no-renames", "HEAD");
    }

    @NotNull
    private static Collection<GitDiffChange> getLocalChanges(@NotNull Project project, @NotNull VirtualFile root, @Nullable Collection<? extends FilePath> paths, String ... parameters) throws VcsException {
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(26);
        }
        if (root == null) {
            GitChangeUtils.$$$reportNull$$$0(27);
        }
        return GitChangeUtils.getLocalChanges(project, root, paths, GitDiffChange::new, parameters);
    }

    @NotNull
    private static <T> Collection<T> getLocalChanges(@NotNull Project project, @NotNull VirtualFile root, @Nullable Collection<? extends FilePath> paths, @NotNull FileStatusLineParser<T> parser, String ... parameters) throws VcsException {
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(28);
        }
        if (root == null) {
            GitChangeUtils.$$$reportNull$$$0(29);
        }
        if (parser == null) {
            GitChangeUtils.$$$reportNull$$$0(30);
        }
        if (paths != null && paths.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                GitChangeUtils.$$$reportNull$$$0(31);
            }
            return list;
        }
        GitLineHandler handler = (GitLineHandler)GitUtil.createHandlerWithPaths(paths, () -> {
            GitLineHandler diff = new GitLineHandler(project, root, GitCommand.DIFF);
            diff.addParameters("--name-status");
            diff.addParameters(parameters);
            return diff;
        });
        String output2 = Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]);
        ArrayList changes = new ArrayList();
        GitChangeUtils.parseChanges(root, new StringScanner(output2), (status, beforePath, afterPath) -> changes.add(parser.parse(status, beforePath, afterPath)));
        ArrayList arrayList = changes;
        if (arrayList == null) {
            GitChangeUtils.$$$reportNull$$$0(32);
        }
        return arrayList;
    }

    @NotNull
    public static List<FilePath> getUnmergedFiles(@NotNull GitRepository repository) throws VcsException {
        if (repository == null) {
            GitChangeUtils.$$$reportNull$$$0(33);
        }
        GitCommandResult result2 = Git.getInstance().getUnmergedFiles(repository);
        VirtualFile root = repository.getRoot();
        String output2 = result2.getOutputOrThrow(new int[0]);
        HashSet<FilePath> unmergedPaths = new HashSet<FilePath>();
        StringScanner s = new StringScanner(output2);
        while (s.hasMoreData()) {
            if (s.isEol()) {
                s.nextLine();
                continue;
            }
            s.boundedToken('\t');
            String relative = s.line();
            String path = GitUtil.unescapePath(relative);
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)root, (String)path, (boolean)false);
            unmergedPaths.add(filePath);
        }
        return new ArrayList<FilePath>(unmergedPaths);
    }

    @NotNull
    public static Collection<Change> getDiffWithWorkingDir(@NotNull Project project, @NotNull VirtualFile root, @NotNull @NonNls String oldRevision, @Nullable Collection<? extends FilePath> dirtyPaths, boolean reverse) throws VcsException {
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(34);
        }
        if (root == null) {
            GitChangeUtils.$$$reportNull$$$0(35);
        }
        if (oldRevision == null) {
            GitChangeUtils.$$$reportNull$$$0(36);
        }
        return GitChangeUtils.getDiffWithWorkingDir(project, root, oldRevision, dirtyPaths, reverse, true);
    }

    @NotNull
    public static Collection<Change> getDiffWithWorkingDir(@NotNull Project project, @NotNull VirtualFile root, @NotNull @NonNls String oldRevision, @Nullable Collection<? extends FilePath> dirtyPaths, boolean reverse, boolean detectRenames) throws VcsException {
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(37);
        }
        if (root == null) {
            GitChangeUtils.$$$reportNull$$$0(38);
        }
        if (oldRevision == null) {
            GitChangeUtils.$$$reportNull$$$0(39);
        }
        String output2 = GitChangeUtils.getDiffOutput(project, root, oldRevision, dirtyPaths, reverse, detectRenames);
        ArrayList<Change> changes = new ArrayList<Change>();
        GitRevisionNumber revisionNumber = GitChangeUtils.resolveReference(project, root, oldRevision);
        GitChangeUtils.parseChanges(project, root, reverse ? revisionNumber : null, reverse ? null : revisionNumber, output2, changes);
        ArrayList<Change> arrayList = changes;
        if (arrayList == null) {
            GitChangeUtils.$$$reportNull$$$0(40);
        }
        return arrayList;
    }

    @NotNull
    private static String getDiffOutput(@NotNull Project project, @NotNull VirtualFile root, @NotNull String diffRange, @Nullable Collection<? extends FilePath> dirtyPaths, boolean reverse, boolean detectRenames) throws VcsException {
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(41);
        }
        if (root == null) {
            GitChangeUtils.$$$reportNull$$$0(42);
        }
        if (diffRange == null) {
            GitChangeUtils.$$$reportNull$$$0(43);
        }
        GitLineHandler h = (GitLineHandler)GitUtil.createHandlerWithPaths(dirtyPaths, () -> {
            GitLineHandler handler = new GitLineHandler(project, root, GitCommand.DIFF);
            if (reverse) {
                handler.addParameters("-R");
            }
            handler.addParameters("--name-status", "--diff-filter=ADCMRUXT");
            if (detectRenames) {
                handler.addParameters("-M");
            }
            handler.addParameters(diffRange);
            handler.setSilent(true);
            handler.setStdoutSuppressed(true);
            return handler;
        });
        String string = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        if (string == null) {
            GitChangeUtils.$$$reportNull$$$0(44);
        }
        return string;
    }

    @Nullable
    public static Collection<Change> getDiffWithWorkingTree(@NotNull GitRepository repository, @NotNull @NonNls String refToCompare, boolean detectRenames) {
        Collection<Change> changes;
        if (repository == null) {
            GitChangeUtils.$$$reportNull$$$0(45);
        }
        if (refToCompare == null) {
            GitChangeUtils.$$$reportNull$$$0(46);
        }
        try {
            changes = GitChangeUtils.getDiffWithWorkingDir(repository.getProject(), repository.getRoot(), refToCompare, null, false, detectRenames);
        }
        catch (VcsException e) {
            LOG.warn("Couldn't collect diff", (Throwable)e);
            changes = null;
        }
        return changes;
    }

    @Nullable
    public static Collection<Change> getDiff(@NotNull GitRepository repository, @NotNull @NonNls String oldRevision, @NotNull @NonNls String newRevision, boolean detectRenames) {
        if (repository == null) {
            GitChangeUtils.$$$reportNull$$$0(47);
        }
        if (oldRevision == null) {
            GitChangeUtils.$$$reportNull$$$0(48);
        }
        if (newRevision == null) {
            GitChangeUtils.$$$reportNull$$$0(49);
        }
        try {
            return GitChangeUtils.getDiff(repository.getProject(), repository.getRoot(), oldRevision, newRevision, null, detectRenames, false);
        }
        catch (VcsException e) {
            LOG.info("Couldn't collect changes between " + oldRevision + " and " + newRevision, (Throwable)e);
            return null;
        }
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static Collection<Change> getThreeDotDiff(@NotNull GitRepository repository, @NotNull @NonNls String oldRevision, @NotNull @NonNls String newRevision) {
        if (repository == null) {
            GitChangeUtils.$$$reportNull$$$0(50);
        }
        if (oldRevision == null) {
            GitChangeUtils.$$$reportNull$$$0(51);
        }
        if (newRevision == null) {
            GitChangeUtils.$$$reportNull$$$0(52);
        }
        try {
            return GitChangeUtils.getDiff(repository.getProject(), repository.getRoot(), oldRevision, newRevision, null, true, true);
        }
        catch (VcsException e) {
            LOG.info("Couldn't collect changes between " + oldRevision + " and " + newRevision, (Throwable)e);
            if (null == null) {
                GitChangeUtils.$$$reportNull$$$0(53);
            }
            return null;
        }
    }

    @NotNull
    public static Collection<Change> getThreeDotDiffOrThrow(@NotNull GitRepository repository, @NotNull @NonNls String oldRevision, @NotNull @NonNls String newRevision) throws VcsException {
        if (repository == null) {
            GitChangeUtils.$$$reportNull$$$0(54);
        }
        if (oldRevision == null) {
            GitChangeUtils.$$$reportNull$$$0(55);
        }
        if (newRevision == null) {
            GitChangeUtils.$$$reportNull$$$0(56);
        }
        return GitChangeUtils.getDiff(repository.getProject(), repository.getRoot(), oldRevision, newRevision, null, true, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 11, 19, 31, 32, 40, 44, 53 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 11: 
            case 19: 
            case 31: 
            case 32: 
            case 40: 
            case 44: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/changes/GitChangeUtils";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 35: 
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 33: 
            case 45: 
            case 47: 
            case 50: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 36: 
            case 39: 
            case 48: 
            case 51: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRevision";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffRange";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refToCompare";
                break;
            }
            case 49: 
            case 52: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/changes/GitChangeUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesParser";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createRefResolveHandler";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiff";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalChanges";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffWithWorkingDir";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffOutput";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreeDotDiff";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getChangesParser";
                break;
            }
            case 1: 
            case 11: 
            case 19: 
            case 31: 
            case 32: 
            case 40: 
            case 44: 
            case 53: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseChanges";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveReference";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createRefResolveHandler";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getRevisionChanges";
                break;
            }
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getDiff";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLocalChangesDiff";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getStagedChanges";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getUnstagedChanges";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingTreeChanges";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getLocalChanges";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getUnmergedFiles";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getDiffWithWorkingDir";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getDiffOutput";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getDiffWithWorkingTree";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getThreeDotDiff";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getThreeDotDiffOrThrow";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 11, 19, 31, 32, 40, 44, 53 -> new IllegalStateException(string);
        };
    }

    private static interface FileStatusLineParser<T> {
        public T parse(@NotNull FileStatus var1, @Nullable FilePath var2, @Nullable FilePath var3);
    }

    private static interface FileStatusLineConsumer {
        public void consume(@NotNull FileStatus var1, @Nullable FilePath var2, @Nullable FilePath var3);
    }

    public static class GitDiffChange
    implements FilePathChange {
        @NotNull
        private final FileStatus status;
        @Nullable
        private final FilePath beforePath;
        @Nullable
        private final FilePath afterPath;

        public GitDiffChange(@NotNull FileStatus status, @Nullable FilePath beforePath, @Nullable FilePath afterPath) {
            if (status == null) {
                GitDiffChange.$$$reportNull$$$0(0);
            }
            assert (beforePath != null || afterPath != null);
            this.status = status;
            this.beforePath = beforePath;
            this.afterPath = afterPath;
        }

        @Nullable
        public FilePath getBeforePath() {
            return this.beforePath;
        }

        @Nullable
        public FilePath getAfterPath() {
            return this.afterPath;
        }

        @NotNull
        public FilePath getFilePath() {
            @Nullable FilePath t = this.afterPath != null ? this.afterPath : this.beforePath;
            FilePath filePath = Objects.requireNonNull(t);
            if (filePath == null) {
                GitDiffChange.$$$reportNull$$$0(1);
            }
            return filePath;
        }

        @NotNull
        public FileStatus getStatus() {
            FileStatus fileStatus = this.status;
            if (fileStatus == null) {
                GitDiffChange.$$$reportNull$$$0(2);
            }
            return fileStatus;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "status";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/changes/GitChangeUtils$GitDiffChange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/changes/GitChangeUtils$GitDiffChange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePath";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

