/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clouds.docker.gateway.templates;

import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/clouds/docker/gateway/templates/DevcontainerTemplatePatcher;", "", "<init>", "()V", "loadAndPatch", "", "path", "Ljava/nio/file/Path;", "patchVolumes", "content", "containsDotDotRef", "", "volString", "VolumeWriter", "intellij.clouds.docker.gateway"})
@SourceDebugExtension(value={"SMAP\nDevcontainerTemplatePatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevcontainerTemplatePatcher.kt\ncom/intellij/clouds/docker/gateway/templates/DevcontainerTemplatePatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1863#2,2:92\n*S KotlinDebug\n*F\n+ 1 DevcontainerTemplatePatcher.kt\ncom/intellij/clouds/docker/gateway/templates/DevcontainerTemplatePatcher\n*L\n60#1:92,2\n*E\n"})
public final class DevcontainerTemplatePatcher {
    @NotNull
    public final String loadAndPatch(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String content = Files.readString(path);
        if (Intrinsics.areEqual((Object)PathsKt.getName((Path)path), (Object)"docker-compose.yml")) {
            Intrinsics.checkNotNull((Object)content);
            return this.patchVolumes(content);
        }
        Intrinsics.checkNotNull((Object)content);
        return content;
    }

    private final String patchVolumes(String content) {
        StringBuilder output = new StringBuilder();
        VolumeWriter volumeWriter = null;
        for (Object e : StringsKt.lines((CharSequence)content)) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            String line = (String)e;
            String trimmed = ((Object)StringsKt.trim((CharSequence)line)).toString();
            if (StringsKt.startsWith$default((String)trimmed, (String)"volumes:", (boolean)false, (int)2, null)) {
                volumeWriter = new VolumeWriter();
                volumeWriter.appendLine(line);
                continue;
            }
            if (volumeWriter != null) {
                if (StringsKt.startsWith$default((String)trimmed, (String)"- ", (boolean)false, (int)2, null)) {
                    if (this.containsDotDotRef(trimmed)) {
                        volumeWriter.commentOut(line);
                        continue;
                    }
                    volumeWriter.appendVolume(line);
                    continue;
                }
                if (((CharSequence)trimmed).length() == 0 || StringsKt.startsWith$default((String)trimmed, (String)"#", (boolean)false, (int)2, null)) {
                    volumeWriter.appendLine(line);
                    continue;
                }
                output.append(volumeWriter.getContent());
                output.append(line).append('\n');
                volumeWriter = null;
                continue;
            }
            output.append(line).append('\n');
        }
        String string = output.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Object object = new char[1];
        object[0] = 10;
        return StringsKt.trimEnd((String)string, (char[])object);
    }

    private final boolean containsDotDotRef(String volString) {
        String[] stringArray = new String[]{":"};
        List volumes = StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)volString, (CharSequence)"- "), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        Iterable $this$forEach$iv = volumes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it, (String)"..", (boolean)false, (int)2, null)) continue;
            return true;
        }
        return false;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u0011\u001a\u00020\u000eR\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/clouds/docker/gateway/templates/DevcontainerTemplatePatcher$VolumeWriter;", "", "<init>", "()V", "volumeSection", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "volCount", "", "workspaceExcluded", "", "appendLine", "", "line", "", "commentOut", "appendVolume", "getContent", "intellij.clouds.docker.gateway"})
    private static final class VolumeWriter {
        @NotNull
        private final StringBuilder volumeSection = new StringBuilder();
        private int volCount;
        private boolean workspaceExcluded;

        public final void appendLine(@NotNull String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            this.volumeSection.append(line).append('\n');
        }

        public final void commentOut(@NotNull String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            this.workspaceExcluded = true;
            this.volumeSection.append("#");
            this.volumeSection.append(line).append('\n');
        }

        public final void appendVolume(@NotNull String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            int n = this.volCount;
            this.volCount = n + 1;
            this.volumeSection.append(line).append('\n');
        }

        @NotNull
        public final String getContent() {
            Object object;
            if (this.volCount == 0 && this.workspaceExcluded) {
                object = "#" + this.volumeSection;
            } else {
                String string = this.volumeSection.toString();
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            }
            return object;
        }
    }
}

