/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.XmlContextType;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.PredefinedConfigurationUtil;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.XmlMatchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.XmlCompiledPattern;
import com.intellij.structuralsearch.impl.matcher.XmlMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.XmlCompilingVisitor;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacerUtil;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.util.LocalTimeCounter;
import com.intellij.xml.parsing.XmlParserBundle;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XmlStructuralSearchProfile
extends StructuralSearchProfile {
    @Override
    public void compile(PsiElement @NotNull [] elements, @NotNull GlobalCompilingVisitor globalVisitor) {
        if (globalVisitor == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(1);
        }
        new XmlCompilingVisitor(globalVisitor).compile(elements);
    }

    @Override
    @NotNull
    public PsiElementVisitor createMatchingVisitor(@NotNull GlobalMatchingVisitor globalVisitor) {
        if (globalVisitor == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(2);
        }
        return new XmlMatchingVisitor(globalVisitor);
    }

    @Override
    public boolean isIdentifier(@Nullable PsiElement element) {
        return element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_NAME;
    }

    @Override
    @NotNull
    public String getTypedVarString(@NotNull PsiElement element) {
        if (element == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(3);
        }
        String string = element instanceof XmlText ? element.getText().trim() : super.getTypedVarString(element);
        if (string == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public boolean isMatchNode(PsiElement element) {
        return !XmlMatchUtil.isWhiteSpace(element) && !(element instanceof PsiErrorElement);
    }

    @Override
    @NotNull
    public CompiledPattern createCompiledPattern() {
        return new XmlCompiledPattern();
    }

    @Override
    public boolean isMyLanguage(@NotNull Language language) {
        if (language == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(5);
        }
        return language instanceof XMLLanguage && (!language.getID().equals("JSP") || ApplicationManager.getApplication().isUnitTestMode());
    }

    @Override
    public PsiElement @NotNull [] createPatternTree(@NonNls @NotNull String text, @NotNull PatternTreeContext context, @NotNull LanguageFileType fileType, @NotNull Language language, String contextId, @NotNull Project project2, boolean physical) {
        if (text == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(6);
        }
        if (context == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(7);
        }
        if (fileType == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(8);
        }
        if (language == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(9);
        }
        if (project2 == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(10);
        }
        text = context == PatternTreeContext.File ? text : "<QQQ>" + (String)text + "</QQQ>";
        @NonNls String fileName = "dummy." + fileType.getDefaultExtension();
        PsiFile fileFromText = PsiFileFactory.getInstance((Project)project2).createFileFromText(fileName, (FileType)fileType, (CharSequence)text, LocalTimeCounter.currentTime(), physical, true);
        XmlDocument document = HtmlUtil.getRealXmlDocument(((XmlFile)fileFromText).getDocument());
        if (context == PatternTreeContext.File) {
            PsiElement[] psiElementArray = new PsiElement[]{document};
            if (psiElementArray == null) {
                XmlStructuralSearchProfile.$$$reportNull$$$0(11);
            }
            return psiElementArray;
        }
        assert (document != null);
        XmlTag rootTag = document.getRootTag();
        assert (rootTag != null);
        XmlTagChild[] children = rootTag.getValue().getChildren();
        Object[] objectArray = children.length == 1 && children[0] instanceof XmlText ? children[0].getChildren() : children;
        if (objectArray == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(12);
        }
        return objectArray;
    }

    @Override
    @NotNull
    public PsiElement extendMatchedByDownUp(@NotNull PsiElement node) {
        PsiElement parent;
        if (node == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(13);
        }
        if (XmlUtil.isXmlToken(node, XmlTokenType.XML_DATA_CHARACTERS) && (parent = node.getParent()).getTextRange().equals((Object)node.getTextRange())) {
            PsiElement psiElement = parent;
            if (psiElement == null) {
                XmlStructuralSearchProfile.$$$reportNull$$$0(14);
            }
            return psiElement;
        }
        PsiElement psiElement = super.extendMatchedByDownUp(node);
        if (psiElement == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(15);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public Class<? extends TemplateContextType> getTemplateContextTypeClass() {
        return XmlContextType.class;
    }

    @Override
    @NotNull
    public LanguageFileType detectFileType(@NotNull PsiElement context) {
        Language contextLanguage;
        if (context == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(16);
        }
        PsiFile file = context instanceof PsiFile ? (PsiFile)context : context.getContainingFile();
        Language language = contextLanguage = context instanceof PsiFile ? null : context.getLanguage();
        if (file.getLanguage() == HTMLLanguage.INSTANCE || file.getFileType().getName().equals("JSP") && contextLanguage == HTMLLanguage.INSTANCE) {
            HtmlFileType htmlFileType = HtmlFileType.INSTANCE;
            if (htmlFileType == null) {
                XmlStructuralSearchProfile.$$$reportNull$$$0(17);
            }
            return htmlFileType;
        }
        XmlFileType xmlFileType = XmlFileType.INSTANCE;
        if (xmlFileType == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(18);
        }
        return xmlFileType;
    }

    @Override
    public void checkSearchPattern(@NotNull CompiledPattern pattern) {
        if (pattern == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(19);
        }
        ValidatingVisitor visitor2 = new ValidatingVisitor();
        NodeIterator nodes = pattern.getNodes();
        while (nodes.hasNext()) {
            nodes.current().accept((PsiElementVisitor)visitor2);
            nodes.advance();
        }
        nodes.reset();
    }

    @Override
    public void checkReplacementPattern(@NotNull Project project2, @NotNull ReplaceOptions options) {
        if (project2 == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(20);
        }
        if (options == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(21);
        }
    }

    @Override
    public StructuralReplaceHandler getReplaceHandler(@NotNull Project project2, @NotNull ReplaceOptions replaceOptions) {
        if (project2 == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(22);
        }
        if (replaceOptions == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(23);
        }
        return new XmlReplaceHandler(project2, replaceOptions);
    }

    @Override
    public Configuration @NotNull [] getPredefinedTemplates() {
        Configuration[] configurationArray = XmlPredefinedConfigurations.createPredefinedTemplates();
        if (configurationArray == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(24);
        }
        return configurationArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 11, 12, 14, 15, 17, 18, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalVisitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/XmlStructuralSearchProfile";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 10: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/XmlStructuralSearchProfile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypedVarString";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createPatternTree";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "extendMatchedByDownUp";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "detectFileType";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedTemplates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createMatchingVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTypedVarString";
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 24: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isMyLanguage";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createPatternTree";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "extendMatchedByDownUp";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "detectFileType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkSearchPattern";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkReplacementPattern";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getReplaceHandler";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 11, 12, 14, 15, 17, 18, 24 -> new IllegalStateException(string);
        };
    }

    static class ValidatingVisitor
    extends PsiRecursiveElementWalkingVisitor {
        ValidatingVisitor() {
        }

        public void visitErrorElement(@NotNull PsiErrorElement element) {
            if (element == null) {
                ValidatingVisitor.$$$reportNull$$$0(0);
            }
            super.visitErrorElement(element);
            String errorDescription = element.getErrorDescription();
            PsiElement parent = element.getParent();
            if (parent instanceof XmlAttribute && XmlParserBundle.message((String)"xml.parsing.expected.attribute.eq.sign", (Object[])new Object[0]).equals(errorDescription)) {
                return;
            }
            if (parent instanceof XmlTag && XmlParserBundle.message((String)"xml.parsing.named.element.is.not.closed", (Object[])new Object[]{((XmlTag)parent).getName()}).equals(errorDescription)) {
                return;
            }
            throw new MalformedPatternException(errorDescription);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/XmlStructuralSearchProfile$ValidatingVisitor", "visitErrorElement"));
        }
    }

    private static class XmlReplaceHandler
    extends StructuralReplaceHandler {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ReplaceOptions myReplaceOptions;

        XmlReplaceHandler(@NotNull Project project2, @NotNull ReplaceOptions replaceOptions) {
            if (project2 == null) {
                XmlReplaceHandler.$$$reportNull$$$0(0);
            }
            if (replaceOptions == null) {
                XmlReplaceHandler.$$$reportNull$$$0(1);
            }
            this.myProject = project2;
            this.myReplaceOptions = replaceOptions;
        }

        @Override
        public void replace(@NotNull ReplacementInfo info, @NotNull ReplaceOptions options) {
            if (info == null) {
                XmlReplaceHandler.$$$reportNull$$$0(2);
            }
            if (options == null) {
                XmlReplaceHandler.$$$reportNull$$$0(3);
            }
            PsiElement elementToReplace = StructuralSearchUtil.getPresentableElement(info.getMatch(0));
            assert (elementToReplace != null);
            String replacementToMake = info.getReplacement();
            PsiElement elementParent = elementToReplace.getParent();
            boolean listContext = elementParent instanceof XmlTag;
            if (listContext) {
                this.doReplaceInContext(info, elementToReplace, replacementToMake, elementParent);
            } else {
                LanguageFileType fileType = this.myReplaceOptions.getMatchOptions().getFileType();
                assert (fileType != null);
                PsiElement[] replacements = MatcherImplUtil.createTreeFromText(replacementToMake, PatternTreeContext.Block, fileType, this.myProject);
                if (replacements.length > 0) {
                    PsiElement replacement = ReplacerUtil.copySpacesAndCommentsBefore(elementToReplace, replacements, replacementToMake, elementParent);
                    Replacer.handleComments(elementToReplace, replacement, info);
                    elementToReplace.replace(replacement);
                } else {
                    elementToReplace.delete();
                }
            }
        }

        private void doReplaceInContext(ReplacementInfo info, PsiElement elementToReplace, String replacementToMake, PsiElement elementParent) {
            LanguageFileType fileType = this.myReplaceOptions.getMatchOptions().getFileType();
            assert (fileType != null);
            PsiElement[] replacements = MatcherImplUtil.createTreeFromText(replacementToMake, PatternTreeContext.Block, fileType, this.myProject);
            if (replacements.length > 0 && !(replacements[0] instanceof XmlAttribute) && !(replacements[0] instanceof XmlTagChild)) {
                replacements = new PsiElement[]{replacements[0].getParent()};
            }
            if (replacements.length > 1) {
                elementParent.addRangeBefore(replacements[0], replacements[replacements.length - 1], elementToReplace);
            } else if (replacements.length == 1) {
                elementToReplace.replace(replacements[0]);
                return;
            }
            int matchSize = info.getMatchesCount();
            for (int i = 0; i < matchSize; ++i) {
                PsiElement match2 = info.getMatch(i);
                if (match2 == null) continue;
                PsiElement element = StructuralSearchUtil.getPresentableElement(match2);
                PsiElement prevSibling = element.getPrevSibling();
                element.getParent().deleteChildRange(XmlMatchUtil.isWhiteSpace(prevSibling) ? prevSibling : element, element);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replaceOptions";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/structuralsearch/XmlStructuralSearchProfile$XmlReplaceHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "replace";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class XmlPredefinedConfigurations {
        private XmlPredefinedConfigurations() {
        }

        static Configuration[] createPredefinedTemplates() {
            return new Configuration[]{PredefinedConfigurationUtil.createLegacyConfiguration(SSRBundle.message("predefined.template.xml.tag", new Object[0]), "Xml tag", "<'a/>", XmlPredefinedConfigurations.getHtmlXml(), (LanguageFileType)XmlFileType.INSTANCE), PredefinedConfigurationUtil.createLegacyConfiguration(SSRBundle.message("predefined.template.xml.attribute", new Object[0]), "Xml attribute", "<'_tag 'attribute=\"'_value\"/>", XmlPredefinedConfigurations.getHtmlXml(), (LanguageFileType)XmlFileType.INSTANCE), PredefinedConfigurationUtil.createLegacyConfiguration(SSRBundle.message("predefined.template.html.attribute", new Object[0]), "Html attribute", "<'_tag 'attribute />", XmlPredefinedConfigurations.getHtmlXml(), (LanguageFileType)HtmlFileType.INSTANCE), PredefinedConfigurationUtil.createLegacyConfiguration(SSRBundle.message("predefined.template.xml.attribute.value", new Object[0]), "Xml attribute value", "<'_tag '_attribute=\"'value\"/>", XmlPredefinedConfigurations.getHtmlXml(), (LanguageFileType)XmlFileType.INSTANCE), PredefinedConfigurationUtil.createLegacyConfiguration(SSRBundle.message("predefined.template.html.attribute.value", new Object[0]), "Html attribute value", "<'_tag '_attribute='value />", XmlPredefinedConfigurations.getHtmlXml(), (LanguageFileType)HtmlFileType.INSTANCE), PredefinedConfigurationUtil.createLegacyConfiguration(SSRBundle.message("predefined.template.xml.html.tag.value", new Object[0]), "Xml/html tag value", "<table>'_content*</table>", XmlPredefinedConfigurations.getHtmlXml(), (LanguageFileType)HtmlFileType.INSTANCE), PredefinedConfigurationUtil.createLegacyConfiguration(SSRBundle.message("predefined.template.ul.or.ol", new Object[0]), "<ul> or <ol>", "<'_tag:[regex( ul|ol )] />", XmlPredefinedConfigurations.getHtmlXml(), (LanguageFileType)HtmlFileType.INSTANCE), PredefinedConfigurationUtil.createLegacyConfiguration(SSRBundle.message("predefined.template.li.not.contained.in.ul.or.ol", new Object[0]), "<li> not contained in <ul> or <ol>", "[!within( <ul> or <ol> )]<li />", XmlPredefinedConfigurations.getHtmlXml(), (LanguageFileType)HtmlFileType.INSTANCE), PredefinedConfigurationUtil.createLegacyConfiguration(SSRBundle.message("predefined.configuration.xml.attribute.referencing.java.class", new Object[0]), "xml attribute referencing java class", "<'_tag 'attribute=\"'_value:[ref( classes, interfaces \\& enums )]\"/>", XmlPredefinedConfigurations.getHtmlXml(), (LanguageFileType)XmlFileType.INSTANCE), PredefinedConfigurationUtil.createConfiguration(SSRBundle.message("predefined.template.xml.tag.without.specific.attribute", new Object[0]), "XML tag without a specific attribute", "<'_tag '_attr{0,0}:attributeName />", XmlPredefinedConfigurations.getHtmlXml(), (LanguageFileType)XmlFileType.INSTANCE)};
        }

        private static String getHtmlXml() {
            return SSRBundle.message("xml_html.category", new Object[0]);
        }
    }
}

