/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.database.Dbms;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.IntentionUtilsKt;
import com.intellij.sql.intentions.UtilsKt;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlInsertDmlInstruction;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\bH\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J!\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/sql/intentions/SqlMergeInsertStatementsIntention;", "Lcom/intellij/codeInsight/intention/impl/BaseIntentionAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "invoke", "", "intellij.database.sql.impl"})
public final class SqlMergeInsertStatementsIntention
extends BaseIntentionAction
implements DumbAware {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message((String)"intention.family.name.merge.insert.statements", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (editor2 == null) {
            return false;
        }
        Dbms dbms = SqlImplUtil.getSqlDialectSafe((PsiElement)file).getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        if (dbms2.isSybase()) {
            return false;
        }
        Sequence<SqlInsertStatement> statements2 = IntentionUtilsKt.getInsertStatements(editor2, file, true);
        if (!SequencesKt.any(statements2) || SequencesKt.singleOrNull(statements2) != null) {
            return false;
        }
        if (editor2.getSelectionModel().hasSelection()) {
            this.setText(SqlBundle.message((String)"intention.name.merge.selected.insert.statements", (Object[])new Object[0]));
        } else {
            this.setText(SqlBundle.message((String)"intention.name.merge.successive.insert.statements", (Object[])new Object[0]));
        }
        return true;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file) {
        DdlBuilder ddlBuilder;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document doc = document;
        List statements2 = SequencesKt.toList(IntentionUtilsKt.getInsertStatements(editor2, file, true));
        SqlInsertStatement sqlInsertStatement = (SqlInsertStatement)CollectionsKt.firstOrNull((List)statements2);
        if (sqlInsertStatement == null) {
            return;
        }
        SqlInsertStatement anchor = sqlInsertStatement;
        String string = UtilsKt.getValuesKeyword(anchor);
        if (string == null) {
            return;
        }
        String valuesKeyword = string;
        DdlBuilder $this$invoke_u24lambda_u242 = ddlBuilder = new DdlBuilder();
        boolean bl = false;
        $this$invoke_u24lambda_u242.plain("INSERT INTO foo " + valuesKeyword + " ");
        $this$invoke_u24lambda_u242.plain(CollectionsKt.joinToString$default((Iterable)statements2, null, null, null, (int)0, null, SqlMergeInsertStatementsIntention::invoke$lambda$2$lambda$1, (int)31, null));
        String string2 = ddlBuilder.getStatement();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStatement(...)");
        String insertText = string2;
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        SqlStatement newInsert = SqlPsiElementFactory.createStatementFromText(insertText, dialect, project, null);
        SqlInsertStatement sqlInsertStatement2 = newInsert instanceof SqlInsertStatement ? (SqlInsertStatement)newInsert : null;
        if (sqlInsertStatement2 == null || (sqlInsertStatement2 = sqlInsertStatement2.getDmlInstruction()) == null || (sqlInsertStatement2 = sqlInsertStatement2.getValuesExpression()) == null) {
            return;
        }
        SqlInsertStatement newValues = sqlInsertStatement2;
        SqlInsertDmlInstruction sqlInsertDmlInstruction = anchor.getDmlInstruction();
        Intrinsics.checkNotNull((Object)sqlInsertDmlInstruction);
        SqlValuesExpression sqlValuesExpression = sqlInsertDmlInstruction.getValuesExpression();
        Intrinsics.checkNotNull((Object)sqlValuesExpression);
        sqlValuesExpression.replace((PsiElement)newValues);
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(doc);
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)anchor);
        PsiElement psiElement = anchor.getNextSibling();
        if (psiElement == null || (psiElement = psiElement.getTextRange()) == null) {
            return;
        }
        int deleteFrom = psiElement.getStartOffset();
        SqlInsertStatement sqlInsertStatement3 = (SqlInsertStatement)CollectionsKt.lastOrNull((List)statements2);
        if (sqlInsertStatement3 == null) {
            return;
        }
        int deleteTo = PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)sqlInsertStatement3));
        doc.deleteString(deleteFrom, deleteTo);
    }

    private static final CharSequence invoke$lambda$2$lambda$1$lambda$0(SqlExpression it) {
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final CharSequence invoke$lambda$2$lambda$1(SqlInsertStatement statement2) {
        Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
        SqlInsertDmlInstruction sqlInsertDmlInstruction = statement2.getDmlInstruction();
        if (sqlInsertDmlInstruction == null || (sqlInsertDmlInstruction = sqlInsertDmlInstruction.getValuesExpression()) == null || (sqlInsertDmlInstruction = sqlInsertDmlInstruction.getExpressions()) == null) {
            JBIterable jBIterable = JBIterable.empty();
            sqlInsertDmlInstruction = jBIterable;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
        }
        SqlInsertDmlInstruction expressions = sqlInsertDmlInstruction;
        return CollectionsKt.joinToString$default((Iterable)((Iterable)expressions), null, null, null, (int)0, null, SqlMergeInsertStatementsIntention::invoke$lambda$2$lambda$1$lambda$0, (int)31, null);
    }
}

