/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.url.FieldSize;
import com.intellij.database.dataSource.url.ui.DatabaseUIUtils;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.state.DbCollectionModelState;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.DbVisualEditorBase;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;

public abstract class DbCollectionEditor<E extends BasicElement, T>
extends DbVisualEditorBase<E, DbCollectionModelState<T>> {
    private final CollectionListModel<T> myItems;
    private final JBList<T> myItemsList;
    private final Splitter mySplitter;
    private final JPanel myEditorHolder;
    private ItemEditor<T> myCurrentEditor;

    protected DbCollectionEditor(@NotNull DbEditorController controller, @NotNull DbModelRef<E, DbCollectionModelState<T>> model) {
        if (controller == null) {
            DbCollectionEditor.$$$reportNull$$$0(0);
        }
        if (model == null) {
            DbCollectionEditor.$$$reportNull$$$0(1);
        }
        super(controller, model);
        this.myItems = new CollectionListModel<T>(new Object[0]){

            public void replaceAll(@NotNull List<? extends T> elements) {
                if (elements == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (this.getSize() != elements.size()) {
                    super.replaceAll(elements);
                } else {
                    this.getInternalList().clear();
                    this.getInternalList().addAll(elements);
                    this.allContentsChanged();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/schemaEditor/ui/DbCollectionEditor$1", "replaceAll"));
            }
        };
        this.myItemsList = new JBList(this.myItems);
        this.myItemsList.setEmptyText(DatabaseBundle.message("status.text.no", this.getTitle()));
        this.myItemsList.setCellRenderer(this.createRenderer());
        this.myItems.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                DbCollectionEditor.this.modified();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                DbCollectionEditor.this.modified();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                DbCollectionEditor.this.modified();
            }
        });
        this.myItemsList.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.setCurrentEditor(this.myItemsList.getSelectedIndex());
        });
        this.mySplitter = new Splitter(false, 0.2f);
        JPanel listPanel = ToolbarDecorator.createDecorator(this.myItemsList).setAddAction(button -> {
            Object item = ((DbCollectionModelState)this.getState()).getItemFactory().createItem(null);
            this.myItems.add(item);
            this.myItemsList.setSelectedValue(item, true);
        }).setPreferredSize((Dimension)JBUI.size((int)150, (int)150)).createPanel();
        this.mySplitter.setFirstComponent((JComponent)listPanel);
        this.mySplitter.setHonorComponentsPreferredSize(true);
        this.mySplitter.setLackOfSpaceStrategy(Splitter.LackOfSpaceStrategy.HONOR_THE_FIRST_MIN_SIZE);
        this.myEditorHolder = new JPanel(new BorderLayout());
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myEditorHolder, (boolean)true);
        this.mySplitter.setSecondComponent((JComponent)scrollPane);
        UserActivityWatcher watcher = new UserActivityWatcher();
        watcher.addUserActivityListener(() -> this.applyCurrentEditor());
        watcher.register((Component)this.myEditorHolder);
    }

    @NotNull
    private ListCellRenderer<T> createRenderer() {
        class R
        extends SimpleColoredComponent
        implements ListCellRenderer<T> {
            R() {
            }

            @Override
            public Component getListCellRendererComponent(JList<? extends T> list, T value, int index, boolean isSelected, boolean cellHasFocus) {
                this.clear();
                this.setForeground(RenderingUtil.getForeground(list, (boolean)isSelected));
                this.setBackground(RenderingUtil.getBackground(list, (boolean)isSelected));
                DbCollectionEditor.this.render(this, value);
                return this;
            }
        }
        return new R();
    }

    protected abstract void render(SimpleColoredComponent var1, T var2);

    protected void renderName(SimpleColoredComponent c2, @NlsSafe String name2) {
        if (StringUtil.isEmpty((String)name2)) {
            c2.append(DatabaseBundle.message("label.none", new Object[0]), SimpleTextAttributes.GRAY_ATTRIBUTES);
        } else {
            c2.append(name2);
        }
    }

    private void applyCurrentEditor() {
        if (this.myCurrentEditor == null) {
            return;
        }
        int index = this.myItemsList.getSelectedIndex();
        if (index == -1) {
            return;
        }
        T val = this.myCurrentEditor.get();
        this.myItems.setElementAt(val, index);
    }

    private void setCurrentEditor(int index) {
        if (this.myCurrentEditor != null) {
            this.myCurrentEditor = null;
            this.myEditorHolder.removeAll();
        }
        if (index == -1) {
            return;
        }
        this.myCurrentEditor = this.createEditor();
        this.myCurrentEditor.set(this.myItems.getElementAt(index));
        this.myEditorHolder.add((Component)this.myCurrentEditor.getComponent(), "North");
        this.myEditorHolder.revalidate();
    }

    @Override
    protected void applyImpl() {
        ((DbCollectionModelState)this.getState()).setItems(this.myItems.getItems());
    }

    @Override
    protected void resetImpl() {
        int index = this.myItemsList.getSelectedIndex();
        this.myItems.replaceAll(((DbCollectionModelState)this.getState()).getItems());
        if (this.myCurrentEditor != null && index != -1) {
            this.myCurrentEditor.set(this.myItems.getElementAt(index));
        }
        if (index == -1 && !this.myItems.isEmpty()) {
            this.myItemsList.setSelectedIndex(0);
        }
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        Splitter splitter = this.mySplitter;
        if (splitter == null) {
            DbCollectionEditor.$$$reportNull$$$0(2);
        }
        return splitter;
    }

    @Override
    @NotNull
    public FieldSize getFieldSize() {
        FieldSize fieldSize = FieldSize.LARGE;
        if (fieldSize == null) {
            DbCollectionEditor.$$$reportNull$$$0(3);
        }
        return fieldSize;
    }

    @Override
    public boolean isEmpty() {
        return this.myItems.isEmpty();
    }

    @Override
    public boolean isVertical() {
        return true;
    }

    public abstract ItemEditor<T> createEditor();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbCollectionEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbCollectionEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    public static interface ItemEditor<T> {
        public void set(T var1);

        public T get();

        public JComponent getComponent();
    }

    public static abstract class BaseItemEditor<T>
    implements ItemEditor<T> {
        private JComponent myComponent;

        @Override
        public final JComponent getComponent() {
            if (this.myComponent == null) {
                this.myComponent = this.createComponent();
            }
            return this.myComponent;
        }

        protected abstract JComponent createComponent();

        protected JComponent createComponent(int rows) {
            return new JPanel((LayoutManager)new GridLayoutManager(rows, 4));
        }

        protected void addRow(JComponent component, int row, @NlsContexts.Label String label, JComponent field) {
            JBLabel lbl = new JBLabel(label);
            component.add((Component)lbl, DatabaseUIUtils.createLabelConstraints(row, 0, lbl.getPreferredSize().getWidth()));
            component.add((Component)field, DatabaseUIUtils.createSimpleConstraints(row, 1, 3));
        }
    }
}

