/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbElementUsage;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DbUtil;
import com.intellij.find.findUsages.CustomUsageSearcher;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.psi.SqlFile;
import com.intellij.usages.Usage;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.usages.impl.rules.UsageTypeProvider;
import com.intellij.util.Processor;
import com.intellij.util.containers.JBTreeTraverser;
import org.jetbrains.annotations.NotNull;

public final class DbCustomUsageSearcher
extends CustomUsageSearcher
implements UsageTypeProvider {
    private static final UsageType SCHEMA_USAGE_TYPE = new UsageType(DatabaseBundle.messagePointer("usage.type.schema", new Object[0]));

    public void processElementUsages(@NotNull PsiElement element, @NotNull Processor<? super Usage> processor2, @NotNull FindUsagesOptions options) {
        if (element == null) {
            DbCustomUsageSearcher.$$$reportNull$$$0(0);
        }
        if (processor2 == null) {
            DbCustomUsageSearcher.$$$reportNull$$$0(1);
        }
        if (options == null) {
            DbCustomUsageSearcher.$$$reportNull$$$0(2);
        }
        if (element instanceof SqlFile) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
            for (DbDataSource dataSource : DbPsiFacade.getInstance(element.getProject()).getDataSources()) {
                RawDataSource delegate = dataSource.getDelegate();
                if (!(delegate instanceof SqlDataSource) || !((SqlDataSource)delegate).containsFile(virtualFile) || processor2.process((Object)new DbElementUsage(dataSource.getName(), dataSource))) continue;
                return;
            }
            return;
        }
        DasObject target2 = DbUtil.getDasObject(element);
        if (target2 == null || !(element instanceof DbElement)) {
            return;
        }
        DbElement dbTarget = (DbElement)element;
        if (DbSqlUtil.isSqlElement(dbTarget)) {
            return;
        }
        DbDataSource dataSource = dbTarget.getDataSource();
        ObjectKind targetKind = target2.getKind();
        if (targetKind == ObjectKind.NONE) {
            return;
        }
        JBTreeTraverser<DasObject> traverser = dataSource.getDelegate().getModel().traverser();
        for (DasObject o : traverser) {
            DbElement oo;
            ProgressManager.checkCanceled();
            if (!DbSqlUtilCore.referencesTarget(o, target2, targetKind) || processor2.process((Object)DbCustomUsageSearcher.createUsage(oo = DbImplUtilCore.findElement(dataSource, o), dbTarget))) continue;
            return;
        }
    }

    public UsageType getUsageType(@NotNull PsiElement element) {
        if (element == null) {
            DbCustomUsageSearcher.$$$reportNull$$$0(3);
        }
        if (element instanceof DbElement) {
            return SCHEMA_USAGE_TYPE;
        }
        return null;
    }

    private static Usage createUsage(@NotNull DbElement o, @NotNull DbElement resolveTo) {
        if (o == null) {
            DbCustomUsageSearcher.$$$reportNull$$$0(4);
        }
        if (resolveTo == null) {
            DbCustomUsageSearcher.$$$reportNull$$$0(5);
        }
        return (Usage)ReadAction.compute(() -> DbElementUsage.create(o, resolveTo));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveTo";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/psi/DbCustomUsageSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processElementUsages";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getUsageType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createUsage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

