/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.BaseAffectAnalysisFun;
import com.intellij.database.dialects.base.BaseAffectAnalyzer;
import com.intellij.database.dialects.oracle.OraAffectAnalyzerKt;
import com.intellij.database.introspection.AffectedObjectScriptedMention;
import com.intellij.database.introspection.BelongingAreaKind;
import com.intellij.database.introspection.ObjectEffectType;
import com.intellij.database.introspection.ScriptedName;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.SearchPath;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.oracle.OraTypes;
import com.intellij.sql.dialects.oracle.psi.OraCreatePackageBodyStatementImpl;
import com.intellij.sql.dialects.oracle.psi.OraCreatePackageStatementImpl;
import com.intellij.sql.dialects.oracle.psi.OraCreateTypeBodyStatementImpl;
import com.intellij.sql.dialects.oracle.psi.OraCreateTypeStatementImpl;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDdlStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRenameToClause;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.impl.SqlCreateSynonymStatementImpl;
import com.intellij.sql.psi.impl.SqlDropStatementImpl;
import com.intellij.sql.psi.impl.SqlRenameToClauseImpl;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00060\u0005R\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0014J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0014J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000e\u001a\u00020\u000bH\u0014\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dialects/oracle/OraAffectAnalyzer;", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer;", "<init>", "()V", "prepareDeterminer", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$Determiner;", "dbms", "Lcom/intellij/database/Dbms;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "refineObjectKind", "Lcom/intellij/database/model/ObjectKind;", "statement", "Lcom/intellij/sql/psi/SqlDdlStatement;", "objectKind", "determineBelongingKind", "Lcom/intellij/database/introspection/BelongingAreaKind;", "OraDeterminer", "intellij.database.dialects.oracle"})
public final class OraAffectAnalyzer
extends BaseAffectAnalyzer {
    @Override
    @NotNull
    protected BaseAffectAnalyzer.Determiner prepareDeterminer(@NotNull Dbms dbms, @Nullable SearchPath searchPath) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        return new OraDeterminer(searchPath);
    }

    @Override
    @NotNull
    protected ObjectKind refineObjectKind(@NotNull SqlDdlStatement statement2, @NotNull ObjectKind objectKind) {
        ObjectKind objectKind2;
        Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)objectKind, (String)"objectKind");
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.BODY)) {
            PsiElement w = BaseAffectAnalysisFun.findChild((PsiElement)statement2, OraAffectAnalyzerKt.access$getPsiTypeOrPackageTypes$p());
            PsiElement psiElement = w;
            ObjectKind objectKind3 = Intrinsics.areEqual((Object)psiElement, (Object)SqlCommonKeywords.SQL_TYPE) ? ObjectKind.OBJECT_TYPE : (Intrinsics.areEqual((Object)psiElement, (Object)SqlCommonKeywords.SQL_PACKAGE) ? ObjectKind.PACKAGE : ObjectKind.SCHEMA_OBJECT);
            Intrinsics.checkNotNull((Object)objectKind3);
            objectKind2 = objectKind3;
        } else {
            objectKind2 = super.refineObjectKind(statement2, objectKind);
        }
        return objectKind2;
    }

    @Override
    @Nullable
    protected BelongingAreaKind determineBelongingKind(@NotNull ObjectKind objectKind) {
        Intrinsics.checkNotNullParameter((Object)objectKind, (String)"objectKind");
        ObjectKind objectKind2 = objectKind;
        return Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.NONE) || Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.UNKNOWN_OBJECT) || Intrinsics.areEqual((Object)objectKind2, (Object)SqlDbElementType.ANY) ? null : (Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.SCHEMA) || Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.TABLESPACE) || Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.DATA_FILE) || Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.USER) ? BelongingAreaKind.A_ROOT : BelongingAreaKind.A_SCHEMA);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0002J \u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0002J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0002J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/dialects/oracle/OraAffectAnalyzer$OraDeterminer;", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$SingleDatabaseDeterminer;", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "<init>", "(Lcom/intellij/database/dialects/oracle/OraAffectAnalyzer;Lcom/intellij/database/util/SearchPath;)V", "analyzeDdlStatement", "", "statement", "Lcom/intellij/sql/psi/SqlDdlStatement;", "analyzeCreateStatement", "Lcom/intellij/sql/psi/SqlCreateStatement;", "analyzeDropStatement", "Lcom/intellij/sql/psi/impl/SqlDropStatementImpl;", "analyzeCreateSynonym", "handleCreateProgram", "programKind", "Lcom/intellij/database/model/ObjectKind;", "isSpec", "", "analyzeAlterStatement", "Lcom/intellij/sql/psi/SqlAlterStatement;", "analyzeCreateUser", "analyzeCreateDbLink", "handleRenameNewStyle", "handleRenameClause", "renameClause", "Lcom/intellij/sql/psi/SqlRenameToClause;", "intellij.database.dialects.oracle"})
    @SourceDebugExtension(value={"SMAP\nOraAffectAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraAffectAnalyzer.kt\ncom/intellij/database/dialects/oracle/OraAffectAnalyzer$OraDeterminer\n+ 2 BaseAffectAnalysisFun.kt\ncom/intellij/database/dialects/base/BaseAffectAnalysisFun\n+ 3 BaseAffectAnalyzer.kt\ncom/intellij/database/dialects/base/BaseAffectAnalyzer$Companion\n+ 4 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,209:1\n33#2:210\n33#2:211\n39#2:212\n33#2:214\n233#3:213\n233#3:215\n455#4:216\n295#5,2:217\n*S KotlinDebug\n*F\n+ 1 OraAffectAnalyzer.kt\ncom/intellij/database/dialects/oracle/OraAffectAnalyzer$OraDeterminer\n*L\n88#1:210\n114#1:211\n130#1:212\n158#1:214\n137#1:213\n176#1:215\n182#1:216\n182#1:217,2\n*E\n"})
    private final class OraDeterminer
    extends BaseAffectAnalyzer.SingleDatabaseDeterminer {
        public OraDeterminer(SearchPath searchPath) {
            super(searchPath);
        }

        @Override
        protected void analyzeDdlStatement(@NotNull SqlDdlStatement statement2) {
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)((PsiElement)statement2)), (Object)OraTypes.ORA_RENAME_STATEMENT)) {
                this.handleRenameNewStyle(statement2);
            } else {
                super.analyzeDdlStatement(statement2);
            }
        }

        @Override
        protected void analyzeCreateStatement(@NotNull SqlCreateStatement statement2) {
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            SqlCreateStatement sqlCreateStatement = statement2;
            if (sqlCreateStatement instanceof OraCreatePackageStatementImpl) {
                ObjectKind objectKind = ObjectKind.PACKAGE;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"PACKAGE");
                this.handleCreateProgram(statement2, objectKind, true);
            } else if (sqlCreateStatement instanceof OraCreatePackageBodyStatementImpl) {
                ObjectKind objectKind = ObjectKind.PACKAGE;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"PACKAGE");
                this.handleCreateProgram(statement2, objectKind, false);
            } else if (sqlCreateStatement instanceof OraCreateTypeStatementImpl) {
                ObjectKind objectKind = ObjectKind.OBJECT_TYPE;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"OBJECT_TYPE");
                this.handleCreateProgram(statement2, objectKind, true);
            } else if (sqlCreateStatement instanceof OraCreateTypeBodyStatementImpl) {
                ObjectKind objectKind = ObjectKind.OBJECT_TYPE;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"OBJECT_TYPE");
                this.handleCreateProgram(statement2, objectKind, false);
            } else if (sqlCreateStatement instanceof SqlCreateSynonymStatementImpl) {
                this.analyzeCreateSynonym(statement2);
            } else {
                IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)((PsiElement)statement2));
                if (Intrinsics.areEqual((Object)iElementType, (Object)OraTypes.ORA_CREATE_USER_STATEMENT)) {
                    this.analyzeCreateUser(statement2);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)OraTypes.ORA_CREATE_DATABASE_LINK_STATEMENT)) {
                    this.analyzeCreateDbLink(statement2);
                } else {
                    super.analyzeCreateStatement(statement2);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void analyzeDropStatement(@NotNull SqlDropStatementImpl statement2) {
            ObjectKind kind;
            Intrinsics.checkNotNullParameter((Object)((Object)statement2), (String)"statement");
            ObjectKind objectKind = statement2.getTargetType();
            if (objectKind == null) {
                ObjectKind objectKind2 = ObjectKind.UNKNOWN_OBJECT;
                objectKind = objectKind2;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind2, (String)"UNKNOWN_OBJECT");
            }
            if (Intrinsics.areEqual((Object)(kind = objectKind), (Object)ObjectKind.SYNONYM) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.DB_LINK)) {
                void $this$hasChild$iv;
                PsiElement psiElement = (PsiElement)statement2;
                SqlTokenType sqlTokenType = SqlCommonKeywords.SQL_PUBLIC;
                Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_PUBLIC");
                IElementType type$iv = (IElementType)sqlTokenType;
                boolean $i$f$hasChild = false;
                if (BaseAffectAnalysisFun.findChild((PsiElement)$this$hasChild$iv, type$iv) != null) {
                    SqlReferenceExpression sqlReferenceExpression = statement2.getTargetExpression();
                    if (sqlReferenceExpression == null) {
                        return;
                    }
                    SqlNameElement nameElement = (SqlNameElement)sqlReferenceExpression;
                    ScriptedName objectName = OraAffectAnalyzerKt.access$getScriptedName(nameElement);
                    objectName = OraAffectAnalyzerKt.access$unquoteIfNeeded(objectName);
                    AffectedObjectScriptedMention mention = AffectedObjectScriptedMention.Companion.wasDropped(ScriptedName.Companion.getUnspecified(), OraAffectAnalyzerKt.access$getPublicSchemaName$p(), objectName, kind, BelongingAreaKind.A_SCHEMA);
                    this.acceptObject(mention);
                    return;
                }
            }
            kind = OraAffectAnalyzer.this.refineObjectKind((SqlDdlStatement)statement2, kind);
            BelongingAreaKind belongingAreaKind = OraAffectAnalyzer.this.determineBelongingKind(kind);
            SqlReferenceExpression identifierElement = statement2.getTargetExpression();
            BaseAffectAnalyzer.Determiner.handleIdentifier$default(this, ObjectEffectType.WAS_DROPPED, belongingAreaKind, kind, (SqlNameElement)identifierElement, 0, 16, null);
            if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.USER)) {
                BaseAffectAnalyzer.Determiner.handleIdentifier$default(this, ObjectEffectType.WAS_DROPPED, BelongingAreaKind.A_ROOT, ObjectKind.SCHEMA, (SqlNameElement)identifierElement, 0, 16, null);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void analyzeCreateSynonym(SqlCreateStatement statement2) {
            void $this$hasChild$iv;
            PsiElement psiElement = (PsiElement)statement2;
            SqlTokenType sqlTokenType = SqlCommonKeywords.SQL_PUBLIC;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_PUBLIC");
            IElementType type$iv = (IElementType)sqlTokenType;
            boolean $i$f$hasChild = false;
            if (BaseAffectAnalysisFun.findChild((PsiElement)$this$hasChild$iv, type$iv) != null) {
                SqlNameElement sqlNameElement = statement2.getNameElement();
                if (sqlNameElement == null) {
                    return;
                }
                SqlNameElement nameElement = sqlNameElement;
                ScriptedName objectName = OraAffectAnalyzerKt.access$getScriptedName(nameElement);
                ScriptedName scriptedName = ScriptedName.Companion.getUnspecified();
                ScriptedName scriptedName2 = OraAffectAnalyzerKt.access$getPublicSchemaName$p();
                ObjectKind objectKind = ObjectKind.SYNONYM;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"SYNONYM");
                AffectedObjectScriptedMention mention = AffectedObjectScriptedMention.Companion.wasCreated(scriptedName, scriptedName2, objectName, objectKind, BelongingAreaKind.A_SCHEMA);
                this.acceptObject(mention);
            } else {
                super.analyzeCreateStatement(statement2);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void handleCreateProgram(SqlCreateStatement statement2, ObjectKind programKind, boolean isSpec) {
            void $this$hasChild$iv;
            PsiElement psiElement = (PsiElement)statement2;
            Set types$iv = OraAffectAnalyzerKt.access$getPsiReplaceOrUpdateTypes$p();
            boolean $i$f$hasChild = false;
            boolean orReplace = BaseAffectAnalysisFun.findChild((PsiElement)$this$hasChild$iv, types$iv) != null;
            ObjectEffectType action = isSpec && !orReplace ? ObjectEffectType.WAS_CREATED : ObjectEffectType.WAS_ALTERED;
            BaseAffectAnalyzer.Determiner.handleIdentifier$default(this, action, BelongingAreaKind.A_SCHEMA, programKind, statement2.getNameElement(), 0, 16, null);
        }

        @Override
        protected void analyzeAlterStatement(@NotNull SqlAlterStatement statement2) {
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            SqlReferenceExpression sqlReferenceExpression = statement2.getAlterTargetReference();
            if (sqlReferenceExpression == null) {
                return;
            }
            SqlReferenceExpression objectRef = sqlReferenceExpression;
            BaseAffectAnalyzer.Companion companion = BaseAffectAnalyzer.Companion;
            PsiElement $this$child$iv = (PsiElement)statement2;
            boolean $i$f$child = false;
            SqlRenameToClauseImpl renameClause = (SqlRenameToClauseImpl)PsiTreeUtil.findChildOfType((PsiElement)$this$child$iv, SqlRenameToClauseImpl.class, (boolean)false);
            if (renameClause == null) {
                ObjectKind objectKind = objectRef.getKind();
                Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getKind(...)");
                ObjectKind kind = objectKind;
                kind = OraAffectAnalyzer.this.refineObjectKind((SqlDdlStatement)statement2, kind);
                BelongingAreaKind belongingAreaKind = OraAffectAnalyzer.this.determineBelongingKind(kind);
                BaseAffectAnalyzer.Determiner.handleIdentifier$default(this, ObjectEffectType.WAS_ALTERED, belongingAreaKind, kind, (SqlNameElement)objectRef, 0, 16, null);
            } else {
                SqlNameElement newNameElement = renameClause.getNameElement();
                this.handleRename(BelongingAreaKind.A_SCHEMA, objectRef, (SqlElement)newNameElement);
            }
        }

        private final void analyzeCreateUser(SqlCreateStatement statement2) {
            BaseAffectAnalyzer.Determiner.handleIdentifier$default(this, ObjectEffectType.WAS_CREATED, BelongingAreaKind.A_ROOT, ObjectKind.USER, statement2.getNameElement(), 0, 16, null);
            BaseAffectAnalyzer.Determiner.handleIdentifier$default(this, ObjectEffectType.WAS_CREATED, BelongingAreaKind.A_ROOT, ObjectKind.SCHEMA, statement2.getNameElement(), 0, 16, null);
        }

        /*
         * WARNING - void declaration
         */
        private final void analyzeCreateDbLink(SqlCreateStatement statement2) {
            void $this$hasChild$iv;
            SqlNameElement sqlNameElement = statement2.getNameElement();
            if (sqlNameElement == null) {
                return;
            }
            SqlNameElement nameElement = sqlNameElement;
            PsiElement psiElement = (PsiElement)statement2;
            SqlTokenType sqlTokenType = SqlCommonKeywords.SQL_PUBLIC;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_PUBLIC");
            IElementType type$iv = (IElementType)sqlTokenType;
            boolean $i$f$hasChild = false;
            if (BaseAffectAnalysisFun.findChild((PsiElement)$this$hasChild$iv, type$iv) != null) {
                ScriptedName objectName = OraAffectAnalyzerKt.access$getScriptedName(nameElement);
                objectName = OraAffectAnalyzerKt.access$unquoteIfNeeded(objectName);
                ScriptedName scriptedName = ScriptedName.Companion.getUnspecified();
                ScriptedName scriptedName2 = OraAffectAnalyzerKt.access$getPublicSchemaName$p();
                ObjectKind objectKind = ObjectKind.DB_LINK;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"DB_LINK");
                AffectedObjectScriptedMention mention = AffectedObjectScriptedMention.Companion.wasCreated(scriptedName, scriptedName2, objectName, objectKind, BelongingAreaKind.A_SCHEMA);
                this.acceptObject(mention);
            } else {
                BaseAffectAnalyzer.Determiner.handleIdentifier$default(this, ObjectEffectType.WAS_CREATED, BelongingAreaKind.A_SCHEMA, ObjectKind.DB_LINK, nameElement, 0, 16, null);
            }
        }

        private final void handleRenameNewStyle(SqlDdlStatement statement2) {
            BaseAffectAnalyzer.Companion companion = BaseAffectAnalyzer.Companion;
            PsiElement $this$child$iv = (PsiElement)statement2;
            boolean $i$f$child = false;
            SqlRenameToClause renameClause = (SqlRenameToClause)PsiTreeUtil.findChildOfType((PsiElement)$this$child$iv, SqlRenameToClause.class, (boolean)false);
            if (renameClause != null) {
                this.handleRenameClause(renameClause);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void handleRenameClause(SqlRenameToClause renameClause) {
            Object v1;
            SqlReferenceExpression originReference;
            block1: {
                void $this$firstOrNull$iv;
                originReference = renameClause.getTargetReference();
                Object $this$childrenOfType$iv = (PsiElement)renameClause;
                boolean $i$f$childrenOfType = false;
                List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, SqlIdentifier.class);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
                $this$childrenOfType$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    SqlIdentifier it = (SqlIdentifier)element$iv;
                    boolean bl = false;
                    if (!(it != originReference)) continue;
                    v1 = element$iv;
                    break block1;
                }
                v1 = null;
            }
            SqlIdentifier targetIdentifier = v1;
            this.handleRename(BelongingAreaKind.A_SCHEMA, ObjectKind.SCHEMA_OBJECT, (SqlNameElement)originReference, (SqlElement)targetIdentifier);
        }
    }
}

