/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.exasol.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.diagnostic.DataSourceDiagnosticRecorder;
import com.intellij.database.diagnostic.DiagnosticSectionReference;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospectorKt;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.IntrospectionQueryContext;
import com.intellij.database.dialects.base.introspector.IntrospectorSqlHelper;
import com.intellij.database.dialects.base.introspector.NameCache;
import com.intellij.database.dialects.base.introspector.jdbc.JdbcIntrospectorHelper;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.DatabaseMetaDataWrapper;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.TableColumnIt;
import com.intellij.database.dialects.exasol.introspector.ExaIntroQueries;
import com.intellij.database.dialects.exasol.introspector.ExaIntrospector$ExaSchemaRetriever$retrieveConstraints$;
import com.intellij.database.dialects.exasol.introspector.ExaIntrospector$ExaSchemaRetrieverBase$retrieveColumns$;
import com.intellij.database.dialects.exasol.model.ExaConnection;
import com.intellij.database.dialects.exasol.model.ExaConstraint;
import com.intellij.database.dialects.exasol.model.ExaDatabase;
import com.intellij.database.dialects.exasol.model.ExaForeignKey;
import com.intellij.database.dialects.exasol.model.ExaIndex;
import com.intellij.database.dialects.exasol.model.ExaKey;
import com.intellij.database.dialects.exasol.model.ExaLikeSchema;
import com.intellij.database.dialects.exasol.model.ExaLikeTable;
import com.intellij.database.dialects.exasol.model.ExaRole;
import com.intellij.database.dialects.exasol.model.ExaRoot;
import com.intellij.database.dialects.exasol.model.ExaRoutine;
import com.intellij.database.dialects.exasol.model.ExaSchema;
import com.intellij.database.dialects.exasol.model.ExaScript;
import com.intellij.database.dialects.exasol.model.ExaTable;
import com.intellij.database.dialects.exasol.model.ExaTableColumn;
import com.intellij.database.dialects.exasol.model.ExaUser;
import com.intellij.database.dialects.exasol.model.ExaView;
import com.intellij.database.dialects.exasol.model.ExaVirtualSchema;
import com.intellij.database.dialects.exasol.model.properties.ExaScriptType;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.DatabaseFragmentIntrospectionTask;
import com.intellij.database.introspection.DatabaseIntrospectionTask;
import com.intellij.database.introspection.IntrospectionTask;
import com.intellij.database.introspection.SchemasIntrospectionTask;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.NameValue;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModTableOrView;
import com.intellij.database.model.basic.BasicModTableOrViewColumn;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.model.properties.references.BasicParentReference;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.Version;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.text.CharSequenceSubSequence;
import com.intellij.util.text.StringKt;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 R2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0006QRSTUVB\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0014J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\rH\u0014J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001dH\u0014J \u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00152\u000e\u0010 \u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010!H\u0014J\u0010\u0010#\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J\b\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J\u0010\u0010'\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J\u0010\u0010(\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J\u0010\u0010)\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J\u0018\u0010*\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020+H\u0014J\u0018\u0010,\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010-\u001a\u00020\u0013H\u0014J\u0010\u0010.\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0015H\u0014J(\u0010/\u001a\u00020\u00192\u0006\u00100\u001a\u00020\u00032\f\u00101\u001a\b\u0012\u0004\u0012\u0002020\f2\b\u00103\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\rH\u0002J!\u00107\u001a\u00020\u00192\u0012\u00108\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001309\"\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010:J\u001e\u0010;\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00152\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00040\fH\u0002J\u0018\u0010<\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010=\u001a\u00020\u0004H\u0002J\u0018\u0010>\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020?H\u0014J4\u0010@\u001a\u001e\u0012\u0004\u0012\u00020\u00030AR\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010-\u001a\u00020\u0003H\u0014J&\u0010B\u001a\u00180CR\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J4\u0010D\u001a\u001e\u0012\u0004\u0012\u00020\u00030ER\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010-\u001a\u00020\u0003H\u0014J6\u0010F\u001a \u0012\u0006\b\u0001\u0012\u00020\u00040GR\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010=\u001a\u00020\u0004H\u0014J8\u0010H\u001a\u00020\u00192\f\u0010I\u001a\b\u0012\u0004\u0012\u00020K0J2\u0006\u0010L\u001a\u0002052\u0018\u0010M\u001a\u0014\u0012\u0004\u0012\u00020K\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r090NH\u0016R \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010O\u001a\u00020PX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "Lcom/intellij/database/dialects/exasol/model/ExaRoot;", "Lcom/intellij/database/dialects/exasol/model/ExaDatabase;", "Lcom/intellij/database/dialects/exasol/model/ExaLikeSchema;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "<init>", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/model/ModelFactory;)V", "privileges", "", "", "getPrivileges", "()Ljava/util/List;", "setPrivileges", "(Ljava/util/List;)V", "reifyDatabase", "Lcom/intellij/database/model/basic/BasicDatabase;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "databaseName", "findDatabase", "introspectDatabase", "", "task", "Lcom/intellij/database/introspection/DatabaseIntrospectionTask;", "introspectSchemas", "Lcom/intellij/database/introspection/SchemasIntrospectionTask;", "introspectAutomatically", "tran", "namespaces", "", "Lcom/intellij/database/model/basic/BasicNamespace;", "introspectRootObjects", "getDefaultScope", "Lcom/intellij/database/util/TreePattern;", "introspectPrivileges", "introspectConnections", "introspectUsers", "introspectRoles", "introspectNamespaces", "Lcom/intellij/database/introspection/IntrospectionTask;", "retrieveSchemasOfDatabase", "database", "introspectNamespacesInTran", "applySchemas", "db", "schemas", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$SchemaInfo;", "opened", "isSystemSchema", "", "name", "introspectDatabaseSchemas", "databases", "", "([Lcom/intellij/database/model/basic/BasicDatabase;)V", "introspectSchemasAuto", "introspectOneSchema", "schema", "introspectDatabaseFragments", "Lcom/intellij/database/introspection/DatabaseFragmentIntrospectionTask;", "createDatabaseRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractDatabaseRetriever;", "createServerObjectsRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractServerObjectsRetriever;", "createNativeRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractNativeRetriever;", "createSchemaRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "introspectNativeDefinitions", "elements", "", "Lcom/intellij/database/model/basic/BasicElement;", "withNestedElements", "result", "", "SURROGATE_PATTERN", "Lkotlin/text/Regex;", "Factory", "Companion", "ExaVSchemaRetriever", "ExaSchemaRetriever", "ExaSchemaRetrieverBase", "ExaSysSchemaRetriever", "intellij.database.dialects.exasol"})
@SourceDebugExtension(value={"SMAP\nExaIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExaIntrospector.kt\ncom/intellij/database/dialects/exasol/introspector/ExaIntrospector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n*L\n1#1,504:1\n865#2,2:505\n865#2,2:507\n195#3,14:509\n178#3,8:523\n178#3,8:531\n178#3,8:539\n178#3,8:547\n*S KotlinDebug\n*F\n+ 1 ExaIntrospector.kt\ncom/intellij/database/dialects/exasol/introspector/ExaIntrospector\n*L\n102#1:505,2\n103#1:507,2\n191#1:509,14\n125#1:523,8\n140#1:531,8\n154#1:539,8\n180#1:547,8\n*E\n"})
public final class ExaIntrospector
extends BaseNativeIntrospector<ExaRoot, ExaDatabase, ExaLikeSchema> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private List<String> privileges;
    @NotNull
    private final Regex SURROGATE_PATTERN;

    public ExaIntrospector(@NotNull DBIntrospectionContext context, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        BaseIntrospector.Nature nature = Companion;
        Dbms dbms = Dbms.EXASOL;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"EXASOL");
        super(context, nature, dbms, modelFactory);
        this.privileges = CollectionsKt.emptyList();
        this.SURROGATE_PATTERN = new Regex("SYS_\\d+");
    }

    @NotNull
    public final List<String> getPrivileges() {
        return this.privileges;
    }

    public final void setPrivileges(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.privileges = list;
    }

    @Override
    @Nullable
    protected BasicDatabase reifyDatabase(@NotNull DBTransaction transaction, @NotNull String databaseName) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        BasicDatabase database = this.findDatabase(databaseName);
        if (database == null) {
            this.introspectNamespacesInTran(transaction);
            database = this.findDatabase(databaseName);
        }
        return database;
    }

    @Override
    @Nullable
    protected BasicDatabase findDatabase(@NotNull String databaseName) {
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        return Intrinsics.areEqual((Object)databaseName, (Object)"@") ? ((ExaRoot)this.getRoot()).getCurrentDatabase() : (BasicDatabase)((ExaRoot)this.getRoot()).findDatabaseByName(databaseName);
    }

    @Override
    protected void introspectDatabase(@NotNull DBTransaction transaction, @NotNull DatabaseIntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        BasicDatabase basicDatabase = this.getDatabase(task);
        if (basicDatabase == null) {
            IntrospectionQueryContext.logWarn$default(this, "Cannot find database with name '" + task.getDatabaseName() + "'.", null, 2, null);
            return;
        }
        BasicDatabase database = basicDatabase;
        this.introspectAutoInTran(transaction, SetsKt.setOf((Object)database));
    }

    @Override
    protected void introspectSchemas(@NotNull DBTransaction transaction, @NotNull SchemasIntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        BasicDatabase basicDatabase = this.getDatabase(task);
        if (basicDatabase == null) {
            IntrospectionQueryContext.logWarn$default(this, "Cannot find database with name '" + task.getDatabaseName() + "'.", null, 2, null);
            return;
        }
        BasicDatabase database = basicDatabase;
        NamingFamily<? extends BasicSchema> namingFamily = database.getSchemas();
        Intrinsics.checkNotNullExpressionValue(namingFamily, (String)"getSchemas(...)");
        List schemas = ModelFun.elementsByNames(namingFamily, task.getSchemaNames());
        this.introspectAutoInTran(transaction, schemas);
    }

    @Override
    protected void introspectAutomatically(@NotNull DBTransaction tran, @Nullable Collection<? extends BasicNamespace> namespaces2) {
        Iterable<BasicNamespace> iterable;
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        Iterable<BasicNamespace> iterable2 = namespaces2;
        if (iterable2 == null || iterable2.isEmpty()) {
            this.introspectNamespacesInTran(tran);
            iterable2 = ((ExaRoot)this.getRoot()).getNamespaces();
            Intrinsics.checkNotNull(iterable2);
            iterable = iterable2;
        } else {
            iterable = namespaces2;
        }
        Iterable<BasicNamespace> toProcess = iterable;
        List schemas = new ArrayList();
        for (BasicNamespace basicNamespace : toProcess) {
            boolean bl;
            ExaLikeSchema it;
            if (basicNamespace instanceof ExaLikeSchema) {
                schemas.add(basicNamespace);
                continue;
            }
            if (!(basicNamespace instanceof ExaDatabase)) continue;
            NamingFamily namingFamily = ((ExaDatabase)basicNamespace).getSchemas();
            Intrinsics.checkNotNullExpressionValue((Object)namingFamily, (String)"getSchemas(...)");
            Iterable $this$filterTo$iv = namingFamily;
            boolean $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                it = (ExaSchema)element$iv;
                bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!this.inIntrospectionScope(it)) continue;
                ((Collection)schemas).add(element$iv);
            }
            ModNamingIdentifyingFamily<? extends ExaVirtualSchema> modNamingIdentifyingFamily = ((ExaDatabase)basicNamespace).getVirtualSchemas();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getVirtualSchemas(...)");
            $this$filterTo$iv = modNamingIdentifyingFamily;
            $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                it = (ExaVirtualSchema)element$iv;
                bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!this.inIntrospectionScope(it)) continue;
                ((Collection)schemas).add(element$iv);
            }
        }
        this.introspectRootObjects(tran);
        this.introspectSchemasAuto(tran, schemas);
    }

    private final void introspectRootObjects(DBTransaction tran) {
        this.introspectPrivileges(tran);
        this.introspectConnections(tran);
        this.introspectUsers(tran);
        this.introspectRoles(tran);
    }

    @Override
    @NotNull
    public TreePattern getDefaultScope() {
        return BaseMultiDatabaseIntrospectorKt.getMULTI_DB_SCOPE();
    }

    private final void introspectPrivileges(DBTransaction tran) {
        this.privileges = ExaIntroQueries.INSTANCE.retrievePrivileges(tran);
    }

    private final void introspectConnections(DBTransaction tran) {
        this.inModel(arg_0 -> ExaIntrospector.introspectConnections$lambda$5(tran, this, arg_0));
    }

    private final void introspectUsers(DBTransaction tran) {
        this.inModel(arg_0 -> ExaIntrospector.introspectUsers$lambda$9(tran, arg_0));
    }

    private final void introspectRoles(DBTransaction tran) {
        this.inModel(arg_0 -> ExaIntrospector.introspectRoles$lambda$13(tran, arg_0));
    }

    @Override
    protected void introspectNamespaces(@NotNull DBTransaction transaction, @NotNull IntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.introspectNamespacesInTran(transaction);
    }

    @Override
    protected void retrieveSchemasOfDatabase(@NotNull DBTransaction transaction, @NotNull BasicDatabase database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        this.introspectNamespacesInTran(transaction);
    }

    @Override
    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        BasicRoot basicRoot = this.getModel().getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)basicRoot, (String)"getRoot(...)");
        List<ExaIntroQueries.SchemaInfo> schemas = ExaIntroQueries.INSTANCE.retrieveAllSchemas(tran, basicRoot);
        boolean wasEmpty = this.getModel().getModelRoots().isEmpty();
        String opened2 = wasEmpty ? ExaIntroQueries.INSTANCE.retrieveOpenedSchema(tran) : null;
        this.inModel(arg_0 -> ExaIntrospector.introspectNamespacesInTran$lambda$16(this, schemas, opened2, arg_0));
    }

    private final void applySchemas(ExaDatabase db, List<ExaIntroQueries.SchemaInfo> schemas, String opened2) {
        boolean wasEmpty = db.getSchemas().isEmpty() && db.getVirtualSchemas().isEmpty();
        ModFamily[] modFamilyArray = new ModFamily[]{db.getSchemas(), db.getVirtualSchemas()};
        ModFamily[] families$iv = modFamilyArray;
        boolean removeUnaffected$iv = true;
        boolean $i$f$modifyFamiliesAndCleanup = false;
        for (ModFamily f$iv : families$iv) {
            f$iv.markChildrenAsSyncPending();
        }
        boolean bl = false;
        for (ExaIntroQueries.SchemaInfo info2 : schemas) {
            long id = info2.id == 0L && this.isSystemSchema(info2.name) ? Long.MIN_VALUE : info2.id;
            Object e = (info2.is_virtual ? db.getVirtualSchemas() : db.getSchemas()).renew(id, info2.name);
            Intrinsics.checkNotNullExpressionValue(e, (String)"renew(...)");
            ExaLikeSchema schema = (ExaLikeSchema)e;
            schema.setComment(info2.comment);
            schema.setOwnerRef(BasicNameReference.create(info2.owner));
            if (!wasEmpty) continue;
            schema.setCurrent(Intrinsics.areEqual((Object)schema.getName(), (Object)opened2));
        }
        for (ModFamily f$iv : families$iv) {
            f$iv.removeSyncPendingChildren();
            f$iv.sort();
        }
    }

    private final boolean isSystemSchema(String name2) {
        return Intrinsics.areEqual((Object)name2, (Object)"SYS") || Intrinsics.areEqual((Object)name2, (Object)"EXA_STATISTICS");
    }

    @Override
    public void introspectDatabaseSchemas(BasicDatabase ... databases) {
        Intrinsics.checkNotNullParameter((Object)databases, (String)"databases");
        this.introspectNamespaces();
    }

    private final void introspectSchemasAuto(DBTransaction tran, List<? extends ExaLikeSchema> schemas) {
        for (ExaLikeSchema exaLikeSchema : schemas) {
            this.introspectOneSchema(tran, exaLikeSchema);
        }
    }

    private final void introspectOneSchema(DBTransaction tran, ExaLikeSchema schema) {
        this.handleErrors("Introspect schema " + schema.getName(), (Function0<Unit>)((Function0)() -> ExaIntrospector.introspectOneSchema$lambda$18(this, tran, schema)));
    }

    @Override
    protected void introspectDatabaseFragments(@NotNull DBTransaction transaction, @NotNull DatabaseFragmentIntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
    }

    @Override
    @NotNull
    protected BaseNativeIntrospector.AbstractDatabaseRetriever<ExaDatabase> createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull ExaDatabase database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        throw new NotImplementedError(null, 1, null);
    }

    @Override
    @NotNull
    protected BaseNativeIntrospector.AbstractServerObjectsRetriever createServerObjectsRetriever(@NotNull DBTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        return new BaseNativeIntrospector.AbstractServerObjectsRetriever(this, transaction){};
    }

    @Override
    @NotNull
    protected BaseNativeIntrospector.AbstractNativeRetriever<ExaDatabase> createNativeRetriever(@NotNull DBTransaction transaction, @NotNull ExaDatabase database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        throw new NotImplementedError(null, 1, null);
    }

    @Override
    @NotNull
    protected BaseNativeIntrospector.AbstractSchemaRetriever<? extends ExaLikeSchema> createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull ExaLikeSchema schema) {
        BaseNativeIntrospector.AbstractSchemaRetriever abstractSchemaRetriever;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        if (schema instanceof ExaSchema) {
            String string = ((ExaSchema)schema).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            abstractSchemaRetriever = this.isSystemSchema(string) ? (ExaSchemaRetrieverBase)new ExaSysSchemaRetriever(transaction, (ExaSchema)schema) : (ExaSchemaRetrieverBase)new ExaSchemaRetriever(transaction, (ExaSchema)schema);
        } else {
            abstractSchemaRetriever = new ExaVSchemaRetriever(transaction, (ExaVirtualSchema)schema);
        }
        return abstractSchemaRetriever;
    }

    @Override
    public void introspectNativeDefinitions(@NotNull Iterable<? extends BasicElement> elements, boolean withNestedElements, @NotNull Map<BasicElement, String[]> result2) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
    }

    private static final Unit introspectConnections$lambda$5$lambda$4$lambda$3(ModNamingFamily $connections, ExaIntroQueries.ConnectionInfo connection2) {
        Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
        Object e = $connections.createOrGet(connection2.name);
        ExaConnection $this$introspectConnections_u24lambda_u245_u24lambda_u244_u24lambda_u243_u24lambda_u242 = (ExaConnection)e;
        boolean bl = false;
        $this$introspectConnections_u24lambda_u245_u24lambda_u244_u24lambda_u243_u24lambda_u242.setComment(connection2.comment);
        $this$introspectConnections_u24lambda_u245_u24lambda_u244_u24lambda_u243_u24lambda_u242.setConnectionString(connection2.connection_string);
        $this$introspectConnections_u24lambda_u245_u24lambda_u244_u24lambda_u243_u24lambda_u242.setUser(connection2.user_name);
        $this$introspectConnections_u24lambda_u245_u24lambda_u244_u24lambda_u243_u24lambda_u242.setPassword(null);
        return Unit.INSTANCE;
    }

    private static final Unit introspectConnections$lambda$5(DBTransaction $tran, ExaIntrospector this$0, ExaRoot root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        ModFamily $this$modifyAndCleanup_u24default$iv = root.getConnections();
        boolean removeUnaffected$iv = true;
        boolean $i$f$modifyAndCleanup = false;
        $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
        ModNamingFamily connections = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
        boolean bl = false;
        ExaIntroQueries.INSTANCE.processConnections($tran, this$0.privileges.contains("SELECT ANY DICTIONARY"), (Function1<? super ExaIntroQueries.ConnectionInfo, Unit>)((Function1)arg_0 -> ExaIntrospector.introspectConnections$lambda$5$lambda$4$lambda$3(connections, arg_0)));
        $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
        $this$modifyAndCleanup_u24default$iv.sort();
        return Unit.INSTANCE;
    }

    private static final Unit introspectUsers$lambda$9$lambda$8$lambda$7(ModNamingFamily $users, ExaIntroQueries.UserInfo user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Object e = $users.createOrGet(user.name);
        ExaUser $this$introspectUsers_u24lambda_u249_u24lambda_u248_u24lambda_u247_u24lambda_u246 = (ExaUser)e;
        boolean bl = false;
        $this$introspectUsers_u24lambda_u249_u24lambda_u248_u24lambda_u247_u24lambda_u246.setComment(user.comment);
        $this$introspectUsers_u24lambda_u249_u24lambda_u248_u24lambda_u247_u24lambda_u246.setSystem(user.is_system);
        $this$introspectUsers_u24lambda_u249_u24lambda_u248_u24lambda_u247_u24lambda_u246.setPassword(null);
        return Unit.INSTANCE;
    }

    private static final Unit introspectUsers$lambda$9(DBTransaction $tran, ExaRoot root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        ModFamily $this$modifyAndCleanup_u24default$iv = root.getUsers();
        boolean removeUnaffected$iv = true;
        boolean $i$f$modifyAndCleanup = false;
        $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
        ModNamingFamily users = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
        boolean bl = false;
        ExaIntroQueries.INSTANCE.processUsers($tran, (Function1<? super ExaIntroQueries.UserInfo, Unit>)((Function1)arg_0 -> ExaIntrospector.introspectUsers$lambda$9$lambda$8$lambda$7(users, arg_0)));
        $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
        $this$modifyAndCleanup_u24default$iv.sort();
        return Unit.INSTANCE;
    }

    private static final Unit introspectRoles$lambda$13$lambda$12$lambda$11(ModNamingFamily $roles, ExaIntroQueries.RoleInfo role) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        Object e = $roles.createOrGet(role.name);
        ExaRole $this$introspectRoles_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410 = (ExaRole)e;
        boolean bl = false;
        $this$introspectRoles_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.setComment(role.comment);
        $this$introspectRoles_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.setSystem(role.is_system);
        return Unit.INSTANCE;
    }

    private static final Unit introspectRoles$lambda$13(DBTransaction $tran, ExaRoot root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        ModFamily $this$modifyAndCleanup_u24default$iv = root.getRoles();
        boolean removeUnaffected$iv = true;
        boolean $i$f$modifyAndCleanup = false;
        $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
        ModNamingFamily roles = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
        boolean bl = false;
        ExaIntroQueries.INSTANCE.processRoles($tran, (Function1<? super ExaIntroQueries.RoleInfo, Unit>)((Function1)arg_0 -> ExaIntrospector.introspectRoles$lambda$13$lambda$12$lambda$11(roles, arg_0)));
        $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
        $this$modifyAndCleanup_u24default$iv.sort();
        return Unit.INSTANCE;
    }

    private static final Unit introspectNamespacesInTran$lambda$16(ExaIntrospector this$0, List $schemas, String $opened, ExaRoot root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        ModFamily $this$modifyAndCleanup_u24default$iv = (ModFamily)((Object)root.getDatabases());
        boolean removeUnaffected$iv = true;
        boolean $i$f$modifyAndCleanup = false;
        $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
        ModNamingFamily databases = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
        boolean bl = false;
        Object e = databases.createOrGet("EXA_DB");
        ExaDatabase $this$introspectNamespacesInTran_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414 = (ExaDatabase)e;
        boolean bl2 = false;
        $this$introspectNamespacesInTran_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414.setCurrent(true);
        $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
        $this$modifyAndCleanup_u24default$iv.sort();
        Object e2 = root.getDatabases().first();
        Intrinsics.checkNotNullExpressionValue(e2, (String)"first(...)");
        this$0.applySchemas((ExaDatabase)e2, $schemas, $opened);
        return Unit.INSTANCE;
    }

    private static final Unit introspectOneSchema$lambda$18(ExaIntrospector this$0, DBTransaction $tran, ExaLikeSchema $schema) {
        BaseNativeIntrospector.AbstractSchemaRetriever<? extends ExaLikeSchema> retriever = this$0.createSchemaRetriever($tran, $schema);
        retriever.process();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector$Companion;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$Nature;", "<init>", "()V", "supportServerObjects", "", "getSupportServerObjects", "()Z", "supportFragmentIntrospection", "getSupportFragmentIntrospection", "supportFragmentKinds", "", "Lcom/intellij/database/model/ObjectKind;", "getSupportFragmentKinds", "()Ljava/util/Set;", "intellij.database.dialects.exasol"})
    private static final class Companion
    implements BaseIntrospector.Nature {
        private Companion() {
        }

        @Override
        public boolean getSupportServerObjects() {
            return false;
        }

        @Override
        public boolean getSupportFragmentIntrospection() {
            return false;
        }

        @Override
        @NotNull
        public Set<ObjectKind> getSupportFragmentKinds() {
            return SetsKt.emptySet();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0002J\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0002J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0002J\u0016\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0002J\u0018\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J \u0010\u001b\u001a\u00020\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002\u00a8\u0006!"}, d2={"Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector$ExaSchemaRetriever;", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector$ExaSchemaRetrieverBase;", "Lcom/intellij/database/dialects/exasol/model/ExaSchema;", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "<init>", "(Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/exasol/model/ExaSchema;)V", "process", "", "retrieveScriptSources", "retrieveViewSources", "retrieveFunctionSources", "refineFunctionArgumentsFromSource", "func", "Lcom/intellij/database/model/basic/BasicModRoutine;", "src", "", "parseRoutine", "Lcom/intellij/database/model/DasRoutine;", "retrieveIndices", "parseIndexColumns", "", "info", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$IndexInfo;", "retrieveConstraints", "setUpConstraint", "con", "Lcom/intellij/database/dialects/exasol/model/ExaConstraint;", "cols", "", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$ConstraintColumnInfo;", "intellij.database.dialects.exasol"})
    @SourceDebugExtension(value={"SMAP\nExaIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExaIntrospector.kt\ncom/intellij/database/dialects/exasol/introspector/ExaIntrospector$ExaSchemaRetriever\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 6 BaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospector\n+ 7 IntrospectorSqlHelper.kt\ncom/intellij/database/dialects/base/introspector/IntrospectorSqlHelper\n+ 8 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/NameCache\n*L\n1#1,504:1\n1557#2:505\n1628#2,3:506\n1557#2:555\n1628#2,3:556\n1872#2,3:592\n1557#2:606\n1628#2,3:607\n1863#2,2:632\n1557#2:640\n1628#2,3:641\n1557#2:644\n1628#2,3:645\n1557#2:648\n1628#2,3:649\n303#3,4:509\n307#3:517\n198#3,5:518\n204#3,5:536\n308#3:541\n303#3,4:559\n307#3:567\n198#3,5:568\n204#3,5:586\n308#3:591\n303#3,4:610\n307#3:618\n198#3,11:619\n308#3:630\n322#3:631\n325#3,6:634\n37#4:513\n36#4,3:514\n37#4:563\n36#4,3:564\n37#4:614\n36#4,3:615\n382#5:523\n383#5,2:529\n382#5:542\n383#5,2:548\n382#5:573\n383#5,2:579\n139#5,2:595\n142#5,8:598\n1039#6:524\n1134#6,2:525\n1040#6,2:527\n1044#6:531\n1139#6,2:532\n1045#6,2:534\n1039#6:543\n1134#6,2:544\n1040#6,2:546\n1044#6:550\n1139#6,2:551\n1045#6,2:553\n1039#6:574\n1134#6,2:575\n1040#6,2:577\n1044#6:581\n1139#6,2:582\n1045#6,2:584\n26#7:597\n409#8,6:652\n409#8,6:658\n412#8,3:664\n*S KotlinDebug\n*F\n+ 1 ExaIntrospector.kt\ncom/intellij/database/dialects/exasol/introspector/ExaIntrospector$ExaSchemaRetriever\n*L\n293#1:505\n293#1:506,3\n322#1:555\n322#1:556,3\n337#1:592,3\n352#1:606\n352#1:607,3\n371#1:632,2\n399#1:640\n399#1:641,3\n407#1:644\n407#1:645,3\n408#1:648\n408#1:649,3\n293#1:509,4\n293#1:517\n293#1:518,5\n293#1:536,5\n293#1:541\n322#1:559,4\n322#1:567\n322#1:568,5\n322#1:586,5\n322#1:591\n352#1:610,4\n352#1:618\n352#1:619,11\n352#1:630\n371#1:631\n371#1:634,6\n293#1:513\n293#1:514,3\n322#1:563\n322#1:564,3\n352#1:614\n352#1:615,3\n294#1:523\n294#1:529,2\n312#1:542\n312#1:548,2\n323#1:573\n323#1:579,2\n349#1:595,2\n349#1:598,8\n294#1:524\n294#1:525,2\n294#1:527,2\n294#1:531\n294#1:532,2\n294#1:534,2\n312#1:543\n312#1:544,2\n312#1:546,2\n312#1:550\n312#1:551,2\n312#1:553,2\n323#1:574\n323#1:575,2\n323#1:577,2\n323#1:581\n323#1:582,2\n323#1:584,2\n349#1:597\n355#1:652,6\n376#1:658,6\n381#1:664,3\n*E\n"})
    private final class ExaSchemaRetriever
    extends ExaSchemaRetrieverBase<ExaSchema> {
        public ExaSchemaRetriever(@NotNull DBTransaction transaction, ExaSchema schema) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super(ExaIntrospector.this, transaction, (ExaLikeSchema)schema);
        }

        @Override
        public void process() {
            this.inSchema(arg_0 -> ExaSchemaRetriever.process$lambda$0(this, arg_0));
            this.inSchema(arg_0 -> ExaSchemaRetriever.process$lambda$1(this, arg_0));
            this.inSchema(arg_0 -> ExaSchemaRetriever.process$lambda$2(this, arg_0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public final void retrieveScriptSources(@NotNull ExaSchema schema) {
            void this_$iv$iv;
            void families$iv;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModNamingIdentifyingFamily<? extends ExaScript> modNamingIdentifyingFamily = schema.getScripts();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getScripts(...)");
            Iterable $this$map$iv = modNamingIdentifyingFamily;
            boolean $i$f$map = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ExaScript exaScript = (ExaScript)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getArguments());
            }
            $this$map$iv = (List)destination$iv$iv;
            object = ExaIntrospector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            void $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModPositioningNamingFamily[0]);
            ModFamily[] families$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)object;
            boolean $i$f$writeSources = false;
            BaseIntrospector baseIntrospector = this_$iv;
            String name$iv$iv = "WriteSources";
            boolean $i$f$doSection = false;
            CharSequence message$iv$iv$iv = null;
            boolean $i$f$logSectionBegin = false;
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv);
            DiagnosticSectionReference ref$iv$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin(name$iv$iv, message$iv$iv$iv) : null;
            try {
                boolean bl2 = false;
                this_$iv.getModel().writeSources(new Runnable(this, schema){
                    final /* synthetic */ ExaSchemaRetriever this$0;
                    final /* synthetic */ ExaSchema $schema$inlined;
                    {
                        this.this$0 = exaSchemaRetriever;
                        this.$schema$inlined = exaSchema;
                    }

                    public final void run() {
                        boolean bl = false;
                        ExaIntroQueries.INSTANCE.processScripts(ExaSchemaRetriever.access$getTransaction(this.this$0), this.$schema$inlined, (Function1<? super ExaIntroQueries.ScriptInfo, Unit>)((Function1)new Function1<ExaIntroQueries.ScriptInfo, Unit>(this.$schema$inlined, this.this$0){
                            final /* synthetic */ ExaSchema $schema;
                            final /* synthetic */ ExaSchemaRetriever this$0;
                            {
                                this.$schema = $schema;
                                this.this$0 = $receiver;
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final void invoke(ExaIntroQueries.ScriptInfo info) {
                                block15: {
                                    Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                                    v0 = (ExaScript)this.$schema.getScripts().get(info.name);
                                    if (v0 == null) break block15;
                                    var2_2 = v0;
                                    var3_3 = this.this$0;
                                    $this$invoke_u24lambda_u242 = var2_2;
                                    $i$a$-apply-ExaIntrospector$ExaSchemaRetriever$retrieveScriptSources$2$1$1$1 = false;
                                    var6_6 = info.type;
                                    if (var6_6 == null) ** GOTO lbl-1000
                                    tmp = -1;
                                    switch (var6_6.hashCode()) {
                                        case 83863: {
                                            if (var6_6.equals("UDF")) {
                                                tmp = 1;
                                            }
                                            break;
                                        }
                                        case -432525521: {
                                            if (var6_6.equals("ADAPTER")) {
                                                tmp = 2;
                                            }
                                            break;
                                        }
                                        case -1258414313: {
                                            if (var6_6.equals("SCRIPTING")) {
                                                tmp = 3;
                                            }
                                            break;
                                        }
                                    }
                                    switch (tmp) {
                                        case 1: {
                                            v1 = ExaScriptType.UDF;
                                            break;
                                        }
                                        case 3: {
                                            v1 = ExaScriptType.SCRIPTING;
                                            break;
                                        }
                                        case 2: {
                                            v1 = ExaScriptType.ADAPTER;
                                            break;
                                        }
                                        default: lbl-1000:
                                        // 2 sources

                                        {
                                            v1 = ExaScriptType.SCRIPTING;
                                        }
                                    }
                                    $this$invoke_u24lambda_u242.setScriptType(v1);
                                    v2 = $this$invoke_u24lambda_u242;
                                    v3 = info.text;
                                    if (v3 != null) {
                                        var7_7 = v3;
                                        var8_8 = v2;
                                        $i$a$-let-ExaIntrospector$ExaSchemaRetriever$retrieveScriptSources$2$1$1$1$1 = false;
                                        v4 = new SimpleCompositeText((CharSequence)it, CompositeText.Kind.ORIGINAL_TEXT);
                                        v2 = var8_8;
                                    } else {
                                        v4 = null;
                                    }
                                    v2.setSourceText(v4);
                                    v5 = info.text;
                                    if (v5 == null) break block15;
                                    it = v5;
                                    $i$a$-let-ExaIntrospector$ExaSchemaRetriever$retrieveScriptSources$2$1$1$1$2 = false;
                                    var3_3.refineFunctionArgumentsFromSource($this$invoke_u24lambda_u242, it);
                                }
                            }
                        }));
                    }
                });
            }
            finally {
                void this_$iv$iv$iv = this_$iv$iv;
                boolean $i$f$logSectionEnd = false;
                if (ref$iv$iv != null) {
                    DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv);
                    if (dataSourceDiagnosticRecorder2 != null) {
                        DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder2, ref$iv$iv, null, 2, null);
                    }
                }
            }
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public final void retrieveViewSources(@NotNull ExaSchema schema) {
            void this_$iv$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            BaseNativeIntrospector this_$iv = ExaIntrospector.this;
            boolean $i$f$writeSources = false;
            BaseIntrospector baseIntrospector = this_$iv;
            String name$iv$iv = "WriteSources";
            boolean $i$f$doSection = false;
            CharSequence message$iv$iv$iv = null;
            boolean $i$f$logSectionBegin = false;
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv);
            DiagnosticSectionReference ref$iv$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin(name$iv$iv, message$iv$iv$iv) : null;
            try {
                boolean bl = false;
                this_$iv.getModel().writeSources(new Runnable(this, schema){
                    final /* synthetic */ ExaSchemaRetriever this$0;
                    final /* synthetic */ ExaSchema $schema$inlined;
                    {
                        this.this$0 = exaSchemaRetriever;
                        this.$schema$inlined = exaSchema;
                    }

                    public final void run() {
                        boolean bl = false;
                        ExaIntroQueries.INSTANCE.processViews(ExaSchemaRetriever.access$getTransaction(this.this$0), this.$schema$inlined, (Function1<? super ExaIntroQueries.ViewInfo, Unit>)((Function1)new Function1<ExaIntroQueries.ViewInfo, Unit>(this.$schema$inlined){
                            final /* synthetic */ ExaSchema $schema;
                            {
                                this.$schema = $schema;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke(ExaIntroQueries.ViewInfo info2) {
                                block2: {
                                    SimpleCompositeText simpleCompositeText;
                                    ExaView exaView;
                                    Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
                                    ExaView exaView2 = (ExaView)this.$schema.getViews().get(info2.name);
                                    if (exaView2 == null) break block2;
                                    ExaView $this$invoke_u24lambda_u241 = exaView = exaView2;
                                    boolean bl = false;
                                    ExaView exaView3 = $this$invoke_u24lambda_u241;
                                    String string = info2.text;
                                    if (string != null) {
                                        void it;
                                        String string2 = string;
                                        ExaView exaView4 = exaView3;
                                        boolean bl2 = false;
                                        simpleCompositeText = new SimpleCompositeText((CharSequence)it, CompositeText.Kind.ORIGINAL_TEXT);
                                        exaView3 = exaView4;
                                    } else {
                                        simpleCompositeText = null;
                                    }
                                    exaView3.setSourceText(simpleCompositeText);
                                }
                            }
                        }));
                    }
                });
            }
            finally {
                void this_$iv$iv$iv = this_$iv$iv;
                boolean $i$f$logSectionEnd = false;
                if (ref$iv$iv != null) {
                    DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv);
                    if (dataSourceDiagnosticRecorder2 != null) {
                        DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder2, ref$iv$iv, null, 2, null);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public final void retrieveFunctionSources(@NotNull ExaSchema schema) {
            void this_$iv$iv;
            void families$iv;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModNamingIdentifyingFamily<? extends ExaRoutine> modNamingIdentifyingFamily = schema.getRoutines();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getRoutines(...)");
            Iterable $this$map$iv = modNamingIdentifyingFamily;
            boolean $i$f$map = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ExaRoutine exaRoutine = (ExaRoutine)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getArguments());
            }
            $this$map$iv = (List)destination$iv$iv;
            object = ExaIntrospector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            void $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModPositioningNamingFamily[0]);
            ModFamily[] families$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)object;
            boolean $i$f$writeSources = false;
            BaseIntrospector baseIntrospector = this_$iv;
            String name$iv$iv = "WriteSources";
            boolean $i$f$doSection = false;
            CharSequence message$iv$iv$iv = null;
            boolean $i$f$logSectionBegin = false;
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv);
            DiagnosticSectionReference ref$iv$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin(name$iv$iv, message$iv$iv$iv) : null;
            try {
                boolean bl2 = false;
                this_$iv.getModel().writeSources(new Runnable(this, schema){
                    final /* synthetic */ ExaSchemaRetriever this$0;
                    final /* synthetic */ ExaSchema $schema$inlined;
                    {
                        this.this$0 = exaSchemaRetriever;
                        this.$schema$inlined = exaSchema;
                    }

                    public final void run() {
                        boolean bl = false;
                        ExaIntroQueries.INSTANCE.processFunctions(ExaSchemaRetriever.access$getTransaction(this.this$0), this.$schema$inlined, (Function1<? super ExaIntroQueries.FunctionInfo, Unit>)((Function1)new Function1<ExaIntroQueries.FunctionInfo, Unit>(this.$schema$inlined, this.this$0){
                            final /* synthetic */ ExaSchema $schema;
                            final /* synthetic */ ExaSchemaRetriever this$0;
                            {
                                this.$schema = $schema;
                                this.this$0 = $receiver;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke(ExaIntroQueries.FunctionInfo info2) {
                                block3: {
                                    SimpleCompositeText simpleCompositeText;
                                    Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
                                    ExaRoutine exaRoutine = (ExaRoutine)this.$schema.getRoutines().get(info2.name);
                                    if (exaRoutine == null) break block3;
                                    ExaRoutine exaRoutine2 = exaRoutine;
                                    ExaSchemaRetriever exaSchemaRetriever = this.this$0;
                                    ExaRoutine $this$invoke_u24lambda_u241 = exaRoutine2;
                                    boolean bl = false;
                                    ExaRoutine exaRoutine3 = $this$invoke_u24lambda_u241;
                                    String string = info2.text;
                                    if (string != null) {
                                        void it;
                                        String string2 = string;
                                        ExaRoutine exaRoutine4 = exaRoutine3;
                                        boolean bl2 = false;
                                        simpleCompositeText = new SimpleCompositeText((CharSequence)it, CompositeText.Kind.ORIGINAL_TEXT);
                                        exaRoutine3 = exaRoutine4;
                                    } else {
                                        simpleCompositeText = null;
                                    }
                                    exaRoutine3.setSourceText(simpleCompositeText);
                                    if (info2.text != null) {
                                        exaSchemaRetriever.refineFunctionArgumentsFromSource($this$invoke_u24lambda_u241, "create " + info2.text);
                                    }
                                }
                            }
                        }));
                    }
                });
            }
            finally {
                void this_$iv$iv$iv = this_$iv$iv;
                boolean $i$f$logSectionEnd = false;
                if (ref$iv$iv != null) {
                    DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv);
                    if (dataSourceDiagnosticRecorder2 != null) {
                        DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder2, ref$iv$iv, null, 2, null);
                    }
                }
            }
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void refineFunctionArgumentsFromSource(@NotNull BasicModRoutine func, @NotNull String src) {
            void $this$forEachIndexed$iv;
            Intrinsics.checkNotNullParameter((Object)func, (String)"func");
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            DasRoutine dasRoutine = this.parseRoutine(src);
            if (dasRoutine == null) {
                return;
            }
            DasRoutine psiFunc = dasRoutine;
            ExaIntrospector.this.getSqlHelper().getBuilder().build(func, psiFunc, ExaIntrospector.this.getSqlHelper().getBuilderContext());
            Iterable<? extends DasArgument> iterable = psiFunc.getArguments();
            Intrinsics.checkNotNullExpressionValue(iterable, (String)"getArguments(...)");
            Iterable<? extends DasArgument> iterable2 = iterable;
            ExaIntrospector exaIntrospector = ExaIntrospector.this;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void psiArg;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                DasArgument dasArgument = (DasArgument)item$iv;
                int i2 = n;
                boolean bl = false;
                exaIntrospector.getSqlHelper().getBuilder().build((BasicModElement)func.getArguments().renewAt((short)(i2 + 1), psiArg.getName()), (DasObject)psiArg, exaIntrospector.getSqlHelper().getBuilderContext());
            }
            DasArgument ret = psiFunc.getReturnArgument();
            if (func.getRoutineKind() == DasRoutine.Kind.PROCEDURE || ret == null) {
                BasicModArgument basicModArgument = (BasicModArgument)func.getReturnArgument();
                if (basicModArgument != null) {
                    basicModArgument.drop();
                }
            } else {
                ExaIntrospector.this.getSqlHelper().getBuilder().build(func.createOrGetReturnArgument(), ret, ExaIntrospector.this.getSqlHelper().getBuilderContext());
            }
        }

        private final DasRoutine parseRoutine(String src) {
            Object object;
            BaseNativeIntrospector this_$iv = ExaIntrospector.this;
            boolean $i$f$parseStatement = false;
            try {
                IntrospectorSqlHelper this_$iv$iv = BaseNativeIntrospector.access$getSqlHelper(this_$iv);
                boolean $i$f$statements = false;
                object = this_$iv$iv.statements(src, DasRoutine.class).first();
            }
            catch (ProcessCanceledException pce$iv) {
                throw pce$iv;
            }
            catch (Exception e$iv) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    this_$iv.log.error((Throwable)e$iv);
                }
                this_$iv.log.warn("Failed to parse sources", (Throwable)e$iv);
                object = null;
            }
            return (DasRoutine)object;
        }

        /*
         * WARNING - void declaration
         */
        public final void retrieveIndices(@NotNull ExaSchema schema) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModNamingIdentifyingFamily<? extends ExaTable> modNamingIdentifyingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTables(...)");
            Iterable $this$map$iv = modNamingIdentifyingFamily;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ExaTable exaTable = (ExaTable)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getIndices());
            }
            Collection families$iv = (List)destination$iv$iv;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            Collection $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModIdentifyingFamily[0]);
            ModFamily[] families$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            NameCache tableCache = new NameCache();
            ExaIntroQueries.INSTANCE.processIndices(this.getTransaction(), schema, (Function1<? super ExaIntroQueries.IndexInfo, Unit>)((Function1)arg_0 -> ExaSchemaRetriever.retrieveIndices$lambda$15$lambda$14(tableCache, schema, this, arg_0)));
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        private final List<String> parseIndexColumns(ExaIntroQueries.IndexInfo info2) {
            int start2;
            String remarks;
            String string = remarks = info2.remarks;
            int n = start2 = string != null ? StringsKt.indexOf$default((CharSequence)string, (char)'(', (int)0, (boolean)false, (int)6, null) : -1;
            if (start2 == -1 || remarks == null || start2 >= remarks.length() - 1) {
                return CollectionsKt.emptyList();
            }
            String[] stringArray = new String[]{","};
            return StringsKt.split$default((CharSequence)((CharSequence)new CharSequenceSubSequence((CharSequence)remarks, start2 + 1, remarks.length() - 1)), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        }

        private final void retrieveConstraints(ExaSchema schema) {
            boolean bl;
            ExaTable s;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            Function1 it = ExaSchemaRetriever$retrieveConstraints$$inlined$modifyFamiliesAndCleanup$1.INSTANCE;
            boolean bl2 = false;
            ModNamingIdentifyingFamily<? extends ExaTable> modNamingIdentifyingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTables(...)");
            Iterable $this$forEach$iv = modNamingIdentifyingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                s = (ExaTable)element$iv;
                bl = false;
                NamingFamily namingFamily = s.getKeys();
                Intrinsics.checkNotNullExpressionValue((Object)namingFamily, (String)"getKeys(...)");
                it.invoke((Object)namingFamily);
                NamingFamily namingFamily2 = s.getForeignKeys();
                Intrinsics.checkNotNullExpressionValue((Object)namingFamily2, (String)"getForeignKeys(...)");
                it.invoke((Object)namingFamily2);
            }
            boolean bl3 = false;
            NameCache tableCache = new NameCache();
            NameCache conCache = new NameCache();
            List conCols = new ArrayList();
            ExaIntroQueries.INSTANCE.processConstraints(this.getTransaction(), schema, (Function1<? super ExaIntroQueries.ConstraintColumnInfo, Unit>)((Function1)arg_0 -> ExaSchemaRetriever.retrieveConstraints$lambda$21$lambda$20(tableCache, conCache, conCols, this, schema, arg_0)));
            this.setUpConstraint((ExaConstraint)conCache.getV(), conCols);
            it = ExaSchemaRetriever$retrieveConstraints$$inlined$modifyFamiliesAndCleanup$2.INSTANCE;
            $i$a$-modifyFamiliesAndCleanup-ExaIntrospector$ExaSchemaRetriever$retrieveConstraints$1 = false;
            ModNamingIdentifyingFamily<? extends ExaTable> modNamingIdentifyingFamily2 = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"getTables(...)");
            $this$forEach$iv = modNamingIdentifyingFamily2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                s = (ExaTable)element$iv;
                bl = false;
                NamingFamily namingFamily = s.getKeys();
                Intrinsics.checkNotNullExpressionValue((Object)namingFamily, (String)"getKeys(...)");
                it.invoke((Object)namingFamily);
                NamingFamily namingFamily3 = s.getForeignKeys();
                Intrinsics.checkNotNullExpressionValue((Object)namingFamily3, (String)"getForeignKeys(...)");
                it.invoke((Object)namingFamily3);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void setUpConstraint(ExaConstraint con, List<ExaIntroQueries.ConstraintColumnInfo> cols) {
            boolean bl;
            ExaIntroQueries.ConstraintColumnInfo f = (ExaIntroQueries.ConstraintColumnInfo)CollectionsKt.firstOrNull(cols);
            Object object = f;
            if (object != null && (object = ((ExaIntroQueries.ConstraintColumnInfo)object).name) != null) {
                CharSequence charSequence = (CharSequence)object;
                bl = ExaIntrospector.this.SURROGATE_PATTERN.matches(charSequence);
            } else {
                bl = true;
            }
            boolean surrogate = bl;
            ExaConstraint exaConstraint = con;
            if (exaConstraint instanceof ExaKey) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                ExaConstraint exaConstraint2 = con;
                ExaKey $this$setUpConstraint_u24lambda_u2423 = (ExaKey)exaConstraint2;
                boolean bl2 = false;
                $this$setUpConstraint_u24lambda_u2423.setNameSurrogate(surrogate);
                $this$setUpConstraint_u24lambda_u2423.setPrimary(true);
                Iterable iterable = cols;
                ExaKey exaKey = $this$setUpConstraint_u24lambda_u2423;
                boolean $i$f$map = false;
                void var12_17 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ExaIntroQueries.ConstraintColumnInfo constraintColumnInfo = (ExaIntroQueries.ConstraintColumnInfo)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(it.column_name);
                }
                exaKey.setColNames((List)destination$iv$iv);
            } else if (exaConstraint instanceof ExaForeignKey) {
                Collection collection;
                ExaIntroQueries.ConstraintColumnInfo it;
                ExaConstraint exaConstraint3 = con;
                ExaForeignKey $this$setUpConstraint_u24lambda_u2426 = (ExaForeignKey)exaConstraint3;
                boolean bl4 = false;
                $this$setUpConstraint_u24lambda_u2426.setNameSurrogate(surrogate);
                ExaIntroQueries.ConstraintColumnInfo constraintColumnInfo = f;
                ExaIntroQueries.ConstraintColumnInfo constraintColumnInfo2 = f;
                $this$setUpConstraint_u24lambda_u2426.setRefTableRef(BasicParentReference.create(constraintColumnInfo != null ? constraintColumnInfo.ref_schema : null, BasicNameReference.create(constraintColumnInfo2 != null ? constraintColumnInfo2.ref_table : null)));
                Iterable $this$map$iv = cols;
                ExaForeignKey exaForeignKey = $this$setUpConstraint_u24lambda_u2426;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (ExaIntroQueries.ConstraintColumnInfo)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl5 = false;
                    collection.add(it.ref_column);
                }
                exaForeignKey.setRefColNames((List)destination$iv$iv);
                $this$map$iv = cols;
                exaForeignKey = $this$setUpConstraint_u24lambda_u2426;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (ExaIntroQueries.ConstraintColumnInfo)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl6 = false;
                    collection.add(it.column_name);
                }
                exaForeignKey.setColNames((List)destination$iv$iv);
            }
            cols.clear();
        }

        private static final Unit process$lambda$0(ExaSchemaRetriever this$0, ExaSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveAllObjects((ExaLikeSchema)schema);
            return Unit.INSTANCE;
        }

        private static final Unit process$lambda$1(ExaSchemaRetriever this$0, ExaSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveColumns((ExaLikeSchema)schema);
            this$0.retrieveConstraints(schema);
            this$0.retrieveIndices(schema);
            return Unit.INSTANCE;
        }

        private static final Unit process$lambda$2(ExaSchemaRetriever this$0, ExaSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveViewSources(schema);
            this$0.retrieveFunctionSources(schema);
            this$0.retrieveScriptSources(schema);
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit retrieveIndices$lambda$15$lambda$14(NameCache $tableCache, ExaSchema $schema, ExaSchemaRetriever this$0, ExaIntroQueries.IndexInfo info) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                var4_4 = $tableCache;
                name$iv = info.table_name;
                $i$f$get = false;
                var7_8 = this_$iv;
                create$iv$iv = false;
                $i$f$get = false;
                if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                v0 = this_$iv$iv.getV();
                Intrinsics.checkNotNull(v0);
                if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv)) {
                    v1 = this_$iv$iv.getV();
                } else lbl-1000:
                // 2 sources

                {
                    var10_11 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, name$iv){
                        final /* synthetic */ boolean $create;
                        final /* synthetic */ String $name;
                        {
                            this.$create = $create;
                            this.$name = $name;
                        }

                        public final T invoke(ModNamingFamily<? extends T> $this$family) {
                            Intrinsics.checkNotNullParameter($this$family, (String)"$this$family");
                            return (T)(this.$create ? $this$family.createOrGet(this.$name) : (BasicModNamedElement)$this$family.get(this.$name));
                        }
                    };
                    var11_12 = this_$iv$iv;
                    var13_13 = this_$iv$iv;
                    $i$a$-get-ExaIntrospector$ExaSchemaRetriever$retrieveIndices$2$1$1 = false;
                    v2 = $schema.getTables();
                    Intrinsics.checkNotNullExpressionValue(v2, (String)"getTables(...)");
                    var13_13.setV((BasicModNamedElement)((ExaTable)it.invoke(v2)));
                    v1 = this_$iv$iv.getV();
                }
                if ((v3 = (ExaTable)v1) == null || (v3 = v3.getIndices()) == null || (v3 = (ExaIndex)v3.createOrGet(info.id)) == null) break block2;
                $this$retrieveIndices_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413 = var6_7 = v3;
                $i$a$-apply-ExaIntrospector$ExaSchemaRetriever$retrieveIndices$2$1$2 = false;
                $this$retrieveIndices_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413.setGlobal(info.is_global);
                $this$retrieveIndices_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413.setColNames(this$0.parseIndexColumns(info));
            }
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit retrieveConstraints$lambda$21$lambda$20(NameCache $tableCache, NameCache $conCache, List $conCols, ExaSchemaRetriever this$0, ExaSchema $schema, ExaIntroQueries.ConstraintColumnInfo c) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            var8_6 = $tableCache;
            name$iv = c.table_name;
            $i$f$get = false;
            var11_10 = this_$iv;
            create$iv$iv = false;
            $i$f$get = false;
            if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
            v0 = this_$iv$iv.getV();
            Intrinsics.checkNotNull(v0);
            if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv)) {
                v1 = this_$iv$iv.getV();
            } else lbl-1000:
            // 2 sources

            {
                var14_14 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, name$iv){
                    final /* synthetic */ boolean $create;
                    final /* synthetic */ String $name;
                    {
                        this.$create = $create;
                        this.$name = $name;
                    }

                    public final T invoke(ModNamingFamily<? extends T> $this$family) {
                        Intrinsics.checkNotNullParameter($this$family, (String)"$this$family");
                        return (T)(this.$create ? $this$family.createOrGet(this.$name) : (BasicModNamedElement)$this$family.get(this.$name));
                    }
                };
                var15_15 = this_$iv$iv;
                var17_16 = this_$iv$iv;
                $i$a$-get-ExaIntrospector$ExaSchemaRetriever$retrieveConstraints$2$1$table$1 = false;
                ExaSchemaRetriever.access$setUpConstraint(this$0, (ExaConstraint)$conCache.getV(), $conCols);
                $conCache.setV(null);
                v2 = $schema.getTables();
                Intrinsics.checkNotNullExpressionValue(v2, (String)"getTables(...)");
                var17_16.setV((BasicModNamedElement)((ExaTable)it.invoke(v2)));
                v1 = this_$iv$iv.getV();
            }
            v3 = (ExaTable)v1;
            if (v3 == null) {
                return Unit.INSTANCE;
            }
            table = v3;
            var7_19 = $conCache;
            this_$iv = c.name;
            create$iv = true;
            $i$f$get = false;
            if (this_$iv.getV() == null) ** GOTO lbl-1000
            v4 = this_$iv.getV();
            Intrinsics.checkNotNull(v4);
            if (Intrinsics.areEqual((Object)v4.getName(), (Object)name$iv)) {
                v5 = this_$iv.getV();
            } else lbl-1000:
            // 2 sources

            {
                this_$iv$iv = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv, (String)name$iv){
                    final /* synthetic */ boolean $create;
                    final /* synthetic */ String $name;
                    {
                        this.$create = $create;
                        this.$name = $name;
                    }

                    public final T invoke(ModNamingFamily<? extends T> $this$family) {
                        Intrinsics.checkNotNullParameter($this$family, (String)"$this$family");
                        return (T)(this.$create ? $this$family.createOrGet(this.$name) : (BasicModNamedElement)$this$family.get(this.$name));
                    }
                };
                create$iv$iv = this_$iv;
                var17_16 = this_$iv;
                $i$a$-get-ExaIntrospector$ExaSchemaRetriever$retrieveConstraints$2$1$1 = false;
                ExaSchemaRetriever.access$setUpConstraint(this$0, (ExaConstraint)$this$retrieveConstraints_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419.getV(), $conCols);
                if (c.is_pk) {
                    v6 = table.getKeys();
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getKeys(...)");
                    v7 = (ExaConstraint)it.invoke((Object)v6);
                } else {
                    v8 = table.getForeignKeys();
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"getForeignKeys(...)");
                    v7 = (ExaConstraint)it.invoke((Object)v8);
                }
                var17_16.setV((BasicModNamedElement)v7);
                v5 = this_$iv.getV();
            }
            $conCols.add(c);
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ DBTransaction access$getTransaction(ExaSchemaRetriever $this) {
            return $this.getTransaction();
        }

        public static final /* synthetic */ void access$setUpConstraint(ExaSchemaRetriever $this, ExaConstraint con, List cols) {
            $this.setUpConstraint(con, cols);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0092\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u001e\u0012\u0004\u0012\u0002H\u00010\u0003R\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020\u0004B\u0017\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00028\u0000\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u000fJ\u0015\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u00112\u0006\u0010\t\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010\u0012J)\u0010\u0014\u001a\u00020\u00112\u0006\u0010\t\u001a\u00028\u00002\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00110\u0016H\u0014\u00a2\u0006\u0002\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector$ExaSchemaRetrieverBase;", "S", "Lcom/intellij/database/dialects/exasol/model/ExaLikeSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "Lcom/intellij/database/dialects/exasol/model/ExaRoot;", "Lcom/intellij/database/dialects/exasol/model/ExaDatabase;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "<init>", "(Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/exasol/model/ExaLikeSchema;)V", "isPossibleToIntrospectSchemaIncrementally", "", "tran", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/exasol/model/ExaLikeSchema;)Z", "retrieveColumns", "", "(Lcom/intellij/database/dialects/exasol/model/ExaLikeSchema;)V", "retrieveAllObjects", "processAllObjects", "it", "Lkotlin/Function1;", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$ObjectInfo;", "(Lcom/intellij/database/dialects/exasol/model/ExaLikeSchema;Lkotlin/jvm/functions/Function1;)V", "intellij.database.dialects.exasol"})
    @SourceDebugExtension(value={"SMAP\nExaIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExaIntrospector.kt\ncom/intellij/database/dialects/exasol/introspector/ExaIntrospector$ExaSchemaRetrieverBase\n+ 2 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/NameCache\n*L\n1#1,504:1\n322#2:505\n325#2,6:508\n195#2,14:515\n1863#3,2:506\n1#4:514\n409#5,6:529\n*S KotlinDebug\n*F\n+ 1 ExaIntrospector.kt\ncom/intellij/database/dialects/exasol/introspector/ExaIntrospector$ExaSchemaRetrieverBase\n*L\n421#1:505\n421#1:508,6\n443#1:515,14\n421#1:506,2\n424#1:529,6\n*E\n"})
    private static class ExaSchemaRetrieverBase<S extends ExaLikeSchema>
    extends BaseNativeIntrospector.AbstractSchemaRetriever<S> {
        final /* synthetic */ ExaIntrospector this$0;

        public ExaSchemaRetrieverBase(@NotNull DBTransaction transaction, S schema) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            this.this$0 = this$0;
            super((BaseNativeIntrospector)this$0, transaction, (BasicModSchema)schema);
        }

        @Override
        protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull S schema) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            return false;
        }

        protected final void retrieveColumns(@NotNull S schema) {
            block5: {
                boolean bl;
                boolean bl2;
                ExaLikeTable s;
                Intrinsics.checkNotNullParameter(schema, (String)"schema");
                ExaSchema exaSchema = schema instanceof ExaSchema ? (ExaSchema)schema : null;
                ModNamingIdentifyingFamily<? extends ExaView> views = exaSchema != null ? exaSchema.getViews() : null;
                boolean $i$f$modifyFamiliesAndCleanup = false;
                Function1 it = ExaSchemaRetrieverBase$retrieveColumns$$inlined$modifyFamiliesAndCleanup$1.INSTANCE;
                boolean bl3 = false;
                ModNamingIdentifyingFamily<? extends ExaLikeTable> modNamingIdentifyingFamily = schema.getTables();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTables(...)");
                Iterable $this$forEach$iv = modNamingIdentifyingFamily;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    s = (ExaLikeTable)element$iv;
                    bl2 = false;
                    PositioningNamingFamily positioningNamingFamily = s.getColumns();
                    Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                    it.invoke((Object)positioningNamingFamily);
                }
                ModNamingIdentifyingFamily<? extends ExaView> modNamingIdentifyingFamily2 = views;
                if (modNamingIdentifyingFamily2 != null) {
                    $this$forEach$iv = modNamingIdentifyingFamily2;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        s = (ExaView)element$iv;
                        bl = false;
                        PositioningNamingFamily positioningNamingFamily = s.getColumns();
                        Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                        it.invoke((Object)positioningNamingFamily);
                    }
                }
                boolean bl4 = false;
                NameCache tableCache = new NameCache();
                ExaIntroQueries.INSTANCE.processColumns(this.getTransaction(), (ExaLikeSchema)schema, (Function1<? super ExaIntroQueries.ColumnInfo, Unit>)((Function1)arg_0 -> ExaSchemaRetrieverBase.retrieveColumns$lambda$8$lambda$7(tableCache, schema, views, arg_0)));
                it = ExaSchemaRetrieverBase$retrieveColumns$$inlined$modifyFamiliesAndCleanup$2.INSTANCE;
                $i$a$-modifyFamiliesAndCleanup-ExaIntrospector$ExaSchemaRetrieverBase$retrieveColumns$1 = false;
                ModNamingIdentifyingFamily<? extends ExaLikeTable> modNamingIdentifyingFamily3 = schema.getTables();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily3, (String)"getTables(...)");
                $this$forEach$iv = modNamingIdentifyingFamily3;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    s = (ExaLikeTable)element$iv;
                    bl2 = false;
                    PositioningNamingFamily positioningNamingFamily = s.getColumns();
                    Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                    it.invoke((Object)positioningNamingFamily);
                }
                ModNamingIdentifyingFamily<? extends ExaView> modNamingIdentifyingFamily4 = views;
                if (modNamingIdentifyingFamily4 == null) break block5;
                $this$forEach$iv = modNamingIdentifyingFamily4;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    s = (ExaView)element$iv;
                    bl = false;
                    PositioningNamingFamily positioningNamingFamily = s.getColumns();
                    Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                    it.invoke((Object)positioningNamingFamily);
                }
            }
        }

        protected final void retrieveAllObjects(@NotNull S schema) {
            ModNamingIdentifyingFamily[] modNamingIdentifyingFamilyArray;
            ExaSchema s;
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            ExaSchema exaSchema = s = schema instanceof ExaSchema ? (ExaSchema)schema : null;
            if (exaSchema != null) {
                ExaSchema $this$retrieveAllObjects_u24lambda_u249 = exaSchema;
                boolean bl = false;
                ModNamingIdentifyingFamily[] modNamingIdentifyingFamilyArray2 = new ModNamingIdentifyingFamily[]{$this$retrieveAllObjects_u24lambda_u249.getTables(), $this$retrieveAllObjects_u24lambda_u249.getViews(), $this$retrieveAllObjects_u24lambda_u249.getRoutines(), $this$retrieveAllObjects_u24lambda_u249.getScripts()};
                modNamingIdentifyingFamilyArray = modNamingIdentifyingFamilyArray2;
            } else {
                ModNamingIdentifyingFamily[] modNamingIdentifyingFamilyArray3 = new ModNamingIdentifyingFamily[]{schema.getTables()};
                modNamingIdentifyingFamilyArray = modNamingIdentifyingFamilyArray3;
            }
            ModNamingIdentifyingFamily[] families = modNamingIdentifyingFamilyArray;
            ModFamily[] families$iv = Arrays.copyOf(families, families.length);
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            for (ModFamily f$iv : families$iv) {
                f$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            this.processAllObjects(schema, (Function1<ExaIntroQueries.ObjectInfo, Unit>)((Function1)arg_0 -> ExaSchemaRetrieverBase.retrieveAllObjects$lambda$11$lambda$10(schema, s, arg_0)));
            for (ModFamily f$iv : families$iv) {
                f$iv.removeSyncPendingChildren();
                f$iv.sort();
            }
        }

        protected void processAllObjects(@NotNull S schema, @NotNull Function1<? super ExaIntroQueries.ObjectInfo, Unit> it) {
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            Intrinsics.checkNotNullParameter(it, (String)"it");
            ExaIntroQueries.INSTANCE.processAllObjects(this.getTransaction(), (ExaLikeSchema)schema, it);
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit retrieveColumns$lambda$8$lambda$7(NameCache $tableCache, ExaLikeSchema $schema, ModNamingIdentifyingFamily $views, ExaIntroQueries.ColumnInfo info) {
            block5: {
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                var4_4 = $tableCache;
                name$iv = info.table_name;
                $i$f$get = false;
                var7_7 = this_$iv;
                create$iv$iv = false;
                $i$f$get = false;
                if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                v0 = this_$iv$iv.getV();
                Intrinsics.checkNotNull(v0);
                if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv)) {
                    v1 = this_$iv$iv.getV();
                } else lbl-1000:
                // 2 sources

                {
                    var10_11 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, name$iv){
                        final /* synthetic */ boolean $create;
                        final /* synthetic */ String $name;
                        {
                            this.$create = $create;
                            this.$name = $name;
                        }

                        public final T invoke(ModNamingFamily<? extends T> $this$family) {
                            Intrinsics.checkNotNullParameter($this$family, (String)"$this$family");
                            return (T)(this.$create ? $this$family.createOrGet(this.$name) : (BasicModNamedElement)$this$family.get(this.$name));
                        }
                    };
                    var11_13 = this_$iv$iv;
                    var14_14 = this_$iv$iv;
                    $i$a$-get-ExaIntrospector$ExaSchemaRetrieverBase$retrieveColumns$2$1$1 = false;
                    v2 = info.is_table != false ? $schema.getTables() : $views;
                    var14_14.setV((BasicModNamedElement)(v2 != null ? (ExaLikeTable)it.invoke(v2) : null));
                    v1 = this_$iv$iv.getV();
                }
                v3 = (ExaLikeTable)v1;
                if (v3 == null) break block5;
                t = v3;
                $i$a$-let-ExaIntrospector$ExaSchemaRetrieverBase$retrieveColumns$2$1$2 = false;
                var7_7 = t.getColumns().renewAt(info.pos, info.name);
                $this$retrieveColumns_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245 = (BasicModTableOrViewColumn)var7_7;
                $i$a$-apply-ExaIntrospector$ExaSchemaRetrieverBase$retrieveColumns$2$1$2$1 = false;
                $this$retrieveColumns_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245.setComment(info.comment);
                v4 = DataTypeFactory.of(info.type);
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"of(...)");
                $this$retrieveColumns_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245.setStoredType(DasUnresolvedTypeReference.Companion.of(v4));
                $this$retrieveColumns_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245.setNotNull(Intrinsics.areEqual((Object)info.is_nullable, (Object)false));
                if ($this$retrieveColumns_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245 instanceof ExaTableColumn) {
                    v5 = (ExaTableColumn)$this$retrieveColumns_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245;
                    v6 = info.ident;
                    if (v6 != null) {
                        it = ((Number)v6).longValue();
                        var12_16 = v5;
                        $i$a$-let-ExaIntrospector$ExaSchemaRetrieverBase$retrieveColumns$2$1$2$1$1 = false;
                        v7 = SequenceIdentity.of(null, it, null, null);
                        v5 = var12_16;
                    } else {
                        v7 = null;
                    }
                    v5.setSequenceIdentity(v7);
                    ((ExaTableColumn)$this$retrieveColumns_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245).setDefaultExpression(info.def);
                    ((ExaTableColumn)$this$retrieveColumns_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245).setDistKey(info.is_dist_key);
                }
            }
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private static final Unit retrieveAllObjects$lambda$11$lambda$10(ExaLikeSchema $schema, ExaSchema $s, ExaIntroQueries.ObjectInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            var5_3 = info.type;
            if (var5_3 == null) ** GOTO lbl-1000
            tmp = -1;
            switch (var5_3.hashCode()) {
                case 79578030: {
                    if (var5_3.equals("TABLE")) {
                        tmp = 1;
                    }
                    break;
                }
                case -1854356277: {
                    if (var5_3.equals("SCRIPT")) {
                        tmp = 2;
                    }
                    break;
                }
                case 2634405: {
                    if (var5_3.equals("VIEW")) {
                        tmp = 3;
                    }
                    break;
                }
                case -2131401768: {
                    if (var5_3.equals("FUNCTION")) {
                        tmp = 4;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 1: {
                    v0 /* !! */  = $schema.getTables();
                    break;
                }
                case 3: {
                    v1 = $s;
                    if (v1 != null) {
                        v0 /* !! */  = v1.getViews();
                        break;
                    }
                    v0 /* !! */  = null;
                    break;
                }
                case 4: {
                    v2 = $s;
                    if (v2 != null) {
                        v0 /* !! */  = v2.getRoutines();
                        break;
                    }
                    v0 /* !! */  = null;
                    break;
                }
                case 2: {
                    v3 = $s;
                    if (v3 != null) {
                        v0 /* !! */  = v3.getScripts();
                        break;
                    }
                    v0 /* !! */  = null;
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    v0 /* !! */  = null;
                }
            }
            if (v0 /* !! */  == null) {
                return Unit.INSTANCE;
            }
            family = v0 /* !! */ ;
            v4 = family.renew(info.id == -1L ? -9223372036854775808L : info.id, info.name);
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"renew(...)");
            obj = v4;
            ((BasicModNamedElement)obj).setComment(info.comment);
            if (obj instanceof ExaRoutine) {
                ((ExaRoutine)obj).setRoutineKind(DasRoutine.Kind.FUNCTION);
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J$\u0010\f\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\u000eH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector$ExaSysSchemaRetriever;", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector$ExaSchemaRetrieverBase;", "Lcom/intellij/database/dialects/exasol/model/ExaSchema;", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "<init>", "(Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/exasol/model/ExaSchema;)V", "process", "", "retrieveSysColumns", "processAllObjects", "it", "Lkotlin/Function1;", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$ObjectInfo;", "intellij.database.dialects.exasol"})
    @SourceDebugExtension(value={"SMAP\nExaIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExaIntrospector.kt\ncom/intellij/database/dialects/exasol/introspector/ExaIntrospector$ExaSysSchemaRetriever\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,504:1\n32#2:505\n32#2,2:506\n33#2:508\n*S KotlinDebug\n*F\n+ 1 ExaIntrospector.kt\ncom/intellij/database/dialects/exasol/introspector/ExaIntrospector$ExaSysSchemaRetriever\n*L\n476#1:505\n478#1:506,2\n476#1:508\n*E\n"})
    private final class ExaSysSchemaRetriever
    extends ExaSchemaRetrieverBase<ExaSchema> {
        public ExaSysSchemaRetriever(@NotNull DBTransaction transaction, ExaSchema schema) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super(ExaIntrospector.this, transaction, (ExaLikeSchema)schema);
        }

        @Override
        public void process() {
            this.inSchema(arg_0 -> ExaSysSchemaRetriever.process$lambda$0(this, arg_0));
            this.inSchema(arg_0 -> ExaSysSchemaRetriever.process$lambda$1(this, arg_0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void retrieveSysColumns(ExaSchema schema) {
            DatabaseConnectionCore databaseConnectionCore = ExaIntrospector.this.getDbConnection();
            Intrinsics.checkNotNull((Object)databaseConnectionCore);
            RemoteDatabaseMetaData remoteDatabaseMetaData = databaseConnectionCore.getRemoteMetaData();
            Intrinsics.checkNotNull((Object)remoteDatabaseMetaData);
            RemoteDatabaseMetaData metaData = remoteDatabaseMetaData;
            String string = schema.getName();
            ExaDatabase exaDatabase = schema.getDatabase();
            Intrinsics.checkNotNull((Object)exaDatabase);
            DatabaseMetaDataWrapper.Schema sc = new DatabaseMetaDataWrapper.Schema(string, exaDatabase.getName());
            ExaDatabase exaDatabase2 = schema.getDatabase();
            Intrinsics.checkNotNull((Object)exaDatabase2);
            RemoteResultSet rset = metaData.getColumns(exaDatabase2.getName(), schema.getName(), null, null);
            Closeable closeable = new TableColumnIt.Grouping(new TableColumnIt(rset, Dbms.EXASOL, sc));
            Throwable throwable = null;
            try {
                TableColumnIt.Grouping gIt = (TableColumnIt.Grouping)closeable;
                boolean bl = false;
                Iterator $this$forEach$iv = (Iterator)((Object)gIt);
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv;
                while (iterator.hasNext()) {
                    PositioningNamingFamily columns;
                    Object element$iv = iterator.next();
                    DatabaseMetaDataWrapper.Table it = (DatabaseMetaDataWrapper.Table)element$iv;
                    boolean bl2 = false;
                    BasicModTableOrView basicModTableOrView = (BasicModTableOrView)schema.getTableOrView(it.name);
                    PositioningNamingFamily positioningNamingFamily = basicModTableOrView != null ? basicModTableOrView.getColumns() : null;
                    if ((positioningNamingFamily instanceof ModPositioningNamingFamily ? positioningNamingFamily : null) == null) continue;
                    columns = columns;
                    JBIterator jBIterator = gIt.groupIt();
                    Intrinsics.checkNotNullExpressionValue(jBIterator, (String)"groupIt(...)");
                    Iterator $this$forEach$iv2 = (Iterator)jBIterator;
                    boolean $i$f$forEach2 = false;
                    Iterator iterator2 = $this$forEach$iv2;
                    while (iterator2.hasNext()) {
                        DasType dasType;
                        Object element$iv2 = iterator2.next();
                        DatabaseMetaDataWrapper.TableColumn col = (DatabaseMetaDataWrapper.TableColumn)element$iv2;
                        boolean bl3 = false;
                        String string2 = col.name;
                        if (string2 == null) {
                            string2 = "";
                        }
                        Object e = columns.createOrGet(string2);
                        Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicModTableOrViewColumn");
                        BasicModTableOrViewColumn column2 = (BasicModTableOrViewColumn)e;
                        String string3 = col.typeName;
                        if (string3 == null) {
                            string3 = "";
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)JdbcIntrospectorHelper.makeDasType(string3, col.length, col.scale, null, col.type, column2), (String)"makeDasType(...)");
                        column2.setPosition((short)col.position);
                        column2.setStoredType(dasType);
                        column2.setNotNull(!col.nullable);
                        column2.setDefaultExpression(col.def);
                        column2.setComment(StringKt.nullize$default((String)col.comment, (boolean)false, (int)1, null));
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        @Override
        protected void processAllObjects(@NotNull ExaSchema schema, @NotNull Function1<? super ExaIntroQueries.ObjectInfo, Unit> it) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Intrinsics.checkNotNullParameter(it, (String)"it");
            ExaIntroQueries.INSTANCE.processAllSysObjects(this.getTransaction(), schema, it);
        }

        private static final Unit process$lambda$0(ExaSysSchemaRetriever this$0, ExaSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveAllObjects((ExaLikeSchema)schema);
            return Unit.INSTANCE;
        }

        private static final Unit process$lambda$1(ExaSysSchemaRetriever this$0, ExaSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveSysColumns(schema);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector$ExaVSchemaRetriever;", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector$ExaSchemaRetrieverBase;", "Lcom/intellij/database/dialects/exasol/model/ExaVirtualSchema;", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "<init>", "(Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/exasol/model/ExaVirtualSchema;)V", "process", "", "retrieveSchemaProps", "retrieveSchemaExtProps", "intellij.database.dialects.exasol"})
    @SourceDebugExtension(value={"SMAP\nExaIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExaIntrospector.kt\ncom/intellij/database/dialects/exasol/introspector/ExaIntrospector$ExaVSchemaRetriever\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,504:1\n1557#2:505\n1628#2,3:506\n*S KotlinDebug\n*F\n+ 1 ExaIntrospector.kt\ncom/intellij/database/dialects/exasol/introspector/ExaIntrospector$ExaVSchemaRetriever\n*L\n258#1:505\n258#1:506,3\n*E\n"})
    private final class ExaVSchemaRetriever
    extends ExaSchemaRetrieverBase<ExaVirtualSchema> {
        public ExaVSchemaRetriever(@NotNull DBTransaction transaction, ExaVirtualSchema schema) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super(ExaIntrospector.this, transaction, (ExaLikeSchema)schema);
        }

        @Override
        public void process() {
            this.inSchema(arg_0 -> ExaVSchemaRetriever.process$lambda$0(this, arg_0));
            this.inSchema(arg_0 -> ExaVSchemaRetriever.process$lambda$1(this, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveSchemaProps(ExaVirtualSchema schema) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ExaIntroQueries.INSTANCE.retrieveVSchemaProps(this.getTransaction(), schema);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string;
                void it;
                ExaIntroQueries.VSchemaProperty vSchemaProperty = (ExaIntroQueries.VSchemaProperty)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string2 = it.prop_name;
                if (string2 == null) {
                    string2 = "";
                }
                if ((string = it.prop_value) == null) {
                    string = "";
                }
                collection.add(new NameValue(string2, string));
            }
            List props = (List)destination$iv$iv;
            schema.setProperties(props);
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveSchemaExtProps(ExaVirtualSchema schema) {
            BasicReference basicReference;
            List list;
            String[] stringArray;
            ExaIntroQueries.VSchemaExtInfo info2 = ExaIntroQueries.INSTANCE.retrieveVSchemaExtInfo(this.getTransaction(), schema);
            Object object = info2;
            if (object != null && (object = ((ExaIntroQueries.VSchemaExtInfo)object).adapter_script) != null) {
                stringArray = new String[]{"."};
                list = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            } else {
                list = null;
            }
            List name2 = list;
            ExaVirtualSchema exaVirtualSchema = schema;
            List list2 = name2;
            if (list2 != null) {
                void it;
                stringArray = list2;
                ExaVirtualSchema exaVirtualSchema2 = exaVirtualSchema;
                boolean bl = false;
                basicReference = BasicParentReference.create((String)CollectionsKt.getOrNull((List)it, (int)0), BasicNameReference.create((String)CollectionsKt.getOrNull((List)it, (int)1)));
                exaVirtualSchema = exaVirtualSchema2;
            } else {
                basicReference = null;
            }
            exaVirtualSchema.setAdapterRef(basicReference);
            ExaIntroQueries.VSchemaExtInfo vSchemaExtInfo = info2;
            schema.setLastRefresh(vSchemaExtInfo != null ? vSchemaExtInfo.last_refreshed : null);
            ExaIntroQueries.VSchemaExtInfo vSchemaExtInfo2 = info2;
            schema.setLastRefreshBy(vSchemaExtInfo2 != null ? vSchemaExtInfo2.last_refreshed_by : null);
        }

        private static final Unit process$lambda$0(ExaVSchemaRetriever this$0, ExaVirtualSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveSchemaExtProps(schema);
            this$0.retrieveSchemaProps(schema);
            this$0.retrieveAllObjects((ExaLikeSchema)schema);
            return Unit.INSTANCE;
        }

        private static final Unit process$lambda$1(ExaVSchemaRetriever this$0, ExaVirtualSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveColumns((ExaLikeSchema)schema);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "<init>", "()V", "isSupported", "", "version", "Lcom/intellij/database/util/Version;", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "e", "Lcom/intellij/database/model/basic/BasicElement;", "VERSION", "intellij.database.dialects.exasol"})
    public static final class Factory
    implements DBIntrospector.Factory {
        @Override
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            int[] nArray = new int[]{5};
            return version.isOrGreater(nArray);
        }

        @Override
        @NotNull
        public DBIntrospector createIntrospector(@NotNull DBIntrospectionContext context, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return new ExaIntrospector(context, modelFactory);
        }

        @Override
        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        @Override
        public boolean isOutdatedCheckSupported(@Nullable BasicElement e) {
            return false;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "<init>", "()V", "intellij.database.dialects.exasol"})
        public static final class VERSION
        extends PerObjectVersion {
            @NotNull
            public static final VERSION INSTANCE = new VERSION();

            private VERSION() {
            }
        }
    }
}

