/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector;

import com.intellij.database.model.basic.BasicSchema;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\b\u0016\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0013H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/dialects/base/introspector/SchemaPortion;", "S", "Lcom/intellij/database/model/basic/BasicSchema;", "", "schemas", "", "incremental", "", "<init>", "(Ljava/util/List;Z)V", "getSchemas", "()Ljava/util/List;", "getIncremental", "()Z", "size", "", "getSize", "()I", "brief", "", "getBrief", "()Ljava/lang/String;", "suffices", "", "toString", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nBaseIntrospectionFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/SchemaPortion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,439:1\n1#2:440\n*E\n"})
public class SchemaPortion<S extends BasicSchema> {
    @NotNull
    private final List<S> schemas;
    private final boolean incremental;

    public SchemaPortion(@NotNull List<? extends S> schemas, boolean incremental) {
        boolean bl;
        Intrinsics.checkNotNullParameter(schemas, (String)"schemas");
        this.schemas = schemas;
        this.incremental = incremental;
        boolean bl2 = bl = !((Collection)this.schemas).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "The list of schemas must not be empty";
            throw new AssertionError((Object)string);
        }
    }

    @NotNull
    public final List<S> getSchemas() {
        return this.schemas;
    }

    public final boolean getIncremental() {
        return this.incremental;
    }

    public final int getSize() {
        return this.schemas.size();
    }

    @NotNull
    public String getBrief() {
        StringBuilder stringBuilder;
        StringBuilder $this$_get_brief__u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$_get_brief__u24lambda_u242.append("Portion of ").append(this.getSize()).append(' ').append(StringUtil.pluralize((String)"schema", (int)this.getSize()));
        $this$_get_brief__u24lambda_u242.append(" (").append(this.incremental ? "inc" : "full");
        if (this.incremental) {
            $this$_get_brief__u24lambda_u242.append("inc");
        }
        CharSequence charSequence = this.suffices();
        if (charSequence != null) {
            CharSequence it = charSequence;
            boolean bl2 = false;
            $this$_get_brief__u24lambda_u242.append(',').append(it);
        }
        $this$_get_brief__u24lambda_u242.append(')');
        return stringBuilder.toString();
    }

    @Nullable
    public CharSequence suffices() {
        return null;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u244.append(this.getBrief());
        $this$toString_u24lambda_u244.append(": ");
        CollectionsKt.joinTo$default((Iterable)this.schemas, (Appendable)$this$toString_u24lambda_u244, (CharSequence)",", null, null, (int)0, null, SchemaPortion::toString$lambda$4$lambda$3, (int)60, null);
        return stringBuilder.toString();
    }

    private static final CharSequence toString$lambda$4$lambda$3(BasicSchema it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }
}

