/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.google.common.base.Objects;
import com.intellij.database.dataSource.ConfigUrlOverrider;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.util.NlsSafe;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceSessionTemplate
extends DatabaseConnectionPoint.Adapter
implements DatabaseConnectionConfig {
    private final String myTemplateId;
    private String myTemplateName;
    private Boolean myReadonly;
    private String myAuthProviderId;
    private String myInitScript;
    final Map<String, String> myAdditionalProperties;
    private final ConfigUrlOverrider myUrlOverrider;

    public DataSourceSessionTemplate(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DataSourceSessionTemplate.$$$reportNull$$$0(0);
        }
        this(dataSource, null);
    }

    public DataSourceSessionTemplate(@NotNull LocalDataSource dataSource, @Nullable String templateId) {
        if (dataSource == null) {
            DataSourceSessionTemplate.$$$reportNull$$$0(1);
        }
        super(dataSource);
        this.myTemplateName = "";
        this.myAdditionalProperties = new LinkedHashMap<String, String>();
        this.myUrlOverrider = new ConfigUrlOverrider(this.getDataSource());
        this.myTemplateId = templateId != null ? templateId : UUID.randomUUID().toString();
    }

    @Override
    public String getName() {
        return super.getName() + "/" + this.getTemplateName();
    }

    @Override
    public String getUrl() {
        return this.myUrlOverrider.getUrl();
    }

    @NotNull
    public ConfigUrlOverrider getUrlOverrider() {
        ConfigUrlOverrider configUrlOverrider = this.myUrlOverrider;
        if (configUrlOverrider == null) {
            DataSourceSessionTemplate.$$$reportNull$$$0(2);
        }
        return configUrlOverrider;
    }

    @NlsSafe
    @NotNull
    public String getTemplateName() {
        String string = this.myTemplateName;
        if (string == null) {
            DataSourceSessionTemplate.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setTemplateName(@NotNull String templateName) {
        if (templateName == null) {
            DataSourceSessionTemplate.$$$reportNull$$$0(4);
        }
        this.myTemplateName = templateName;
    }

    @Override
    @NotNull
    public DatabaseConnectionConfig getMutableConfig() {
        DataSourceSessionTemplate dataSourceSessionTemplate = this;
        if (dataSourceSessionTemplate == null) {
            DataSourceSessionTemplate.$$$reportNull$$$0(5);
        }
        return dataSourceSessionTemplate;
    }

    @Override
    public boolean isReadOnly() {
        return this.myReadonly == null ? super.isReadOnly() : this.myReadonly.booleanValue();
    }

    @Nullable
    public Boolean getReadonlyOverride() {
        return this.myReadonly;
    }

    public void setReadonlyOverride(@Nullable Boolean readonly) {
        this.myReadonly = readonly;
    }

    @Override
    @Nullable
    public String getAdditionalProperty(@NotNull String name2) {
        if (name2 == null) {
            DataSourceSessionTemplate.$$$reportNull$$$0(6);
        }
        if (this.myAdditionalProperties.containsKey(name2)) {
            return this.myAdditionalProperties.get(name2);
        }
        return super.getAdditionalProperty(name2);
    }

    @Override
    public void setAdditionalProperty(@NotNull String name2, @Nullable String value) {
        if (name2 == null) {
            DataSourceSessionTemplate.$$$reportNull$$$0(7);
        }
        String existing2 = super.getAdditionalProperty(name2);
        if (value == null && existing2 != null) {
            this.myAdditionalProperties.put(name2, null);
            return;
        }
        DbImplUtilCore.putOrRemove(this.myAdditionalProperties, name2, Objects.equal((Object)value, (Object)existing2) ? null : value);
    }

    @Override
    @NotNull
    public Set<String> getAdditionalPropertiesNames() {
        LinkedHashSet<String> res2 = new LinkedHashSet<String>(this.myAdditionalProperties.keySet());
        res2.addAll(super.getAdditionalPropertiesNames());
        LinkedHashSet<String> linkedHashSet = res2;
        if (linkedHashSet == null) {
            DataSourceSessionTemplate.$$$reportNull$$$0(8);
        }
        return linkedHashSet;
    }

    @NotNull
    public String getTemplateId() {
        String string = this.myTemplateId;
        if (string == null) {
            DataSourceSessionTemplate.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @NotNull
    public String getAuthProviderId() {
        String string = this.myAuthProviderId == null ? super.getAuthProviderId() : this.myAuthProviderId;
        if (string == null) {
            DataSourceSessionTemplate.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    public String getAuthProviderIdOverride() {
        return this.myAuthProviderId;
    }

    @Override
    public void setAuthProviderId(@Nullable String authProviderId) {
        this.setAuthProviderIdOverride(authProviderId);
    }

    public void setAuthProviderIdOverride(@Nullable String authProviderId) {
        this.myAuthProviderId = authProviderId;
    }

    @Override
    @Nullable
    public String getInitScript() {
        if (this.myInitScript != null) {
            return this.myInitScript;
        }
        return super.getInitScript();
    }

    @Override
    public void setInitScript(@Nullable String initScript) {
        this.myInitScript = initScript == null || Objects.equal((Object)initScript, (Object)super.getInitScript()) ? null : initScript;
    }

    public boolean equalConfiguration(@NotNull DataSourceSessionTemplate o) {
        if (o == null) {
            DataSourceSessionTemplate.$$$reportNull$$$0(11);
        }
        if (!Objects.equal((Object)this.myTemplateId, (Object)o.myTemplateId)) {
            return false;
        }
        if (!Objects.equal((Object)this.myTemplateName, (Object)o.myTemplateName)) {
            return false;
        }
        if (!Objects.equal((Object)this.myReadonly, (Object)o.myReadonly)) {
            return false;
        }
        if (!Objects.equal((Object)this.myAuthProviderId, (Object)o.myAuthProviderId)) {
            return false;
        }
        if (!Objects.equal(this.myAdditionalProperties, o.myAdditionalProperties)) {
            return false;
        }
        if (!Objects.equal((Object)this.myInitScript, (Object)o.myInitScript)) {
            return false;
        }
        return Objects.equal((Object)this.myUrlOverrider, (Object)o.myUrlOverrider);
    }

    public void copyFrom(@NotNull DataSourceSessionTemplate other) {
        if (other == null) {
            DataSourceSessionTemplate.$$$reportNull$$$0(12);
        }
        if (other == this) {
            return;
        }
        this.myTemplateName = other.myTemplateName;
        this.myReadonly = other.myReadonly;
        this.myAuthProviderId = other.myAuthProviderId;
        this.myInitScript = other.myInitScript;
        this.myAdditionalProperties.clear();
        this.myAdditionalProperties.putAll(other.myAdditionalProperties);
        this.myUrlOverrider.clear();
        for (Map.Entry<String, String> param : other.myUrlOverrider.getParams()) {
            this.myUrlOverrider.setParam(param.getKey(), param.getValue());
        }
    }

    public DataSourceSessionTemplate copyTo(@NotNull LocalDataSource other) {
        if (other == null) {
            DataSourceSessionTemplate.$$$reportNull$$$0(13);
        }
        DataSourceSessionTemplate res2 = new DataSourceSessionTemplate(other, this.myTemplateId);
        res2.copyFrom(this);
        return res2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceSessionTemplate";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceSessionTemplate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlOverrider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutableConfig";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalPropertiesNames";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateId";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthProviderId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setTemplateName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalProperty";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setAdditionalProperty";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "equalConfiguration";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "copyTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

