/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.runConfiguration;

import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfiguration;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfigurationOptions;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfigurationType;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespace;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nJ0\u0010\u0011\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00152\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0015J\u0018\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00152\u0006\u0010\t\u001a\u00020\nH\u0002J*\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00152\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015H\u0002J\u0018\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00152\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0015H\u0002J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006&"}, d2={"Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationProducer;", "Lcom/intellij/execution/actions/LazyRunConfigurationProducer;", "Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfiguration;", "<init>", "()V", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "createConfigurationFromContext", "Lcom/intellij/execution/actions/ConfigurationFromContext;", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "setupConfigurationFromContext", "", "configuration", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "canCreate", "project", "Lcom/intellij/openapi/project/Project;", "virtualFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "psiElements", "getVirtualFilesFromContext", "getSelectedFiles", "", "getPsiElements", "getSelectedTargets", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationOptions$Target;", "psi", "asTarget", "e", "Lcom/intellij/database/psi/DbElement;", "isConfigurationFromContext", "findExistingConfiguration", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDatabaseScriptRunConfigurationProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseScriptRunConfigurationProducer.kt\ncom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationProducer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n1#2:108\n774#3:109\n865#3,2:110\n1557#3:112\n1628#3,3:113\n*S KotlinDebug\n*F\n+ 1 DatabaseScriptRunConfigurationProducer.kt\ncom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationProducer\n*L\n69#1:109\n69#1:110,2\n70#1:112\n70#1:113,3\n*E\n"})
public final class DatabaseScriptRunConfigurationProducer
extends LazyRunConfigurationProducer<DatabaseScriptRunConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        return DatabaseScriptRunConfigurationType.Companion.getInstance().getConfigurationFactories()[0];
    }

    @Nullable
    public ConfigurationFromContext createConfigurationFromContext(@NotNull ConfigurationContext context) {
        ConfigurationFromContext configurationFromContext;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ConfigurationFromContext configurationFromContext2 = super.createConfigurationFromContext(context);
        if (configurationFromContext2 != null) {
            ConfigurationFromContext configurationFromContext3;
            ConfigurationFromContext $this$createConfigurationFromContext_u24lambda_u240 = configurationFromContext3 = configurationFromContext2;
            boolean bl = false;
            $this$createConfigurationFromContext_u24lambda_u240.getConfigurationSettings().setEditBeforeRun(true);
            configurationFromContext = configurationFromContext3;
        } else {
            configurationFromContext = null;
        }
        return configurationFromContext;
    }

    protected boolean setupConfigurationFromContext(@NotNull DatabaseScriptRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        block1: {
            DatabaseScriptRunConfigurationOptions databaseScriptRunConfigurationOptions;
            PsiElement source;
            Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
            PsiElement psiElement = source = (PsiElement)sourceElement.get();
            PsiFile sourceFile = psiElement != null ? psiElement.getContainingFile() : null;
            List<String> list = this.getSelectedFiles(context.getProject(), this.getVirtualFilesFromContext(context));
            if (list == null) {
                return false;
            }
            List<String> selectedFiles = list;
            JBIterable<DatabaseScriptRunConfigurationOptions.Target> selectedTargets = this.getSelectedTargets(this.getPsiElements(context));
            DatabaseScriptRunConfigurationOptions $this$setupConfigurationFromContext_u24lambda_u241 = databaseScriptRunConfigurationOptions = configuration.getOptions();
            boolean bl = false;
            $this$setupConfigurationFromContext_u24lambda_u241.setMode(DatabaseScriptRunConfigurationOptions.Mode.FILE);
            $this$setupConfigurationFromContext_u24lambda_u241.setFiles(CollectionsKt.toMutableList((Collection)selectedFiles));
            $this$setupConfigurationFromContext_u24lambda_u241.setTargets(CollectionsKt.toMutableList((Iterable)((Iterable)selectedTargets)));
            configuration.setGeneratedName();
            PsiFile psiFile = sourceFile;
            if (psiFile == null) break block1;
            PsiFile it = psiFile;
            boolean bl2 = false;
            sourceElement.set((Object)it);
        }
        return true;
    }

    public final boolean canCreate(@NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.canCreate(context.getProject(), this.getVirtualFilesFromContext(context), this.getPsiElements(context));
    }

    public final boolean canCreate(@Nullable Project project, @Nullable List<? extends VirtualFile> virtualFiles, @Nullable List<? extends PsiElement> psiElements) {
        List<String> list = this.getSelectedFiles(project, virtualFiles);
        return (list != null ? !((Collection)list).isEmpty() : false) && this.getSelectedTargets(psiElements).isNotEmpty();
    }

    private final List<VirtualFile> getVirtualFilesFromContext(ConfigurationContext context) {
        DataContext dataContext = context.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Object object = (VirtualFile[])LangDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (object == null || (object = ArraysKt.asList((Object[])object)) == null) {
            DataContext dataContext2 = context.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
            VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext2);
            if (virtualFile != null) {
                VirtualFile it = virtualFile;
                boolean bl = false;
                object = CollectionsKt.listOf((Object)it);
            } else {
                object = null;
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getSelectedFiles(Project project, List<? extends VirtualFile> virtualFiles) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        VirtualFile it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        if (virtualFiles == null) {
            return null;
        }
        Iterable iterable = virtualFiles;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!(DbImplUtil.isScriptFile(project, it) && !DbVFSUtils.isConsoleFile(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath());
        }
        List files2 = (List)destination$iv$iv;
        Iterable it2 = iterable = files2;
        boolean bl = false;
        return !((Collection)it2).isEmpty() ? iterable : null;
    }

    private final List<PsiElement> getPsiElements(ConfigurationContext context) {
        DataContext dataContext = context.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Object object = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        if (object == null || (object = ArraysKt.asList((Object[])object)) == null) {
            DataContext dataContext2 = context.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
            PsiElement psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext2);
            if (psiElement != null) {
                PsiElement it = psiElement;
                boolean bl = false;
                object = CollectionsKt.listOf((Object)it);
            } else {
                object = null;
            }
        }
        return object;
    }

    private final JBIterable<DatabaseScriptRunConfigurationOptions.Target> getSelectedTargets(List<? extends PsiElement> psi) {
        JBIterable jBIterable = JBIterable.from((Iterable)psi).filter(DbElement.class).filterMap(arg_0 -> DatabaseScriptRunConfigurationProducer.getSelectedTargets$lambda$9(DatabaseScriptRunConfigurationProducer::getSelectedTargets$lambda$8, arg_0)).map(arg_0 -> DatabaseScriptRunConfigurationProducer.getSelectedTargets$lambda$11(arg_0 -> DatabaseScriptRunConfigurationProducer.getSelectedTargets$lambda$10(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"map(...)");
        return jBIterable;
    }

    private final DatabaseScriptRunConfigurationOptions.Target asTarget(DbElement e) {
        DbElement dbElement;
        DbDataSource dbDataSource = e.getDataSource();
        Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"getDataSource(...)");
        DbDataSource dataSource = dbDataSource;
        DbElement it = dbElement = e;
        boolean bl = false;
        ObjectPath path = ObjectPaths.of(!Intrinsics.areEqual((Object)it, (Object)dataSource) ? dbElement : null);
        ObjectPath objectPath = path;
        return new DatabaseScriptRunConfigurationOptions.Target(dataSource.getUniqueId(), objectPath != null ? objectPath.serialize() : null);
    }

    public boolean isConfigurationFromContext(@NotNull DatabaseScriptRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DatabaseScriptRunConfigurationOptions options = configuration.getOptions();
        List<String> list = this.getSelectedFiles(context.getProject(), this.getVirtualFilesFromContext(context));
        if (list == null) {
            return false;
        }
        List<String> selectedFiles = list;
        List list2 = this.getSelectedTargets(this.getPsiElements(context)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"toList(...)");
        List targets = list2;
        return options.getMode() == DatabaseScriptRunConfigurationOptions.Mode.FILE && selectedFiles.size() == options.getFiles().size() && selectedFiles.containsAll((Collection)options.getFiles()) && (targets.isEmpty() || targets.size() == options.getTargets().size() && targets.containsAll((Collection)options.getTargets()));
    }

    @Nullable
    public RunnerAndConfigurationSettings findExistingConfiguration(@NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = RunManager.Companion.getInstance(project).getSelectedConfiguration();
        if (runnerAndConfigurationSettings != null) {
            DatabaseScriptRunConfiguration rc;
            RunnerAndConfigurationSettings cur = runnerAndConfigurationSettings;
            boolean bl = false;
            RunConfiguration runConfiguration = cur.getConfiguration();
            DatabaseScriptRunConfiguration databaseScriptRunConfiguration = rc = runConfiguration instanceof DatabaseScriptRunConfiguration ? (DatabaseScriptRunConfiguration)runConfiguration : null;
            if (rc != null && this.isConfigurationFromContext(rc, context)) {
                return cur;
            }
        }
        return super.findExistingConfiguration(context);
    }

    private static final DbElement getSelectedTargets$lambda$8(DbElement it) {
        return it instanceof DbDataSource ? it : (DbElement)DasUtil.getParentOfClass(it, DbNamespace.class, false);
    }

    private static final DbElement getSelectedTargets$lambda$9(Function1 $tmp0, Object p0) {
        return (DbElement)$tmp0.invoke(p0);
    }

    private static final DatabaseScriptRunConfigurationOptions.Target getSelectedTargets$lambda$10(DatabaseScriptRunConfigurationProducer this$0, DbElement it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.asTarget(it);
    }

    private static final DatabaseScriptRunConfigurationOptions.Target getSelectedTargets$lambda$11(Function1 $tmp0, Object p0) {
        return (DatabaseScriptRunConfigurationOptions.Target)((Object)$tmp0.invoke(p0));
    }
}

