/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.plist;

import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.plist.JsonPlistReader;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.plist.PlistReader;
import org.jetbrains.plugins.textmate.plist.XmlPlistReader;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/textmate/plist/CompositePlistReader;", "Lorg/jetbrains/plugins/textmate/plist/PlistReader;", "<init>", "()V", "myJsonReader", "myXmlReader", "read", "Lorg/jetbrains/plugins/textmate/plist/Plist;", "inputStream", "Ljava/io/InputStream;", "intellij.textmate.core"})
public final class CompositePlistReader
implements PlistReader {
    @NotNull
    private final PlistReader myJsonReader = new JsonPlistReader();
    @NotNull
    private final PlistReader myXmlReader = new XmlPlistReader();

    @Override
    @NotNull
    public Plist read(@NotNull InputStream inputStream) throws IOException {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        inputStream.mark(256);
        int symbol = inputStream.read();
        for (int tries = 0; symbol > 0 && CharsKt.isWhitespace((char)((char)symbol)) && tries < 255; ++tries) {
            symbol = inputStream.read();
        }
        inputStream.reset();
        if (symbol == 123) {
            return this.myJsonReader.read(inputStream);
        }
        if (symbol == 60) {
            return this.myXmlReader.read(inputStream);
        }
        throw new IOException("Unknown bundle type, first char: " + (char)symbol);
    }
}

