/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleNavigatable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryNavigatable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.uml.java.utils.DiagramJavaBundle;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleItem {
    private final Module myModule;
    private final Library myLibrary;
    private final Project myProject;
    private Navigatable navigatable;
    @NonNls
    private static final String SEPARATOR = "-";
    @NonNls
    private static final String MODULE_PREFIX = "mdl-";
    @NonNls
    private static final String LIB_PREFIX = "lib-";
    @NonNls
    private static final String JAR_PREFIX = "jar-";
    public static final ModuleItem[] EMPTY_ARRAY = new ModuleItem[0];

    public ModuleItem(@NotNull Module module) {
        if (module == null) {
            ModuleItem.$$$reportNull$$$0(0);
        }
        this(module, null, module.getProject());
    }

    public ModuleItem(@NotNull Library library, @NotNull Project project) {
        if (library == null) {
            ModuleItem.$$$reportNull$$$0(1);
        }
        if (project == null) {
            ModuleItem.$$$reportNull$$$0(2);
        }
        this(null, library, project);
    }

    public Module getModule() {
        return this.myModule;
    }

    public Library getLibrary() {
        return this.myLibrary;
    }

    public static ModuleItem fromFQN(@NotNull String fqn, Project project) throws IllegalArgumentException {
        if (fqn == null) {
            ModuleItem.$$$reportNull$$$0(3);
        }
        if (fqn.length() < 5 || fqn.charAt(3) != '-') {
            throw new IllegalArgumentException("Wrong FQN");
        }
        String prefix = fqn.substring(0, 4);
        String name = fqn.substring(4);
        if (MODULE_PREFIX.equals(prefix)) {
            Module module = ModuleManager.getInstance((Project)project).findModuleByName(name);
            if (module == null) {
                throw new IllegalArgumentException("Wrong FQN");
            }
            return new ModuleItem(module);
        }
        if (LIB_PREFIX.equals(prefix)) {
            for (Library library : LibraryTablesRegistrar.getInstance().getLibraryTable(project).getLibraries()) {
                if (!name.equals(library.getName())) continue;
                return new ModuleItem(library, project);
            }
        }
        throw new IllegalArgumentException("Wrong FQN");
    }

    public ModuleItem(@Nullable Module module, @Nullable Library library, @NotNull Project project) {
        if (project == null) {
            ModuleItem.$$$reportNull$$$0(4);
        }
        this.myModule = module;
        this.myLibrary = library;
        this.myProject = project;
    }

    public boolean isModule() {
        return this.myLibrary == null;
    }

    public boolean isLibrary() {
        return this.myLibrary != null;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ModuleItem.$$$reportNull$$$0(5);
        }
        return project;
    }

    private String getPrefix() {
        if (this.isModule()) {
            return MODULE_PREFIX;
        }
        if (this.isLibrary()) {
            return LIB_PREFIX;
        }
        return JAR_PREFIX;
    }

    @NlsSafe
    public String getName() {
        if (this.isModule()) {
            return this.myModule.getName();
        }
        if (this.isLibrary()) {
            String name = this.myLibrary.getName();
            if (name != null) {
                return StringUtil.toLowerCase((String)name).startsWith("maven") ? ModuleItem.getMavenLibraryShortName(name) : name;
            }
            if (!Disposer.isDisposed((Disposable)this.myLibrary)) {
                String[] urls = this.myLibrary.getUrls(OrderRootType.CLASSES);
                if (urls.length > 0) {
                    return PathUtil.getFileName((String)StringUtil.trimEnd((String)urls[0], (String)"!/"));
                }
                return DiagramJavaBundle.message("unnamed.empty.library", new Object[0]);
            }
        }
        return DiagramJavaBundle.message("unknown.module.item", new Object[0]);
    }

    @NlsSafe
    private static String getMavenLibraryShortName(@NotNull String name) {
        String[] coords;
        if (name == null) {
            ModuleItem.$$$reportNull$$$0(6);
        }
        if ((coords = name.split(":")).length == 4 && StringUtil.toLowerCase((String)coords[0]).trim().equals("maven")) {
            return coords[0] + ": " + coords[2];
        }
        return name;
    }

    public String getQualifiedName() {
        return this.getPrefix() + this.getName();
    }

    public Icon getIcon() {
        if (this.isModule()) {
            return PlatformIcons.CONTENT_ROOT_ICON_CLOSED;
        }
        return PlatformIcons.LIBRARY_ICON;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleItem that = (ModuleItem)o;
        return this.getQualifiedName().equals(that.getQualifiedName());
    }

    public int hashCode() {
        return this.getQualifiedName().hashCode();
    }

    public String toString() {
        return this.getPresentableName();
    }

    @NotNull
    public String getPresentableName() {
        String string = (this.isLibrary() ? "Library '" : "Module '") + this.getName() + "'";
        if (string == null) {
            ModuleItem.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public Navigatable getNavigatable() {
        if (this.navigatable == null) {
            this.navigatable = this.isModule() ? new ModuleNavigatable(this.getModule()) : new LibraryNavigatable(this.myLibrary, this.myProject, this.myModule);
        }
        Navigatable navigatable = this.navigatable;
        if (navigatable == null) {
            ModuleItem.$$$reportNull$$$0(8);
        }
        return navigatable;
    }

    public boolean isDisposed() {
        return this.myLibrary == null ? this.myModule.isDisposed() : ((LibraryEx)this.myLibrary).isDisposed();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/java/project/ModuleItem";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/java/project/ModuleItem";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigatable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromFQN";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMavenLibraryShortName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 8 -> new IllegalStateException(string);
        };
    }
}

